/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandArgs;
import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.AggregateOperation;
import com.redis.lettucemod.search.Order;
import com.redis.lettucemod.search.RediSearchArgument;
import io.lettuce.core.internal.LettuceAssert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Sort
implements AggregateOperation {
    private final Property[] properties;
    private final Long max;

    public Sort(Property[] properties, Long max) {
        LettuceAssert.notEmpty((Object[])properties, (String)"At least one property is required");
        LettuceAssert.noNullElements((Object[])properties, (String)"Properties must not be null");
        this.properties = properties;
        this.max = max;
    }

    @Override
    public void build(SearchCommandArgs args) {
        args.add(SearchCommandKeyword.SORTBY);
        args.add((long)this.properties.length * 2L);
        for (Property property : this.properties) {
            property.build(args);
        }
        if (this.max != null) {
            args.add(SearchCommandKeyword.MAX);
            args.add(this.max);
        }
    }

    public static SortBuilder by(Property ... properties) {
        return new SortBuilder(properties);
    }

    public static class Property
    implements RediSearchArgument {
        private final String name;
        private final Order order;

        public Property(String name, Order order) {
            LettuceAssert.notNull((Object)name, (String)"Name is required");
            LettuceAssert.notNull((Object)((Object)order), (String)"Order is required");
            this.name = name;
            this.order = order;
        }

        public void build(SearchCommandArgs args) {
            args.addProperty(this.name);
            args.add(this.order == Order.ASC ? SearchCommandKeyword.ASC : SearchCommandKeyword.DESC);
        }

        public static PropertyBuilder name(String name) {
            return new PropertyBuilder(name);
        }

        public static class PropertyBuilder {
            private final String name;

            public PropertyBuilder(String name) {
                this.name = name;
            }

            public Property order(Order order) {
                return new Property(this.name, order);
            }
        }
    }

    public static class SortBuilder {
        private final List<Property> properties = new ArrayList<Property>();
        private Long max;

        public SortBuilder(Property ... properties) {
            Collections.addAll(this.properties, properties);
        }

        public SortBuilder by(Property property) {
            return this.by(property);
        }

        public SortBuilder max(long max) {
            this.max = max;
            return this;
        }

        public Sort build() {
            return new Sort(this.properties.toArray(new Property[0]), this.max);
        }
    }
}

