/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring;

import com.ryantenney.metrics.spring.AnnotationFilter;
import com.yammer.metrics.annotation.ExceptionMetered;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

public class ExceptionMeteredMethodInterceptor
implements MethodInterceptor,
ReflectionUtils.MethodCallback,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(ExceptionMeteredMethodInterceptor.class);
    private static final ReflectionUtils.MethodFilter filter = new AnnotationFilter(ExceptionMetered.class);
    private final MetricsRegistry metrics;
    private final Class<?> targetClass;
    private final Map<String, Meter> meters;
    private final Map<String, Class<? extends Throwable>> causes;
    private final String scope;

    public ExceptionMeteredMethodInterceptor(MetricsRegistry metrics, Class<?> targetClass, String scope) {
        this.metrics = metrics;
        this.targetClass = targetClass;
        this.meters = new HashMap<String, Meter>();
        this.causes = new HashMap<String, Class<? extends Throwable>>();
        this.scope = scope;
        log.debug("Creating method interceptor for class {}", (Object)targetClass.getCanonicalName());
        log.debug("Scanning for @ExceptionMetered annotated methods");
        ReflectionUtils.doWithMethods(targetClass, (ReflectionUtils.MethodCallback)this, (ReflectionUtils.MethodFilter)filter);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return invocation.proceed();
        }
        catch (Throwable t) {
            Meter meter;
            String name = invocation.getMethod().getName();
            Class<? extends Throwable> cause = this.causes.get(name);
            if (cause != null && cause.isAssignableFrom(t.getClass()) && (meter = this.meters.get(name)) != null) {
                meter.mark();
            }
            throw t;
        }
    }

    public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
        ExceptionMetered metered = method.getAnnotation(ExceptionMetered.class);
        String methodName = method.getName();
        String group = MetricName.chooseGroup((String)metered.group(), this.targetClass);
        String type = MetricName.chooseType((String)metered.type(), this.targetClass);
        String name = metered.name() == null || metered.name().equals("") ? methodName + "Exceptions" : metered.name();
        MetricName metricName = new MetricName(group, type, name, this.scope);
        Meter meter = this.metrics.newMeter(metricName, metered.eventType(), metered.rateUnit());
        this.meters.put(methodName, meter);
        this.causes.put(methodName, metered.cause());
        log.debug("Created metric {} for method {}", (Object)metricName, (Object)methodName);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

