/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring;

import com.yammer.metrics.core.HealthCheck;
import com.yammer.metrics.core.HealthCheckRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

public class HealthCheckBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckBeanPostProcessor.class);
    private final HealthCheckRegistry healthChecks;

    public HealthCheckBeanPostProcessor(HealthCheckRegistry healthChecks) {
        this.healthChecks = healthChecks;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof HealthCheck) {
            this.healthChecks.register((HealthCheck)bean);
            log.debug("Registering HealthCheck bean {}", (Object)beanName);
        }
        return bean;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

