/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring;

import com.ryantenney.metrics.spring.AnnotationFilter;
import com.yammer.metrics.annotation.Metered;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class MeteredMethodInterceptor
implements MethodInterceptor,
ReflectionUtils.MethodCallback {
    private static final Logger log = LoggerFactory.getLogger(MeteredMethodInterceptor.class);
    private static final ReflectionUtils.MethodFilter filter = new AnnotationFilter(Metered.class);
    protected final MetricsRegistry metrics;
    protected final Class<?> targetClass;
    protected final Map<String, Meter> meters;
    protected final String scope;

    public MeteredMethodInterceptor(MetricsRegistry metrics, Class<?> targetClass, String scope) {
        this.metrics = metrics;
        this.targetClass = targetClass;
        this.meters = new HashMap<String, Meter>();
        this.scope = scope;
        log.debug("Creating method interceptor for class {}", (Object)targetClass.getCanonicalName());
        log.debug("Scanning for @Metered annotated methods");
        ReflectionUtils.doWithMethods(targetClass, (ReflectionUtils.MethodCallback)this, (ReflectionUtils.MethodFilter)filter);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Meter meter = this.meters.get(invocation.getMethod().getName());
        if (meter != null) {
            meter.mark();
        }
        return invocation.proceed();
    }

    public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
        Metered metered = method.getAnnotation(Metered.class);
        String group = MetricName.chooseGroup((String)metered.group(), this.targetClass);
        String type = MetricName.chooseType((String)metered.type(), this.targetClass);
        String name = MetricName.chooseName((String)metered.name(), (Method)method);
        MetricName metricName = new MetricName(group, type, name, this.scope);
        Meter meter = this.metrics.newMeter(metricName, metered.eventType(), metered.rateUnit());
        this.meters.put(method.getName(), meter);
        log.debug("Created metric {} for method {}", (Object)metricName, (Object)method.getName());
    }
}

