/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring;

import com.ryantenney.metrics.spring.AnnotationFilter;
import com.yammer.metrics.annotation.Timed;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

public class TimedMethodInterceptor
implements MethodInterceptor,
ReflectionUtils.MethodCallback,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(TimedMethodInterceptor.class);
    private static final ReflectionUtils.MethodFilter filter = new AnnotationFilter(Timed.class);
    private final MetricsRegistry metrics;
    private final Class<?> targetClass;
    private final Map<String, Timer> timers;
    private final String scope;

    public TimedMethodInterceptor(MetricsRegistry metrics, Class<?> targetClass, String scope) {
        this.metrics = metrics;
        this.targetClass = targetClass;
        this.timers = new HashMap<String, Timer>();
        this.scope = scope;
        log.debug("Creating method interceptor for class {}", (Object)targetClass.getCanonicalName());
        log.debug("Scanning for @Timed annotated methods");
        ReflectionUtils.doWithMethods(targetClass, (ReflectionUtils.MethodCallback)this, (ReflectionUtils.MethodFilter)filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Timer timer = this.timers.get(invocation.getMethod().getName());
        TimerContext timerCtx = timer != null ? timer.time() : null;
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            if (timerCtx != null) {
                timerCtx.stop();
            }
        }
    }

    public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
        Timed timed = method.getAnnotation(Timed.class);
        String group = MetricName.chooseGroup((String)timed.group(), this.targetClass);
        String type = MetricName.chooseType((String)timed.type(), this.targetClass);
        String name = MetricName.chooseName((String)timed.name(), (Method)method);
        MetricName metricName = new MetricName(group, type, name, this.scope);
        Timer timer = this.metrics.newTimer(metricName, timed.durationUnit(), timed.rateUnit());
        this.timers.put(method.getName(), timer);
        log.debug("Created metric {} for method {}", (Object)metricName, (Object)method.getName());
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

