/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.context;

import com.salesforce.grpc.contrib.context.AmbientContext;
import com.salesforce.servicelibs.io.grpc.Metadata;
import com.salesforce.servicelibs.io.grpc.ServerCall;
import com.salesforce.servicelibs.io.grpc.ServerCallHandler;
import com.salesforce.servicelibs.io.grpc.ServerInterceptor;
import com.salesforce.servicelibs.io.grpc.Status;

public class AmbientContextEnforcerServerInterceptor
implements ServerInterceptor {
    private String[] requiredContextKeys = new String[0];

    public AmbientContextEnforcerServerInterceptor() {
    }

    public AmbientContextEnforcerServerInterceptor(String ... requiredContextKeys) {
        this.requiredContextKeys = requiredContextKeys;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        if (!AmbientContext.isPresent()) {
            call.close(this.missingContextStatus(), new Metadata());
            return new ServerCall.Listener<ReqT>(){};
        }
        for (String requiredKey : this.requiredContextKeys) {
            if (AmbientContext.current().keys().contains(requiredKey)) continue;
            call.close(this.incompleteContextStatus(requiredKey), new Metadata());
            return new ServerCall.Listener<ReqT>(){};
        }
        return next.startCall(call, headers);
    }

    protected Status missingContextStatus() {
        return Status.FAILED_PRECONDITION.withDescription("Ambient context is required but not found");
    }

    protected Status incompleteContextStatus(String missingKey) {
        return Status.FAILED_PRECONDITION.withDescription("Required ambient context key " + missingKey + " was not found");
    }
}

