/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.interceptor;

import com.salesforce.servicelibs.com.google.common.base.Preconditions;
import com.salesforce.servicelibs.io.grpc.CallOptions;
import com.salesforce.servicelibs.io.grpc.Channel;
import com.salesforce.servicelibs.io.grpc.ClientCall;
import com.salesforce.servicelibs.io.grpc.ClientInterceptor;
import com.salesforce.servicelibs.io.grpc.Context;
import com.salesforce.servicelibs.io.grpc.ForwardingClientCall;
import com.salesforce.servicelibs.io.grpc.MethodDescriptor;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class DefaultDeadlineInterceptor
implements ClientInterceptor {
    private Duration duration;

    public DefaultDeadlineInterceptor(Duration duration) {
        Preconditions.checkNotNull(duration, "duration");
        Preconditions.checkArgument(!duration.isNegative(), "duration must be greater than zero");
        this.duration = duration;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        if (callOptions.getDeadline() == null && Context.current().getDeadline() == null) {
            callOptions = callOptions.withDeadlineAfter(this.duration.toMillis(), TimeUnit.MILLISECONDS);
        }
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){};
    }
}

