/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.PackedOffsets;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.SortedLSNTreeWalker;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.UtilizationFileReader;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.utilint.DbLsn;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class VerifyUtils {
    private static final boolean DEBUG = false;

    public static void checkLsns(Database db) throws DatabaseException {
        VerifyUtils.checkLsns(DbInternal.getDbImpl(db), System.out);
    }

    private static void checkLsns(DatabaseImpl dbImpl, PrintStream out) throws DatabaseException {
        GatherLSNs gatherLsns = new GatherLSNs();
        long rootLsn = dbImpl.getTree().getRootLsn();
        ArrayList<DatabaseException> savedExceptions = new ArrayList<DatabaseException>();
        SortedLSNTreeWalker walker = new SortedLSNTreeWalker(new DatabaseImpl[]{dbImpl}, new long[]{rootLsn}, gatherLsns, savedExceptions, null);
        walker.walk();
        if (savedExceptions.size() > 0) {
            out.println(savedExceptions.size() + " problems seen during tree walk for checkLsns");
            for (DatabaseException savedException : savedExceptions) {
                out.println("  " + savedException);
            }
        }
        Set<Long> lsnsInTree = gatherLsns.getLsns();
        if (rootLsn != -1L) {
            lsnsInTree.add(rootLsn);
        }
        Iterator<Long> iter = lsnsInTree.iterator();
        HashSet<Long> fileNums = new HashSet<Long>();
        while (iter.hasNext()) {
            long lsn = iter.next();
            fileNums.add(DbLsn.getFileNumber(lsn));
        }
        iter = fileNums.iterator();
        HashSet<Long> obsoleteLsns = new HashSet<Long>();
        EnvironmentImpl envImpl = dbImpl.getEnv();
        UtilizationProfile profile = envImpl.getUtilizationProfile();
        while (iter.hasNext()) {
            Long fileNum = iter.next();
            PackedOffsets obsoleteOffsets = profile.getObsoleteDetailPacked(fileNum, false);
            PackedOffsets.Iterator obsoleteIter = obsoleteOffsets.iterator();
            while (obsoleteIter.hasNext()) {
                long offset = obsoleteIter.next();
                Long oneLsn = DbLsn.makeLsn((long)fileNum, offset);
                obsoleteLsns.add(oneLsn);
            }
        }
        boolean error = false;
        for (Long lsn : lsnsInTree) {
            if (!obsoleteLsns.contains(lsn)) continue;
            out.println("Obsolete LSN set contains valid LSN " + DbLsn.getNoFormatString(lsn));
            error = true;
        }
        for (Long lsn : obsoleteLsns) {
            if (!lsnsInTree.contains(lsn)) continue;
            out.println("Tree contains obsolete LSN " + DbLsn.getNoFormatString(lsn));
            error = true;
        }
        if (error) {
            throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "Lsn mismatch");
        }
        if (savedExceptions.size() > 0) {
            throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "Sorted LSN Walk problem");
        }
    }

    public static void verifyUtilization(EnvironmentImpl envImpl, boolean expectAccurateObsoleteLNCount, boolean expectAccurateObsoleteLNSize) throws DatabaseException {
        SortedMap<Long, FileSummary> profileMap = envImpl.getCleaner().getUtilizationProfile().getFileSummaryMap(true);
        envImpl.getLogManager().flushNoSync();
        Map<Long, FileSummary> recalcMap = UtilizationFileReader.calcFileSummaryMap(envImpl);
        for (Map.Entry entry : profileMap.entrySet()) {
            Long file = (Long)entry.getKey();
            String fileStr = "0x" + Long.toHexString(file);
            FileSummary profileSummary = (FileSummary)entry.getValue();
            FileSummary recalcSummary = recalcMap.remove(file);
            VerifyUtils.checkTrue(fileStr, recalcSummary != null);
            VerifyUtils.checkEquals(fileStr, recalcSummary.totalCount, profileSummary.totalCount);
            VerifyUtils.checkEquals(fileStr, recalcSummary.totalSize, profileSummary.totalSize);
            VerifyUtils.checkEquals(fileStr, recalcSummary.totalINCount, profileSummary.totalINCount);
            VerifyUtils.checkEquals(fileStr, recalcSummary.totalINSize, profileSummary.totalINSize);
            VerifyUtils.checkEquals(fileStr, recalcSummary.totalLNCount, profileSummary.totalLNCount);
            VerifyUtils.checkEquals(fileStr, recalcSummary.totalLNSize, profileSummary.totalLNSize);
            if (!expectAccurateObsoleteLNCount) continue;
            VerifyUtils.checkEquals(fileStr, recalcSummary.obsoleteLNCount, profileSummary.obsoleteLNCount);
            if (!expectAccurateObsoleteLNSize) continue;
            VerifyUtils.checkEquals(fileStr, recalcSummary.getObsoleteLNSize(), profileSummary.obsoleteLNSize);
        }
        VerifyUtils.checkTrue(recalcMap.toString(), recalcMap.isEmpty());
    }

    private static void checkTrue(String errorMessage, boolean checkIsTrue) {
        if (!checkIsTrue) {
            throw EnvironmentFailureException.unexpectedState(errorMessage);
        }
    }

    private static void checkEquals(String errorMessage, long expect, long actual) {
        if (expect != actual) {
            throw EnvironmentFailureException.unexpectedState(errorMessage + " expected=" + expect + " actual=" + actual);
        }
    }

    private static class GatherLSNs
    implements SortedLSNTreeWalker.TreeNodeProcessor {
        private final Set<Long> lsns = new HashSet<Long>();

        private GatherLSNs() {
        }

        @Override
        public void processLSN(long childLSN, LogEntryType childType, Node ignore, byte[] ignore2, int ignore3, boolean ignore4) {
            if (childLSN != -1L) {
                this.lsns.add(childLSN);
            }
        }

        @Override
        public void processDirtyDeletedLN(long childLsn, LN ln, byte[] lnKey) {
        }

        public Set<Long> getLsns() {
            return this.lsns;
        }

        @Override
        public void noteMemoryExceeded() {
        }
    }
}

