/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.PackedOffsets;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.utilint.StringUtils;
import java.nio.ByteBuffer;

public final class FileSummaryLN
extends LN {
    private static final String BEGIN_TAG = "<fileSummaryLN>";
    private static final String END_TAG = "</fileSummaryLN>";
    private int extraMarshaledMemorySize;
    private final FileSummary baseSummary;
    private TrackedFileSummary trackedSummary;
    private PackedOffsets obsoleteOffsets;
    private boolean needOffsets;
    private int entryVersion;

    public FileSummaryLN(FileSummary baseSummary) {
        super(new byte[0]);
        assert (baseSummary != null);
        this.baseSummary = baseSummary;
        this.obsoleteOffsets = new PackedOffsets();
        this.entryVersion = -1;
    }

    public FileSummaryLN() {
        this.baseSummary = new FileSummary();
        this.obsoleteOffsets = new PackedOffsets();
    }

    private FileSummaryLN(boolean deletedMarker) {
        super((byte[])null);
        this.baseSummary = new FileSummary();
        this.obsoleteOffsets = new PackedOffsets();
    }

    public static LN makeDeletedLN() {
        return new FileSummaryLN(true);
    }

    public void setTrackedSummary(TrackedFileSummary trackedSummary) {
        this.trackedSummary = trackedSummary;
        this.needOffsets = true;
    }

    public TrackedFileSummary getTrackedSummary() {
        return this.trackedSummary;
    }

    public FileSummary getBaseSummary() {
        return this.baseSummary;
    }

    public PackedOffsets getObsoleteOffsets() {
        return this.obsoleteOffsets;
    }

    public static boolean hasStringKey(byte[] bytes) {
        if (bytes.length != 8) {
            return true;
        }
        return bytes[4] >= 48 && bytes[4] <= 57;
    }

    public static long getFileNumber(byte[] bytes) {
        if (FileSummaryLN.hasStringKey(bytes)) {
            return Long.valueOf(StringUtils.fromUTF8(bytes));
        }
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        return (long)LogUtils.readIntMSB(buf) & 0xFFFFFFFFL;
    }

    private static long getSequence(byte[] bytes) {
        if (FileSummaryLN.hasStringKey(bytes)) {
            return 0L;
        }
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        LogUtils.readIntMSB(buf);
        return (long)(Integer.MAX_VALUE - LogUtils.readIntMSB(buf)) & 0xFFFFFFFFL;
    }

    public static byte[] makePartialKey(long fileNum) {
        byte[] bytes = new byte[4];
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        LogUtils.writeIntMSB(buf, (int)fileNum);
        return bytes;
    }

    public static byte[] makeFullKey(long fileNum, int sequence) {
        assert (sequence >= 0);
        byte[] bytes = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        LogUtils.writeIntMSB(buf, (int)fileNum);
        LogUtils.writeIntMSB(buf, Integer.MAX_VALUE - sequence);
        return bytes;
    }

    @Override
    public void postFetchInit(DatabaseImpl db, long sourceLsn) throws DatabaseException {
        super.postFetchInit(db, sourceLsn);
        if (this.entryVersion == 1 && db.getEnv().getCleaner().isRMWFixEnabled()) {
            this.obsoleteOffsets = new PackedOffsets();
        }
    }

    @Override
    public String toString() {
        return this.dumpString(0, true);
    }

    @Override
    public String beginTag() {
        return BEGIN_TAG;
    }

    @Override
    public String endTag() {
        return END_TAG;
    }

    @Override
    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.dumpString(nSpaces, dumpTags));
        sb.append('\n');
        if (!this.isDeleted()) {
            sb.append(this.baseSummary.toString());
            sb.append(this.obsoleteOffsets.toString());
        }
        return sb.toString();
    }

    @Override
    protected void dumpLogAdditional(StringBuilder sb, boolean verbose) {
        if (!this.isDeleted()) {
            this.baseSummary.dumpLog(sb, true);
            if (verbose) {
                this.obsoleteOffsets.dumpLog(sb, true);
            }
        }
    }

    @Override
    protected LogEntryType getLogType(boolean isInsert, boolean isTransactional, DatabaseImpl db) {
        assert (!isTransactional) : "Txnl access to UP db not allowed";
        return LogEntryType.LOG_FILESUMMARYLN;
    }

    @Override
    public int getLogSize(int logVersion, boolean forReplication) {
        int size = super.getLogSize(logVersion, forReplication);
        if (!this.isDeleted()) {
            size += this.baseSummary.getLogSize();
            this.getOffsets();
            size += this.obsoleteOffsets.getLogSize();
        }
        return size;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer, int logVersion, boolean forReplication) {
        if (this.trackedSummary != null && !this.isDeleted()) {
            this.baseSummary.add(this.trackedSummary);
            this.getOffsets();
            this.trackedSummary.reset();
        }
        super.writeToLog(logBuffer, logVersion, forReplication);
        if (!this.isDeleted()) {
            this.baseSummary.writeToLog(logBuffer);
            this.obsoleteOffsets.writeToLog(logBuffer);
        }
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        this.entryVersion = entryVersion;
        super.readFromLog(itemBuffer, entryVersion);
        if (!this.isDeleted()) {
            this.baseSummary.readFromLog(itemBuffer, entryVersion);
            if (entryVersion > 0) {
                this.obsoleteOffsets.readFromLog(itemBuffer, entryVersion);
            }
        }
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    private void getOffsets() {
        assert (!this.isDeleted());
        if (this.needOffsets) {
            long[] offsets = this.trackedSummary.getObsoleteOffsets();
            if (offsets != null) {
                int oldSize = this.obsoleteOffsets.getExtraMemorySize();
                this.obsoleteOffsets.pack(offsets);
                int newSize = this.obsoleteOffsets.getExtraMemorySize();
                this.extraMarshaledMemorySize = newSize - oldSize;
            }
            this.needOffsets = false;
        }
    }

    @Override
    public long getMemorySizeIncludedByParent() {
        return super.getMemorySizeIncludedByParent() + (long)(MemoryBudget.FILESUMMARYLN_OVERHEAD - MemoryBudget.LN_OVERHEAD) + (long)this.obsoleteOffsets.getExtraMemorySize();
    }

    @Override
    void makeDeleted() {
        super.makeDeleted();
        this.obsoleteOffsets = new PackedOffsets();
    }

    @Override
    public void addExtraMarshaledMemorySize(BIN parentBIN) {
        if (this.extraMarshaledMemorySize != 0) {
            assert (this.trackedSummary != null);
            assert (parentBIN.isLatchExclusiveOwner());
            parentBIN.updateMemorySize(0L, this.extraMarshaledMemorySize);
            this.extraMarshaledMemorySize = 0;
        }
    }

    @Override
    public void dumpKey(StringBuilder sb, byte[] key) {
        sb.append("<fileSummaryLNKey fileNumber=\"0x" + Long.toHexString(FileSummaryLN.getFileNumber(key)) + "\" ");
        sb.append("sequence=\"0x" + Long.toHexString(FileSummaryLN.getSequence(key)) + "\"/>");
        super.dumpKey(sb, key);
    }
}

