/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.ExtinctionFilter;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.CleanerStatDefinition;
import com.sleepycat.je.cleaner.ExpirationProfile;
import com.sleepycat.je.cleaner.FileProcessor;
import com.sleepycat.je.cleaner.FileProtector;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.LNInfo;
import com.sleepycat.je.cleaner.UtilizationCalculator;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.AtomicLongMapStat;
import com.sleepycat.je.utilint.DaemonRunner;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.FileStoreInfo;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.Pair;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.VLSN;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cleaner
implements DaemonRunner,
EnvConfigObserver {
    static final String CLEAN_IN = "CleanIN:";
    static final String CLEAN_LN = "CleanLN:";
    static final String CLEAN_PENDING_LN = "CleanPendingLN:";
    private static final NumberFormat INT_FORMAT = NumberFormat.getIntegerInstance();
    static final CacheMode UPDATE_GENERATION = CacheMode.UNCHANGED;
    static final boolean DO_CRITICAL_EVICTION = true;
    private static final String DELETED_SUBDIR = "deleted";
    private static final long MAX_CLEANER_BYTES_INTERVAL = 0x6400000L;
    private static final long MAX_DISK_ADJUSTMENT_THRESHOLD = 0x280000000L;
    private boolean fileDeletionEnabled = true;
    private final ReentrantLock manageDiskUsageLock = new ReentrantLock();
    private final StatGroup statGroup;
    final LongStat nCleanerRuns;
    final LongStat nTwoPassRuns;
    final LongStat nRevisalRuns;
    private final LongStat nCleanerDeletions;
    final LongStat nINsObsolete;
    final LongStat nINsCleaned;
    final LongStat nINsDead;
    final LongStat nINsMigrated;
    final LongStat nBINDeltasObsolete;
    final LongStat nBINDeltasCleaned;
    final LongStat nBINDeltasDead;
    final LongStat nBINDeltasMigrated;
    final LongStat nLNsObsolete;
    final LongStat nLNsExpired;
    final LongStat nLNsExtinct;
    final LongStat nLNsCleaned;
    final LongStat nLNsDead;
    final LongStat nLNsLocked;
    final LongStat nLNsMigrated;
    final LongStat nLNsMarked;
    final LongStat nLNQueueHits;
    private final LongStat nPendingLNsProcessed;
    private final LongStat nPendingLNsLocked;
    private final LongStat nPendingDBsProcessed;
    private final LongStat nPendingDBsIncomplete;
    final LongStat nEntriesRead;
    final LongStat nDiskReads;
    private FileProtector.LogSizeStats logSizeStats;
    private long availableLogSize;
    private long totalLogSize;
    private long maxDiskOverage;
    private long freeDiskShortage;
    private String diskUsageMessage;
    private volatile String diskUsageViolationMessage;
    private boolean loggedDiskLimitViolation;
    long lockTimeout;
    int readBufferSize;
    int lookAheadCacheSize;
    long nDeadlockRetries;
    boolean expunge;
    private boolean useDeletedDir;
    int twoPassGap;
    int twoPassThreshold;
    boolean gradualExpiration;
    long cleanerBytesInterval;
    boolean trackDetail;
    private boolean fetchObsoleteSize;
    int dbCacheClearCount;
    private final boolean rmwFixEnabled;
    int minUtilization;
    int minFileUtilization;
    int minAge;
    private long maxDiskLimit;
    private long freeDiskLimit;
    private long adjustedMaxDiskLimit;
    private long reservedDiskLimit;
    private final String name;
    private final EnvironmentImpl env;
    private final FileStoreInfo fileStoreInfo;
    private final FileProtector fileProtector;
    private final UtilizationProfile profile;
    private final UtilizationTracker tracker;
    private final ExpirationProfile expirationProfile;
    private final UtilizationCalculator calculator;
    private final FileSelector fileSelector;
    private FileProcessor[] threads;
    private final Logger logger;
    final AtomicLong totalRuns;
    TestHook fileChosenHook;
    private final AtomicBoolean processPendingReentrancyGuard = new AtomicBoolean(false);
    private final AtomicLong bytesWrittenSinceActivation = new AtomicLong(0L);

    public Cleaner(EnvironmentImpl env, String name) {
        this.env = env;
        this.name = name;
        this.statGroup = new StatGroup("Cleaning", "Log cleaning involves garbage collection of data files in the append-only storage system.");
        this.nCleanerRuns = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_RUNS);
        this.nTwoPassRuns = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_TWO_PASS_RUNS);
        this.nRevisalRuns = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_REVISAL_RUNS);
        this.nCleanerDeletions = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_DELETIONS);
        this.nINsObsolete = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_INS_OBSOLETE);
        this.nINsCleaned = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_INS_CLEANED);
        this.nINsDead = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_INS_DEAD);
        this.nINsMigrated = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_INS_MIGRATED);
        this.nBINDeltasObsolete = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_BIN_DELTAS_OBSOLETE);
        this.nBINDeltasCleaned = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_BIN_DELTAS_CLEANED);
        this.nBINDeltasDead = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_BIN_DELTAS_DEAD);
        this.nBINDeltasMigrated = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_BIN_DELTAS_MIGRATED);
        this.nLNsObsolete = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_LNS_OBSOLETE);
        this.nLNsExpired = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_LNS_EXPIRED);
        this.nLNsExtinct = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_LNS_EXTINCT);
        this.nLNsCleaned = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_LNS_CLEANED);
        this.nLNsDead = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_LNS_DEAD);
        this.nLNsLocked = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_LNS_LOCKED);
        this.nLNsMigrated = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_LNS_MIGRATED);
        this.nLNsMarked = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_LNS_MARKED);
        this.nLNQueueHits = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_LNQUEUE_HITS);
        this.nPendingLNsProcessed = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_PENDING_LNS_PROCESSED);
        this.nPendingLNsLocked = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_PENDING_LNS_LOCKED);
        this.nPendingDBsProcessed = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_PENDING_DBS_PROCESSED);
        this.nPendingDBsIncomplete = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_PENDING_DBS_INCOMPLETE);
        this.nEntriesRead = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_ENTRIES_READ);
        this.nDiskReads = new LongStat(this.statGroup, CleanerStatDefinition.CLEANER_DISK_READS);
        this.logSizeStats = new FileProtector.LogSizeStats(0L, 0L, 0L, new HashMap<String, Long>());
        if (env.isMemOnly()) {
            this.fileStoreInfo = null;
        } else {
            try {
                this.fileStoreInfo = FileStoreInfo.getInfo(env.getEnvironmentHome().getAbsolutePath());
            }
            catch (IOException e) {
                throw EnvironmentFailureException.unexpectedException(env, (Exception)e);
            }
        }
        this.fileProtector = new FileProtector(env);
        this.tracker = new UtilizationTracker(env, this);
        this.profile = new UtilizationProfile(env, this.tracker);
        this.expirationProfile = new ExpirationProfile(env);
        this.calculator = new UtilizationCalculator(env, this);
        this.fileSelector = new FileSelector();
        this.threads = new FileProcessor[0];
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.totalRuns = new AtomicLong(0L);
        this.trackDetail = env.getConfigManager().getBoolean(EnvironmentParams.CLEANER_TRACK_DETAIL);
        this.rmwFixEnabled = env.getConfigManager().getBoolean(EnvironmentParams.CLEANER_RMW_FIX);
        this.setMutableProperties(env.getConfigManager());
        env.addConfigObserver(this);
    }

    @Override
    public void envConfigUpdate(DbConfigManager cm, EnvironmentMutableConfig ignore) {
        this.setMutableProperties(cm);
        this.wakeupActivate();
    }

    private void setMutableProperties(DbConfigManager cm) {
        this.lockTimeout = cm.getDuration(EnvironmentParams.CLEANER_LOCK_TIMEOUT);
        this.readBufferSize = cm.getInt(EnvironmentParams.CLEANER_READ_SIZE);
        if (this.readBufferSize <= 0) {
            this.readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        }
        this.lookAheadCacheSize = cm.getInt(EnvironmentParams.CLEANER_LOOK_AHEAD_CACHE_SIZE);
        this.nDeadlockRetries = cm.getInt(EnvironmentParams.CLEANER_DEADLOCK_RETRY);
        this.expunge = cm.getBoolean(EnvironmentParams.CLEANER_REMOVE);
        this.useDeletedDir = cm.getBoolean(EnvironmentParams.CLEANER_USE_DELETED_DIR);
        this.twoPassGap = cm.getInt(EnvironmentParams.CLEANER_TWO_PASS_GAP);
        this.twoPassThreshold = cm.getInt(EnvironmentParams.CLEANER_TWO_PASS_THRESHOLD);
        if (this.twoPassThreshold == 0) {
            this.twoPassThreshold = cm.getInt(EnvironmentParams.CLEANER_MIN_UTILIZATION) - 5;
        }
        this.gradualExpiration = cm.getBoolean(EnvironmentParams.CLEANER_GRADUAL_EXPIRATION);
        this.dbCacheClearCount = cm.getInt(EnvironmentParams.ENV_DB_CACHE_CLEAR_COUNT);
        int nThreads = cm.getInt(EnvironmentParams.CLEANER_THREADS);
        assert (nThreads > 0);
        if (nThreads != this.threads.length) {
            int i;
            for (int i2 = nThreads; i2 < this.threads.length; ++i2) {
                if (this.threads[i2] == null) continue;
                this.threads[i2].shutdown();
                this.threads[i2] = null;
            }
            FileProcessor[] newThreads = new FileProcessor[nThreads];
            for (i = 0; i < nThreads && i < this.threads.length; ++i) {
                newThreads[i] = this.threads[i];
            }
            this.threads = newThreads;
            for (i = 0; i < nThreads; ++i) {
                if (this.threads[i] != null) continue;
                this.threads[i] = new FileProcessor(this.name + '-' + (i + 1), i == 0, this.env, this, this.profile, this.calculator, this.fileSelector);
            }
        }
        this.cleanerBytesInterval = cm.getLong(EnvironmentParams.CLEANER_BYTES_INTERVAL);
        if (this.cleanerBytesInterval == 0L) {
            this.cleanerBytesInterval = cm.getLong(EnvironmentParams.LOG_FILE_MAX) / 4L;
            this.cleanerBytesInterval = Math.min(this.cleanerBytesInterval, 0x6400000L);
        }
        int wakeupInterval = cm.getDuration(EnvironmentParams.CLEANER_WAKEUP_INTERVAL);
        for (FileProcessor thread : this.threads) {
            if (thread == null) continue;
            thread.setWaitTime(wakeupInterval);
        }
        this.fetchObsoleteSize = cm.getBoolean(EnvironmentParams.CLEANER_FETCH_OBSOLETE_SIZE);
        this.minAge = cm.getInt(EnvironmentParams.CLEANER_MIN_AGE);
        this.minUtilization = cm.getInt(EnvironmentParams.CLEANER_MIN_UTILIZATION);
        this.minFileUtilization = cm.getInt(EnvironmentParams.CLEANER_MIN_FILE_UTILIZATION);
        this.adjustedMaxDiskLimit = this.maxDiskLimit = cm.getLong(EnvironmentParams.MAX_DISK);
        if (this.env.isMemOnly()) {
            this.freeDiskLimit = 0L;
        } else {
            int replayFreeDiskPct = this.env.getReplayFreeDiskPercent();
            if (replayFreeDiskPct == 0) {
                this.freeDiskLimit = cm.getLong(EnvironmentParams.FREE_DISK);
            } else {
                if (cm.isSpecified(EnvironmentParams.FREE_DISK)) {
                    throw new IllegalArgumentException("Cannot specify both je.freeDisk and je.rep.replayFreeDiskPercent.");
                }
                this.freeDiskLimit = this.getDiskTotalSpace() * (long)replayFreeDiskPct / 100L;
            }
            if (this.maxDiskLimit > 0x280000000L || cm.isSpecified(EnvironmentParams.FREE_DISK) || replayFreeDiskPct != 0) {
                this.adjustedMaxDiskLimit -= this.freeDiskLimit;
            }
        }
        this.reservedDiskLimit = cm.getLong(EnvironmentParams.RESERVED_DISK);
    }

    public FileProtector getFileProtector() {
        return this.fileProtector;
    }

    public UtilizationTracker getUtilizationTracker() {
        return this.tracker;
    }

    public UtilizationProfile getUtilizationProfile() {
        return this.profile;
    }

    UtilizationCalculator getUtilizationCalculator() {
        return this.calculator;
    }

    public ExpirationProfile getExpirationProfile() {
        return this.expirationProfile;
    }

    public FileSelector getFileSelector() {
        return this.fileSelector;
    }

    public boolean getFetchObsoleteSize(DatabaseImpl db) {
        return this.fetchObsoleteSize && !db.isLNImmediatelyObsolete();
    }

    public boolean isRMWFixEnabled() {
        return this.rmwFixEnabled;
    }

    void setFileChosenHook(TestHook hook) {
        this.fileChosenHook = hook;
    }

    @Override
    public void runOrPause(boolean run) {
        if (this.env.isNoLocking()) {
            return;
        }
        for (FileProcessor processor : this.threads) {
            if (processor == null) continue;
            if (run) {
                processor.activateOnWakeup();
            }
            processor.runOrPause(run);
        }
    }

    public void wakeupAfterWrite(int writeSize) {
        if (this.bytesWrittenSinceActivation.addAndGet(writeSize) > this.cleanerBytesInterval) {
            this.bytesWrittenSinceActivation.set(0L);
            this.wakeupActivate();
        }
    }

    public void wakeupActivate() {
        for (FileProcessor thread : this.threads) {
            if (thread == null) continue;
            thread.activateOnWakeup();
            thread.wakeup();
        }
    }

    @Override
    public void requestShutdown() {
        for (FileProcessor thread : this.threads) {
            if (thread == null) continue;
            thread.requestShutdown();
        }
    }

    @Override
    public void shutdown() {
        for (int i = 0; i < this.threads.length; ++i) {
            if (this.threads[i] == null) continue;
            this.threads[i].shutdown();
            this.threads[i] = null;
        }
    }

    @Override
    public int getNWakeupRequests() {
        int count = 0;
        for (FileProcessor thread : this.threads) {
            if (thread == null) continue;
            count += thread.getNWakeupRequests();
        }
        return count;
    }

    public int doClean(boolean cleanMultipleFiles, boolean forceCleaning) {
        FileProcessor processor = this.createProcessor();
        return processor.doClean(false, cleanMultipleFiles, forceCleaning);
    }

    public FileProcessor createProcessor() {
        return new FileProcessor("", false, this.env, this, this.profile, this.calculator, this.fileSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatGroup loadStats(StatsConfig config) {
        StatGroup stats = this.statGroup.cloneGroup(config.getClear());
        Pair<Integer, Integer> pendingQueueSizes = this.fileSelector.getPendingQueueSizes();
        new IntStat(stats, CleanerStatDefinition.CLEANER_MIN_UTILIZATION, this.calculator.getCurrentMinUtilization());
        new IntStat(stats, CleanerStatDefinition.CLEANER_MAX_UTILIZATION, this.calculator.getCurrentMaxUtilization());
        new IntStat(stats, CleanerStatDefinition.CLEANER_PREDICTED_MIN_UTILIZATION, this.calculator.getPredictedMinUtilization());
        new IntStat(stats, CleanerStatDefinition.CLEANER_PREDICTED_MAX_UTILIZATION, this.calculator.getPredictedMaxUtilization());
        new IntStat(stats, CleanerStatDefinition.CLEANER_PENDING_LN_QUEUE_SIZE, pendingQueueSizes.first());
        new IntStat(stats, CleanerStatDefinition.CLEANER_PENDING_DB_QUEUE_SIZE, pendingQueueSizes.second());
        StatGroup statGroup = this.statGroup;
        synchronized (statGroup) {
            new LongStat(stats, CleanerStatDefinition.CLEANER_ACTIVE_LOG_SIZE, this.logSizeStats.activeSize);
            new LongStat(stats, CleanerStatDefinition.CLEANER_RESERVED_LOG_SIZE, this.logSizeStats.reservedSize);
            new LongStat(stats, CleanerStatDefinition.CLEANER_PROTECTED_LOG_SIZE, this.logSizeStats.protectedSize);
            new LongStat(stats, CleanerStatDefinition.CLEANER_AVAILABLE_LOG_SIZE, this.availableLogSize);
            new LongStat(stats, CleanerStatDefinition.CLEANER_TOTAL_LOG_SIZE, this.totalLogSize);
            AtomicLongMapStat protectedSizeMap = new AtomicLongMapStat(stats, CleanerStatDefinition.CLEANER_PROTECTED_LOG_SIZE_MAP);
            for (Map.Entry<String, Long> entry : this.logSizeStats.protectedSizeMap.entrySet()) {
                protectedSizeMap.createStat(entry.getKey()).set(entry.getValue());
            }
        }
        return stats;
    }

    public synchronized void enableFileDeletion(boolean enable) {
        this.fileDeletionEnabled = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manageDiskUsage() {
        this.env.checkIfInvalid();
        if (this.env.isMemOnly() || this.env.mayNotWrite() || !this.fileDeletionEnabled) {
            return;
        }
        if (!this.manageDiskUsageLock.tryLock()) {
            return;
        }
        try {
            String violation;
            this.freshenLogSizeStats();
            if (this.fileProtector.getNReservedFiles() > 0) {
                boolean freshenStats = false;
                if (this.env.isReplicated()) {
                    long bytesNeeded;
                    long origBytesNeeded = (this.maxDiskLimit > 0L ? Math.max(this.maxDiskOverage, this.freeDiskShortage) : this.freeDiskShortage) + Math.max(0x100000L, 3L * this.cleanerBytesInterval);
                    if (this.reservedDiskLimit > 0L) {
                        origBytesNeeded = Math.max(origBytesNeeded, this.logSizeStats.reservedSize - this.reservedDiskLimit);
                    }
                    if ((bytesNeeded = origBytesNeeded) > 0L) {
                        bytesNeeded = this.deleteUnprotectedFiles(bytesNeeded);
                    }
                    if (bytesNeeded > 0L && this.env.tryVlsnHeadTruncate(bytesNeeded)) {
                        bytesNeeded = this.deleteUnprotectedFiles(bytesNeeded);
                        freshenStats = true;
                    }
                    if (bytesNeeded < origBytesNeeded) {
                        freshenStats = true;
                    }
                } else {
                    long bytesNeeded = this.deleteUnprotectedFiles(Long.MAX_VALUE);
                    if (bytesNeeded < Long.MAX_VALUE) {
                        freshenStats = true;
                    }
                }
                if (freshenStats) {
                    this.freshenLogSizeStats();
                }
            }
            if ((violation = this.diskUsageViolationMessage) != null) {
                if (!this.loggedDiskLimitViolation) {
                    LoggerUtils.logMsg(this.logger, this.env, Level.SEVERE, violation);
                    this.loggedDiskLimitViolation = true;
                }
            } else {
                this.loggedDiskLimitViolation = false;
            }
        }
        catch (EnvLockedException e) {
            LoggerUtils.logMsg(this.logger, this.env, Level.SEVERE, "Could not delete files due to read-only processes. " + this.diskUsageMessage);
        }
        finally {
            this.manageDiskUsageLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long deleteUnprotectedFiles(long bytesNeeded) throws EnvLockedException {
        FileManager fileManager = this.env.getFileManager();
        TreeSet<Long> deletedFiles = new TreeSet<Long>();
        if (!fileManager.lockEnvironment(false, true)) {
            throw new EnvLockedException();
        }
        try {
            long file = -1L;
            while (bytesNeeded > 0L || !this.env.isReplicated()) {
                Pair<Long, Long> pair = this.fileProtector.takeCondemnedFile(file + 1L);
                if (pair == null) {
                    break;
                }
                file = pair.first();
                long size = pair.second();
                if (!this.deleteFile(file)) {
                    this.fileProtector.putBackCondemnedFile(file, size);
                    continue;
                }
                bytesNeeded = Math.max(0L, bytesNeeded - size);
                this.profile.deleteReservedFileRecord(file);
                this.nCleanerDeletions.increment();
                deletedFiles.add(file);
            }
        }
        finally {
            fileManager.releaseExclusiveLock();
            if (!deletedFiles.isEmpty()) {
                StringBuilder sb = new StringBuilder("Cleaner deleted files:");
                for (Long file : deletedFiles) {
                    sb.append(" 0x");
                    sb.append(Long.toHexString(file));
                }
                LoggerUtils.traceAndLog(this.logger, this.env, Level.INFO, sb.toString());
            }
        }
        return bytesNeeded;
    }

    private boolean deleteFile(Long file) {
        FileManager fileManager = this.env.getFileManager();
        String expungeLabel = this.expunge ? "delete" : "rename";
        String expungedLabel = expungeLabel + "d";
        try {
            if (this.expunge) {
                if (fileManager.deleteFile(file)) {
                    return true;
                }
            } else {
                File newFile = fileManager.renameFile(file, ".del", this.useDeletedDir ? DELETED_SUBDIR : null);
                if (newFile != null) {
                    newFile.setLastModified(System.currentTimeMillis());
                    return true;
                }
            }
        }
        catch (IOException e) {
            throw new EnvironmentFailureException(this.env, EnvironmentFailureReason.LOG_WRITE, "Unable to " + expungeLabel + " " + file, e);
        }
        if (!fileManager.isFileValid(file)) {
            return true;
        }
        LoggerUtils.traceAndLog(this.logger, this.env, Level.WARNING, "Log file 0x" + Long.toHexString(file) + " could not be " + expungedLabel + ". The deletion will be retried later.");
        return false;
    }

    public void freshenLogSizeStats() {
        this.recalcLogSizeStats(this.fileProtector.getLogSizeStats(), this.getDiskFreeSpace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recalcLogSizeStats(FileProtector.LogSizeStats stats, long diskFreeSpace) {
        long freeBytes2;
        long maxOverage;
        long maxLimit = this.maxDiskLimit;
        long adjustedMax = this.adjustedMaxDiskLimit;
        long freeLimit = this.freeDiskLimit;
        long freeBytes1 = diskFreeSpace - freeLimit;
        long freeShortage = 0L - freeBytes1;
        long totalSize = stats.activeSize + stats.reservedSize;
        if (adjustedMax > 0L) {
            maxOverage = totalSize - adjustedMax;
            freeBytes2 = Math.min(freeBytes1, adjustedMax - totalSize);
        } else {
            maxOverage = 0L;
            freeBytes2 = freeBytes1;
        }
        long availBytes = freeBytes2 + stats.reservedSize - stats.protectedSize;
        StringBuilder sb = new StringBuilder();
        if (availBytes <= 0L) {
            sb.append("Disk usage is not within je.maxDisk or je.freeDisk ");
            sb.append("limits and write operations are prohibited:");
        } else {
            sb.append("Disk usage is currently within je.maxDisk and ");
            sb.append("je.freeDisk limits:");
        }
        sb.append(" maxDiskLimit=");
        sb.append(INT_FORMAT.format(maxLimit));
        sb.append(" freeDiskLimit=");
        sb.append(INT_FORMAT.format(freeLimit));
        sb.append(" adjustedMaxDiskLimit=");
        sb.append(INT_FORMAT.format(adjustedMax));
        sb.append(" maxDiskOverage=");
        sb.append(INT_FORMAT.format(maxOverage));
        sb.append(" freeDiskShortage=");
        sb.append(INT_FORMAT.format(freeShortage));
        sb.append(" diskFreeSpace=");
        sb.append(INT_FORMAT.format(diskFreeSpace));
        sb.append(" availableLogSize=");
        sb.append(INT_FORMAT.format(availBytes));
        sb.append(" totalLogSize=");
        sb.append(INT_FORMAT.format(totalSize));
        sb.append(" activeLogSize=");
        sb.append(INT_FORMAT.format(stats.activeSize));
        sb.append(" reservedLogSize=");
        sb.append(INT_FORMAT.format(stats.reservedSize));
        sb.append(" protectedLogSize=");
        sb.append(INT_FORMAT.format(stats.protectedSize));
        sb.append(" protectedLogSizeMap={");
        for (Map.Entry<String, Long> entry : stats.protectedSizeMap.entrySet()) {
            sb.append(entry.getKey()).append(":");
            sb.append(INT_FORMAT.format(entry.getValue()));
        }
        sb.append("}");
        String msg = sb.toString();
        StatGroup statGroup = this.statGroup;
        synchronized (statGroup) {
            this.maxDiskOverage = maxOverage;
            this.freeDiskShortage = freeShortage;
            this.diskUsageMessage = msg;
            this.diskUsageViolationMessage = availBytes <= 0L ? msg : null;
            this.availableLogSize = availBytes;
            this.totalLogSize = totalSize;
            this.logSizeStats = stats;
        }
    }

    private long getDiskFreeSpace() {
        try {
            return this.fileStoreInfo.getUsableSpace();
        }
        catch (IOException e) {
            throw EnvironmentFailureException.unexpectedException(this.env, (Exception)e);
        }
    }

    private long getDiskTotalSpace() {
        try {
            return this.fileStoreInfo.getTotalSpace();
        }
        catch (IOException e) {
            throw EnvironmentFailureException.unexpectedException(this.env, (Exception)e);
        }
    }

    public String getDiskLimitMessage() {
        return this.diskUsageMessage;
    }

    public String getDiskLimitViolation() {
        return this.diskUsageViolationMessage;
    }

    long getMaxDiskOverage() {
        return this.maxDiskOverage;
    }

    long getFreeDiskShortage() {
        return this.freeDiskShortage;
    }

    public FileSelector.CheckpointStartCleanerState getFilesAtCheckpointStart() {
        this.processPending();
        return this.fileSelector.getFilesAtCheckpointStart(this.env, this.logger);
    }

    public void updateFilesAtCheckpointEnd(FileSelector.CheckpointStartCleanerState info) {
        Map<Long, FileSelector.FileInfo> reservedFiles = this.fileSelector.updateFilesAtCheckpointEnd(this.env, info);
        this.profile.reserveFiles(reservedFiles);
        this.manageDiskUsage();
        this.expirationProfile.processCompletedTrackers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPending() {
        if (!this.processPendingReentrancyGuard.compareAndSet(false, true)) {
            return;
        }
        try {
            List<DatabaseId> pendingDBs;
            DbTree dbMapTree = this.env.getDbTree();
            LockManager lockManager = this.env.getTxnManager().getLockManager();
            Map<Long, LNInfo> pendingLNs = this.fileSelector.getPendingLNs();
            if (pendingLNs != null) {
                TreeLocation location = new TreeLocation();
                for (Map.Entry entry : pendingLNs.entrySet()) {
                    if (!this.env.isValid()) {
                        return;
                    }
                    if (this.diskUsageViolationMessage != null) break;
                    this.nPendingLNsProcessed.increment();
                    long logLsn = (Long)entry.getKey();
                    LNInfo info = (LNInfo)entry.getValue();
                    byte[] key = info.getKey();
                    DatabaseId dbId = info.getDbId();
                    DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                    try {
                        if (this.env.expiresWithin(info.getExpirationTime(), 0 - this.env.getTtlLnPurgeDelay())) {
                            if (lockManager.isLockUncontended(logLsn)) {
                                this.fileSelector.removePendingLN(logLsn);
                                this.nLNsExpired.increment();
                                this.nLNsObsolete.increment();
                                continue;
                            }
                            this.nPendingLNsLocked.increment();
                            continue;
                        }
                        if (this.env.getExtinctionState(db, key) == ExtinctionFilter.ExtinctionStatus.EXTINCT) {
                            this.fileSelector.removePendingLN(logLsn);
                            this.nLNsExtinct.increment();
                            this.nLNsObsolete.increment();
                            continue;
                        }
                        this.env.daemonEviction(true);
                        this.processPendingLN(logLsn, db, key, location);
                    }
                    finally {
                        dbMapTree.releaseDb(db);
                    }
                }
            }
            if ((pendingDBs = this.fileSelector.getPendingDBs()) != null) {
                for (DatabaseId databaseId : pendingDBs) {
                    if (!this.env.isValid()) {
                        return;
                    }
                    this.nPendingDBsProcessed.increment();
                    DatabaseImpl db = dbMapTree.getDb(databaseId, this.lockTimeout);
                    try {
                        if (db == null) {
                            this.fileSelector.removePendingDB(databaseId);
                            continue;
                        }
                        this.nPendingDBsIncomplete.increment();
                    }
                    finally {
                        dbMapTree.releaseDb(db);
                    }
                }
            }
        }
        finally {
            this.processPendingReentrancyGuard.set(false);
        }
    }

    private void processPendingLN(long logLsn, DatabaseImpl db, byte[] keyFromLog, TreeLocation location) {
        boolean processedHere = true;
        boolean lockDenied = false;
        boolean obsolete = false;
        boolean completed = false;
        Locker locker = null;
        IN bin = null;
        try {
            if (db == null || db.isDeleting()) {
                if (db != null) {
                    this.addPendingDB(DbLsn.getFileNumber(logLsn), db.getId());
                }
                this.nLNsDead.increment();
                obsolete = true;
                completed = true;
                return;
            }
            Tree tree = db.getTree();
            assert (tree != null);
            locker = BasicLocker.createBasicLocker(this.env, false);
            locker.setPreemptable(false);
            LockResult lockRet = locker.nonBlockingLock(logLsn, LockType.READ, false, db);
            if (lockRet.getLockGrant() == LockGrantType.DENIED) {
                this.nPendingLNsLocked.increment();
                lockDenied = true;
                completed = true;
                return;
            }
            boolean parentFound = tree.getParentBINForChildLN(location, keyFromLog, false, false, UPDATE_GENERATION);
            bin = location.bin;
            int index = location.index;
            if (!parentFound) {
                this.nLNsDead.increment();
                obsolete = true;
                completed = true;
                return;
            }
            processedHere = false;
            lockDenied = this.migratePendingLN(db, logLsn, bin.getLsn(index), (BIN)bin, index);
            completed = true;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            LoggerUtils.traceAndLogException(this.env, "com.sleepycat.je.cleaner.Cleaner", "processLN", "Exception thrown: ", e);
            throw e;
        }
        finally {
            if (bin != null) {
                bin.releaseLatch();
            }
            if (locker != null) {
                locker.operationEnd();
            }
            if (completed && !lockDenied) {
                this.fileSelector.removePendingLN(logLsn);
            }
            if (processedHere) {
                this.logFine(CLEAN_PENDING_LN, null, -1L, completed, obsolete, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean migratePendingLN(DatabaseImpl db, long logLsn, long treeLsn, BIN bin, int index) {
        boolean bl;
        LN ln;
        boolean completed;
        boolean migrated;
        boolean obsolete;
        block27: {
            Locker locker;
            boolean clearTarget;
            block25: {
                boolean lockRet2;
                block26: {
                    block21: {
                        boolean bl2;
                        block24: {
                            block22: {
                                boolean bl3;
                                block23: {
                                    block19: {
                                        boolean bl4;
                                        block20: {
                                            block17: {
                                                boolean bl5;
                                                block18: {
                                                    obsolete = false;
                                                    migrated = false;
                                                    completed = false;
                                                    clearTarget = false;
                                                    locker = null;
                                                    ln = null;
                                                    try {
                                                        if (treeLsn != -1L) break block17;
                                                        completed = true;
                                                        bl5 = false;
                                                        if (clearTarget) {
                                                            bin.evictLN(index);
                                                        }
                                                        if (locker == null) break block18;
                                                    }
                                                    catch (Throwable throwable) {
                                                        if (clearTarget) {
                                                            bin.evictLN(index);
                                                        }
                                                        if (locker != null) {
                                                            locker.operationEnd();
                                                        }
                                                        this.logFine(CLEAN_PENDING_LN, ln, treeLsn, completed, obsolete, migrated);
                                                        throw throwable;
                                                    }
                                                    locker.operationEnd();
                                                }
                                                this.logFine(CLEAN_PENDING_LN, ln, treeLsn, completed, obsolete, migrated);
                                                return bl5;
                                            }
                                            if (!bin.isEntryKnownDeleted(index)) break block19;
                                            this.nLNsDead.increment();
                                            obsolete = true;
                                            completed = true;
                                            bl4 = false;
                                            if (clearTarget) {
                                                bin.evictLN(index);
                                            }
                                            if (locker == null) break block20;
                                            locker.operationEnd();
                                        }
                                        this.logFine(CLEAN_PENDING_LN, ln, treeLsn, completed, obsolete, migrated);
                                        return bl4;
                                    }
                                    if (logLsn == treeLsn) break block21;
                                    locker = BasicLocker.createBasicLocker(this.env, false);
                                    locker.setPreemptable(false);
                                    LockResult lockRet2 = locker.nonBlockingLock(treeLsn, LockType.READ, false, db);
                                    if (lockRet2.getLockGrant() != LockGrantType.DENIED) break block22;
                                    this.nLNsLocked.increment();
                                    completed = true;
                                    bl3 = true;
                                    if (clearTarget) {
                                        bin.evictLN(index);
                                    }
                                    if (locker == null) break block23;
                                    locker.operationEnd();
                                }
                                this.logFine(CLEAN_PENDING_LN, ln, treeLsn, completed, obsolete, migrated);
                                return bl3;
                            }
                            this.nLNsDead.increment();
                            obsolete = true;
                            completed = true;
                            bl2 = false;
                            if (clearTarget) {
                                bin.evictLN(index);
                            }
                            if (locker == null) break block24;
                            locker.operationEnd();
                        }
                        this.logFine(CLEAN_PENDING_LN, ln, treeLsn, completed, obsolete, migrated);
                        return bl2;
                    }
                    if (bin.isEmbeddedLN(index)) {
                        throw EnvironmentFailureException.unexpectedState(this.env, "LN is embedded although its associated logrec (at " + treeLsn + " does not have the embedded flag on");
                    }
                    ln = (LN)bin.getTarget(index);
                    if (ln == null) {
                        ln = bin.fetchLN(index, CacheMode.EVICT_LN);
                        boolean bl6 = clearTarget = !db.getId().equals(DbTree.ID_DB_ID);
                    }
                    if (ln != null && !ln.isDeleted()) break block25;
                    bin.setKnownDeletedAndEvictLN(index);
                    this.nLNsDead.increment();
                    obsolete = true;
                    completed = true;
                    lockRet2 = false;
                    if (clearTarget) {
                        bin.evictLN(index);
                    }
                    if (locker == null) break block26;
                    locker.operationEnd();
                }
                this.logFine(CLEAN_PENDING_LN, ln, treeLsn, completed, obsolete, migrated);
                return lockRet2;
            }
            LogItem logItem = ln.log(this.env, db, null, null, false, bin.getKey(index), bin.getExpiration(index), bin.isExpirationInHours(), false, treeLsn, bin.getLastLoggedSize(index), false, true, Cleaner.getMigrationRepContext(ln));
            bin.updateEntry(index, logItem.lsn, ln.getVLSNSequence(), logItem.size);
            this.nLNsMigrated.increment();
            CursorImpl.lockAfterLsnChange(db, treeLsn, logItem.lsn, null);
            migrated = true;
            completed = true;
            bl = false;
            if (clearTarget) {
                bin.evictLN(index);
            }
            if (locker == null) break block27;
            locker.operationEnd();
        }
        this.logFine(CLEAN_PENDING_LN, ln, treeLsn, completed, obsolete, migrated);
        return bl;
    }

    static ReplicationContext getMigrationRepContext(LN ln) {
        long vlsnSeq = ln.getVLSNSequence();
        if (vlsnSeq <= 0L) {
            return ReplicationContext.NO_REPLICATE;
        }
        return new ReplicationContext(new VLSN(vlsnSeq), false);
    }

    void addPendingDB(Long file, DatabaseId id) {
        if (this.fileSelector.addPendingDB(file, id)) {
            LoggerUtils.logMsg(this.logger, this.env, Level.FINE, "CleanAddPendingDB " + id);
        }
    }

    void logFine(String action, Node node, long logLsn, boolean completed, boolean obsolete, boolean dirtiedMigrated) {
        if (this.logger.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append(action);
            if (node instanceof IN) {
                sb.append(" node=");
                sb.append(((IN)node).getNodeId());
            }
            sb.append(" logLsn=");
            sb.append(DbLsn.getNoFormatString(logLsn));
            sb.append(" complete=").append(completed);
            sb.append(" obsolete=").append(obsolete);
            sb.append(" dirtiedOrMigrated=").append(dirtiedMigrated);
            LoggerUtils.logMsg(this.logger, this.env, Level.FINE, sb.toString());
        }
    }

    public void close() {
        this.profile.close();
        this.tracker.close();
        this.fileSelector.close(this.env.getMemoryBudget());
    }

    private static class EnvLockedException
    extends Exception {
        private EnvLockedException() {
        }
    }
}

