/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DiskLimitException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.ExtinctionScanner;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.evictor.OffHeapCache;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.Provisional;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.CheckpointStart;
import com.sleepycat.je.recovery.CheckpointStatDefinition;
import com.sleepycat.je.recovery.DirtyINMap;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LSNStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;

public class Checkpointer
extends DaemonThread
implements EnvConfigObserver {
    private static TestHook<?> maxFlushLevelHook = null;
    private static TestHook<?> beforeFlushHook = null;
    static TestHook<IN> examineINForCheckpointHook = null;
    private long checkpointId;
    private final long logSizeBytesInterval;
    private final long logFileMax;
    private final long timeInterval;
    private long lastCheckpointMillis;
    private volatile boolean wakeupAfterNoWrites;
    private boolean highPriority;
    private long nCheckpoints;
    private long lastCheckpointStart;
    private long lastCheckpointEnd;
    private long lastCheckpointInterval;
    private final FlushStats flushStats;
    private final DirtyINMap checkpointDirtyMap;

    public Checkpointer(EnvironmentImpl envImpl, long waitTime, String name) {
        super(waitTime, name, envImpl);
        this.logSizeBytesInterval = envImpl.getConfigManager().getLong(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL);
        this.logFileMax = envImpl.getConfigManager().getLong(EnvironmentParams.LOG_FILE_MAX);
        this.timeInterval = waitTime;
        this.lastCheckpointMillis = 0L;
        this.nCheckpoints = 0L;
        this.flushStats = new FlushStats();
        this.checkpointDirtyMap = new DirtyINMap(envImpl);
        this.envConfigUpdate(envImpl.getConfigManager(), null);
        envImpl.addConfigObserver(this);
    }

    @Override
    public void envConfigUpdate(DbConfigManager cm, EnvironmentMutableConfig ignore) {
        this.highPriority = cm.getBoolean(EnvironmentParams.CHECKPOINTER_HIGH_PRIORITY);
    }

    void initIntervals(long lastCheckpointStart, long lastCheckpointEnd, long lastCheckpointMillis) {
        this.lastCheckpointStart = lastCheckpointStart;
        this.lastCheckpointEnd = lastCheckpointEnd;
        this.lastCheckpointMillis = lastCheckpointMillis;
    }

    public Provisional coordinateEvictionWithCheckpoint(DatabaseImpl db, int targetLevel, IN parent) {
        return this.checkpointDirtyMap.coordinateEvictionWithCheckpoint(db, targetLevel, parent);
    }

    public void coordinateSplitWithCheckpoint(IN newSibling) {
        this.checkpointDirtyMap.coordinateSplitWithCheckpoint(newSibling);
    }

    public static long getWakeupPeriod(DbConfigManager configManager) throws IllegalArgumentException {
        long wakeupPeriod = configManager.getDuration(EnvironmentParams.CHECKPOINTER_WAKEUP_INTERVAL);
        long bytePeriod = configManager.getLong(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL);
        if (wakeupPeriod == 0L && bytePeriod == 0L) {
            throw new IllegalArgumentException(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL.getName() + " and " + EnvironmentParams.CHECKPOINTER_WAKEUP_INTERVAL.getName() + " cannot both be 0. ");
        }
        if (bytePeriod == 0L) {
            return wakeupPeriod;
        }
        return 0L;
    }

    synchronized void setCheckpointId(long lastCheckpointId) {
        this.checkpointId = lastCheckpointId;
    }

    public StatGroup loadStats(StatsConfig config) {
        StatGroup stats = new StatGroup("Checkpoints", "Dirty Btree internal nodes are written to the data log periodically to bound recovery time.");
        new LongStat(stats, CheckpointStatDefinition.CKPT_LAST_CKPTID, this.checkpointId);
        new LongStat(stats, CheckpointStatDefinition.CKPT_CHECKPOINTS, this.nCheckpoints);
        new LongStat(stats, CheckpointStatDefinition.CKPT_LAST_CKPT_INTERVAL, this.lastCheckpointInterval);
        new LSNStat(stats, CheckpointStatDefinition.CKPT_LAST_CKPT_START, this.lastCheckpointStart);
        new LSNStat(stats, CheckpointStatDefinition.CKPT_LAST_CKPT_END, this.lastCheckpointEnd);
        new LongStat(stats, CheckpointStatDefinition.CKPT_FULL_IN_FLUSH, this.flushStats.nFullINFlush);
        new LongStat(stats, CheckpointStatDefinition.CKPT_FULL_BIN_FLUSH, this.flushStats.nFullBINFlush);
        new LongStat(stats, CheckpointStatDefinition.CKPT_DELTA_IN_FLUSH, this.flushStats.nDeltaINFlush);
        if (config.getClear()) {
            this.nCheckpoints = 0L;
            this.flushStats.nFullINFlush = 0L;
            this.flushStats.nFullBINFlush = 0L;
            this.flushStats.nDeltaINFlush = 0L;
        }
        return stats;
    }

    @Override
    protected long nDeadlockRetries() {
        return this.envImpl.getConfigManager().getInt(EnvironmentParams.CHECKPOINTER_RETRY);
    }

    @Override
    protected void onWakeup() {
        if (this.envImpl.isClosing()) {
            return;
        }
        this.doCheckpoint(CheckpointConfig.DEFAULT, "daemon", true);
        this.wakeupAfterNoWrites = false;
    }

    public void wakeupAfterWrite() {
        long nextLsn;
        if (this.logSizeBytesInterval != 0L && !this.isRunning() && DbLsn.getNoCleaningDistance(nextLsn = this.envImpl.getFileManager().getNextLsn(), this.lastCheckpointStart, this.logFileMax) >= this.logSizeBytesInterval) {
            this.wakeup();
        }
    }

    public void wakeupAfterNoWrites() {
        if (!this.isRunning() && this.needCheckpointForCleanedFiles()) {
            this.wakeupAfterNoWrites = true;
            this.wakeup();
        }
    }

    private boolean needCheckpointForCleanedFiles() {
        return this.envImpl.getCleaner().getFileSelector().isCheckpointNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunnable(CheckpointConfig config) {
        long useBytesInterval = 0L;
        long useTimeInterval = 0L;
        long nextLsn = -1L;
        boolean runnable = false;
        try {
            if (config.getForce()) {
                runnable = true;
                boolean bl = true;
                return bl;
            }
            if (this.wakeupAfterNoWrites && this.needCheckpointForCleanedFiles()) {
                runnable = true;
                boolean bl = true;
                return bl;
            }
            if (config.getKBytes() != 0) {
                useBytesInterval = config.getKBytes() << 10;
            } else if (config.getMinutes() != 0) {
                useTimeInterval = config.getMinutes() * 60 * 1000;
            } else if (this.logSizeBytesInterval != 0L) {
                useBytesInterval = this.logSizeBytesInterval;
            } else {
                useTimeInterval = this.timeInterval;
            }
            if (useBytesInterval != 0L) {
                nextLsn = this.envImpl.getFileManager().getNextLsn();
                if (DbLsn.getNoCleaningDistance(nextLsn, this.lastCheckpointStart, this.logFileMax) >= useBytesInterval) {
                    runnable = true;
                }
            } else if (useTimeInterval != 0L) {
                long lastUsedLsn = this.envImpl.getFileManager().getLastUsedLsn();
                if (System.currentTimeMillis() - this.lastCheckpointMillis >= useTimeInterval && DbLsn.compareTo(lastUsedLsn, this.lastCheckpointEnd) != 0) {
                    runnable = true;
                }
            }
            boolean bl = runnable;
            return bl;
        }
        finally {
            if (this.logger.isLoggable(Level.FINEST)) {
                StringBuilder sb = new StringBuilder();
                sb.append("size interval=").append(useBytesInterval);
                if (nextLsn != -1L) {
                    sb.append(" nextLsn=").append(DbLsn.getNoFormatString(nextLsn));
                }
                if (this.lastCheckpointEnd != -1L) {
                    sb.append(" lastCkpt=");
                    sb.append(DbLsn.getNoFormatString(this.lastCheckpointEnd));
                }
                sb.append(" time interval=").append(useTimeInterval);
                sb.append(" force=").append(config.getForce());
                sb.append(" runnable=").append(runnable);
                LoggerUtils.finest(this.logger, this.envImpl, sb.toString());
            }
        }
    }

    public synchronized void doCheckpoint(CheckpointConfig config, String invokingSource, boolean invokedFromDaemon) {
        if (this.envImpl.isReadOnly()) {
            return;
        }
        if (!this.isRunnable(config)) {
            return;
        }
        try {
            this.envImpl.checkDiskLimitViolation();
        }
        catch (DiskLimitException e) {
            if (!invokedFromDaemon) {
                throw e;
            }
            return;
        }
        boolean flushAll = config.getMinimizeRecoveryTime();
        Cleaner cleaner = this.envImpl.getCleaner();
        FileSelector.CheckpointStartCleanerState cleanerState = cleaner.getFilesAtCheckpointStart();
        ExtinctionScanner extinctionScanner = this.envImpl.getExtinctionScanner();
        Set<Long> completedScans = extinctionScanner.getCompletedRecordScans();
        boolean flushExtraLevel = !cleanerState.isEmpty();
        this.lastCheckpointMillis = System.currentTimeMillis();
        this.flushStats.resetPerRunCounters();
        ++this.checkpointId;
        ++this.nCheckpoints;
        boolean success = false;
        boolean traced = false;
        LogManager logManager = this.envImpl.getLogManager();
        this.checkpointDirtyMap.beginCheckpoint(flushAll, flushExtraLevel);
        try {
            SingleItemEntry<CheckpointStart> startEntry = SingleItemEntry.create(LogEntryType.LOG_CKPT_START, new CheckpointStart(this.checkpointId, invokingSource));
            long checkpointStart = logManager.log(startEntry, ReplicationContext.NO_REPLICATE);
            long firstActiveLsn = this.envImpl.getTxnManager().getFirstActiveLsn();
            if (firstActiveLsn == -1L) {
                firstActiveLsn = checkpointStart;
            }
            this.envImpl.awaitVLSNConsistency();
            this.checkpointDirtyMap.selectDirtyINsForCheckpoint();
            TestHookExecute.doHookIfSet(beforeFlushHook);
            Checkpointer.flushDirtyNodes(this.envImpl, this.checkpointDirtyMap, checkpointStart, this.highPriority, this.flushStats);
            this.checkpointDirtyMap.flushMapLNs(checkpointStart);
            this.checkpointDirtyMap.flushRoot(checkpointStart);
            this.envImpl.preCheckpointEndFlush();
            this.envImpl.getUtilizationProfile().flushFileUtilization(this.envImpl.getUtilizationTracker().getTrackedFiles());
            DbTree dbTree = this.envImpl.getDbTree();
            boolean willDeleteFiles = !cleanerState.isEmpty();
            CheckpointEnd ckptEnd = new CheckpointEnd(invokingSource, checkpointStart, this.envImpl.getRootLsn(), firstActiveLsn, this.envImpl.getNodeSequence().getLastLocalNodeId(), this.envImpl.getNodeSequence().getLastReplicatedNodeId(), dbTree.getLastLocalDbId(), dbTree.getLastReplicatedDbId(), this.envImpl.getTxnManager().getLastLocalTxnId(), this.envImpl.getTxnManager().getLastReplicatedTxnId(), this.envImpl.getExtinctionScanner().getLastLocalId(), this.envImpl.getExtinctionScanner().getLastReplicatedId(), this.checkpointId, willDeleteFiles);
            SingleItemEntry<CheckpointEnd> endEntry = SingleItemEntry.create(LogEntryType.LOG_CKPT_END, ckptEnd);
            this.trace(this.envImpl, invokingSource, true);
            traced = true;
            this.lastCheckpointInterval = DbLsn.getNoCleaningDistance(checkpointStart, this.lastCheckpointStart, this.logFileMax);
            this.lastCheckpointEnd = logManager.logForceFlush(endEntry, true, ReplicationContext.NO_REPLICATE);
            this.lastCheckpointStart = checkpointStart;
            success = true;
            cleaner.updateFilesAtCheckpointEnd(cleanerState);
            extinctionScanner.deleteCompletedRecordScans(completedScans);
        }
        catch (DiskLimitException e) {
            LoggerUtils.logMsg(this.envImpl.getLogger(), this.envImpl, Level.WARNING, "Ckpt id=" + this.checkpointId + " success=" + success + " aborted because of disk limit violation: " + e);
            if (!invokedFromDaemon) {
                throw e;
            }
        }
        catch (DatabaseException e) {
            LoggerUtils.traceAndLogException(this.envImpl, "Checkpointer", "doCheckpoint", "checkpointId=" + this.checkpointId, e);
            throw e;
        }
        finally {
            this.checkpointDirtyMap.reset();
            if (!traced) {
                this.trace(this.envImpl, invokingSource, success);
            }
        }
    }

    private void trace(EnvironmentImpl envImpl, String invokingSource, boolean success) {
        StringBuilder sb = new StringBuilder();
        sb.append("Checkpoint ").append(this.checkpointId);
        sb.append(": source=").append(invokingSource);
        sb.append(" success=").append(success);
        sb.append(" nFullINFlushThisRun=");
        sb.append(this.flushStats.nFullINFlushThisRun);
        sb.append(" nDeltaINFlushThisRun=");
        sb.append(this.flushStats.nDeltaINFlushThisRun);
        LoggerUtils.logMsg(this.logger, envImpl, Level.CONFIG, sb.toString());
    }

    public void syncDatabase(EnvironmentImpl envImpl, DatabaseImpl dbImpl, boolean flushLog) {
        if (envImpl.isReadOnly()) {
            return;
        }
        envImpl.checkDiskLimitViolation();
        DirtyINMap dirtyMap = new DirtyINMap(envImpl);
        FlushStats fstats = new FlushStats();
        try {
            dirtyMap.selectDirtyINsForDbSync(dbImpl);
            if (dirtyMap.getNumEntries() > 0) {
                Checkpointer.flushDirtyNodes(envImpl, dirtyMap, -1L, false, fstats);
                if (flushLog) {
                    envImpl.getLogManager().flushSync();
                }
            }
        }
        catch (DiskLimitException e) {
            throw e;
        }
        catch (DatabaseException e) {
            LoggerUtils.traceAndLogException(envImpl, "Checkpointer", "syncDatabase", "of " + dbImpl.getName(), e);
            throw e;
        }
        finally {
            dirtyMap.reset();
        }
    }

    public static void setMaxFlushLevelHook(TestHook<?> hook) {
        maxFlushLevelHook = hook;
    }

    public static void setBeforeFlushHook(TestHook<?> hook) {
        beforeFlushHook = hook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flushDirtyNodes(EnvironmentImpl envImpl, DirtyINMap dirtyMap, long checkpointStart, boolean highPriority, FlushStats fstats) {
        DbTree dbTree = envImpl.getDbTree();
        HashMap<DatabaseId, DatabaseImpl> dbCache = new HashMap<DatabaseId, DatabaseImpl>();
        try {
            while (dirtyMap.getNumLevels() > 0) {
                CheckpointReference targetRef;
                Integer currentLevel = dirtyMap.getLowestLevelSet();
                int currentLevelVal = currentLevel;
                if (currentLevelVal == 131072) {
                    dirtyMap.flushMapLNs(checkpointStart);
                }
                while ((targetRef = dirtyMap.removeNextNode(currentLevel)) != null) {
                    int maxFlushLevel;
                    envImpl.checkDiskLimitViolation();
                    DatabaseImpl db = dbTree.getDb(targetRef.dbId, -1L, dbCache);
                    if (db != null && currentLevelVal <= (maxFlushLevel = dirtyMap.getHighestFlushLevel(db))) {
                        Checkpointer.flushIN(db, targetRef, dirtyMap, maxFlushLevel, highPriority, fstats, true);
                        envImpl.sleepAfterBackgroundIO();
                    }
                    envImpl.checkIfInvalid();
                }
                dirtyMap.removeLevel(currentLevel);
            }
        }
        finally {
            dbTree.releaseDbs(dbCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flushIN(DatabaseImpl db, CheckpointReference targetRef, DirtyINMap dirtyMap, int maxFlushLevel, boolean highPriority, FlushStats fstats, boolean allowLogSubtree) {
        CheckpointReference parentRef;
        ArrayList<CheckpointReference> logSiblingsSeparately;
        EnvironmentImpl envImpl = db.getEnv();
        Tree tree = db.getTree();
        int targetLevel = targetRef.nodeLevel;
        assert (targetLevel < maxFlushLevel || TestHookExecute.doHookIfSet(maxFlushLevelHook));
        if (targetRef.isRoot) {
            RootFlusher flusher = new RootFlusher(db, targetRef.nodeId);
            tree.withRootLatchedExclusive(flusher);
            if (flusher.getFlushed()) {
                DbTree dbTree = envImpl.getDbTree();
                dbTree.modifyDbRoot(db);
                ++fstats.nFullINFlushThisRun;
                ++fstats.nFullINFlush;
            }
            if (flusher.stillRoot()) {
                return;
            }
        }
        SearchResult result = tree.getParentINForChildIN(-1L, targetRef.treeKey, targetRef.nodeLevel, targetRef.nodeLevel + 1, false, false, CacheMode.UNCHANGED, null);
        if (result.parent == null) {
            return;
        }
        IN parent = result.parent;
        int index = result.index;
        int parentLevel = parent.getLevel();
        try {
            boolean bottomLevelTarget;
            boolean bl = bottomLevelTarget = (parentLevel & 0xFFFF) == 2;
            Provisional provisional = targetLevel >= maxFlushLevel ? Provisional.NO : (bottomLevelTarget ? Provisional.YES : Provisional.BEFORE_CKPT_END);
            if (!result.exactParentFound) {
                if (parentLevel > targetLevel) {
                    dirtyMap.addIN(parent, -1, false, true);
                }
                return;
            }
            assert (parentLevel == targetLevel + 1);
            dirtyMap.addIN(parent, -1, false, true);
            if (targetRef.lsn != -1L) {
                if (targetRef.lsn != parent.getLsn(index)) {
                    return;
                }
            } else {
                assert (targetRef.nodeId >= 0L);
                assert (db.isDeferredWriteMode());
                IN target = (IN)parent.getTarget(index);
                if (target == null || targetRef.nodeId != target.getNodeId()) {
                    return;
                }
            }
            Checkpointer.logDirtyIN(envImpl, parent, index, provisional, fstats);
            if (!bottomLevelTarget || !allowLogSubtree) {
                return;
            }
            logSiblingsSeparately = highPriority && !db.isDurableDeferredWrite() ? null : new ArrayList<CheckpointReference>();
            for (int i = 0; i < parent.getNEntries(); ++i) {
                if (i == index) continue;
                IN child = (IN)parent.getTarget(i);
                long childId = child != null ? child.getNodeId() : -1L;
                long childLsn = parent.getLsn(i);
                CheckpointReference childRef = dirtyMap.removeNode(targetLevel, childLsn, childId);
                if (childRef == null) continue;
                if (logSiblingsSeparately != null) {
                    logSiblingsSeparately.add(childRef);
                    continue;
                }
                Checkpointer.logDirtyIN(envImpl, parent, i, provisional, fstats);
            }
            parentRef = parentLevel <= maxFlushLevel ? dirtyMap.removeNode(parentLevel, parent.getLastLoggedLsn(), parent.getNodeId()) : null;
        }
        finally {
            parent.releaseLatch();
        }
        if (logSiblingsSeparately != null) {
            for (CheckpointReference childRef : logSiblingsSeparately) {
                Checkpointer.flushIN(db, childRef, dirtyMap, maxFlushLevel, highPriority, fstats, false);
            }
        }
        if (parentRef != null) {
            Checkpointer.flushIN(db, parentRef, dirtyMap, maxFlushLevel, highPriority, fstats, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logDirtyIN(EnvironmentImpl envImpl, IN parent, int index, Provisional provisional, FlushStats fstats) {
        boolean isDelta;
        boolean isBIN;
        long newLsn;
        IN child = (IN)parent.getTarget(index);
        if (child != null) {
            child.latch(CacheMode.UNCHANGED);
            try {
                if (!child.getDirty()) {
                    return;
                }
                if (child.getDatabase().isDurableDeferredWrite()) {
                    child.logDirtyChildren();
                }
                newLsn = child.log(true, provisional, true, parent);
                assert (newLsn != -1L);
                isBIN = child.isBIN();
                isDelta = newLsn == child.getLastDeltaLsn();
            }
            finally {
                child.releaseLatch();
            }
        } else {
            OffHeapCache ohCache = envImpl.getOffHeapCache();
            INLogEntry<BIN> logEntry = ohCache.createBINLogEntryForCheckpoint(parent, index);
            if (logEntry == null) {
                return;
            }
            isBIN = true;
            isDelta = logEntry.isBINDelta();
            newLsn = IN.logEntry(logEntry, provisional, true, parent);
            ohCache.postBINLog(parent, index, logEntry, newLsn);
        }
        parent.updateEntry(index, newLsn, -1L, 0);
        if (isDelta) {
            ++fstats.nDeltaINFlushThisRun;
            ++fstats.nDeltaINFlush;
        } else {
            ++fstats.nFullINFlushThisRun;
            ++fstats.nFullINFlush;
            if (isBIN) {
                ++fstats.nFullBINFlush;
                ++fstats.nFullBINFlushThisRun;
            }
        }
    }

    public static class FlushStats {
        public long nFullINFlush;
        public long nFullBINFlush;
        public long nDeltaINFlush;
        long nFullINFlushThisRun;
        long nFullBINFlushThisRun;
        long nDeltaINFlushThisRun;

        void resetPerRunCounters() {
            this.nFullINFlushThisRun = 0L;
            this.nFullBINFlushThisRun = 0L;
            this.nDeltaINFlushThisRun = 0L;
        }
    }

    public static class CheckpointReference {
        final DatabaseId dbId;
        final long nodeId;
        final int nodeLevel;
        final boolean isRoot;
        final byte[] treeKey;
        final long lsn;

        CheckpointReference(DatabaseId dbId, long nodeId, int nodeLevel, boolean isRoot, byte[] treeKey, long lsn) {
            this.dbId = dbId;
            this.nodeId = nodeId;
            this.nodeLevel = nodeLevel;
            this.isRoot = isRoot;
            this.treeKey = treeKey;
            this.lsn = lsn;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CheckpointReference)) {
                return false;
            }
            CheckpointReference other = (CheckpointReference)o;
            return this.nodeId == other.nodeId;
        }

        public int hashCode() {
            return (int)this.nodeId;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("db=").append(this.dbId);
            sb.append(" nodeId=").append(this.nodeId);
            return sb.toString();
        }
    }

    private static class RootFlusher
    implements WithRootLatched {
        private final DatabaseImpl db;
        private boolean flushed;
        private boolean stillRoot;
        private final long targetNodeId;

        RootFlusher(DatabaseImpl db, long targetNodeId) {
            this.db = db;
            this.flushed = false;
            this.targetNodeId = targetNodeId;
            this.stillRoot = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IN doWork(ChildReference root) {
            if (root == null) {
                return null;
            }
            IN rootIN = (IN)root.fetchTarget(this.db, null);
            rootIN.latch(CacheMode.UNCHANGED);
            try {
                if (rootIN.getNodeId() == this.targetNodeId) {
                    if (rootIN.getDatabase().isDurableDeferredWrite()) {
                        rootIN.logDirtyChildren();
                    }
                    this.stillRoot = true;
                    if (rootIN.getDirty()) {
                        long newLsn = rootIN.log();
                        root.setLsn(newLsn);
                        this.flushed = true;
                    }
                }
            }
            finally {
                rootIN.releaseLatch();
            }
            return null;
        }

        boolean getFlushed() {
            return this.flushed;
        }

        boolean stillRoot() {
            return this.stillRoot;
        }
    }
}

