/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.FileProtector;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.stream.FeederReader;
import com.sleepycat.je.rep.stream.FeederSource;
import com.sleepycat.je.rep.stream.OutputWireRecord;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;

public class MasterFeederSource
implements FeederSource {
    private final FeederReader feederReader;
    private final FileProtector.ProtectedFileRange protectedFileRange;

    public MasterFeederSource(RepImpl envImpl, VLSNIndex vlsnIndex, NameIdPair replicaNameIdPair, VLSN startVLSN) throws DatabaseException, IOException {
        int readBufferSize = envImpl.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        this.feederReader = new FeederReader(envImpl, vlsnIndex, -1L, readBufferSize);
        long startLsn = this.feederReader.initScan(startVLSN);
        this.protectedFileRange = envImpl.getFileProtector().protectFileRange("Feeder-" + replicaNameIdPair, DbLsn.getFileNumber(startLsn), true);
    }

    @Override
    public void shutdown(EnvironmentImpl envImpl) {
        envImpl.getFileProtector().removeFileProtection(this.protectedFileRange);
    }

    @Override
    public OutputWireRecord getWireRecord(VLSN vlsn, int waitTime) throws DatabaseException, InterruptedException, IOException {
        try {
            OutputWireRecord record = this.feederReader.scanForwards(vlsn, waitTime);
            if (record == null) {
                return null;
            }
            long lastFile = this.feederReader.getLastFile(record);
            if (lastFile > this.protectedFileRange.getRangeStart()) {
                this.protectedFileRange.advanceRange(lastFile);
            }
            return record;
        }
        catch (DatabaseException e) {
            e.addErrorMessage("MasterFeederSource fetching vlsn=" + vlsn + " waitTime=" + waitTime);
            throw e;
        }
    }

    @Override
    public String dumpState() {
        return this.feederReader.dumpState();
    }
}

