/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.subscription;

import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.subscription.StreamAuthenticator;
import com.sleepycat.je.rep.utilint.ServiceHandshake;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ServerAuthMethod
implements ServiceHandshake.AuthenticationMethod {
    private final StreamAuthenticator serverAuth;

    public ServerAuthMethod(StreamAuthenticator serverAuth) {
        this.serverAuth = serverAuth;
    }

    @Override
    public String getMechanismName() {
        return "SubscriptionTokenAuth";
    }

    @Override
    public ServiceHandshake.ClientInitOp getClientOp(ServiceHandshake.ClientHandshake initState, String ignoredParams) {
        return new ClientTokenOp(initState);
    }

    @Override
    public ServiceHandshake.ServerInitOp getServerOp(ServiceHandshake.ServerHandshake initState) {
        return new ServerTokenOp(initState, this.serverAuth);
    }

    @Override
    public String getServerParams() {
        return "";
    }

    class ClientTokenOp
    extends ServiceHandshake.ClientInitOp {
        ClientTokenOp(ServiceHandshake.ClientHandshake initState) {
            super(initState);
        }

        @Override
        public ServiceHandshake.InitResult processOp(ServiceHandshake.IOAdapter ioAdapter) throws IOException {
            return ServiceHandshake.InitResult.REJECT;
        }
    }

    static class ServerTokenOp
    extends ServiceHandshake.ServerInitOp {
        private static final int BUFFER_TOKEN_SIZE = 4;
        private final ByteBuffer tokenSzBuf = ByteBuffer.allocate(4);
        private ByteBuffer tokenBuf = null;
        private int tokenSz = 0;
        private final StreamAuthenticator auth;

        ServerTokenOp(ServiceHandshake.ServerHandshake initState, StreamAuthenticator auth) {
            super(initState);
            this.auth = auth;
        }

        @Override
        public ServiceHandshake.InitResult processOp(DataChannel channel) throws IOException {
            ServiceHandshake.InitResult readResult;
            if (this.tokenBuf == null) {
                readResult = this.fillBuffer(channel, this.tokenSzBuf);
                if (readResult != ServiceHandshake.InitResult.DONE) {
                    return readResult;
                }
                this.tokenSzBuf.flip();
                this.tokenSz = LogUtils.readInt(this.tokenSzBuf);
                if (this.tokenSz <= 0) {
                    return ServiceHandshake.InitResult.REJECT;
                }
                this.tokenBuf = ByteBuffer.allocate(this.tokenSz);
            }
            if ((readResult = this.fillBuffer(channel, this.tokenBuf)) != ServiceHandshake.InitResult.DONE) {
                return readResult;
            }
            this.tokenBuf.flip();
            byte[] token = LogUtils.readBytesNoLength(this.tokenBuf, this.tokenSz);
            this.auth.setToken(token);
            if (!this.auth.authenticate()) {
                return ServiceHandshake.InitResult.REJECT;
            }
            return ServiceHandshake.InitResult.DONE;
        }
    }
}

