/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import java.util.function.Supplier;

public abstract class PollCondition
implements Supplier<Boolean> {
    private final long checkPeriodMs;
    private final long timeoutMs;

    public PollCondition(long checkPeriodMs, long timeoutMs) {
        assert (checkPeriodMs <= timeoutMs);
        this.checkPeriodMs = checkPeriodMs;
        this.timeoutMs = timeoutMs;
    }

    protected abstract boolean condition();

    @Override
    public Boolean get() {
        return this.condition();
    }

    public boolean await() {
        return PollCondition.await(this.checkPeriodMs, this.timeoutMs, this);
    }

    public static boolean await(long checkPeriodMs, long timeoutMs, Supplier<Boolean> cond) {
        if (cond.get().booleanValue()) {
            return true;
        }
        long timeLimit = System.currentTimeMillis() + timeoutMs;
        do {
            try {
                Thread.sleep(checkPeriodMs);
            }
            catch (InterruptedException e) {
                return false;
            }
            if (!cond.get().booleanValue()) continue;
            return true;
        } while (System.currentTimeMillis() < timeLimit);
        return false;
    }
}

