/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.DataView;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.util.keyrange.KeyRange;
import com.sleepycat.util.keyrange.RangeCursor;

class MyRangeCursor
extends RangeCursor {
    private DataView view;
    private boolean isRecnoOrQueue;
    private boolean writeCursor;

    MyRangeCursor(KeyRange range, CursorConfig config, DataView view, boolean writeAllowed) throws DatabaseException {
        super(range, view.dupsRange, MyRangeCursor.openCursor(view, config, writeAllowed));
        this.view = view;
        this.isRecnoOrQueue = view.recNumAllowed && !view.btreeRecNumDb;
        this.writeCursor = MyRangeCursor.isWriteCursor(config, writeAllowed);
    }

    private static boolean isWriteCursor(CursorConfig config, boolean writeAllowed) {
        return DbCompat.getWriteCursor(config) || config == CursorConfig.DEFAULT && writeAllowed;
    }

    private static Cursor openCursor(DataView view, CursorConfig config, boolean writeAllowed) throws DatabaseException {
        return view.currentTxn.openCursor(view.db, config, MyRangeCursor.isWriteCursor(config, writeAllowed), view.useTransaction());
    }

    protected Cursor dupCursor(Cursor cursor, boolean samePosition) throws DatabaseException {
        return this.view.currentTxn.dupCursor(cursor, this.writeCursor, samePosition);
    }

    protected void closeCursor(Cursor cursor) throws DatabaseException {
        this.view.currentTxn.closeCursor(cursor);
    }

    protected boolean checkRecordNumber() {
        return this.isRecnoOrQueue;
    }
}

