/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.PrimaryKeyAssigner;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredEntrySet;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.collections.StoredKeySet;
import com.sleepycat.collections.StoredSortedEntrySet;
import com.sleepycat.collections.StoredSortedKeySet;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.collections.StoredSortedValueSet;
import com.sleepycat.collections.StoredValueSet;
import com.sleepycat.je.Database;
import com.sleepycat.util.keyrange.KeyRangeException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StoredMap
extends StoredContainer
implements Map {
    private StoredKeySet keySet;
    private StoredEntrySet entrySet;
    private StoredValueSet valueSet;

    public StoredMap(Database database, EntryBinding keyBinding, EntryBinding valueBinding, boolean writeAllowed) {
        super(new DataView(database, keyBinding, valueBinding, null, writeAllowed, null));
        this.initView();
    }

    public StoredMap(Database database, EntryBinding keyBinding, EntryBinding valueBinding, PrimaryKeyAssigner keyAssigner) {
        super(new DataView(database, keyBinding, valueBinding, null, true, keyAssigner));
        this.initView();
    }

    public StoredMap(Database database, EntryBinding keyBinding, EntityBinding valueEntityBinding, boolean writeAllowed) {
        super(new DataView(database, keyBinding, null, valueEntityBinding, writeAllowed, null));
        this.initView();
    }

    public StoredMap(Database database, EntryBinding keyBinding, EntityBinding valueEntityBinding, PrimaryKeyAssigner keyAssigner) {
        super(new DataView(database, keyBinding, null, valueEntityBinding, true, keyAssigner));
        this.initView();
    }

    StoredMap(DataView view) {
        super(view);
        this.initView();
    }

    void initAfterClone() {
        this.initView();
    }

    private void initView() {
        this.entrySet = this.isOrdered() ? new StoredSortedEntrySet(this.view) : new StoredEntrySet(this.view);
        DataView newView = this.view.keySetView();
        this.keySet = this.isOrdered() ? new StoredSortedKeySet(newView) : new StoredKeySet(newView);
        newView = this.view.valueSetView();
        this.valueSet = this.isOrdered() && newView.canDeriveKeyFromValue() ? new StoredSortedValueSet(newView) : new StoredValueSet(newView);
    }

    public Object get(Object key) {
        return super.get(key);
    }

    public Object put(Object key, Object value) {
        return super.put(key, value);
    }

    public Object append(Object value) {
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            Object[] key = new Object[1];
            this.view.append(value, key, null);
            this.commitAutoCommit(doAutoCommit);
            return key[0];
        }
        catch (Exception e) {
            throw this.handleException(e, doAutoCommit);
        }
    }

    public Object remove(Object key) {
        Object[] oldVal = new Object[1];
        this.removeKey(key, oldVal);
        return oldVal[0];
    }

    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    public void putAll(Map map) {
        boolean doAutoCommit = this.beginAutoCommit();
        Iterator i = null;
        try {
            Set coll = map.entrySet();
            i = this.storedOrExternalIterator(coll);
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                this.put(entry.getKey(), entry.getValue());
            }
            StoredIterator.close(i);
            this.commitAutoCommit(doAutoCommit);
        }
        catch (Exception e) {
            StoredIterator.close(i);
            throw this.handleException(e, doAutoCommit);
        }
    }

    public Set keySet() {
        return this.keySet;
    }

    public Set entrySet() {
        return this.entrySet;
    }

    public Collection values() {
        return this.valueSet;
    }

    public Collection duplicates(Object key) {
        try {
            DataView newView = this.view.valueSetView(key);
            return new StoredValueSet(newView);
        }
        catch (KeyRangeException e) {
            return Collections.EMPTY_SET;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    public Map duplicatesMap(Object secondaryKey, EntryBinding primaryKeyBinding) {
        try {
            DataView newView = this.view.duplicatesView(secondaryKey, primaryKeyBinding);
            if (this.isOrdered()) {
                return new StoredSortedMap(newView);
            }
            return new StoredMap(newView);
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof Map) {
            return ((Object)this.entrySet()).equals(((Map)other).entrySet());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public int size() {
        return this.values().size();
    }

    public String toString() {
        return this.entrySet().toString();
    }
}

