/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchSupport;
import java.io.IOException;
import java.io.RandomAccessFile;

class FileHandle {
    private RandomAccessFile file;
    private Latch fileLatch;
    private boolean oldHeaderVersion;

    FileHandle(RandomAccessFile file, String fileName, EnvironmentImpl env, boolean oldHeaderVersion) {
        this.file = file;
        this.oldHeaderVersion = oldHeaderVersion;
        this.fileLatch = LatchSupport.makeLatch(fileName + "_fileHandle", env);
    }

    RandomAccessFile getFile() {
        return this.file;
    }

    boolean isOldHeaderVersion() {
        return this.oldHeaderVersion;
    }

    void latch() throws DatabaseException {
        this.fileLatch.acquire();
    }

    boolean latchNoWait() throws DatabaseException {
        return this.fileLatch.acquireNoWait();
    }

    void release() throws DatabaseException {
        this.fileLatch.release();
    }

    void close() throws IOException {
        if (this.file != null) {
            this.file.close();
            this.file = null;
        }
    }
}

