/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.CollectionProxy;
import com.sleepycat.persist.impl.ComplexFormat;
import com.sleepycat.persist.impl.CompositeKeyFormat;
import com.sleepycat.persist.impl.EnumFormat;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.MapProxy;
import com.sleepycat.persist.impl.NonPersistentFormat;
import com.sleepycat.persist.impl.ObjectArrayFormat;
import com.sleepycat.persist.impl.PrimitiveArrayFormat;
import com.sleepycat.persist.impl.ProxiedFormat;
import com.sleepycat.persist.impl.ReadOnlyCatalog;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.impl.StoredModel;
import com.sleepycat.persist.model.AnnotationModel;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistCatalog
implements Catalog {
    private static final byte[] FORMATS_KEY = PersistCatalog.getIntBytes(-1);
    private static final byte[] MUTATIONS_KEY = PersistCatalog.getIntBytes(-2);
    private volatile List<Format> formatList;
    private volatile Map<String, Format> formatMap;
    private Map<String, String> proxyClassMap;
    private EntityModel model;
    private Mutations mutations;
    private Database db;
    private int openCount;

    private static byte[] getIntBytes(int val) {
        DatabaseEntry entry = new DatabaseEntry();
        IntegerBinding.intToEntry(val, entry);
        assert (entry.getSize() == 4 && entry.getData().length == 4);
        return entry.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistCatalog(Transaction txn, Environment env, String dbName, DatabaseConfig dbConfig, EntityModel modelParam, Mutations mutationsParam, boolean useCurrentModel) throws DatabaseException {
        this.db = env.openDatabase(txn, dbName, dbConfig);
        this.openCount = 1;
        boolean success = false;
        try {
            String className;
            this.mutations = (Mutations)this.readObject(txn, MUTATIONS_KEY);
            if (mutationsParam != null) {
                this.mutations = this.mergeMutations(this.mutations, mutationsParam);
                this.writeObject(txn, MUTATIONS_KEY, this.mutations);
            }
            this.formatList = (List)this.readObject(txn, FORMATS_KEY);
            if (this.formatList == null) {
                this.formatList = SimpleCatalog.copyFormatList();
                NonPersistentFormat format = new NonPersistentFormat(Object.class);
                format.setId(1);
                this.formatList.set(1, format);
            }
            this.formatMap = new HashMap<String, Format>(this.formatList.size());
            if (!useCurrentModel) {
                for (Format format : this.formatList) {
                    if (format == null) continue;
                    this.formatMap.put(format.getClassName(), format);
                }
                for (Format format : this.formatList) {
                    if (format == null) continue;
                    format.initializeIfNeeded(this);
                }
                success = true;
                return;
            }
            if (modelParam == null) {
                modelParam = new AnnotationModel();
            }
            this.model = modelParam;
            for (int i = 0; i <= 30; ++i) {
                Format simpleFormat = this.formatList.get(i);
                if (simpleFormat == null) continue;
                this.formatMap.put(simpleFormat.getClassName(), simpleFormat);
            }
            ArrayList<String> knownClasses = new ArrayList<String>(this.model.getKnownClasses());
            this.addPredefinedProxies(knownClasses);
            this.proxyClassMap = new HashMap<String, String>();
            for (Format oldFormat : this.formatList) {
                if (oldFormat == null || Format.isPredefined(oldFormat)) continue;
                this.addProxiedClass(oldFormat.getClassName());
            }
            for (String className2 : knownClasses) {
                this.addProxiedClass(className2);
            }
            HashMap<String, Format> newFormats = new HashMap<String, Format>();
            for (Format oldFormat : this.formatList) {
                Class type;
                if (oldFormat == null || Format.isPredefined(oldFormat) || newFormats.containsKey(className = oldFormat.getClassName())) continue;
                try {
                    type = SimpleCatalog.classForName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Class no longer exists: " + className);
                }
                this.createFormat(type, newFormats);
            }
            for (String className3 : knownClasses) {
                Class type;
                if (newFormats.containsKey(className3)) continue;
                try {
                    type = SimpleCatalog.classForName(className3);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Class no longer exists: " + className3);
                }
                if (SimpleCatalog.isSimpleType(type)) continue;
                this.createFormat(type, newFormats);
            }
            for (Format oldFormat : this.formatList) {
                if (oldFormat == null || Format.isPredefined(oldFormat)) continue;
                className = oldFormat.getClassName();
                Format newFormat = (Format)newFormats.get(className);
                assert (newFormat != null);
                if (newFormat.equals(oldFormat)) {
                    this.formatMap.put(className, oldFormat);
                    newFormats.remove(className);
                    continue;
                }
                throw new UnsupportedOperationException("Class evolution is not supported in the beta release and the store must be deleted when a class is changed: " + className);
            }
            for (Format newFormat : newFormats.values()) {
                this.addFormat(newFormat);
            }
            for (Format format : this.formatList) {
                if (format == null) continue;
                format.initializeIfNeeded(this);
            }
            if (!this.db.getConfig().getReadOnly() && newFormats.size() > 0) {
                this.writeObject(txn, FORMATS_KEY, this.formatList);
            }
            this.proxyClassMap = null;
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    private void addProxiedClass(String className) {
        String proxiedClassName;
        ClassMetadata metadata = this.model.getClassMetadata(className);
        if (metadata != null && (proxiedClassName = metadata.getProxiedClassName()) != null) {
            this.proxyClassMap.put(proxiedClassName, className);
        }
    }

    private void addPredefinedProxies(List<String> knownClasses) {
        knownClasses.add(CollectionProxy.ArrayListProxy.class.getName());
        knownClasses.add(CollectionProxy.LinkedListProxy.class.getName());
        knownClasses.add(CollectionProxy.HashSetProxy.class.getName());
        knownClasses.add(CollectionProxy.TreeSetProxy.class.getName());
        knownClasses.add(MapProxy.HashMapProxy.class.getName());
        knownClasses.add(MapProxy.TreeMapProxy.class.getName());
    }

    public EntityModel getResolvedModel() {
        if (this.model != null) {
            return this.model;
        }
        return new StoredModel(this);
    }

    public void openExisting() {
        ++this.openCount;
    }

    public boolean close() throws DatabaseException {
        if (this.openCount == 0) {
            throw new IllegalStateException("Catalog is not open");
        }
        --this.openCount;
        if (this.openCount == 0) {
            Database dbToClose = this.db;
            this.db = null;
            dbToClose.close();
            return true;
        }
        return false;
    }

    public Mutations getMutations() {
        return this.mutations;
    }

    @Override
    public Format createFormat(Class type, Map<String, Format> newFormats) {
        String className = type.getName();
        Format format = newFormats.get(className);
        if (format != null) {
            return format;
        }
        format = this.formatMap.get(className);
        if (format != null) {
            return format;
        }
        assert (!SimpleCatalog.isSimpleType(type)) : className;
        String proxyClassName = null;
        if (this.proxyClassMap != null) {
            proxyClassName = this.proxyClassMap.get(className);
        }
        if (proxyClassName != null) {
            Class proxyClass;
            try {
                proxyClass = SimpleCatalog.classForName(proxyClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            Format proxyFormat = this.createFormat(proxyClass, newFormats);
            format = new ProxiedFormat(type, proxyFormat);
        } else if (type.isArray()) {
            format = type.getComponentType().isPrimitive() ? new PrimitiveArrayFormat(type) : new ObjectArrayFormat(type);
        } else if (type.isEnum()) {
            format = new EnumFormat(type);
        } else if (type == Object.class || type.isInterface()) {
            format = new NonPersistentFormat(type);
        } else {
            ClassMetadata metadata = this.model.getClassMetadata(className);
            if (metadata == null) {
                throw new IllegalArgumentException("Class is not persistent: " + className);
            }
            if (metadata.getCompositeKeyFields() != null && (metadata.getPrimaryKey() != null || metadata.getSecondaryKeys() != null)) {
                throw new IllegalArgumentException("A composite key class may not have primary or secondary key fields: " + type.getName());
            }
            try {
                type.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("No default constructor: " + type.getName(), e);
            }
            if (metadata.getCompositeKeyFields() != null) {
                format = new CompositeKeyFormat(type, metadata, metadata.getCompositeKeyFields());
            } else {
                EntityMetadata entityMetadata = this.model.getEntityMetadata(className);
                format = new ComplexFormat(type, metadata, entityMetadata);
            }
        }
        newFormats.put(className, format);
        format.collectRelatedFormats(this, newFormats);
        return format;
    }

    private void addFormat(Format format) {
        this.addFormat(format, this.formatList, this.formatMap);
    }

    private void addFormat(Format format, List<Format> list, Map<String, Format> map) {
        format.setId(list.size());
        list.add(format);
        map.put(format.getClassName(), format);
    }

    private void replaceFormat(Format oldFormat, Format newFormat) {
        assert (oldFormat.getClassName().equals(newFormat.getClassName()));
        int id = oldFormat.getId();
        newFormat.setId(id);
        this.formatList.set(id, newFormat);
    }

    Set<String> getModelClasses() {
        HashSet<String> classes = new HashSet<String>();
        for (Format format : this.formatMap.values()) {
            if (!format.isModelClass()) continue;
            classes.add(format.getClassName());
        }
        return classes;
    }

    @Override
    public Format getFormat(int formatId) {
        try {
            Format format = this.formatList.get(formatId);
            if (format == null) {
                throw new IllegalStateException("Format does not exist: " + formatId);
            }
            return format;
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("Format does not exist: " + formatId);
        }
    }

    @Override
    public Format getFormat(Class cls) {
        Format format = this.formatMap.get(cls.getName());
        if (format == null) {
            if (this.model != null) {
                format = this.addNewFormat(cls);
            }
            if (format == null) {
                throw new IllegalArgumentException("Class is not persistent: " + cls.getName());
            }
        }
        return format;
    }

    @Override
    public Format getFormat(String className) {
        return this.formatMap.get(className);
    }

    private synchronized Format addNewFormat(Class cls) {
        Format format = this.formatMap.get(cls.getName());
        if (format != null) {
            return format;
        }
        ArrayList<Format> newList = new ArrayList<Format>(this.formatList);
        HashMap<String, Format> newMap = new HashMap<String, Format>(this.formatMap);
        HashMap<String, Format> newFormats = new HashMap<String, Format>();
        format = this.createFormat(cls, newFormats);
        for (Format newFormat : newFormats.values()) {
            this.addFormat(newFormat, newList, newMap);
        }
        ReadOnlyCatalog newFormatCatalog = new ReadOnlyCatalog(newList, newMap);
        for (Format newFormat : newFormats.values()) {
            newFormat.initializeIfNeeded(newFormatCatalog);
        }
        try {
            this.writeObject(null, FORMATS_KEY, newList);
        }
        catch (DatabaseException e) {
            throw new RuntimeExceptionWrapper(e);
        }
        this.formatList = newList;
        this.formatMap = newMap;
        return format;
    }

    private Object readObject(Transaction txn, byte[] recordKey) throws DatabaseException {
        Object object = null;
        DatabaseEntry key = new DatabaseEntry(recordKey);
        DatabaseEntry data = new DatabaseEntry();
        OperationStatus status = this.db.get(txn, key, data, null);
        if (status == OperationStatus.SUCCESS) {
            ByteArrayInputStream bais = new ByteArrayInputStream(data.getData(), data.getOffset(), data.getSize());
            try {
                ObjectInputStream ois = new ObjectInputStream(bais);
                object = ois.readObject();
                assert (ois.available() == 0);
            }
            catch (ClassNotFoundException e) {
                throw new DatabaseException(e);
            }
            catch (IOException e) {
                throw new DatabaseException(e);
            }
        }
        return object;
    }

    private void writeObject(Transaction txn, byte[] recordKey, Object object) throws DatabaseException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
        DatabaseEntry key = new DatabaseEntry(recordKey);
        DatabaseEntry data = new DatabaseEntry(baos.toByteArray());
        this.db.put(txn, key, data);
    }

    private Mutations mergeMutations(Mutations storedMutations, Mutations newMutations) {
        throw new UnsupportedOperationException("Class evolution is not supported in this beta release.");
    }
}

