/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

public class DeltaInfo
implements LogWritable,
LogReadable {
    private byte[] key;
    private long lsn;
    private byte state;

    DeltaInfo(byte[] key, long lsn, byte state) {
        this.key = key;
        this.lsn = lsn;
        this.state = state;
    }

    DeltaInfo() {
        this.lsn = -1L;
    }

    public int getLogSize() {
        return LogUtils.getByteArrayLogSize(this.key) + LogUtils.getLongLogSize() + 1;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeByteArray(logBuffer, this.key);
        LogUtils.writeLong(logBuffer, this.lsn);
        logBuffer.put(this.state);
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryTypeVersion) throws LogException {
        this.key = LogUtils.readByteArray(itemBuffer);
        this.lsn = LogUtils.readLong(itemBuffer);
        this.state = itemBuffer.get();
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append(Key.dumpString(this.key, 0));
        sb.append(DbLsn.toString(this.lsn));
        IN.dumpDeletedState(sb, this.state);
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    byte[] getKey() {
        return this.key;
    }

    byte getState() {
        return this.state;
    }

    boolean isKnownDeleted() {
        return IN.isStateKnownDeleted(this.state);
    }

    long getLsn() {
        return this.lsn;
    }
}

