/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.util;

public class PackedInteger {
    public static final int MAX_LENGTH = 5;

    public static int readInt(byte[] buf, int off) {
        int byteLen;
        boolean negative;
        byte b1;
        if ((b1 = buf[off++]) < -119) {
            negative = true;
            byteLen = -b1 - 119;
        } else if (b1 > 119) {
            negative = false;
            byteLen = b1 - 119;
        } else {
            return b1;
        }
        int value = buf[off++] & 0xFF;
        if (byteLen > 1) {
            value |= (buf[off++] & 0xFF) << 8;
            if (byteLen > 2) {
                value |= (buf[off++] & 0xFF) << 16;
                if (byteLen > 3) {
                    value |= (buf[off++] & 0xFF) << 24;
                }
            }
        }
        return negative ? -value - 119 : value + 119;
    }

    public static int getReadIntLength(byte[] buf, int off) {
        byte b1 = buf[off];
        if (b1 < -119) {
            return -b1 - 119 + 1;
        }
        if (b1 > 119) {
            return b1 - 119 + 1;
        }
        return 1;
    }

    public static int writeInt(byte[] buf, int offset, int value) {
        boolean negative;
        int byte1Off = offset;
        if (value < -119) {
            negative = true;
            value = -value - 119;
        } else if (value > 119) {
            negative = false;
            value -= 119;
        } else {
            buf[offset++] = (byte)value;
            return offset;
        }
        int n = ++offset;
        ++offset;
        buf[n] = (byte)value;
        if ((value & 0xFFFFFF00) == 0) {
            buf[byte1Off] = negative ? -120 : 120;
            return offset;
        }
        buf[offset++] = (byte)(value >>> 8);
        if ((value & 0xFFFF0000) == 0) {
            buf[byte1Off] = negative ? -121 : 121;
            return offset;
        }
        buf[offset++] = (byte)(value >>> 16);
        if ((value & 0xFF000000) == 0) {
            buf[byte1Off] = negative ? -122 : 122;
            return offset;
        }
        buf[offset++] = (byte)(value >>> 24);
        buf[byte1Off] = negative ? -123 : 123;
        return offset;
    }

    public static int getWriteIntLength(int value) {
        if (value < -119) {
            value = -value - 119;
        } else if (value > 119) {
            value -= 119;
        } else {
            return 1;
        }
        if ((value & 0xFFFFFF00) == 0) {
            return 2;
        }
        if ((value & 0xFFFF0000) == 0) {
            return 3;
        }
        if ((value & 0xFF000000) == 0) {
            return 4;
        }
        return 5;
    }
}

