/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.entry.BaseEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.NodeLogEntry;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LNLogEntry
extends BaseEntry
implements LogEntry,
NodeLogEntry {
    private static final byte ABORT_KNOWN_DELETED_MASK = 1;
    private LN ln;
    private DatabaseId dbId;
    private byte[] key;
    private long abortLsn = -1L;
    private boolean abortKnownDeleted;
    private Txn txn;
    private long nodeId;

    public LNLogEntry(Class<? extends LN> LNClass) {
        super(LNClass);
    }

    public LNLogEntry(LogEntryType entryType, LN ln, DatabaseId dbId, byte[] key, long abortLsn, boolean abortKnownDeleted, Txn txn) {
        this.setLogType(entryType);
        this.ln = ln;
        this.dbId = dbId;
        this.key = key;
        this.abortLsn = abortLsn;
        this.abortKnownDeleted = abortKnownDeleted;
        this.txn = txn;
        this.nodeId = ln.getNodeId();
        assert (entryType.isTransactional() == (txn != null));
    }

    @Override
    public void readEntry(LogEntryHeader header, ByteBuffer entryBuffer, boolean readFullItem) throws DatabaseException {
        int logVersion = header.getVersion();
        boolean unpacked = logVersion < 6;
        int recStartPosition = entryBuffer.position();
        if (unpacked) {
            this.ln = (LN)this.newInstanceOfType();
            this.ln.readFromLog(entryBuffer, logVersion);
            this.nodeId = this.ln.getNodeId();
        }
        this.dbId = new DatabaseId();
        this.dbId.readFromLog(entryBuffer, logVersion);
        if (unpacked) {
            this.key = LogUtils.readByteArray(entryBuffer, true);
        }
        if (this.entryType.isTransactional()) {
            this.abortLsn = LogUtils.readLong(entryBuffer, unpacked);
            if (DbLsn.getFileNumber(this.abortLsn) == DbLsn.getFileNumber(-1L)) {
                this.abortLsn = -1L;
            }
            this.abortKnownDeleted = (entryBuffer.get() & 1) != 0;
            this.txn = new Txn();
            this.txn.readFromLog(entryBuffer, logVersion);
        }
        if (unpacked) {
            if (!readFullItem) {
                int endPosition = recStartPosition + header.getItemSize();
                entryBuffer.position(endPosition);
            }
        } else if (readFullItem) {
            this.ln = (LN)this.newInstanceOfType();
            this.ln.readFromLog(entryBuffer, logVersion);
            this.nodeId = this.ln.getNodeId();
            int bytesWritten = entryBuffer.position() - recStartPosition;
            if (this.isLNType()) {
                int keySize = header.getItemSize() - bytesWritten;
                this.key = LogUtils.readBytesNoLength(entryBuffer, keySize);
            } else {
                int keySize = LogUtils.readInt(entryBuffer, false);
                this.key = LogUtils.readBytesNoLength(entryBuffer, keySize);
            }
        } else {
            int endPosition = recStartPosition + header.getItemSize();
            this.nodeId = LogUtils.readPackedLong(entryBuffer);
            entryBuffer.position(endPosition);
            this.ln = null;
        }
        if (this.ln != null) {
            this.ln.setLastLoggedSize(header.getSize() + header.getItemSize());
        }
    }

    @Override
    public StringBuilder dumpEntry(StringBuilder sb, boolean verbose) {
        this.ln.dumpLog(sb, verbose);
        this.dbId.dumpLog(sb, verbose);
        this.ln.dumpKey(sb, this.key);
        if (this.entryType.isTransactional()) {
            if (this.abortLsn != -1L) {
                sb.append(DbLsn.toString(this.abortLsn));
            }
            sb.append("<knownDeleted val=\"");
            sb.append(this.abortKnownDeleted ? "true" : "false");
            sb.append("\"/>");
            this.txn.dumpLog(sb, verbose);
        }
        return sb;
    }

    @Override
    public void dumpRep(StringBuilder sb) {
        if (this.entryType.isTransactional()) {
            sb.append(" txn=").append(this.txn.getId());
        }
    }

    @Override
    public Object getMainItem() {
        return this.ln;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public long getTransactionId() {
        if (this.entryType.isTransactional()) {
            return this.txn.getId();
        }
        return 0L;
    }

    @Override
    public long getNodeId() {
        return this.nodeId;
    }

    @Override
    public int getSize() {
        int len = this.key.length;
        int size = this.ln.getLogSize() + this.dbId.getLogSize() + len;
        if (!this.isLNType()) {
            size += LogUtils.getPackedIntLogSize(len);
        }
        if (this.entryType.isTransactional()) {
            size += LogUtils.getPackedLongLogSize(this.abortLsn);
            ++size;
            size += this.txn.getLogSize();
        }
        return size;
    }

    @Override
    public int getLastLoggedSize() {
        return this.ln.getLastLoggedSize();
    }

    private boolean isLNType() {
        return this.entryType == LogEntryType.LOG_LN || this.entryType == LogEntryType.LOG_LN_TRANSACTIONAL;
    }

    @Override
    public void writeEntry(LogEntryHeader header, ByteBuffer destBuffer) {
        this.dbId.writeToLog(destBuffer);
        if (this.entryType.isTransactional()) {
            LogUtils.writePackedLong(destBuffer, this.abortLsn);
            byte aKD = 0;
            if (this.abortKnownDeleted) {
                aKD = (byte)(aKD | 1);
            }
            destBuffer.put(aKD);
            this.txn.writeToLog(destBuffer);
        }
        this.ln.writeToLog(destBuffer);
        if (this.isLNType()) {
            LogUtils.writeBytesNoLength(destBuffer, this.key);
        } else {
            LogUtils.writePackedInt(destBuffer, this.key.length);
            LogUtils.writeBytesNoLength(destBuffer, this.key);
        }
        this.ln.setLastLoggedSize(header.getSize() + header.getItemSize());
    }

    @Override
    public boolean isDeleted() {
        return this.ln.isDeleted();
    }

    @Override
    public void postLogWork(long justLoggedLsn) {
        if (this.entryType.isTransactional()) {
            this.txn.addLogInfo(justLoggedLsn);
        }
    }

    public LN getLN() {
        return this.ln;
    }

    @Override
    public DatabaseId getDbId() {
        return this.dbId;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getDupKey() {
        if (this.ln.isDeleted()) {
            return null;
        }
        return this.ln.getData();
    }

    public long getAbortLsn() {
        return this.abortLsn;
    }

    public boolean getAbortKnownDeleted() {
        return this.abortKnownDeleted;
    }

    public Long getTxnId() {
        if (this.entryType.isTransactional()) {
            return this.txn.getId();
        }
        return null;
    }

    public Txn getUserTxn() {
        if (this.entryType.isTransactional()) {
            return this.txn;
        }
        return null;
    }

    @Override
    public boolean logicalEquals(LogEntry other) {
        if (!(other instanceof LNLogEntry)) {
            return false;
        }
        LNLogEntry otherEntry = (LNLogEntry)other;
        if (!this.dbId.logicalEquals(otherEntry.dbId)) {
            return false;
        }
        if (this.txn != null ? !this.txn.logicalEquals(otherEntry.txn) : otherEntry.txn != null) {
            return false;
        }
        if (!Arrays.equals(this.key, otherEntry.key)) {
            return false;
        }
        return this.ln.logicalEquals(otherEntry.ln);
    }
}

