/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.Durability;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.txn.Locker;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsufficientReplicasException
extends OperationFailureException {
    private static final long serialVersionUID = 1L;
    private final Durability.ReplicaAckPolicy commitPolicy;
    private final int requiredAckCount;
    private final Set<String> availableReplicas;

    public InsufficientReplicasException(Locker locker, Durability.ReplicaAckPolicy ackPolicy, int requiredAckCount, Set<String> availableReplicas) {
        super(locker, true, InsufficientReplicasException.makeMsg(ackPolicy, requiredAckCount, availableReplicas), null);
        this.commitPolicy = ackPolicy;
        this.requiredAckCount = requiredAckCount;
        this.availableReplicas = availableReplicas;
    }

    private InsufficientReplicasException(String message, InsufficientReplicasException cause) {
        super(message, cause);
        this.commitPolicy = cause.commitPolicy;
        this.requiredAckCount = cause.requiredAckCount;
        this.availableReplicas = cause.availableReplicas;
    }

    @Override
    public OperationFailureException wrapSelf(String msg) {
        return new InsufficientReplicasException(msg, this);
    }

    public Durability.ReplicaAckPolicy getCommitPolicy() {
        return this.commitPolicy;
    }

    public int getRequiredNodeCount() {
        return this.requiredAckCount + 1;
    }

    public Set<String> getAvailableReplicas() {
        return this.availableReplicas;
    }

    private static String makeMsg(Durability.ReplicaAckPolicy commitPolicy, int requiredAckCount, Set<String> availableReplicas) {
        String errorPrefix = "Commit policy: " + commitPolicy.name() + " required " + requiredAckCount + " replica" + (requiredAckCount > 1 ? "s. " : ". ");
        switch (availableReplicas.size()) {
            case 0: {
                return errorPrefix + "But none were active with this master.";
            }
            case 1: {
                return errorPrefix + "Only replica: " + availableReplicas + " was available.";
            }
        }
        return errorPrefix + " Only the following " + availableReplicas.size() + " replicas listed here were available: " + availableReplicas;
    }
}

