/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.CommitPointConsistencyPolicy;
import com.sleepycat.je.rep.GroupShutdownException;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.MasterStateException;
import com.sleepycat.je.rep.ReplicaConsistencyException;
import com.sleepycat.je.rep.RestartRequiredException;
import com.sleepycat.je.rep.TimeConsistencyPolicy;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.impl.node.Replay;
import com.sleepycat.je.rep.impl.node.ReplicaStatDefinition;
import com.sleepycat.je.rep.stream.MasterStatus;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.rep.stream.ReplicaFeederHandshake;
import com.sleepycat.je.rep.stream.ReplicaFeederSyncup;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.NamedChannel;
import com.sleepycat.je.rep.utilint.NamedChannelWithTimeout;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Replica {
    private final RepNode repNode;
    private final RepImpl repImpl;
    private final Replay replay;
    private Exception shutdownException = null;
    private NamedChannelWithTimeout replicaFeederChannel = null;
    private final ConsistencyTracker consistencyTracker;
    private int testDelayMs = 0;
    private boolean dontProcessStream = false;
    private static final int NETWORK_RETRIES = 2;
    private static final int SERVICE_UNAVAILABLE_RETRIES = 10;
    private static final int CONNECT_RETRY_SLEEP_MS = 1000;
    private Protocol protocol = null;
    private final StatGroup aggProtoStats;
    private HardRecoveryElectionException hardRecoveryElectionException;
    private final Logger logger;
    private ReplicaFeederSyncup.TestHook<Object> replicaFeederSyncupHook;
    private final Map<DatabaseId, DatabaseImpl> dbCache = new HashMap<DatabaseId, DatabaseImpl>();

    Replica(RepNode repNode, Replay replay) {
        this.repNode = repNode;
        this.repImpl = repNode.getRepImpl();
        this.consistencyTracker = new ConsistencyTracker();
        this.replay = replay;
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.aggProtoStats = new StatGroup("BinaryProtocol", "Network traffic due to the replication stream.");
        this.testDelayMs = repNode.getConfigManager().getInt(RepParams.TEST_REPLICA_DELAY);
    }

    public void shutdown() {
        if (!this.repNode.isShutdown()) {
            throw EnvironmentFailureException.unexpectedState("Rep node must have initiated the shutdown.");
        }
        this.consistencyTracker.shutdown();
        if (Thread.currentThread() == this.repNode) {
            return;
        }
        RepUtils.shutdownChannel(this.replicaFeederChannel);
        this.repNode.getVLSNFreezeLatch().clearLatch();
    }

    public void setTestDelayMs(int testDelayMs) {
        this.testDelayMs = testDelayMs;
    }

    public void setDontProcessStream() {
        this.dontProcessStream = true;
    }

    public Replay replay() {
        return this.replay;
    }

    Map<DatabaseId, DatabaseImpl> getDbCache() {
        return this.dbCache;
    }

    public ConsistencyTracker getConsistencyTracker() {
        return this.consistencyTracker;
    }

    SocketChannel getReplicaFeederChannel() {
        return this.replicaFeederChannel.getChannel();
    }

    Protocol getProtocol() {
        return this.protocol;
    }

    long getMasterCommitVLSN() {
        return this.consistencyTracker.getMasterCommitVLSN();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runReplicaLoop() throws InterruptedException, DatabaseException, GroupShutdownException {
        Class<?> retryExceptionClass = null;
        int retryCount = 0;
        try {
            while (true) {
                try {
                    this.runReplicaLoopInternal();
                }
                catch (RetryException e) {
                    if (!this.repNode.getMasterStatus().inSync()) {
                        LoggerUtils.fine(this.logger, this.repImpl, "Retry terminated, out of sync.");
                        break;
                    }
                    if (e.getClass() == retryExceptionClass || e.retries == 0) {
                        if (++retryCount >= e.retries) {
                            LoggerUtils.info(this.logger, this.repImpl, "Failed to recover from exception: " + e.getMessage() + ", despite " + e.retries + " retries.\n" + LoggerUtils.getStackTrace(e));
                            break;
                        }
                    } else {
                        retryCount = 0;
                        retryExceptionClass = e.getClass();
                    }
                    LoggerUtils.info(this.logger, this.repImpl, "Retry #: " + retryCount + "/" + e.retries + " Will retry replica loop after " + e.retrySleepMs + "ms. ");
                    Thread.sleep(e.retrySleepMs);
                    if (this.repNode.getMasterStatus().inSync()) continue;
                }
                break;
            }
            Object var5_4 = null;
            if (this.hardRecoveryElectionException == null) {
                this.repNode.resetReadyLatch(this.shutdownException);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.hardRecoveryElectionException == null) {
                this.repNode.resetReadyLatch(this.shutdownException);
            }
            throw throwable;
        }
    }

    private void runReplicaLoopInternal() throws RestartRequiredException, InterruptedException, RetryException, InsufficientLogException {
        block14: {
            this.shutdownException = null;
            LoggerUtils.info(this.logger, this.repImpl, "Replica loop started with master: " + this.repNode.getMasterStatus().getNodeMasterNameId());
            if (this.testDelayMs > 0) {
                LoggerUtils.info(this.logger, this.repImpl, "Test delay of: " + this.testDelayMs + "ms." + " after each message sent");
            }
            try {
                try {
                    this.initReplicaLoop();
                    this.doRunReplicaLoopInternalWork();
                }
                catch (RestartRequiredException rre) {
                    this.shutdownException = rre;
                    throw rre;
                }
                catch (ClosedByInterruptException closedByInterruptException) {
                    if (this.repNode.isShutdown()) {
                        LoggerUtils.info(this.logger, this.repImpl, "Replica loop interrupted for shutdown.");
                        Object var3_2 = null;
                        this.loopExitCleanup();
                        return;
                    }
                    LoggerUtils.warning(this.logger, this.repImpl, "Replica loop unexpected interrupt.");
                    throw new InterruptedException(closedByInterruptException.getMessage());
                }
                catch (IOException e) {
                    LoggerUtils.info(this.logger, this.repImpl, "Replica IO exception: " + e.getMessage() + "\n" + LoggerUtils.getStackTrace(e));
                    Object var3_3 = null;
                    this.loopExitCleanup();
                    break block14;
                }
                catch (RetryException e) {
                    throw e;
                }
                catch (GroupShutdownException e) {
                    this.shutdownException = e;
                    throw e;
                }
                catch (RuntimeException e) {
                    this.shutdownException = e;
                    LoggerUtils.severe(this.logger, this.repImpl, "Replica unexpected exception " + e + " " + LoggerUtils.getStackTrace(e));
                    throw e;
                }
                catch (MasterStatus.MasterSyncException e) {
                    LoggerUtils.info(this.logger, this.repImpl, e.getMessage());
                    Object var3_4 = null;
                    this.loopExitCleanup();
                    break block14;
                }
                catch (HardRecoveryElectionException e) {
                    this.hardRecoveryElectionException = e;
                    LoggerUtils.info(this.logger, this.repImpl, e.getMessage());
                    Object var3_5 = null;
                    this.loopExitCleanup();
                    break block14;
                }
                catch (Exception e) {
                    this.shutdownException = e;
                    LoggerUtils.severe(this.logger, this.repImpl, "Replica unexpected exception " + e + " " + LoggerUtils.getStackTrace(e));
                    throw EnvironmentFailureException.unexpectedException(e);
                }
                Object var3_1 = null;
                this.loopExitCleanup();
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                this.loopExitCleanup();
                throw throwable;
            }
        }
    }

    protected void doRunReplicaLoopInternalWork() throws Exception {
        int dbTreeCacheClearingOpCount = this.repNode.getDbTreeCacheClearingOpCount();
        long opCount = 0L;
        int timeoutMs = this.repNode.getConfigManager().getDuration(RepParams.REPLICA_TIMEOUT);
        this.replicaFeederChannel.setTimeoutMs(timeoutMs);
        while (true) {
            BinaryProtocol.Message message = this.protocol.read(this.replicaFeederChannel);
            if (this.repNode.isShutdown() || message == null) {
                return;
            }
            this.repNode.getMasterStatus().assertSync();
            BinaryProtocol.MessageOp messageOps = message.getOp();
            if (messageOps == Protocol.SHUTDOWN_REQUEST) {
                throw this.processShutdown((Protocol.ShutdownRequest)message);
            }
            if (messageOps == Protocol.HEARTBEAT) {
                this.processHeartbeat(this.replicaFeederChannel, (Protocol.Heartbeat)message);
                this.clearDbTreeCache();
            } else {
                if (this.dontProcessStream) {
                    LoggerUtils.info(this.logger, this.repImpl, "Not processing " + message);
                    continue;
                }
                this.replay.replayEntry(this.replicaFeederChannel, this.protocol, (Protocol.Entry)message);
                if (messageOps == Protocol.COMMIT) {
                    this.consistencyTracker.trackCommit();
                }
                this.consistencyTracker.trackVLSN();
            }
            if (this.testDelayMs > 0) {
                Thread.sleep(this.testDelayMs);
            }
            if (opCount++ % (long)dbTreeCacheClearingOpCount != 0L) continue;
            this.clearDbTreeCache();
        }
    }

    private GroupShutdownException processShutdown(Protocol.ShutdownRequest shutdown) throws IOException {
        CheckpointConfig config = new CheckpointConfig();
        config.setForce(true);
        this.repNode.getRepImpl().invokeCheckpoint(config, false, "Group Shutdown");
        this.repNode.getRepImpl().shutdownDaemons();
        this.protocol.write((BinaryProtocol.Message)new Protocol.ShutdownResponse(this.protocol), this.replicaFeederChannel);
        return new GroupShutdownException(this.logger, this.repNode, shutdown.getShutdownTimeMs());
    }

    private void initReplicaLoop() throws IOException, ConnectRetryException, DatabaseException, BinaryProtocol.ProtocolException, InterruptedException, HardRecoveryElectionException {
        boolean hardRecoveryNeedsElection;
        this.createReplicaFeederChannel();
        ReplicaFeederHandshake handshake = new ReplicaFeederHandshake(this.repNode, this.replicaFeederChannel);
        this.protocol = handshake.execute();
        if (this.hardRecoveryElectionException != null) {
            LoggerUtils.info(this.logger, this.repImpl, "Replica syncup after election to verify master:" + this.hardRecoveryElectionException.getMaster() + " elected master:" + this.repNode.getMasterStatus().getNodeMasterNameId());
            hardRecoveryNeedsElection = false;
        } else {
            hardRecoveryNeedsElection = true;
        }
        this.hardRecoveryElectionException = null;
        ReplicaFeederSyncup syncup = new ReplicaFeederSyncup(this.repNode, this.replay, this.replicaFeederChannel, this.protocol, hardRecoveryNeedsElection);
        syncup.execute(this.repNode.getCBVLSNTracker());
        VLSN matchedTxnVLSN = syncup.getMatchedVLSN();
        long matchedTxnCommitTime = syncup.getMatchedVLSNTime();
        this.consistencyTracker.reinit(matchedTxnVLSN.getSequence(), matchedTxnCommitTime);
        Protocol.Heartbeat heartbeat = this.protocol.read(this.replicaFeederChannel.getChannel(), Protocol.Heartbeat.class);
        this.processHeartbeat(this.replicaFeederChannel, heartbeat);
        long replicaDelta = this.consistencyTracker.getMasterCommitVLSN() - this.consistencyTracker.lastReplayedVLSN.getSequence();
        LoggerUtils.info(this.logger, this.repImpl, String.format("Replica initialization completed. Replica VLSN: %s  Heartbeat master commit VLSN: %,d VLSN delta: %,d", this.consistencyTracker.lastReplayedVLSN, this.consistencyTracker.getMasterCommitVLSN(), replicaDelta));
        this.repNode.getReadyLatch().countDown();
    }

    private void processHeartbeat(NamedChannel namedChannel, Protocol.Heartbeat heartbeat) throws IOException {
        Protocol protocol = this.protocol;
        protocol.getClass();
        this.protocol.write((BinaryProtocol.Message)new Protocol.HeartbeatResponse(protocol, this.repNode.getCBVLSNTracker().getBroadcastCBVLSN()), namedChannel);
        this.consistencyTracker.trackHeartbeat(heartbeat);
    }

    private void loopExitCleanup() {
        if (this.shutdownException != null) {
            if (this.shutdownException instanceof RetryException) {
                LoggerUtils.info(this.logger, this.repImpl, "Retrying connection to feeder. Message: " + this.shutdownException.getMessage());
            } else if (this.shutdownException instanceof GroupShutdownException) {
                LoggerUtils.info(this.logger, this.repImpl, "Exiting inner Replica loop. Master requested shutdown.");
            } else {
                LoggerUtils.warning(this.logger, this.repImpl, "Exiting inner Replica loop with exception " + this.shutdownException + "\n" + LoggerUtils.getStackTrace(this.shutdownException));
            }
        } else {
            LoggerUtils.info(this.logger, this.repImpl, "Exiting inner Replica loop.");
        }
        this.clearDbTreeCache();
        RepUtils.shutdownChannel(this.replicaFeederChannel);
        if (this.consistencyTracker != null) {
            this.consistencyTracker.logStats();
        }
        if (this.protocol != null) {
            this.aggProtoStats.addAll(this.protocol.getStats(StatsConfig.DEFAULT));
        }
        this.protocol = null;
    }

    void clearDbTreeCache() {
        this.repNode.getRepImpl().getDbTree().releaseDbs(this.dbCache);
        this.dbCache.clear();
    }

    void masterTransitionCleanup() throws DatabaseException {
        this.hardRecoveryElectionException = null;
        this.replay.abortOldTxns();
        this.consistencyTracker.forceTripLatches(new MasterStateException(this.repNode.getRepImpl().getStateChangeEvent()));
    }

    private void createReplicaFeederChannel() throws IOException, ConnectRetryException {
        SocketChannel channel = SocketChannel.open();
        DbConfigManager configManager = this.repNode.getConfigManager();
        int timeoutMs = this.repNode.getConfigManager().getDuration(RepParams.PRE_HEARTBEAT_TIMEOUT);
        this.replicaFeederChannel = new NamedChannelWithTimeout(this.repNode, channel, timeoutMs);
        Socket socket = channel.socket();
        channel.configureBlocking(true);
        socket.setTcpNoDelay(true);
        try {
            int openTimeout = configManager.getDuration(RepParams.REPSTREAM_OPEN_TIMEOUT);
            socket.connect(this.repNode.getMasterStatus().getNodeMaster(), openTimeout);
            ServiceDispatcher.doServiceHandshake(channel, "Feeder");
        }
        catch (ConnectException e) {
            throw new ConnectRetryException(e.getMessage(), 2, 1000);
        }
        catch (ServiceDispatcher.ServiceConnectFailedException e) {
            if (e.getResponse() == ServiceDispatcher.Response.UNKNOWN_SERVICE) {
                throw new ConnectRetryException(e.getMessage(), 10, 1000);
            }
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    public StatGroup getReplayStats(StatsConfig config) {
        return this.replay.getStats(config);
    }

    public StatGroup getProtocolStats(StatsConfig config) {
        StatGroup protoStats = this.aggProtoStats.cloneGroup(config.getClear());
        Protocol prot = this.protocol;
        if (prot != null) {
            protoStats.addAll(prot.getStats(config));
        }
        return protoStats;
    }

    public StatGroup getTrackerStats(StatsConfig config) {
        return this.consistencyTracker.getStats(config);
    }

    public void resetStats() {
        this.replay.resetStats();
        this.aggProtoStats.clear();
        if (this.protocol != null) {
            this.protocol.resetStats();
        }
        this.consistencyTracker.resetStats();
    }

    public void setReplicaFeederSyncupHook(ReplicaFeederSyncup.TestHook<Object> syncupHook) {
        this.replicaFeederSyncupHook = syncupHook;
    }

    public ReplicaFeederSyncup.TestHook<Object> getReplicaFeederSyncupHook() {
        return this.replicaFeederSyncupHook;
    }

    public static class HardRecoveryElectionException
    extends Exception {
        final NameIdPair masterNameIdPair;
        final VLSN lastTxnEnd;
        final VLSN matchpointVLSN;

        public HardRecoveryElectionException(NameIdPair masterNameIdPair, VLSN lastTxnEnd, VLSN matchpointVLSN) {
            this.masterNameIdPair = masterNameIdPair;
            this.lastTxnEnd = lastTxnEnd;
            this.matchpointVLSN = matchpointVLSN;
        }

        public NameIdPair getMaster() {
            return this.masterNameIdPair;
        }

        public String getMessage() {
            return "Need election preceding hard recovery to verify master:" + this.masterNameIdPair + " last txn end:" + this.lastTxnEnd + " matchpoint VLSN:" + this.matchpointVLSN;
        }
    }

    static class ConnectRetryException
    extends RetryException {
        ConnectRetryException(String message, int retries, int retrySleepMs) {
            super(message, retries, retrySleepMs);
        }
    }

    static abstract class RetryException
    extends Exception {
        final int retries;
        final int retrySleepMs;

        RetryException(String message, int retries, int retrySleepMs) {
            super(message);
            this.retries = retries;
            this.retrySleepMs = retrySleepMs;
        }

        public String getMessage() {
            return "Failed after retries: " + this.retries + " with retry interval: " + this.retrySleepMs + "ms.";
        }
    }

    private abstract class OrderedLatches {
        final EnvironmentImpl envImpl;
        final SortedMap<Long, RepUtils.ExceptionAwareCountDownLatch> latchMap = new TreeMap<Long, RepUtils.ExceptionAwareCountDownLatch>();

        abstract boolean tripPredicate(long var1, long var3);

        OrderedLatches(EnvironmentImpl envImpl) {
            this.envImpl = envImpl;
        }

        synchronized RepUtils.ExceptionAwareCountDownLatch getOrCreate(Long key) {
            RepUtils.ExceptionAwareCountDownLatch latch = (RepUtils.ExceptionAwareCountDownLatch)this.latchMap.get(key);
            if (latch == null) {
                latch = new RepUtils.ExceptionAwareCountDownLatch(this.envImpl, 1);
                this.latchMap.put(key, latch);
            }
            return latch;
        }

        synchronized void trip(long tripValue, DatabaseException exception) {
            while (this.latchMap.size() > 0) {
                Long key = this.latchMap.firstKey();
                if (!this.tripPredicate(key, tripValue)) {
                    return;
                }
                RepUtils.ExceptionAwareCountDownLatch latch = (RepUtils.ExceptionAwareCountDownLatch)this.latchMap.remove(key);
                latch.releaseAwait(exception);
            }
        }
    }

    public class ConsistencyTracker {
        private final long NULL_VLSN_SEQUENCE;
        private long lastReplayedTxnVLSN;
        private VLSN lastReplayedVLSN;
        private long txnMasterCommitTime;
        private long masterCommitVLSN;
        private long masterNow;
        private final StatGroup stats;
        private final LongStat nLagConsistencyWaits;
        private final LongStat nLagConsistencyWaitMs;
        private final LongStat nVLSNConsistencyWaits;
        private final LongStat nVLSNConsistencyWaitMs;
        private final OrderedLatches vlsnLatches;
        private final OrderedLatches lagLatches;

        public ConsistencyTracker() {
            this.lastReplayedTxnVLSN = this.NULL_VLSN_SEQUENCE = VLSN.NULL_VLSN.getSequence();
            this.lastReplayedVLSN = VLSN.NULL_VLSN;
            this.txnMasterCommitTime = 0L;
            this.masterNow = 0L;
            this.stats = new StatGroup("ConsistencyTracker", "Statistics on the delays experienced by read requests at the replica in order to conform to the specified ReplicaConsistencyPolicy.");
            this.nLagConsistencyWaits = new LongStat(this.stats, ReplicaStatDefinition.N_LAG_CONSISTENCY_WAITS);
            this.nLagConsistencyWaitMs = new LongStat(this.stats, ReplicaStatDefinition.N_LAG_CONSISTENCY_WAIT_MS);
            this.nVLSNConsistencyWaits = new LongStat(this.stats, ReplicaStatDefinition.N_VLSN_CONSISTENCY_WAITS);
            this.nVLSNConsistencyWaitMs = new LongStat(this.stats, ReplicaStatDefinition.N_VLSN_CONSISTENCY_WAIT_MS);
            this.vlsnLatches = new OrderedLatches((EnvironmentImpl)Replica.this.repNode.getRepImpl()){

                boolean tripPredicate(long keyVLSN, long tripVLSN) {
                    return keyVLSN <= tripVLSN;
                }
            };
            this.lagLatches = new OrderedLatches((EnvironmentImpl)Replica.this.repNode.getRepImpl()){

                boolean tripPredicate(long keyLag, long currentLag) {
                    return currentLag <= keyLag;
                }
            };
        }

        void reinit(long matchedTxnVLSN, long matchedCommitTime) {
            this.lastReplayedVLSN = new VLSN(matchedTxnVLSN);
            this.lastReplayedTxnVLSN = matchedTxnVLSN;
            this.txnMasterCommitTime = matchedCommitTime;
        }

        public long getMasterCommitVLSN() {
            return this.masterCommitVLSN;
        }

        void close() {
            this.logStats();
        }

        void logStats() {
            if (Replica.this.logger.isLoggable(Level.INFO)) {
                LoggerUtils.info(Replica.this.logger, Replica.this.repImpl, "Replica stats - Lag waits: " + this.nLagConsistencyWaits.get() + " Lag wait time: " + this.nLagConsistencyWaitMs.get() + "ms. " + " VLSN waits: " + this.nVLSNConsistencyWaits.get() + " Lag wait time: " + this.nVLSNConsistencyWaitMs.get() + "ms.");
            }
        }

        private long currentLag() {
            if (this.masterNow == 0L) {
                return Integer.MAX_VALUE;
            }
            long lag = this.lastReplayedTxnVLSN < this.masterCommitVLSN ? System.currentTimeMillis() - this.txnMasterCommitTime : (this.lastReplayedTxnVLSN == this.masterCommitVLSN ? System.currentTimeMillis() - this.masterNow : System.currentTimeMillis() - this.masterNow);
            return lag;
        }

        synchronized void forceTripLatches(DatabaseException exception) {
            assert (exception != null);
            this.vlsnLatches.trip(Long.MAX_VALUE, exception);
            this.lagLatches.trip(0L, exception);
        }

        synchronized void trackCommit() {
            Replay.TxnInfo lastReplayedTxn = Replica.this.replay.getLastReplayedTxn();
            this.lastReplayedTxnVLSN = lastReplayedTxn.getTxnVLSN().getSequence();
            this.txnMasterCommitTime = lastReplayedTxn.getMasterCommitTime();
            if (this.lastReplayedTxnVLSN > this.masterCommitVLSN && this.txnMasterCommitTime >= this.masterNow) {
                this.masterCommitVLSN = this.lastReplayedTxnVLSN;
                this.masterNow = this.txnMasterCommitTime;
            }
            this.vlsnLatches.trip(this.lastReplayedTxnVLSN, null);
            this.lagLatches.trip(this.currentLag(), null);
        }

        synchronized void trackVLSN() {
            this.lastReplayedVLSN = Replica.this.replay.getLastReplayedVLSN();
            this.vlsnLatches.trip(this.lastReplayedVLSN.getSequence(), null);
        }

        synchronized void trackHeartbeat(Protocol.Heartbeat heartbeat) {
            this.masterCommitVLSN = heartbeat.getCurrentCommitVLSN();
            this.masterNow = heartbeat.getMasterNow();
            this.lagLatches.trip(this.currentLag(), null);
        }

        public void lagAwait(TimeConsistencyPolicy consistencyPolicy) throws InterruptedException, ReplicaConsistencyException, DatabaseException {
            long lag;
            long currentLag = this.currentLag();
            if (currentLag <= (lag = consistencyPolicy.getPermissibleLag(TimeUnit.MILLISECONDS))) {
                return;
            }
            long waitStart = System.currentTimeMillis();
            RepUtils.ExceptionAwareCountDownLatch waitLagLatch = this.lagLatches.getOrCreate(lag);
            this.await(waitLagLatch, consistencyPolicy);
            this.nLagConsistencyWaits.increment();
            this.nLagConsistencyWaitMs.add(System.currentTimeMillis() - waitStart);
        }

        public void commitVLSNAwait(long vlsn, ReplicaConsistencyPolicy consistencyPolicy) throws InterruptedException, ReplicaConsistencyException, DatabaseException {
            this.VLSNAwait(vlsn, consistencyPolicy);
        }

        public void anyVLSNAwait(long vlsn, ReplicaConsistencyPolicy consistencyPolicy) throws InterruptedException, ReplicaConsistencyException, DatabaseException {
            this.VLSNAwait(vlsn, consistencyPolicy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void VLSNAwait(long vlsn, ReplicaConsistencyPolicy consistencyPolicy) throws InterruptedException, ReplicaConsistencyException, DatabaseException {
            long waitStart = System.currentTimeMillis();
            RepUtils.ExceptionAwareCountDownLatch waitVLSNLatch = null;
            ConsistencyTracker consistencyTracker = this;
            synchronized (consistencyTracker) {
                long compareVLSN;
                long l = compareVLSN = consistencyPolicy instanceof CommitPointConsistencyPolicy ? this.lastReplayedTxnVLSN : this.lastReplayedVLSN.getSequence();
                if (vlsn <= compareVLSN) {
                    return;
                }
                waitVLSNLatch = this.vlsnLatches.getOrCreate(vlsn);
            }
            this.await(waitVLSNLatch, consistencyPolicy);
            this.nVLSNConsistencyWaits.increment();
            this.nVLSNConsistencyWaitMs.add(System.currentTimeMillis() - waitStart);
        }

        private void await(RepUtils.ExceptionAwareCountDownLatch consistencyLatch, ReplicaConsistencyPolicy consistencyPolicy) throws ReplicaConsistencyException, DatabaseException, InterruptedException {
            if (!consistencyLatch.awaitOrException(consistencyPolicy.getTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS)) {
                boolean detached = Replica.this.repNode.getRepImpl().getState().isDetached();
                throw new ReplicaConsistencyException(consistencyPolicy, detached);
            }
        }

        private StatGroup getStats(StatsConfig config) {
            if (config.getClear()) {
                this.stats.clear();
            }
            StatGroup ret = this.stats.cloneGroup(false);
            return ret;
        }

        private void resetStats() {
            this.stats.clear();
        }

        public void shutdown() {
            Exception savedShutdownException = Replica.this.repNode.getSavedShutdownException();
            EnvironmentFailureException latchException = savedShutdownException instanceof EnvironmentFailureException ? (EnvironmentFailureException)savedShutdownException : EnvironmentFailureException.unexpectedException("Node: " + Replica.this.repNode.getNameIdPair() + " was shut down.", savedShutdownException);
            this.forceTripLatches(latchException);
        }
    }
}

