/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.stream.OutputWireRecord;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;

abstract class VLSNReader
extends FileReader {
    final VLSNIndex vlsnIndex;
    VLSN currentVLSN;
    OutputWireRecord currentFeedRecord;
    long nScanned;
    long nReposition;

    VLSNReader(EnvironmentImpl envImpl, VLSNIndex vlsnIndex, boolean forward, long startLsn, int readBufferSize, NameIdPair nameIdPair, long finishLsn) throws DatabaseException {
        super(envImpl, readBufferSize, forward, startLsn, null, startLsn, finishLsn);
        this.vlsnIndex = vlsnIndex;
        this.currentVLSN = VLSN.NULL_VLSN;
    }

    void setPosition(long startLsn) throws ChecksumException, FileNotFoundException, DatabaseException {
        long offset;
        long fileNum;
        if (startLsn == -1L) {
            return;
        }
        if (this.forward) {
            if (DbLsn.compareTo(this.getLastLsn(), startLsn) > 0) {
                throw EnvironmentFailureException.unexpectedState("Feeder forward scanning should not be repositioned to  a position earlier than the current position. Current lsn = " + DbLsn.getNoFormatString(this.getLastLsn()) + " reposition = " + DbLsn.getNoFormatString(startLsn));
            }
        } else if (DbLsn.compareTo(this.getLastLsn(), startLsn) < 0) {
            throw EnvironmentFailureException.unexpectedState("Feeder backward scanning should not be repositioned to  a position later than the current position. Current lsn = " + DbLsn.getNoFormatString(this.getLastLsn()) + " reposition = " + DbLsn.getNoFormatString(startLsn));
        }
        if (this.window.containsLsn(fileNum = DbLsn.getFileNumber(startLsn), offset = DbLsn.getFileOffset(startLsn))) {
            this.window.positionBuffer(offset);
        } else {
            this.window.slideAndFill(fileNum, offset, offset, this.forward);
        }
        if (this.forward) {
            this.nextEntryOffset = offset;
        } else {
            this.currentEntryPrevOffset = offset;
        }
        ++this.nReposition;
    }

    protected boolean processEntry(ByteBuffer entryBuffer) {
        ByteBuffer buffer = entryBuffer.slice();
        buffer.limit(this.currentEntryHeader.getItemSize());
        this.currentFeedRecord = new OutputWireRecord(this.currentEntryHeader, buffer);
        entryBuffer.position(entryBuffer.position() + this.currentEntryHeader.getItemSize());
        return true;
    }

    long getNReposition() {
        return this.nReposition;
    }

    long getNScanned() {
        return this.nScanned;
    }

    void resetStats() {
        this.nReposition = 0L;
        this.nScanned = 0L;
    }
}

