/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.ForwardCursor;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DupKeyData;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.dbi.RangeConstraint;
import com.sleepycat.je.dbi.RangeRestartException;
import com.sleepycat.je.dbi.RecordVersion;
import com.sleepycat.je.dbi.TriggerManager;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.tree.CountEstimator;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.txn.BuddyLocker;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.Pair;
import com.sleepycat.je.utilint.ThroughputStatGroup;
import java.util.Collection;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cursor
implements ForwardCursor {
    private static final DatabaseEntry EMPTY_DUP_DATA = new DatabaseEntry(new byte[0]);
    static final DatabaseEntry NO_RETURN_DATA = new DatabaseEntry();
    CursorConfig config;
    private Transaction transaction;
    private Database dbHandle;
    private DatabaseImpl dbImpl;
    CursorImpl cursorImpl;
    private boolean updateOperationsProhibited;
    private boolean readUncommittedDefault;
    private boolean serializableIsolationDefault;
    private boolean nonCloning = false;
    private CacheMode cacheMode;
    private boolean cacheModeOverridden;
    private RangeConstraint rangeConstraint;
    private ThroughputStatGroup thrput;
    private Logger logger;

    Cursor(Database dbHandle, Transaction txn, CursorConfig cursorConfig) {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        if (dbHandle != null) {
            dbHandle.checkOpen("Can't access Database:");
        }
        Locker locker = LockerFactory.getReadableLocker(dbHandle, txn, cursorConfig.getReadCommitted());
        this.init(dbHandle, dbHandle.getDatabaseImpl(), locker, cursorConfig, false);
    }

    Cursor(Database dbHandle, Locker locker, CursorConfig cursorConfig) {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        if (dbHandle != null) {
            dbHandle.checkOpen("Can't access Database:");
        }
        locker = LockerFactory.getReadableLocker(dbHandle, locker, cursorConfig.getReadCommitted());
        this.init(dbHandle, dbHandle.getDatabaseImpl(), locker, cursorConfig, false);
    }

    Cursor(Database dbHandle, Locker locker, CursorConfig cursorConfig, boolean retainNonTxnLocks) {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        if (dbHandle != null) {
            dbHandle.checkOpen("Can't access Database:");
        }
        this.init(dbHandle, dbHandle.getDatabaseImpl(), locker, cursorConfig, retainNonTxnLocks);
    }

    Cursor(DatabaseImpl databaseImpl, Locker locker, CursorConfig cursorConfig, boolean retainNonTxnLocks) {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        if (this.dbHandle != null) {
            this.dbHandle.checkOpen("Can't access Database:");
        }
        this.init(null, databaseImpl, locker, cursorConfig, retainNonTxnLocks);
    }

    private void init(Database dbHandle, DatabaseImpl databaseImpl, Locker locker, CursorConfig cursorConfig, boolean retainNonTxnLocks) {
        assert (locker != null);
        try {
            locker.openCursorHook(databaseImpl);
        }
        catch (RuntimeException e) {
            locker.operationEnd();
            throw e;
        }
        this.cursorImpl = new CursorImpl(databaseImpl, locker, retainNonTxnLocks, this.isSecondaryCursor());
        this.transaction = locker.getTransaction();
        this.cacheMode = databaseImpl.getDefaultCacheMode();
        this.cursorImpl.setAllowEviction(true);
        this.readUncommittedDefault = cursorConfig.getReadUncommitted() || locker.isReadUncommittedDefault();
        this.serializableIsolationDefault = this.cursorImpl.getLocker().isSerializableIsolation();
        this.updateOperationsProhibited = locker.isReadOnly() || dbHandle != null && !dbHandle.isWritable() || databaseImpl.isTransactional() && !locker.isTransactional() || databaseImpl.isReplicated() == locker.isLocalWrite();
        this.dbImpl = databaseImpl;
        if (dbHandle != null) {
            this.dbHandle = dbHandle;
            dbHandle.addCursor(this);
            this.thrput = dbHandle.getEnvironment().getEnvironmentImpl().getThroughputStatGroup();
        }
        this.config = cursorConfig;
        this.logger = databaseImpl.getDbEnvironment().getLogger();
    }

    Cursor(Cursor cursor, boolean samePosition) {
        this.readUncommittedDefault = cursor.readUncommittedDefault;
        this.serializableIsolationDefault = cursor.serializableIsolationDefault;
        this.updateOperationsProhibited = cursor.updateOperationsProhibited;
        this.cursorImpl = cursor.cursorImpl.dup(samePosition);
        this.dbImpl = cursor.dbImpl;
        this.dbHandle = cursor.dbHandle;
        if (this.dbHandle != null) {
            this.dbHandle.addCursor(this);
        }
        this.config = cursor.config;
        this.logger = this.dbImpl.getDbEnvironment().getLogger();
        this.cacheMode = cursor.cacheMode;
        this.cacheModeOverridden = cursor.cacheModeOverridden;
        this.thrput = cursor.thrput;
    }

    boolean isSecondaryCursor() {
        return false;
    }

    void setNonCloning(boolean nonCloning) {
        this.nonCloning = nonCloning;
    }

    CursorImpl getCursorImpl() {
        return this.cursorImpl;
    }

    @Override
    public Database getDatabase() {
        return this.dbHandle;
    }

    DatabaseImpl getDatabaseImpl() {
        return this.dbImpl;
    }

    public CursorConfig getConfig() {
        try {
            return this.config.clone();
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.cacheModeOverridden = cacheMode != null;
        this.cacheMode = cacheMode != null ? cacheMode : this.dbImpl.getDefaultCacheMode();
    }

    public void setRangeConstraint(RangeConstraint rangeConstraint) {
        if (this.dbImpl.getSortedDuplicates()) {
            throw new UnsupportedOperationException("Not allowed with dups");
        }
        this.rangeConstraint = rangeConstraint;
    }

    private void setPrefixConstraint(Cursor c, final byte[] keyBytes2) {
        c.rangeConstraint = new RangeConstraint(){

            @Override
            public boolean inBounds(byte[] checkKey) {
                return DupKeyData.compareMainKey(checkKey, keyBytes2, Cursor.this.dbImpl.getBtreeComparator()) == 0;
            }
        };
    }

    private void setPrefixConstraint(Cursor c, final DatabaseEntry key2) {
        c.rangeConstraint = new RangeConstraint(){

            @Override
            public boolean inBounds(byte[] checkKey) {
                return DupKeyData.compareMainKey(checkKey, key2.getData(), key2.getOffset(), key2.getSize(), Cursor.this.dbImpl.getBtreeComparator()) == 0;
            }
        };
    }

    private boolean checkRangeConstraint(DatabaseEntry key) {
        assert (key.getOffset() == 0);
        assert (key.getData().length == key.getSize());
        if (this.rangeConstraint == null) {
            return true;
        }
        return this.rangeConstraint.inBounds(key.getData());
    }

    @Override
    public void close() throws DatabaseException {
        try {
            if (this.cursorImpl.isClosed()) {
                return;
            }
            this.checkEnv();
            this.cursorImpl.close();
            if (this.dbHandle != null) {
                this.dbHandle.removeCursor(this);
                this.dbHandle = null;
            }
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    public Cursor dup(boolean samePosition) throws DatabaseException {
        try {
            this.checkState(false);
            return new Cursor(this, samePosition);
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    public OperationStatus delete() throws LockConflictException, DatabaseException, UnsupportedOperationException {
        this.checkState(true);
        this.trace(Level.FINEST, "Cursor.delete: ", null);
        if (this.thrput != null) {
            this.thrput.increment(7);
        }
        return this.deleteInternal(this.dbImpl.getRepContext());
    }

    public OperationStatus put(DatabaseEntry key, DatabaseEntry data) throws DatabaseException, UnsupportedOperationException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.trace(Level.FINEST, "Cursor.put: ", key, data, null);
        if (this.thrput != null) {
            this.thrput.increment(17);
        }
        return this.putInternal(key, data, PutMode.OVERWRITE);
    }

    public OperationStatus putNoOverwrite(DatabaseEntry key, DatabaseEntry data) throws DatabaseException, UnsupportedOperationException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.trace(Level.FINEST, "Cursor.putNoOverwrite: ", key, data, null);
        if (this.thrput != null) {
            this.thrput.increment(20);
        }
        return this.putInternal(key, data, PutMode.NO_OVERWRITE);
    }

    public OperationStatus putNoDupData(DatabaseEntry key, DatabaseEntry data) throws DatabaseException, UnsupportedOperationException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.trace(Level.FINEST, "Cursor.putNoDupData: ", key, data, null);
        if (this.thrput != null) {
            this.thrput.increment(19);
        }
        return this.putInternal(key, data, PutMode.NO_DUP_DATA);
    }

    public OperationStatus putCurrent(DatabaseEntry data) throws DatabaseException, UnsupportedOperationException {
        this.checkState(true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        this.trace(Level.FINEST, "Cursor.putCurrent: ", null, data, null);
        if (this.thrput != null) {
            this.thrput.increment(18);
        }
        return this.putInternal(null, data, PutMode.CURRENT);
    }

    @Override
    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        try {
            this.checkState(true);
            Cursor.checkArgsNoValRequired(key, data);
            this.trace(Level.FINEST, "Cursor.getCurrent: ", lockMode);
            if (this.thrput != null) {
                this.thrput.increment(8);
            }
            return this.getCurrentInternal(key, data, lockMode, false);
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    public OperationStatus getFirst(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        Cursor.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getFirst: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(9);
        }
        return this.position(key, data, lockMode, true);
    }

    public OperationStatus getLast(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        Cursor.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getLast: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(10);
        }
        return this.position(key, data, lockMode, false);
    }

    @Override
    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        Cursor.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getNext: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(11);
        }
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, true);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.NEXT);
    }

    public OperationStatus getNextDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        Cursor.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getNextDup: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(12);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.NEXT_DUP);
    }

    public OperationStatus getNextNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        Cursor.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getNextNoDup: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(13);
        }
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, true);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.NEXT_NODUP);
    }

    public OperationStatus getPrev(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        Cursor.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getPrev: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(14);
        }
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, false);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.PREV);
    }

    public OperationStatus getPrevDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        Cursor.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getPrevDup: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(15);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.PREV_DUP);
    }

    public OperationStatus getPrevNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        Cursor.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getPrevNoDup: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(16);
        }
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, false);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.PREV_NODUP);
    }

    public long skipNext(long maxCount, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        if (maxCount <= 0L) {
            throw new IllegalArgumentException("maxCount must be positive: " + maxCount);
        }
        this.trace(Level.FINEST, "Cursor.skipNext: ", lockMode);
        return this.skipInternal(maxCount, true, key, data, lockMode);
    }

    public long skipPrev(long maxCount, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        if (maxCount <= 0L) {
            throw new IllegalArgumentException("maxCount must be positive: " + maxCount);
        }
        this.trace(Level.FINEST, "Cursor.skipPrev: ", lockMode);
        return this.skipInternal(maxCount, false, key, data, lockMode);
    }

    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "Cursor.getSearchKey: ", key, null, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.SET);
    }

    public OperationStatus getSearchKeyRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "Cursor.getSearchKeyRange: ", key, null, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.SET_RANGE);
    }

    public OperationStatus getSearchBoth(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        Cursor.checkArgsValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getSearchBoth: ", key, data, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.BOTH);
    }

    public OperationStatus getSearchBothRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        Cursor.checkArgsValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getSearchBothRange: ", key, data, lockMode);
        if (!this.dbImpl.getSortedDuplicates()) {
            return this.search(key, data, lockMode, CursorImpl.SearchMode.BOTH);
        }
        return this.search(key, data, lockMode, CursorImpl.SearchMode.BOTH_RANGE);
    }

    public OperationStatus getNextAfterPrefix(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "Cursor.getNextAfterPrefix: ", key, null, lockMode);
        Comparator<byte[]> searchComparator = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] prefix, byte[] checkKey) {
                int cmp;
                int prefixLen = prefix.length;
                int checkLen = Math.min(checkKey.length, prefixLen);
                Comparator<byte[]> btreeComparator = Cursor.this.dbImpl.getBtreeComparator();
                if (btreeComparator == null) {
                    cmp = Key.compareUnsignedBytes(prefix, 0, prefixLen, checkKey, 0, checkLen);
                } else {
                    byte[] key2 = new byte[checkLen];
                    System.arraycopy(checkKey, 0, key2, 0, checkLen);
                    cmp = btreeComparator.compare(prefix, key2);
                }
                return cmp != 0 ? cmp : 1;
            }
        };
        OperationStatus status = OperationStatus.NOTFOUND;
        LockType lockType = this.getLockType(lockMode, false);
        while (true) {
            try {
                return this.searchRange(key, data, lockType, searchComparator, false);
            }
            catch (RangeRestartException e) {
                continue;
            }
            break;
        }
    }

    public int count() throws DatabaseException {
        this.checkState(true);
        this.trace(Level.FINEST, "Cursor.count: ", null);
        return this.countInternal();
    }

    public long countEstimate() throws DatabaseException {
        this.checkState(true);
        this.trace(Level.FINEST, "Cursor.countEstimate: ", null);
        return this.countEstimateInternal();
    }

    OperationStatus deleteInternal(ReplicationContext repContext) {
        boolean hasAssociations;
        this.checkUpdatesAllowed();
        boolean hasUserTriggers = this.dbImpl.getTriggers() != null;
        boolean bl = hasAssociations = this.dbHandle != null && this.dbHandle.hasSecondaryOrForeignKeyAssociations();
        if (hasAssociations) {
            try {
                this.dbImpl.getDbEnvironment().getSecondaryAssociationLock().readLock().lockInterruptibly();
            }
            catch (InterruptedException e) {
                throw new ThreadInterruptedException(this.dbImpl.getDbEnvironment(), (Throwable)e);
            }
        }
        try {
            OperationStatus operationStatus;
            OperationStatus deleteStatus;
            OperationStatus status;
            DatabaseEntry oldData;
            boolean needOldData;
            Collection<SecondaryDatabase> fkSecondaries;
            Collection<SecondaryDatabase> secondaries;
            DatabaseEntry key;
            if (hasAssociations || hasUserTriggers) {
                key = new DatabaseEntry();
                key.setData(this.cursorImpl.getCurrentKey());
                EnvironmentFailureException.assertState(key.getData() != null);
            } else {
                key = null;
            }
            if (hasAssociations) {
                secondaries = this.dbHandle.secAssoc.getSecondaries(key);
                fkSecondaries = this.dbHandle.foreignKeySecondaries;
                needOldData = hasUserTriggers || SecondaryDatabase.needOldDataForDelete(secondaries);
            } else {
                secondaries = null;
                fkSecondaries = null;
                needOldData = hasUserTriggers;
            }
            DatabaseEntry databaseEntry = oldData = needOldData ? new DatabaseEntry() : null;
            if ((needOldData || hasAssociations) && (status = this.getCurrentInternal(key, oldData, LockMode.RMW, false)) != OperationStatus.SUCCESS) {
                OperationStatus operationStatus2 = OperationStatus.KEYEMPTY;
                return operationStatus2;
            }
            Locker locker = this.cursorImpl.getLocker();
            if (fkSecondaries != null) {
                for (SecondaryDatabase secDb : fkSecondaries) {
                    secDb.onForeignKeyDelete(locker, key);
                }
            }
            if (secondaries != null) {
                for (SecondaryDatabase secDb : secondaries) {
                    secDb.updateSecondary(locker, null, key, oldData, null);
                }
            }
            if ((deleteStatus = this.deleteNoNotify(repContext)) != OperationStatus.SUCCESS) {
                operationStatus = deleteStatus;
                return operationStatus;
            }
            if (hasUserTriggers) {
                TriggerManager.runDeleteTriggers(locker, this.dbImpl, key, oldData);
            }
            operationStatus = OperationStatus.SUCCESS;
            return operationStatus;
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
        finally {
            if (hasAssociations) {
                this.dbImpl.getDbEnvironment().getSecondaryAssociationLock().readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus deleteNoNotify(ReplicationContext repContext) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            this.beginUseExistingCursor();
            OperationStatus status = this.cursorImpl.deleteCurrentRecord(repContext);
            this.endUseExistingCursor();
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus putForReplay(DatabaseEntry key, DatabaseEntry data, LN ln, PutMode putMode, ReplicationContext repContext) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            assert (putMode != PutMode.CURRENT);
            return this.putNotify(key, data, ln, putMode, repContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus putInternal(DatabaseEntry key, DatabaseEntry data, PutMode putMode) {
        this.checkUpdatesAllowed();
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            if (this.dbImpl.getSortedDuplicates()) {
                return this.putHandleDups(key, data, putMode);
            }
            if (putMode == PutMode.NO_DUP_DATA) {
                throw new UnsupportedOperationException("Database is not configured for duplicate data.");
            }
            return this.putNoDups(key, data, putMode);
        }
    }

    private OperationStatus putHandleDups(DatabaseEntry key, DatabaseEntry data, PutMode putMode) {
        switch (putMode) {
            case OVERWRITE: {
                return this.dupsPutOverwrite(key, data);
            }
            case NO_OVERWRITE: {
                return this.dupsPutNoOverwrite(key, data);
            }
            case NO_DUP_DATA: {
                return this.dupsPutNoDupData(key, data);
            }
            case CURRENT: {
                return this.dupsPutCurrent(data);
            }
        }
        throw EnvironmentFailureException.unexpectedState(putMode.toString());
    }

    private OperationStatus dupsPutOverwrite(DatabaseEntry key, DatabaseEntry data) {
        DatabaseEntry twoPartKey = DupKeyData.combine(key, data);
        return this.putNoDups(twoPartKey, EMPTY_DUP_DATA, PutMode.OVERWRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus dupsPutNoOverwrite(DatabaseEntry key, DatabaseEntry data) {
        DatabaseEntry key2 = new DatabaseEntry();
        DatabaseEntry data2 = new DatabaseEntry();
        try (Cursor c = this.dup(false);){
            c.setNonCloning(true);
            Cursor.setEntry(key, key2);
            OperationStatus status = c.dupsGetSearchKeyRange(key2, data2, LockMode.RMW, false);
            if (status == OperationStatus.SUCCESS && key.equals(key2)) {
                OperationStatus operationStatus = OperationStatus.KEYEXIST;
                return operationStatus;
            }
            if (status != OperationStatus.SUCCESS) {
                c.cursorImpl.lockEof(LockType.WRITE);
            }
            Cursor.setEntry(key, key2);
            status = c.dupsGetSearchKey(key2, data2, LockMode.RMW, false, null);
            if (status == OperationStatus.SUCCESS) {
                OperationStatus operationStatus = OperationStatus.KEYEXIST;
                return operationStatus;
            }
            status = c.dupsPutNoDupData(key, data);
            if (status != OperationStatus.SUCCESS) {
                OperationStatus operationStatus = status;
                return operationStatus;
            }
            this.swapCursor(c);
            OperationStatus operationStatus = OperationStatus.SUCCESS;
            return operationStatus;
        }
    }

    private OperationStatus dupsPutNoDupData(DatabaseEntry key, DatabaseEntry data) {
        DatabaseEntry twoPartKey = DupKeyData.combine(key, data);
        return this.putNoDups(twoPartKey, EMPTY_DUP_DATA, PutMode.NO_OVERWRITE);
    }

    private OperationStatus dupsPutCurrent(DatabaseEntry newData) {
        DatabaseEntry oldTwoPartKey = new DatabaseEntry();
        LockType lockType = this.getLockType(LockMode.RMW, false);
        OperationStatus status = this.getCurrentNoDups(oldTwoPartKey, NO_RETURN_DATA, lockType, false);
        if (status != OperationStatus.SUCCESS) {
            return status;
        }
        DatabaseEntry key = new DatabaseEntry();
        DupKeyData.split(oldTwoPartKey, key, null);
        DatabaseEntry newTwoPartKey = DupKeyData.combine(key, newData);
        return this.putNoDups(newTwoPartKey, EMPTY_DUP_DATA, PutMode.CURRENT);
    }

    private OperationStatus putNoDups(DatabaseEntry key, DatabaseEntry data, PutMode putMode) {
        LN ln = putMode == PutMode.CURRENT ? null : LN.makeLN(this.dbImpl.getDbEnvironment(), data);
        return this.putNotify(key, data, ln, putMode, this.dbImpl.getRepContext());
    }

    private OperationStatus putNotify(DatabaseEntry key, DatabaseEntry data, LN ln, PutMode putMode, ReplicationContext repContext) {
        boolean hasAssociations;
        boolean hasUserTriggers = this.dbImpl.getTriggers() != null;
        boolean bl = hasAssociations = this.dbHandle != null && this.dbHandle.hasSecondaryOrForeignKeyAssociations();
        if (hasAssociations) {
            try {
                this.dbImpl.getDbEnvironment().getSecondaryAssociationLock().readLock().lockInterruptibly();
            }
            catch (InterruptedException e) {
                throw new ThreadInterruptedException(this.dbImpl.getDbEnvironment(), (Throwable)e);
            }
        }
        try {
            Object result;
            boolean inserted;
            OperationStatus commitStatus;
            DatabaseEntry replaceKey = null;
            if (putMode == PutMode.CURRENT) {
                if (key == null) {
                    if (hasAssociations || hasUserTriggers) {
                        key = new DatabaseEntry();
                        key.setData(this.cursorImpl.getCurrentKey());
                        EnvironmentFailureException.assertState(key.getData() != null);
                    }
                } else {
                    replaceKey = key;
                }
            }
            DatabaseEntry oldData = null;
            DatabaseEntry newData = null;
            Collection<SecondaryDatabase> secondaries = null;
            if (hasAssociations || hasUserTriggers) {
                if (data.getPartial()) {
                    newData = new DatabaseEntry();
                }
                if (hasUserTriggers) {
                    oldData = new DatabaseEntry();
                }
                if (hasAssociations) {
                    secondaries = this.dbHandle.secAssoc.getSecondaries(key);
                    if (oldData == null && SecondaryDatabase.needOldDataForUpdate(secondaries)) {
                        oldData = new DatabaseEntry();
                    }
                }
            }
            if (putMode == PutMode.CURRENT) {
                commitStatus = this.putCurrentNoNotify(replaceKey, data, oldData, newData, repContext);
                inserted = false;
            } else {
                result = this.putNoNotify(key, data, ln, putMode, oldData, newData, repContext);
                commitStatus = result.first();
                inserted = result.second();
            }
            if (commitStatus != OperationStatus.SUCCESS) {
                result = commitStatus;
                return result;
            }
            if (oldData != null && oldData.getData() == null) {
                oldData = null;
            }
            if (newData == null) {
                newData = data;
            }
            Locker locker = this.cursorImpl.getLocker();
            if (secondaries != null) {
                for (SecondaryDatabase secDb : secondaries) {
                    if (!inserted && !secDb.updateMayChangeSecondary()) continue;
                    secDb.updateSecondary(locker, null, key, oldData, newData);
                }
            }
            if (hasUserTriggers) {
                TriggerManager.runPutTriggers(locker, this.dbImpl, key, oldData, newData);
            }
            OperationStatus operationStatus = OperationStatus.SUCCESS;
            return operationStatus;
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
        finally {
            if (hasAssociations) {
                this.dbImpl.getDbEnvironment().getSecondaryAssociationLock().readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<OperationStatus, Boolean> putNoNotify(DatabaseEntry key, DatabaseEntry data, LN ln, PutMode putMode, DatabaseEntry returnOldData, DatabaseEntry returnNewData, ReplicationContext repContext) {
        Pair<OperationStatus, Boolean> pair;
        Locker nextKeyLocker;
        block12: {
            assert (key != null);
            assert (ln != null);
            assert (putMode != null);
            assert (putMode != PutMode.CURRENT);
            nextKeyLocker = null;
            CursorImpl nextKeyCursor = null;
            CursorImpl dup = null;
            OperationStatus status = OperationStatus.NOTFOUND;
            try {
                Locker cursorLocker = this.cursorImpl.getLocker();
                if (this.dbImpl.getDbEnvironment().getTxnManager().areOtherSerializableTransactionsActive(cursorLocker)) {
                    nextKeyLocker = BuddyLocker.createBuddyLocker(this.dbImpl.getDbEnvironment(), cursorLocker);
                    nextKeyCursor = new CursorImpl(this.dbImpl, nextKeyLocker);
                    nextKeyCursor.setAllowEviction(true);
                    nextKeyCursor.lockNextKeyForInsert(key);
                }
                dup = this.beginMoveCursor(false, nextKeyCursor);
                Pair<OperationStatus, Boolean> result = dup.insertOrUpdateRecord(key, data, ln, putMode, returnOldData, returnNewData, repContext);
                status = result.first();
                pair = result;
                if (dup != null) {
                    this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
                }
                if (nextKeyCursor == null) break block12;
            }
            catch (Throwable throwable) {
                if (dup != null) {
                    this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
                }
                if (nextKeyCursor != null) {
                    nextKeyCursor.close();
                }
                if (nextKeyLocker != null) {
                    nextKeyLocker.operationEnd();
                }
                throw throwable;
            }
            nextKeyCursor.close();
        }
        if (nextKeyLocker != null) {
            nextKeyLocker.operationEnd();
        }
        return pair;
    }

    private OperationStatus putCurrentNoNotify(DatabaseEntry key, DatabaseEntry data, DatabaseEntry returnOldData, DatabaseEntry returnNewData, ReplicationContext repContext) {
        assert (data != null);
        this.beginUseExistingCursor();
        OperationStatus status = this.cursorImpl.updateCurrentRecord(key, data, returnOldData, returnNewData, repContext);
        this.endUseExistingCursor();
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus getCurrentInternal(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean lockCheckDelete) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            LockType lockType = this.getLockType(lockMode, false);
            if (this.dbImpl.getSortedDuplicates()) {
                return this.getCurrentHandleDups(key, data, lockType, lockCheckDelete);
            }
            return this.getCurrentNoDups(key, data, lockType, lockCheckDelete);
        }
    }

    OperationStatus checkCurrent(LockMode lockMode) {
        LockType lockType = this.getLockType(lockMode, false);
        return this.getCurrentNoDups(null, null, lockType, false);
    }

    private OperationStatus getCurrentHandleDups(DatabaseEntry key, DatabaseEntry data, LockType lockType, boolean lockCheckDelete) {
        DatabaseEntry twoPartKey = new DatabaseEntry();
        OperationStatus status = this.getCurrentNoDups(twoPartKey, NO_RETURN_DATA, lockType, lockCheckDelete);
        if (status != OperationStatus.SUCCESS) {
            return status;
        }
        DupKeyData.split(twoPartKey, key, data);
        return OperationStatus.SUCCESS;
    }

    private OperationStatus getCurrentNoDups(DatabaseEntry key, DatabaseEntry data, LockType lockType, boolean lockCheckDelete) {
        this.beginUseExistingCursor();
        OperationStatus status = this.cursorImpl.lockAndGetCurrent(key, data, lockType, false, true, lockCheckDelete);
        this.endUseExistingCursor();
        return status;
    }

    OperationStatus position(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean first) {
        return this.position(key, data, lockMode, first, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus position(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean first, boolean lockCheckDelete) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            if (this.dbImpl.getSortedDuplicates()) {
                return this.positionHandleDups(key, data, lockMode, first, lockCheckDelete);
            }
            return this.positionNoDups(key, data, lockMode, first, lockCheckDelete);
        }
    }

    private OperationStatus positionHandleDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean first, boolean lockCheckDelete) {
        DatabaseEntry twoPartKey = new DatabaseEntry();
        OperationStatus status = this.positionNoDups(twoPartKey, NO_RETURN_DATA, lockMode, first, lockCheckDelete);
        if (status != OperationStatus.SUCCESS) {
            return status;
        }
        DupKeyData.split(twoPartKey, key, data);
        return OperationStatus.SUCCESS;
    }

    private OperationStatus positionNoDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean first, boolean lockCheckDelete) {
        try {
            if (!this.isSerializableIsolation(lockMode)) {
                return this.positionAllowPhantoms(key, data, this.getLockType(lockMode, false), first, lockCheckDelete);
            }
            while (true) {
                try {
                    if (!first) {
                        this.cursorImpl.lockEof(LockType.RANGE_READ);
                    }
                    LockType lockType = this.getLockType(lockMode, first);
                    OperationStatus status = this.positionAllowPhantoms(key, data, lockType, first, false);
                    if (first && status != OperationStatus.SUCCESS) {
                        this.cursorImpl.lockEof(LockType.RANGE_READ);
                    }
                    return status;
                }
                catch (RangeRestartException e) {
                    continue;
                }
                break;
            }
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus positionAllowPhantoms(DatabaseEntry key, DatabaseEntry data, LockType lockType, boolean first, boolean lockCheckDelete) {
        assert (key != null && data != null);
        OperationStatus status = OperationStatus.NOTFOUND;
        CursorImpl dup = this.beginMoveCursor(false);
        try {
            if (!dup.positionFirstOrLast(first)) {
                status = OperationStatus.NOTFOUND;
                if (LatchSupport.TRACK_LATCHES) {
                    LatchSupport.expectBtreeLatchesHeld(0);
                }
            } else {
                if (LatchSupport.TRACK_LATCHES) {
                    LatchSupport.expectBtreeLatchesHeld(1);
                }
                if ((status = dup.lockAndGetCurrent(key, data, lockType, true, false, lockCheckDelete)) != OperationStatus.SUCCESS) {
                    status = dup.getNext(key, data, lockType, first, true, null, lockCheckDelete);
                }
            }
            dup.releaseBIN();
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
        }
        catch (Throwable throwable) {
            dup.releaseBIN();
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
            throw throwable;
        }
        return status;
    }

    OperationStatus retrieveNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, GetMode getMode) {
        return this.retrieveNext(key, data, lockMode, getMode, false);
    }

    OperationStatus retrieveNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, GetMode getMode, boolean lockCheckDelete) {
        if (this.dbImpl.getSortedDuplicates()) {
            return this.retrieveNextHandleDups(key, data, lockMode, getMode, lockCheckDelete);
        }
        return this.retrieveNextNoDups(key, data, lockMode, getMode, lockCheckDelete);
    }

    private OperationStatus retrieveNextHandleDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, GetMode getMode, boolean lockCheckDelete) {
        switch (getMode) {
            case NEXT: 
            case PREV: {
                return this.dupsGetNextOrPrev(key, data, lockMode, getMode, lockCheckDelete);
            }
            case NEXT_DUP: {
                return this.dupsGetNextOrPrevDup(key, data, lockMode, GetMode.NEXT, lockCheckDelete);
            }
            case PREV_DUP: {
                return this.dupsGetNextOrPrevDup(key, data, lockMode, GetMode.PREV, lockCheckDelete);
            }
            case NEXT_NODUP: {
                return this.dupsGetNextNoDup(key, data, lockMode, lockCheckDelete);
            }
            case PREV_NODUP: {
                return this.dupsGetPrevNoDup(key, data, lockMode, lockCheckDelete);
            }
        }
        throw EnvironmentFailureException.unexpectedState(getMode.toString());
    }

    private OperationStatus dupsGetNextOrPrev(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, GetMode getMode, boolean lockCheckDelete) {
        DatabaseEntry twoPartKey = new DatabaseEntry();
        OperationStatus status = this.retrieveNextNoDups(twoPartKey, NO_RETURN_DATA, lockMode, getMode, lockCheckDelete);
        if (status != OperationStatus.SUCCESS) {
            return status;
        }
        DupKeyData.split(twoPartKey, key, data);
        return OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus dupsGetNextOrPrevDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, GetMode getMode, boolean lockCheckDelete) {
        byte[] currentKey = this.cursorImpl.getCurrentKey();
        try (Cursor c = this.dup(true);){
            c.setNonCloning(true);
            this.setPrefixConstraint(c, currentKey);
            DatabaseEntry twoPartKey = new DatabaseEntry();
            OperationStatus status = c.retrieveNextNoDups(twoPartKey, NO_RETURN_DATA, lockMode, getMode, lockCheckDelete);
            if (status != OperationStatus.SUCCESS) {
                OperationStatus operationStatus = status;
                return operationStatus;
            }
            DupKeyData.split(twoPartKey, key, data);
            this.swapCursor(c);
            OperationStatus operationStatus = OperationStatus.SUCCESS;
            return operationStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus dupsGetNextNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean lockCheckDelete) {
        byte[] currentKey = this.cursorImpl.getCurrentKey();
        DatabaseEntry twoPartKey = DupKeyData.removeData(currentKey);
        try (Cursor c = this.dup(false);){
            c.setNonCloning(true);
            DupKeyData.NextNoDupComparator searchComparator = new DupKeyData.NextNoDupComparator(this.dbImpl.getBtreeComparator());
            OperationStatus status = c.searchNoDups(twoPartKey, NO_RETURN_DATA, lockMode, CursorImpl.SearchMode.SET_RANGE, searchComparator, lockCheckDelete, null);
            if (status != OperationStatus.SUCCESS) {
                OperationStatus operationStatus = status;
                return operationStatus;
            }
            DupKeyData.split(twoPartKey, key, data);
            this.swapCursor(c);
            OperationStatus operationStatus = OperationStatus.SUCCESS;
            return operationStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus dupsGetPrevNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean lockCheckDelete) {
        OperationStatus status;
        byte[] currentKey = this.cursorImpl.getCurrentKey();
        DatabaseEntry twoPartKey = DupKeyData.removeData(currentKey);
        try (Cursor c = this.dup(false);){
            c.setNonCloning(true);
            this.setPrefixConstraint(c, currentKey);
            status = c.searchNoDups(twoPartKey, NO_RETURN_DATA, lockMode, CursorImpl.SearchMode.SET_RANGE, null, lockCheckDelete, null);
            if (status == OperationStatus.SUCCESS) {
                c.rangeConstraint = null;
                status = c.retrieveNextNoDups(twoPartKey, NO_RETURN_DATA, lockMode, GetMode.PREV, lockCheckDelete);
                if (status != OperationStatus.SUCCESS) {
                    OperationStatus operationStatus = status;
                    return operationStatus;
                }
                DupKeyData.split(twoPartKey, key, data);
                this.swapCursor(c);
                OperationStatus operationStatus = OperationStatus.SUCCESS;
                return operationStatus;
            }
        }
        c = this.dup(true);
        try {
            c.setNonCloning(true);
            while (true) {
                if ((status = c.retrieveNextNoDups(twoPartKey, NO_RETURN_DATA, lockMode, GetMode.PREV, false)) != OperationStatus.SUCCESS) {
                    OperationStatus operationStatus = status;
                    return operationStatus;
                }
                if (this.haveSameDupPrefix(twoPartKey, currentKey)) continue;
                DupKeyData.split(twoPartKey, key, data);
                this.swapCursor(c);
                OperationStatus operationStatus = OperationStatus.SUCCESS;
                return operationStatus;
            }
        }
        finally {
            c.close();
        }
    }

    private OperationStatus retrieveNextNoDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, GetMode getModeParam, boolean lockCheckDelete) {
        GetMode getMode;
        switch (getModeParam) {
            case NEXT_DUP: 
            case PREV_DUP: {
                return OperationStatus.NOTFOUND;
            }
            case NEXT_NODUP: {
                getMode = GetMode.NEXT;
                break;
            }
            case PREV_NODUP: {
                getMode = GetMode.PREV;
                break;
            }
            default: {
                getMode = getModeParam;
            }
        }
        try {
            if (!this.isSerializableIsolation(lockMode)) {
                return this.retrieveNextAllowPhantoms(key, data, this.getLockType(lockMode, false), getMode, this.rangeConstraint, lockCheckDelete);
            }
            while (true) {
                try {
                    if (!getMode.isForward()) {
                        this.rangeLockCurrentPosition(getMode);
                    }
                    LockType lockType = this.getLockType(lockMode, getMode.isForward());
                    DatabaseEntry tryKey = Cursor.cloneEntry(key);
                    DatabaseEntry tryData = Cursor.cloneEntry(data);
                    OperationStatus status = this.retrieveNextAllowPhantoms(tryKey, tryData, lockType, getMode, null, false);
                    if (getMode.isForward() && status != OperationStatus.SUCCESS) {
                        this.cursorImpl.lockEof(LockType.RANGE_READ);
                    }
                    if (status == OperationStatus.SUCCESS && !this.checkRangeConstraint(tryKey)) {
                        status = OperationStatus.NOTFOUND;
                    }
                    if (status == OperationStatus.SUCCESS) {
                        Cursor.setEntry(tryKey, key);
                        Cursor.setEntry(tryData, data);
                    }
                    return status;
                }
                catch (RangeRestartException e) {
                    continue;
                }
                break;
            }
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rangeLockCurrentPosition(GetMode getMode) {
        OperationStatus status;
        DatabaseEntry tempKey = new DatabaseEntry();
        DatabaseEntry tempData = new DatabaseEntry();
        tempKey.setPartial(0, 0, true);
        tempData.setPartial(0, 0, true);
        CursorImpl dup = this.cursorImpl.cloneCursor(true, this.cacheMode);
        try {
            status = dup.lockAndGetCurrent(tempKey, tempData, LockType.RANGE_READ);
            if (status != OperationStatus.SUCCESS) {
                while (true) {
                    if (LatchSupport.TRACK_LATCHES) {
                        LatchSupport.expectBtreeLatchesHeld(0);
                    }
                    status = dup.getNext(tempKey, tempData, LockType.RANGE_READ, true, false, null);
                    if (!this.cursorImpl.checkForInsertion(GetMode.NEXT, dup)) break;
                    dup.close(this.cursorImpl);
                    dup = this.cursorImpl.cloneCursor(true, this.cacheMode);
                }
                if (LatchSupport.TRACK_LATCHES) {
                    LatchSupport.expectBtreeLatchesHeld(0);
                }
            }
        }
        finally {
            dup.close(this.cursorImpl);
        }
        if (status != OperationStatus.SUCCESS) {
            this.cursorImpl.lockEof(LockType.RANGE_READ);
        }
    }

    private OperationStatus retrieveNextAllowPhantoms(DatabaseEntry key, DatabaseEntry data, LockType lockType, GetMode getMode, RangeConstraint rangeConstraint, boolean lockCheckDelete) {
        OperationStatus status;
        block8: {
            CursorImpl dup;
            assert (key != null && data != null);
            while (true) {
                block7: {
                    if (LatchSupport.TRACK_LATCHES) {
                        LatchSupport.expectBtreeLatchesHeld(0);
                    }
                    dup = this.beginMoveCursor(true);
                    try {
                        if (getMode == GetMode.NEXT) {
                            status = dup.getNext(key, data, lockType, true, false, rangeConstraint, lockCheckDelete);
                            break block7;
                        }
                        if (getMode == GetMode.PREV) {
                            status = dup.getNext(key, data, lockType, false, false, rangeConstraint, lockCheckDelete);
                            break block7;
                        }
                        throw EnvironmentFailureException.unexpectedState("unknown GetMode: " + (Object)((Object)getMode));
                    }
                    catch (DatabaseException DBE) {
                        this.endMoveCursor(dup, false);
                        throw DBE;
                    }
                }
                if (!this.cursorImpl.checkForInsertion(getMode, dup)) break;
                this.endMoveCursor(dup, false);
            }
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
            if (!LatchSupport.TRACK_LATCHES) break block8;
            LatchSupport.expectBtreeLatchesHeld(0);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long skipInternal(long maxCount, boolean forward, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        LockType lockType = this.getLockType(lockMode, false);
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            while (true) {
                CursorImpl dup = this.beginMoveCursor(true);
                boolean success = false;
                try {
                    long count = dup.skip(forward, maxCount, null);
                    if (count <= 0L) {
                        long l = 0L;
                        return l;
                    }
                    OperationStatus status = this.getCurrentWithCursorImpl(dup, key, data, lockType);
                    if (status == OperationStatus.KEYEMPTY) continue;
                    success = true;
                    long l = count;
                    return l;
                }
                finally {
                    this.endMoveCursor(dup, success);
                    continue;
                }
                break;
            }
        }
    }

    private OperationStatus getCurrentWithCursorImpl(CursorImpl c, DatabaseEntry key, DatabaseEntry data, LockType lockType) {
        if (!this.dbImpl.getSortedDuplicates()) {
            return c.lockAndGetCurrent(key, data, lockType);
        }
        DatabaseEntry twoPartKey = new DatabaseEntry();
        OperationStatus status = c.lockAndGetCurrent(twoPartKey, NO_RETURN_DATA, lockType);
        if (status != OperationStatus.SUCCESS) {
            return status;
        }
        DupKeyData.split(twoPartKey, key, data);
        return OperationStatus.SUCCESS;
    }

    OperationStatus search(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CursorImpl.SearchMode searchMode) {
        return this.search(key, data, lockMode, searchMode, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus search(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CursorImpl.SearchMode searchMode, boolean lockCheckDelete, Cursor scur) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            if (this.dbImpl.getSortedDuplicates()) {
                switch (searchMode) {
                    case SET: {
                        return this.dupsGetSearchKey(key, data, lockMode, lockCheckDelete, scur);
                    }
                    case SET_RANGE: {
                        return this.dupsGetSearchKeyRange(key, data, lockMode, lockCheckDelete);
                    }
                    case BOTH: {
                        return this.dupsGetSearchBoth(key, data, lockMode, lockCheckDelete);
                    }
                    case BOTH_RANGE: {
                        return this.dupsGetSearchBothRange(key, data, lockMode, lockCheckDelete);
                    }
                }
                throw EnvironmentFailureException.unexpectedState(searchMode.toString());
            }
            return this.searchNoDups(key, data, lockMode, searchMode, null, lockCheckDelete, scur);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus searchForReplay(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CursorImpl.SearchMode searchMode) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            return this.searchNoDups(key, data, lockMode, searchMode, null, false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus dupsGetSearchKey(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean lockCheckDelete, Cursor scur) {
        DatabaseEntry twoPartKey = new DatabaseEntry(DupKeyData.makePrefixKey(key.getData(), key.getOffset(), key.getSize()));
        RangeConstraint savedRangeConstraint = this.rangeConstraint;
        try {
            this.setPrefixConstraint(this, key);
            OperationStatus status = this.searchNoDups(twoPartKey, NO_RETURN_DATA, lockMode, CursorImpl.SearchMode.SET_RANGE, null, lockCheckDelete, scur);
            if (status != OperationStatus.SUCCESS) {
                OperationStatus operationStatus = OperationStatus.NOTFOUND;
                return operationStatus;
            }
            DupKeyData.split(twoPartKey, key, data);
            OperationStatus operationStatus = OperationStatus.SUCCESS;
            return operationStatus;
        }
        finally {
            this.rangeConstraint = savedRangeConstraint;
        }
    }

    private OperationStatus dupsGetSearchKeyRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean lockCheckDelete) {
        DatabaseEntry twoPartKey = new DatabaseEntry(DupKeyData.makePrefixKey(key.getData(), key.getOffset(), key.getSize()));
        OperationStatus status = this.searchNoDups(twoPartKey, NO_RETURN_DATA, lockMode, CursorImpl.SearchMode.SET_RANGE, null, lockCheckDelete, null);
        if (status != OperationStatus.SUCCESS) {
            return status;
        }
        DupKeyData.split(twoPartKey, key, data);
        return OperationStatus.SUCCESS;
    }

    private OperationStatus dupsGetSearchBoth(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean lockCheckDelete) {
        DatabaseEntry twoPartKey = DupKeyData.combine(key, data);
        OperationStatus status = this.searchNoDups(twoPartKey, NO_RETURN_DATA, lockMode, CursorImpl.SearchMode.BOTH, null, lockCheckDelete, null);
        if (status != OperationStatus.SUCCESS) {
            return status;
        }
        DupKeyData.split(twoPartKey, key, data);
        return OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus dupsGetSearchBothRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean lockCheckDelete) {
        DatabaseEntry twoPartKey = DupKeyData.combine(key, data);
        RangeConstraint savedRangeConstraint = this.rangeConstraint;
        try {
            this.setPrefixConstraint(this, key);
            OperationStatus status = this.searchNoDups(twoPartKey, NO_RETURN_DATA, lockMode, CursorImpl.SearchMode.SET_RANGE, null, lockCheckDelete, null);
            if (status != OperationStatus.SUCCESS) {
                OperationStatus operationStatus = OperationStatus.NOTFOUND;
                return operationStatus;
            }
            DupKeyData.split(twoPartKey, key, data);
            OperationStatus operationStatus = OperationStatus.SUCCESS;
            return operationStatus;
        }
        finally {
            this.rangeConstraint = savedRangeConstraint;
        }
    }

    private OperationStatus searchNoDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CursorImpl.SearchMode searchMode, Comparator<byte[]> comparator, boolean lockCheckDelete, Cursor scur) {
        assert (searchMode != CursorImpl.SearchMode.BOTH_RANGE);
        try {
            if (!this.isSerializableIsolation(lockMode)) {
                LockType lockType = this.getLockType(lockMode, false);
                if (searchMode.isExactSearch()) {
                    assert (comparator == null);
                    return this.searchExact(key, data, lockType, searchMode, lockCheckDelete, scur);
                }
                while (true) {
                    try {
                        return this.searchRange(key, data, lockType, comparator, lockCheckDelete);
                    }
                    catch (RangeRestartException e) {
                        continue;
                    }
                    break;
                }
            }
            while (true) {
                try {
                    LockType searchLockType = this.getLockType(lockMode, false);
                    LockType advanceLockType = this.getLockType(lockMode, true);
                    DatabaseEntry tryKey = Cursor.cloneEntry(key);
                    DatabaseEntry tryData = Cursor.cloneEntry(data);
                    OperationStatus result = this.searchRangeSerializable(tryKey, tryData, searchLockType, advanceLockType, comparator, searchMode);
                    if (result == OperationStatus.SUCCESS) {
                        Cursor.setEntry(tryKey, key);
                        Cursor.setEntry(tryData, data);
                    }
                    return result;
                }
                catch (RangeRestartException e) {
                    continue;
                }
                break;
            }
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus searchExact(DatabaseEntry key, DatabaseEntry data, LockType lockType, CursorImpl.SearchMode searchMode, boolean lockCheckDelete, Cursor scur) {
        CursorImpl dup;
        DatabaseEntry origData;
        OperationStatus status;
        block5: {
            assert (key != null && data != null);
            assert (searchMode == CursorImpl.SearchMode.SET || searchMode == CursorImpl.SearchMode.BOTH);
            status = OperationStatus.NOTFOUND;
            origData = new DatabaseEntry(data.getData(), data.getOffset(), data.getSize());
            dup = this.beginMoveCursor(false);
            try {
                boolean found = dup.searchExact(key, lockType, lockCheckDelete, scur == null ? null : scur.getCursorImpl());
                if (found) break block5;
                OperationStatus operationStatus = status;
                dup.releaseBIN();
                this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
                return operationStatus;
            }
            catch (Throwable throwable) {
                dup.releaseBIN();
                this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
                throw throwable;
            }
        }
        dup.getCurrent(searchMode == CursorImpl.SearchMode.SET ? null : key, data);
        status = searchMode == CursorImpl.SearchMode.BOTH ? (this.checkDataMatch(origData, data) ? OperationStatus.SUCCESS : OperationStatus.NOTFOUND) : OperationStatus.SUCCESS;
        dup.releaseBIN();
        this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus searchRange(DatabaseEntry key, DatabaseEntry data, LockType lockType, Comparator<byte[]> comparator, boolean lockCheckDelete) {
        boolean foundLast;
        int searchResult;
        CursorImpl dup;
        OperationStatus status;
        block7: {
            assert (key != null && data != null);
            status = OperationStatus.NOTFOUND;
            dup = this.beginMoveCursor(false);
            try {
                searchResult = dup.searchRange(key, lockType, comparator);
                if ((searchResult & 1) != 0) break block7;
                OperationStatus operationStatus = status;
                dup.releaseBIN();
                this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
                return operationStatus;
            }
            catch (Throwable throwable) {
                dup.releaseBIN();
                this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
                throw throwable;
            }
        }
        boolean exactKeyMatch = (searchResult & 2) != 0;
        boolean bl = foundLast = (searchResult & 4) != 0;
        if (exactKeyMatch) {
            status = dup.lockAndGetCurrent(key, data, lockType, true, false, lockCheckDelete);
        }
        if (!exactKeyMatch || status == OperationStatus.KEYEMPTY) {
            status = OperationStatus.NOTFOUND;
            if (!foundLast) {
                status = this.searchRangeAdvanceAndCheckKey(dup, key, data, lockType, comparator, this.rangeConstraint, lockCheckDelete);
            }
        }
        dup.releaseBIN();
        this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus searchRangeSerializable(DatabaseEntry key, DatabaseEntry data, LockType searchLockType, LockType advanceLockType, Comparator<byte[]> comparator, CursorImpl.SearchMode searchMode) {
        assert (key != null && data != null);
        OperationStatus status = OperationStatus.NOTFOUND;
        boolean exactSearch = searchMode.isExactSearch();
        boolean keyChange = false;
        boolean mustLockEOF = false;
        DatabaseEntry origData = null;
        if (exactSearch) {
            origData = new DatabaseEntry(data.getData(), data.getOffset(), data.getSize());
        }
        CursorImpl dup = this.beginMoveCursor(false);
        try {
            int searchResult = dup.searchRange(key, searchLockType, comparator);
            if ((searchResult & 1) != 0) {
                boolean foundLast;
                boolean exactKeyMatch = (searchResult & 2) != 0;
                boolean bl = foundLast = (searchResult & 4) != 0;
                if (exactKeyMatch) {
                    status = dup.lockAndGetCurrent(key, data, searchLockType, true, false, false);
                }
                if (!exactKeyMatch || status == OperationStatus.KEYEMPTY) {
                    status = OperationStatus.NOTFOUND;
                    if (!foundLast) {
                        status = this.searchRangeAdvanceAndCheckKey(dup, key, data, advanceLockType, comparator, null, false);
                        keyChange = status == OperationStatus.SUCCESS;
                    }
                    boolean bl2 = mustLockEOF = status != OperationStatus.SUCCESS;
                }
                if (status == OperationStatus.SUCCESS && exactSearch) {
                    if (keyChange) {
                        status = OperationStatus.NOTFOUND;
                    } else if (searchMode == CursorImpl.SearchMode.BOTH) {
                        status = this.checkDataMatch(origData, data) ? OperationStatus.SUCCESS : OperationStatus.NOTFOUND;
                    }
                }
                if (status == OperationStatus.SUCCESS && !exactSearch && !this.checkRangeConstraint(key)) {
                    status = OperationStatus.NOTFOUND;
                }
            } else {
                mustLockEOF = true;
            }
            dup.releaseBIN();
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
        }
        catch (Throwable throwable) {
            dup.releaseBIN();
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
            throw throwable;
        }
        if (mustLockEOF) {
            this.cursorImpl.lockEof(LockType.RANGE_READ);
        }
        return status;
    }

    private OperationStatus searchRangeAdvanceAndCheckKey(CursorImpl dup, DatabaseEntry key, DatabaseEntry data, LockType lockType, Comparator<byte[]> comparator, RangeConstraint rangeConstraint, boolean lockCheckDelete) {
        OperationStatus status;
        if (comparator == null) {
            comparator = this.dbImpl.getKeyComparator();
        }
        DatabaseEntry origKey = new DatabaseEntry(key.getData(), key.getOffset(), key.getSize());
        DatabaseEntry nextKey = key;
        if (key.getPartial()) {
            nextKey = new DatabaseEntry(key.getData(), key.getOffset(), key.getSize());
        }
        if ((status = dup.getNext(nextKey, data, lockType, true, true, rangeConstraint, lockCheckDelete)) == OperationStatus.SUCCESS) {
            int c = Key.compareKeys(nextKey, origKey, comparator);
            if (c < 0) {
                key.setData(origKey.getData(), origKey.getOffset(), origKey.getSize());
                throw new RangeRestartException();
            }
            if (key.getPartial()) {
                LN.setEntry(key, nextKey);
            }
        }
        return status;
    }

    private boolean checkDataMatch(DatabaseEntry data1, DatabaseEntry data2) {
        int size2;
        int size1 = data1.getSize();
        if (size1 != (size2 = data2.getSize())) {
            return false;
        }
        return Key.compareUnsignedBytes(data1.getData(), data1.getOffset(), size1, data2.getData(), data2.getOffset(), size2) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int countInternal() {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            if (this.dbImpl.getSortedDuplicates()) {
                return this.countHandleDups();
            }
            return this.countNoDups();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countHandleDups() {
        byte[] currentKey = this.cursorImpl.getCurrentKey();
        DatabaseEntry twoPartKey = DupKeyData.removeData(currentKey);
        try (Cursor c = this.dup(false);){
            c.setNonCloning(true);
            this.setPrefixConstraint(c, currentKey);
            OperationStatus status = c.searchNoDups(twoPartKey, NO_RETURN_DATA, LockMode.READ_UNCOMMITTED, CursorImpl.SearchMode.SET_RANGE, null, false, null);
            if (status != OperationStatus.SUCCESS) {
                int n = 0;
                return n;
            }
            long count = c.cursorImpl.skip(true, 0L, c.rangeConstraint) + 1L;
            if (count > Integer.MAX_VALUE) {
                throw new IllegalStateException("count exceeded integer size: " + count);
            }
            int n = (int)count;
            return n;
        }
    }

    private int countNoDups() {
        try {
            this.beginUseExistingCursor();
            OperationStatus status = this.cursorImpl.lockAndGetCurrent(null, null, LockType.NONE);
            this.endUseExistingCursor();
            return status == OperationStatus.SUCCESS ? 1 : 0;
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    long countEstimateInternal() {
        if (this.dbImpl.getSortedDuplicates()) {
            return this.countEstimateHandleDups();
        }
        return this.countNoDups();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long countEstimateHandleDups() {
        byte[] currentKey = this.cursorImpl.getCurrentKey();
        DatabaseEntry twoPartKey = DupKeyData.removeData(currentKey);
        try (Cursor c1 = this.dup(false);){
            boolean c2Inclusive;
            Cursor c2;
            block14: {
                long l;
                OperationStatus status;
                block15: {
                    c1.setNonCloning(true);
                    this.setPrefixConstraint(c1, currentKey);
                    status = c1.searchNoDups(twoPartKey, NO_RETURN_DATA, LockMode.READ_UNCOMMITTED, CursorImpl.SearchMode.SET_RANGE, null, false, null);
                    if (status != OperationStatus.SUCCESS) {
                        long l2 = 0L;
                        return l2;
                    }
                    c2 = c1.dup(true);
                    c2.setNonCloning(true);
                    status = c2.dupsGetNextNoDup(twoPartKey, NO_RETURN_DATA, LockMode.READ_UNCOMMITTED, false);
                    if (status == OperationStatus.SUCCESS) {
                        c2Inclusive = false;
                        break block14;
                    }
                    c2Inclusive = true;
                    status = c2.positionNoDups(twoPartKey, NO_RETURN_DATA, LockMode.READ_UNCOMMITTED, false, false);
                    if (status == OperationStatus.SUCCESS) break block15;
                    long l3 = 0L;
                    c2.close();
                    return l3;
                }
                try {
                    while (!this.haveSameDupPrefix(twoPartKey, currentKey)) {
                        status = c2.retrieveNextNoDups(twoPartKey, NO_RETURN_DATA, LockMode.READ_UNCOMMITTED, GetMode.PREV, false);
                        if (status == OperationStatus.SUCCESS) continue;
                        l = 0L;
                    }
                }
                catch (Throwable throwable) {
                    c2.close();
                    throw throwable;
                }
                {
                    c2.close();
                    return l;
                }
            }
            long l = CountEstimator.count(this.dbImpl, c1.cursorImpl, true, c2.cursorImpl, c2Inclusive);
            c2.close();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<OperationStatus, RecordVersion> readPrimaryAfterGet(Database priDb, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, boolean secondaryScanDirty, Cursor scur) {
        DatabaseEntry copyToPartialEntry = null;
        boolean readUncommitted = this.isReadUncommittedMode(lockMode);
        if (readUncommitted && data.getPartial()) {
            if (data.getPartialLength() == 0) {
                data.setData(LogUtils.ZERO_LENGTH_BYTE_ARRAY);
                return new Pair<OperationStatus, Object>(OperationStatus.SUCCESS, null);
            }
            copyToPartialEntry = data;
            data = new DatabaseEntry();
        }
        Locker locker = this.cursorImpl.getLocker();
        try (Cursor cursor = new Cursor(priDb, locker, null, true);){
            LockMode primaryLockMode = readUncommitted ? LockMode.READ_UNCOMMITTED : lockMode;
            OperationStatus status = cursor.search(pKey, data, primaryLockMode, CursorImpl.SearchMode.SET, false, scur);
            if (status != OperationStatus.SUCCESS) {
                if (secondaryScanDirty) {
                    Pair<OperationStatus, Object> pair = new Pair<OperationStatus, Object>(OperationStatus.KEYEMPTY, null);
                    return pair;
                }
                throw this.dbHandle.secondaryRefersToMissingPrimaryKey(locker, key, pKey);
            }
            if (readUncommitted && this.checkForPrimaryUpdate(key, pKey, data)) {
                Pair<OperationStatus, Object> pair = new Pair<OperationStatus, Object>(OperationStatus.KEYEMPTY, null);
                return pair;
            }
            if (copyToPartialEntry != null) {
                LN.setEntry(copyToPartialEntry, data.getData());
            }
            Pair<OperationStatus, RecordVersion> pair = new Pair<OperationStatus, RecordVersion>(OperationStatus.SUCCESS, cursor.cursorImpl.getCachedRecordVersion());
            return pair;
        }
    }

    boolean checkForPrimaryUpdate(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data) {
        return false;
    }

    private boolean haveSameDupPrefix(DatabaseEntry twoPartKey1, byte[] keyBytes2) {
        assert (twoPartKey1.getOffset() == 0);
        assert (twoPartKey1.getData().length == twoPartKey1.getSize());
        return DupKeyData.compareMainKey(twoPartKey1.getData(), keyBytes2, this.dbImpl.getBtreeComparator()) == 0;
    }

    private CursorImpl beginMoveCursor(boolean addCursor, CursorImpl usePosition) {
        if (this.cursorImpl.isNotInitialized()) {
            this.cursorImpl.setCacheMode(this.cacheMode);
            this.cursorImpl.criticalEviction();
            return this.cursorImpl;
        }
        if (this.nonCloning) {
            this.cursorImpl.setCacheMode(this.cacheMode);
            if (addCursor) {
                this.cursorImpl.performCacheEvictionBeforeAdvance();
                this.cursorImpl.criticalEviction();
            } else {
                this.cursorImpl.reset();
            }
            return this.cursorImpl;
        }
        CursorImpl dup = this.cursorImpl.cloneCursor(addCursor, this.cacheMode, usePosition);
        dup.setClosingLocker(this.cursorImpl);
        return dup;
    }

    private CursorImpl beginMoveCursor(boolean addCursor) {
        return this.beginMoveCursor(addCursor, null);
    }

    private void endMoveCursor(CursorImpl dup, boolean success) {
        dup.clearClosingLocker();
        if (dup == this.cursorImpl) {
            if (success) {
                this.cursorImpl.criticalEviction();
            } else {
                this.cursorImpl.reset();
            }
        } else {
            if (success) {
                this.cursorImpl.close(dup);
                this.cursorImpl = dup;
            } else {
                dup.close(this.cursorImpl);
            }
            if (!this.cacheModeOverridden) {
                this.cacheMode = this.dbImpl.getDefaultCacheMode();
            }
        }
    }

    private void beginUseExistingCursor() {
        this.cursorImpl.setCacheMode(this.cacheMode);
        this.cursorImpl.criticalEviction();
    }

    private void endUseExistingCursor() {
        this.cursorImpl.criticalEviction();
    }

    private void swapCursor(Cursor other) {
        CursorImpl otherImpl = other.cursorImpl;
        other.cursorImpl = this.cursorImpl;
        this.cursorImpl = otherImpl;
    }

    boolean advanceCursor(DatabaseEntry key, DatabaseEntry data) {
        return this.cursorImpl.advanceCursor(key, data);
    }

    private LockType getLockType(LockMode lockMode, boolean rangeLock) {
        if (this.isReadUncommittedMode(lockMode)) {
            return LockType.NONE;
        }
        if (lockMode == null || lockMode == LockMode.DEFAULT) {
            return rangeLock ? LockType.RANGE_READ : LockType.READ;
        }
        if (lockMode == LockMode.RMW) {
            return rangeLock ? LockType.RANGE_WRITE : LockType.WRITE;
        }
        if (lockMode == LockMode.READ_COMMITTED) {
            throw new IllegalArgumentException(lockMode.toString() + " not allowed with Cursor methods, " + "use CursorConfig.setReadCommitted instead.");
        }
        assert (false) : lockMode;
        return LockType.NONE;
    }

    boolean isReadUncommittedMode(LockMode lockMode) {
        return lockMode == LockMode.READ_UNCOMMITTED || this.readUncommittedDefault && (lockMode == null || lockMode == LockMode.DEFAULT);
    }

    boolean isSerializableIsolation(LockMode lockMode) {
        return this.serializableIsolationDefault && !this.isReadUncommittedMode(lockMode);
    }

    void checkUpdatesAllowed() {
        if (!this.updateOperationsProhibited) {
            return;
        }
        Locker locker = this.cursorImpl.getLocker();
        StringBuilder str = new StringBuilder(200);
        str.append("Write operation is not allowed because ");
        if (locker.isReadOnly()) {
            str.append("the Transaction is configured as read-only.");
        } else if (this.dbHandle != null && !this.dbHandle.isWritable()) {
            str.append("the Database is configured as read-only.");
        } else if (this.dbImpl.isTransactional() && !locker.isTransactional()) {
            str.append("a Transaction was not supplied to openCursor ");
            str.append("and the Database is transactional.");
        } else if (this.dbImpl.isReplicated() && locker.isLocalWrite()) {
            str.append("the Database is replicated and Transaction is ");
            str.append("configured as local-write.");
        } else if (!this.dbImpl.isReplicated() && !locker.isLocalWrite()) {
            str.append("the Database is not replicated and the ");
            str.append("Transaction is not configured as local-write.");
        } else assert (false);
        throw new UnsupportedOperationException(str.toString());
    }

    static void checkArgsNoValRequired(DatabaseEntry key, DatabaseEntry data) {
        DatabaseUtil.checkForNullDbt(key, "key", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
    }

    static void checkArgsValRequired(DatabaseEntry key, DatabaseEntry data) {
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
    }

    void checkState(boolean mustBeInitialized) {
        this.checkEnv();
        if (this.dbHandle != null) {
            this.dbHandle.checkOpen("Can't call Cursor method:");
        }
        this.cursorImpl.checkCursorState(mustBeInitialized);
    }

    void checkEnv() {
        this.cursorImpl.checkEnv();
    }

    private Object getTxnSynchronizer() {
        return this.transaction != null ? this.transaction : this;
    }

    private void checkTxnState() {
        if (this.transaction == null) {
            return;
        }
        this.transaction.checkOpen();
        this.transaction.getTxn().checkState(false);
    }

    void trace(Level level, String methodName, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        if (this.logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName);
            this.traceCursorImpl(sb);
            if (key != null) {
                sb.append(" key=").append(key.dumpData());
            }
            if (data != null) {
                sb.append(" data=").append(data.dumpData());
            }
            if (lockMode != null) {
                sb.append(" lockMode=").append((Object)lockMode);
            }
            LoggerUtils.logMsg(this.logger, this.dbImpl.getDbEnvironment(), level, sb.toString());
        }
    }

    void trace(Level level, String methodName, LockMode lockMode) {
        if (this.logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName);
            this.traceCursorImpl(sb);
            if (lockMode != null) {
                sb.append(" lockMode=").append((Object)lockMode);
            }
            LoggerUtils.logMsg(this.logger, this.dbImpl.getDbEnvironment(), level, sb.toString());
        }
    }

    private void traceCursorImpl(StringBuilder sb) {
        sb.append(" locker=").append(this.cursorImpl.getLocker().getId());
        sb.append(" bin=").append(this.cursorImpl.getCurrentNodeId());
        sb.append(" idx=").append(this.cursorImpl.getIndex());
    }

    private static DatabaseEntry cloneEntry(DatabaseEntry from) {
        DatabaseEntry to = new DatabaseEntry();
        Cursor.setEntry(from, to);
        return to;
    }

    private static void setEntry(DatabaseEntry from, DatabaseEntry to) {
        to.setPartial(from.getPartialOffset(), from.getPartialLength(), from.getPartial());
        to.setData(from.getData(), from.getOffset(), from.getSize());
    }

    static {
        NO_RETURN_DATA.setPartial(0, 0, true);
    }
}

