/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.VersionMismatchException;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.utilint.Timestamp;
import java.nio.ByteBuffer;
import java.util.Calendar;

public class FileHeader
implements Loggable {
    private long fileNum;
    private long lastEntryInPrevFileOffset;
    private Timestamp time;
    private int logVersion;

    FileHeader(long fileNum, long lastEntryInPrevFileOffset) {
        this.fileNum = fileNum;
        this.lastEntryInPrevFileOffset = lastEntryInPrevFileOffset;
        Calendar now = Calendar.getInstance();
        this.time = new Timestamp(now.getTimeInMillis());
        this.logVersion = 9;
    }

    public FileHeader() {
    }

    public int getLogVersion() {
        return this.logVersion;
    }

    int validate(EnvironmentImpl envImpl, String fileName, long expectedFileNum) throws DatabaseException {
        if (this.logVersion > 9) {
            throw new VersionMismatchException(envImpl, "Expected log version 9 or earlier but found " + this.logVersion);
        }
        if (this.fileNum != expectedFileNum) {
            throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "Wrong filenum in header for file " + fileName + " expected " + expectedFileNum + " got " + this.fileNum);
        }
        return this.logVersion;
    }

    long getLastEntryInPrevFileOffset() {
        return this.lastEntryInPrevFileOffset;
    }

    public static int entrySize() {
        return 24;
    }

    @Override
    public int getLogSize() {
        return FileHeader.entrySize();
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeLong(logBuffer, this.time.getTime());
        LogUtils.writeUnsignedInt(logBuffer, this.fileNum);
        LogUtils.writeLong(logBuffer, this.lastEntryInPrevFileOffset);
        LogUtils.writeInt(logBuffer, this.logVersion);
    }

    @Override
    public void readFromLog(ByteBuffer logBuffer, int unusableEntryVersion) {
        this.time = LogUtils.readTimestamp(logBuffer, true);
        this.fileNum = LogUtils.readUnsignedInt(logBuffer);
        this.lastEntryInPrevFileOffset = LogUtils.readLong(logBuffer);
        this.logVersion = LogUtils.readInt(logBuffer);
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<FileHeader num=\"0x");
        sb.append(Long.toHexString(this.fileNum));
        sb.append("\" lastEntryInPrevFileOffset=\"0x");
        sb.append(Long.toHexString(this.lastEntryInPrevFileOffset));
        sb.append("\" logVersion=\"0x");
        sb.append(Integer.toHexString(this.logVersion));
        sb.append("\" time=\"").append(this.time);
        sb.append("\"/>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.dumpLog(sb, true);
        return sb.toString();
    }
}

