/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.NamedChannel;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReplicaFeederHandshake {
    private final RepNode repNode;
    private final NamedChannel namedChannel;
    private final NameIdPair replicaNameIdPair;
    private NameIdPair feederNameIdPair;
    private Protocol protocol = null;
    private Protocol.FeederJEVersions feederJEVersions;
    static final int MEMBERSHIP_RETRY_SLEEP_MS = 60000;
    static final int MEMBERSHIP_RETRIES = 0;
    private static volatile int testCurrentLogVersion = 0;
    private static volatile int testCurrentProtocolVersion = 0;
    private long clockDelay = Long.MAX_VALUE;
    private long clockDelta = Long.MAX_VALUE;
    private static int CLOCK_SKEW_MAX_SAMPLE_SIZE = 5;
    private static final long CLOCK_SKEW_MIN_DELAY_MS = 2L;
    private final int maxClockDelta;
    private final Logger logger;

    public ReplicaFeederHandshake(RepNode repNode, NamedChannel namedChannel) {
        this.repNode = repNode;
        this.namedChannel = namedChannel;
        RepImpl repImpl = repNode.getRepImpl();
        this.replicaNameIdPair = repNode.getNameIdPair();
        this.maxClockDelta = repImpl.getConfigManager().getDuration(RepParams.MAX_CLOCK_DELTA);
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    private static int getCurrentLogVersion() {
        return testCurrentLogVersion != 0 ? testCurrentLogVersion : 9;
    }

    public static void setTestLogVersion(int testLogVersion) {
        testCurrentLogVersion = testLogVersion;
    }

    private JEVersion getCurrentJEVersion() {
        return this.repNode.getRepImpl().getCurrentJEVersion();
    }

    private int getCurrentProtocolVersion() {
        if (testCurrentProtocolVersion != 0) {
            return testCurrentProtocolVersion;
        }
        return Protocol.getJEVersionProtocolVersion(this.getCurrentJEVersion());
    }

    public static void setTestProtocolVersion(int testProtocolVersion) {
        testCurrentProtocolVersion = testProtocolVersion;
    }

    private Protocol negotiateProtocol() throws IOException {
        Protocol defaultProtocol = Protocol.getProtocol(this.repNode, this.getCurrentProtocolVersion());
        defaultProtocol.write((BinaryProtocol.Message)defaultProtocol.new Protocol.ReplicaProtocolVersion(), this.namedChannel);
        BinaryProtocol.Message message = defaultProtocol.read(this.namedChannel);
        if (message instanceof Protocol.DuplicateNodeReject) {
            throw new EnvironmentFailureException((EnvironmentImpl)this.repNode.getRepImpl(), EnvironmentFailureReason.HANDSHAKE_ERROR, "A replica with the name: " + this.replicaNameIdPair + " is already active with the Feeder:" + this.feederNameIdPair);
        }
        Protocol.FeederProtocolVersion feederVersion = (Protocol.FeederProtocolVersion)message;
        this.feederNameIdPair = feederVersion.getNameIdPair();
        Protocol configuredProtocol = Protocol.get(this.repNode, feederVersion.getVersion(), this.getCurrentProtocolVersion());
        LoggerUtils.fine(this.logger, this.repNode.getRepImpl(), "Feeder id: " + feederVersion.getNameIdPair() + "Response message: " + feederVersion.getVersion());
        this.namedChannel.setNameIdPair(this.feederNameIdPair);
        LoggerUtils.fine(this.logger, this.repNode.getRepImpl(), "Channel Mapping: " + this.feederNameIdPair + " is at " + this.namedChannel.getChannel());
        if (configuredProtocol == null) {
            throw new EnvironmentFailureException((EnvironmentImpl)this.repNode.getRepImpl(), EnvironmentFailureReason.PROTOCOL_VERSION_MISMATCH, "Incompatible protocol versions. Protocol version: " + feederVersion.getVersion() + " introduced in JE version: " + Protocol.getProtocolJEVersion(feederVersion.getVersion()) + " requested by the Feeder: " + this.feederNameIdPair + " is not supported by this Replica: " + this.replicaNameIdPair + " with protocol version: " + defaultProtocol.getVersion() + " introduced in JE version: " + Protocol.getProtocolJEVersion(defaultProtocol.getVersion()));
        }
        return configuredProtocol;
    }

    public Protocol execute() throws IOException, BinaryProtocol.ProtocolException {
        LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Replica-feeder handshake start");
        this.protocol = this.negotiateProtocol();
        this.verifyVersions();
        this.verifyMembership();
        this.checkClockSkew();
        LoggerUtils.info(this.logger, this.repNode.getRepImpl(), "Replica-feeder " + this.feederNameIdPair.getName() + " handshake completed.");
        return this.protocol;
    }

    private void verifyVersions() throws IOException {
        Protocol protocol = this.protocol;
        protocol.getClass();
        this.protocol.write((BinaryProtocol.Message)protocol.new Protocol.ReplicaJEVersions(this.getCurrentJEVersion(), ReplicaFeederHandshake.getCurrentLogVersion()), this.namedChannel);
        BinaryProtocol.Message message = this.protocol.read(this.namedChannel);
        if (message instanceof Protocol.JEVersionsReject) {
            throw new EnvironmentFailureException((EnvironmentImpl)this.repNode.getRepImpl(), EnvironmentFailureReason.HANDSHAKE_ERROR, " Feeder: " + this.feederNameIdPair + ". " + ((Protocol.JEVersionsReject)message).getErrorMessage());
        }
        this.feederJEVersions = (Protocol.FeederJEVersions)message;
        if (this.feederJEVersions.getLogVersion() > ReplicaFeederHandshake.getCurrentLogVersion()) {
            throw new EnvironmentFailureException((EnvironmentImpl)this.repNode.getRepImpl(), EnvironmentFailureReason.HANDSHAKE_ERROR, " Feeder: " + this.feederNameIdPair + ". " + "Feeder log version " + this.feederJEVersions.getLogVersion() + " is not known to the replica, whose current log version is " + ReplicaFeederHandshake.getCurrentLogVersion());
        }
    }

    private void verifyMembership() throws IOException {
        RepImpl repImpl = this.repNode.getRepImpl();
        DbConfigManager configManager = repImpl.getConfigManager();
        String groupName = configManager.get(RepParams.GROUP_NAME);
        NodeType nodeType = this.repNode.getNodeType();
        Protocol protocol = this.protocol;
        protocol.getClass();
        BinaryProtocol.Message message = protocol.new Protocol.NodeGroupInfo(groupName, this.repNode.getGroup().getUUID(), this.replicaNameIdPair, repImpl.getHostName(), repImpl.getPort(), nodeType, repImpl.isDesignatedPrimary(), this.getCurrentJEVersion());
        this.protocol.write(message, this.namedChannel);
        message = this.protocol.read(this.namedChannel);
        if (message instanceof Protocol.NodeGroupInfoReject) {
            Protocol.NodeGroupInfoReject reject = (Protocol.NodeGroupInfoReject)message;
            throw new EnvironmentFailureException((EnvironmentImpl)repImpl, EnvironmentFailureReason.HANDSHAKE_ERROR, " Feeder: " + this.feederNameIdPair + ". " + reject.getErrorMessage());
        }
        if (!(message instanceof Protocol.NodeGroupInfoOK)) {
            throw new EnvironmentFailureException((EnvironmentImpl)repImpl, EnvironmentFailureReason.HANDSHAKE_ERROR, " Feeder: " + this.feederNameIdPair + ". " + "Protocol error. Unexpected response " + message);
        }
        Protocol.NodeGroupInfoOK nodeGroupInfoOK = (Protocol.NodeGroupInfoOK)message;
        if (this.repNode.getGroup().hasUnknownUUID()) {
            this.repNode.getGroup().setUUID(nodeGroupInfoOK.getUUID());
        }
        if (nodeType.isSecondary()) {
            this.repNode.getNameIdPair().update(nodeGroupInfoOK.getNameIdPair());
        }
    }

    private void checkClockSkew() throws IOException, BinaryProtocol.ProtocolException {
        boolean isLast = false;
        int sampleCount = 0;
        do {
            isLast = ++sampleCount >= CLOCK_SKEW_MAX_SAMPLE_SIZE || this.clockDelay <= 2L;
            Protocol protocol = this.protocol;
            protocol.getClass();
            this.protocol.write((BinaryProtocol.Message)protocol.new Protocol.SNTPRequest(isLast), this.namedChannel);
            Protocol.SNTPResponse response = this.protocol.read(this.namedChannel, Protocol.SNTPResponse.class);
            if (response.getDelay() >= this.clockDelay) continue;
            this.clockDelay = response.getDelay();
            this.clockDelta = response.getDelta();
        } while (!isLast);
        LoggerUtils.logMsg(this.logger, this.repNode.getRepImpl(), Math.abs(this.clockDelta) >= (long)this.maxClockDelta ? Level.SEVERE : Level.FINE, "Round trip delay: " + this.clockDelay + " ms. " + "Clock delta: " + this.clockDelta + " ms. " + "Max permissible delta: " + this.maxClockDelta + " ms.");
        if (Math.abs(this.clockDelta) >= (long)this.maxClockDelta) {
            throw new EnvironmentFailureException((EnvironmentImpl)this.repNode.getRepImpl(), EnvironmentFailureReason.HANDSHAKE_ERROR, "Clock delta: " + this.clockDelta + " ms. " + "between Feeder: " + this.feederNameIdPair.getName() + " and this Replica exceeds max permissible delta: " + this.maxClockDelta + " ms.");
        }
    }
}

