/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.cleaner.PackedObsoleteInfo;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.latch.LatchContext;
import com.sleepycat.je.latch.LatchFactory;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.latch.LatchTable;
import com.sleepycat.je.latch.SharedLatch;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.Provisional;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.WholeEntry;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.Generation;
import com.sleepycat.je.tree.INArrayRep;
import com.sleepycat.je.tree.INKeyRep;
import com.sleepycat.je.tree.INLogContext;
import com.sleepycat.je.tree.INLogItem;
import com.sleepycat.je.tree.INTargetRep;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.tree.dupConvert.DupConvert;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.SizeofMarker;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IN
extends Node
implements Comparable<IN>,
LatchContext {
    private static final String BEGIN_TAG = "<in>";
    private static final String END_TAG = "</in>";
    private static final String TRACE_SPLIT = "Split:";
    private static final String TRACE_DELETE = "Delete:";
    private static final int BYTES_PER_LSN_ENTRY = 4;
    public static final int MAX_FILE_OFFSET = 0xFFFFFE;
    private static final int THREE_BYTE_NEGATIVE_ONE = 0xFFFFFF;
    public static final int DBMAP_LEVEL = 131072;
    public static final int MAIN_LEVEL = 65536;
    public static final int LEVEL_MASK = 65535;
    public static final int MIN_LEVEL = -1;
    public static final int MAX_LEVEL = Integer.MAX_VALUE;
    public static final int BIN_LEVEL = 65537;
    public static final int EXACT_MATCH = 65536;
    public static final int INSERT_SUCCESS = 131072;
    public static final long NON_EVICTABLE_IN = 0x4000000000000000L;
    private static final int IN_DIRTY_BIT = 1;
    private static final int IN_RECALC_TOGGLE_BIT = 2;
    private static final int IN_IS_ROOT_BIT = 4;
    private static final int HAS_CACHED_CHILDREN_BIT = 8;
    private static final int IN_DIRTY_LRU_BIT = 16;
    private static final int IN_DELTA_BIT = 32;
    private static final boolean doTrace = false;
    private static final Level traceLevel = Level.INFO;
    DatabaseImpl databaseImpl;
    private int level;
    long nodeId;
    int flags;
    private byte[] identifierKey;
    int nEntries;
    byte[] entryStates;
    INKeyRep entryKeyVals;
    byte[] keyPrefix;
    long baseFileNumber;
    byte[] entryLsnByteArray;
    long[] entryLsnLongArray;
    public static boolean disableCompactLsns;
    INTargetRep entryTargets;
    long inMemorySize;
    private int accumulatedDelta = 0;
    public static int ACCUMULATED_LIMIT;
    private boolean inListResident;
    private IN nextLRUNode = null;
    private IN prevLRUNode = null;
    long lastFullVersion = -1L;
    private PackedObsoleteInfo provisionalObsolete;
    private boolean needDupKeyConversion;
    private int pinCount = 0;
    protected SharedLatch latch;
    private long generation;
    private TestHook fetchINHook;

    public IN() {
        this.init(null, Key.EMPTY_KEY, 0, 0);
    }

    public IN(DatabaseImpl dbImpl, byte[] identifierKey, int capacity, int level) {
        this.nodeId = dbImpl.getDbEnvironment().getNodeSequence().getNextLocalNodeId();
        this.init(dbImpl, identifierKey, capacity, IN.generateLevel(dbImpl.getId(), level));
        this.initMemorySize();
    }

    public IN(SizeofMarker marker) {
        this.entryTargets = null;
        this.entryKeyVals = null;
        this.keyPrefix = null;
        this.entryLsnByteArray = null;
        this.entryLsnLongArray = null;
        this.entryStates = null;
        this.latch = LatchFactory.createSharedLatch(LatchSupport.DUMMY_LATCH_CONTEXT, this.isAlwaysLatchedExclusively());
        this.latch.acquireExclusive();
        this.latch.release();
        this.latch.acquireExclusive();
        this.latch.release();
    }

    protected IN createNewInstance(byte[] identifierKey, int maxEntries, int level) {
        return new IN(this.databaseImpl, identifierKey, maxEntries, level);
    }

    protected void init(DatabaseImpl db, byte[] identifierKey, int initialCapacity, int level) {
        this.setDatabase(db);
        this.latch = LatchFactory.createSharedLatch(this, this.isAlwaysLatchedExclusively());
        this.generation = 0L;
        this.flags = 0;
        this.nEntries = 0;
        this.identifierKey = identifierKey;
        this.entryTargets = INTargetRep.NONE;
        this.entryKeyVals = new INKeyRep.Default(initialCapacity);
        this.keyPrefix = null;
        this.baseFileNumber = -1L;
        if (disableCompactLsns) {
            this.entryLsnByteArray = null;
            this.entryLsnLongArray = new long[initialCapacity];
        } else {
            this.entryLsnByteArray = new byte[initialCapacity << 2];
            this.entryLsnLongArray = null;
        }
        this.entryStates = new byte[initialCapacity];
        this.level = level;
        this.inListResident = false;
    }

    @Override
    public final boolean isIN() {
        return true;
    }

    @Override
    public final boolean isUpperIN() {
        return !this.isBIN();
    }

    @Override
    public final String getLatchName() {
        return this.shortClassName() + this.getNodeId();
    }

    public final String getLatchString() {
        return this.latch.toString();
    }

    @Override
    public final int getLatchTimeoutMs() {
        return this.databaseImpl.getEnvironmentImpl().getLatchTimeoutMs();
    }

    @Override
    public final LatchTable getLatchTable() {
        return LatchSupport.btreeLatchTable;
    }

    boolean isAlwaysLatchedExclusively() {
        return false;
    }

    public final boolean latchNoWait(CacheMode cacheMode) throws DatabaseException {
        if (this.latch.acquireExclusiveNoWait()) {
            this.setGeneration(cacheMode);
            return true;
        }
        return false;
    }

    public final boolean latchNoWait() throws DatabaseException {
        return this.latchNoWait(CacheMode.DEFAULT);
    }

    public void latch(CacheMode cacheMode) throws DatabaseException {
        this.latch.acquireExclusive();
        this.setGeneration(cacheMode);
    }

    public final void latch() throws DatabaseException {
        this.latch(CacheMode.DEFAULT);
    }

    @Override
    public void latchShared(CacheMode cacheMode) throws DatabaseException {
        this.latch.acquireShared();
        this.setGeneration(cacheMode);
    }

    @Override
    public final void latchShared() throws DatabaseException {
        this.latchShared(CacheMode.DEFAULT);
    }

    @Override
    public final void releaseLatch() {
        this.latch.release();
    }

    public final void releaseLatchIfOwner() {
        this.latch.releaseIfOwner();
    }

    public final boolean isLatchOwner() {
        return this.latch.isOwner();
    }

    public final boolean isLatchExclusiveOwner() {
        return this.latch.isExclusiveOwner();
    }

    public final int getLatchNWaiters() {
        return this.latch.getNWaiters();
    }

    public final long getGeneration() {
        return this.generation;
    }

    public final void setGeneration(CacheMode cacheMode) {
        Evictor evictor = this.getEvictor();
        switch (cacheMode) {
            case DEFAULT: 
            case EVICT_LN: {
                this.generation = Generation.getNextGeneration();
                if (!this.isBIN() && this.hasCachedChildrenFlag()) break;
                assert (this.isBIN() || !this.hasResidentChildren());
                if (evictor == null) break;
                evictor.moveBack(this);
                break;
            }
            case UNCHANGED: {
                break;
            }
            case KEEP_HOT: {
                this.generation = Long.MAX_VALUE;
                if (!this.isBIN() && this.hasCachedChildrenFlag()) break;
                assert (this.isBIN() || !this.hasResidentChildren());
                if (evictor == null) break;
                evictor.moveBack(this);
                break;
            }
            case MAKE_COLD: 
            case EVICT_BIN: {
                if (!this.isBIN()) break;
                this.generation = 0L;
                if (evictor == null) break;
                evictor.moveFront(this);
                break;
            }
            default: {
                throw EnvironmentFailureException.unexpectedState("unknown cacheMode: " + (Object)((Object)cacheMode));
            }
        }
    }

    public final void setGeneration(long newGeneration) {
        this.generation = newGeneration;
    }

    public final synchronized void pin() {
        assert (this.isLatchOwner());
        assert (this.pinCount >= 0);
        ++this.pinCount;
    }

    public final synchronized void unpin() {
        assert (this.pinCount > 0);
        --this.pinCount;
    }

    public final synchronized boolean isPinned() {
        assert (this.isLatchExclusiveOwner());
        assert (this.pinCount >= 0);
        return this.pinCount > 0;
    }

    public final DatabaseImpl getDatabase() {
        return this.databaseImpl;
    }

    public final void setDatabase(DatabaseImpl db) {
        this.databaseImpl = db;
    }

    public final DatabaseId getDatabaseId() {
        return this.databaseImpl.getId();
    }

    @Override
    public final EnvironmentImpl getEnvImplForFatalException() {
        return this.databaseImpl.getEnvironmentImpl();
    }

    public final EnvironmentImpl getEnv() {
        return this.databaseImpl.getDbEnvironment();
    }

    protected final Evictor getEvictor() {
        return this.databaseImpl.getDbEnvironment().getEvictor();
    }

    public final Comparator<byte[]> getKeyComparator() {
        return this.databaseImpl.getKeyComparator();
    }

    @Override
    public final int getLevel() {
        return this.level;
    }

    public final int getNormalizedLevel() {
        return this.level & 0xFFFF;
    }

    private static int generateLevel(DatabaseId dbId, int newLevel) {
        if (dbId.equals(DbTree.ID_DB_ID)) {
            return newLevel | 0x20000;
        }
        return newLevel | 0x10000;
    }

    public final long getNodeId() {
        return this.nodeId;
    }

    final void setNodeId(long nid) {
        this.nodeId = nid;
    }

    public final int hashCode() {
        return (int)(this.getNodeId() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof IN)) {
            return false;
        }
        IN in = (IN)obj;
        return this.getNodeId() == in.getNodeId();
    }

    @Override
    public final int compareTo(IN argIN) {
        long argNodeId = argIN.getNodeId();
        long myNodeId = this.getNodeId();
        if (myNodeId < argNodeId) {
            return -1;
        }
        if (myNodeId > argNodeId) {
            return 1;
        }
        return 0;
    }

    public final boolean getDirty() {
        return (this.flags & 1) != 0;
    }

    public final void setDirty(boolean dirty) {
        this.flags = dirty ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    @Override
    public final boolean isBINDelta() {
        assert (this.isUpperIN() || this.isLatchOwner());
        return (this.flags & 0x20) != 0;
    }

    @Override
    public final boolean isBINDelta(boolean checkLatched) {
        assert (!checkLatched || this.isUpperIN() || this.isLatchOwner());
        return (this.flags & 0x20) != 0;
    }

    final void setBINDelta(boolean delta) {
        this.flags = delta ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    public final boolean getRecalcToggle() {
        return (this.flags & 2) != 0;
    }

    public final void setRecalcToggle(boolean toggle) {
        this.flags = toggle ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public final boolean isRoot() {
        return (this.flags & 4) != 0;
    }

    public final boolean isDbRoot() {
        return (this.flags & 4) != 0;
    }

    final void setIsRoot(boolean isRoot) {
        this.setIsRootFlag(isRoot);
        this.setDirty(true);
    }

    private final void setIsRootFlag(boolean isRoot) {
        this.flags = isRoot ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public final boolean hasCachedChildrenFlag() {
        return (this.flags & 8) != 0;
    }

    private final void setHasCachedChildrenFlag(boolean value) {
        this.flags = value ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public final boolean isInDirtyLRU() {
        return (this.flags & 0x10) != 0;
    }

    public final void setInDirtyLRU(boolean value) {
        this.flags = value ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public final byte[] getIdentifierKey() {
        return this.identifierKey;
    }

    public final void setIdentifierKey(byte[] key) {
        assert (!this.isBINDelta());
        this.identifierKey = key;
        this.setDirty(true);
    }

    public final int getNEntries() {
        return this.nEntries;
    }

    public int getMaxEntries() {
        return this.entryStates.length;
    }

    public final byte getState(int idx) {
        return this.entryStates[idx];
    }

    final boolean isDirty(int idx) {
        return (this.entryStates[idx] & 2) != 0;
    }

    public final boolean isEntryPendingDeleted(int idx) {
        return (this.entryStates[idx] & 8) != 0;
    }

    public final void setPendingDeleted(int idx) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 8);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
    }

    public final void clearPendingDeleted(int idx) {
        assert (!this.isBINDelta());
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFF7);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
    }

    public final boolean isEntryKnownDeleted(int idx) {
        return (this.entryStates[idx] & 1) != 0;
    }

    void setKnownDeleted(int idx) {
        assert (!this.isBINDelta());
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 1);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
        this.setDirty(true);
    }

    public final void clearKnownDeleted(int idx) {
        assert (!this.isBINDelta());
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFFE);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
        this.setDirty(true);
    }

    static boolean isStateKnownDeleted(byte state) {
        return (state & 1) != 0;
    }

    static boolean isStatePendingDeleted(byte state) {
        return (state & 8) != 0;
    }

    public final INKeyRep getKeyVals() {
        return this.entryKeyVals;
    }

    public final byte[] getKey(int idx) {
        byte[] suffix = (byte[])this.entryKeyVals.get(idx);
        if (suffix == null) {
            suffix = Key.EMPTY_KEY;
        }
        if (this.keyPrefix == null) {
            return suffix;
        }
        int prefixLen = this.keyPrefix.length;
        if (prefixLen == 0) {
            return suffix;
        }
        int suffixLen = suffix.length;
        byte[] key = new byte[prefixLen + suffixLen];
        System.arraycopy(this.keyPrefix, 0, key, 0, prefixLen);
        System.arraycopy(suffix, 0, key, prefixLen, suffixLen);
        return key;
    }

    private boolean setLNSlotKey(int idx, byte[] newKey) {
        assert (newKey == null || this.isBIN());
        if (newKey != null && this.getKeyComparator() != null && !Arrays.equals(newKey, this.getKey(idx))) {
            this.setDirty(true);
            return this.setKeyAndDirty(idx, newKey);
        }
        return false;
    }

    private boolean setKeyAndDirty(int idx, byte[] keyVal) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 2);
        return this.setKeyAndPrefix(idx, keyVal);
    }

    private boolean setKeyAndPrefix(int idx, byte[] keyVal) {
        if (this.databaseImpl.getKeyPrefixing() && this.keyPrefix != null) {
            if (!this.compareToKeyPrefix(keyVal)) {
                byte[] newPrefix = this.computeKeyPrefix(idx);
                if (newPrefix != null) {
                    newPrefix = Key.createKeyPrefix(newPrefix, keyVal);
                }
                this.recalcSuffixes(newPrefix, keyVal, idx);
                return true;
            }
            INKeyRep.Type prevRepType = (INKeyRep.Type)((Object)this.entryKeyVals.getType());
            this.entryKeyVals = (INKeyRep)this.entryKeyVals.set(idx, this.computeKeySuffix(this.keyPrefix, keyVal), this);
            return prevRepType != this.entryKeyVals.getType();
        }
        if (this.keyPrefix != null) {
            this.recalcSuffixes(new byte[0], keyVal, idx);
            return true;
        }
        INKeyRep.Type oldRepType = (INKeyRep.Type)((Object)this.entryKeyVals.getType());
        this.entryKeyVals = (INKeyRep)this.entryKeyVals.set(idx, keyVal, this);
        return oldRepType != this.entryKeyVals.getType();
    }

    private void recalcSuffixes(byte[] newPrefix, byte[] keyVal, int idx) {
        for (int i = 0; i < this.nEntries; ++i) {
            byte[] curKey = i == idx ? keyVal : this.getKey(i);
            this.entryKeyVals = (INKeyRep)this.entryKeyVals.set(i, this.computeKeySuffix(newPrefix, curKey), this);
        }
        this.setKeyPrefix(newPrefix);
    }

    private byte[] computeKeySuffix(byte[] newPrefix, byte[] keyVal) {
        int prefixLen;
        int n = prefixLen = newPrefix == null ? 0 : newPrefix.length;
        if (prefixLen == 0) {
            return keyVal;
        }
        int suffixLen = keyVal.length - prefixLen;
        byte[] ret = new byte[suffixLen];
        System.arraycopy(keyVal, prefixLen, ret, 0, suffixLen);
        return ret;
    }

    public final void recalcKeyPrefix() {
        assert (!this.isBINDelta());
        this.recalcSuffixes(this.computeKeyPrefix(-1), null, -1);
    }

    private byte[] computeKeyPrefix(int excludeIdx) {
        if (!this.databaseImpl.getKeyPrefixing() || this.nEntries <= 1) {
            return null;
        }
        int firstIdx = excludeIdx == 0 ? 1 : 0;
        byte[] curPrefixKey = this.getKey(firstIdx);
        int prefixLen = curPrefixKey.length;
        boolean byteOrdered = false;
        if (byteOrdered) {
            byte[] lastKey;
            int newPrefixLen;
            int lastIdx = this.nEntries - 1;
            if (lastIdx == excludeIdx) {
                --lastIdx;
            }
            if (lastIdx > firstIdx && (newPrefixLen = Key.getKeyPrefixLength(curPrefixKey, prefixLen, lastKey = this.getKey(lastIdx))) < prefixLen) {
                curPrefixKey = lastKey;
                prefixLen = newPrefixLen;
            }
        } else {
            for (int i = firstIdx + 1; i < this.nEntries; ++i) {
                byte[] curKey;
                int newPrefixLen;
                if (i == excludeIdx || (newPrefixLen = Key.getKeyPrefixLength(curPrefixKey, prefixLen, curKey = this.getKey(i))) >= prefixLen) continue;
                curPrefixKey = curKey;
                prefixLen = newPrefixLen;
            }
        }
        byte[] ret = new byte[prefixLen];
        System.arraycopy(curPrefixKey, 0, ret, 0, prefixLen);
        return ret;
    }

    final byte[] getKeyPrefix() {
        return this.keyPrefix;
    }

    public final boolean hasKeyPrefix() {
        return this.keyPrefix != null;
    }

    final void setKeyPrefix(byte[] keyPrefix) {
        assert (!this.isBINDelta());
        assert (this.databaseImpl != null);
        int prevLength = this.keyPrefix == null ? 0 : this.keyPrefix.length;
        this.keyPrefix = keyPrefix;
        int currLength = keyPrefix == null ? 0 : keyPrefix.length;
        this.updateMemorySize(prevLength, currLength);
    }

    final boolean compareToKeyPrefix(byte[] newKey) {
        if (this.keyPrefix == null || this.keyPrefix.length == 0) {
            return false;
        }
        int newKeyLen = newKey.length;
        for (int i = 0; i < this.keyPrefix.length; ++i) {
            if (i < newKeyLen && this.keyPrefix[i] == newKey[i]) continue;
            return false;
        }
        return true;
    }

    final boolean verifyKeyPrefix() {
        assert (!this.isBINDelta());
        byte[] computedKeyPrefix = this.computeKeyPrefix(-1);
        if (this.keyPrefix == null) {
            return computedKeyPrefix == null;
        }
        if (computedKeyPrefix == null || computedKeyPrefix.length < this.keyPrefix.length) {
            System.out.println("VerifyKeyPrefix failed");
            System.out.println(this.dumpString(0, false));
            return false;
        }
        for (int i = 0; i < this.keyPrefix.length; ++i) {
            if (this.keyPrefix[i] == computedKeyPrefix[i]) continue;
            System.out.println("VerifyKeyPrefix failed");
            System.out.println(this.dumpString(0, false));
            return false;
        }
        return true;
    }

    public final boolean isKeyInBounds(byte[] keyVal) {
        assert (!this.isBINDelta());
        if (this.nEntries < 2) {
            return false;
        }
        Comparator<byte[]> userCompareToFcn = this.getKeyComparator();
        byte[] myKey = this.getKey(0);
        int cmp = Key.compareKeys(keyVal, myKey, userCompareToFcn);
        if (cmp < 0) {
            return false;
        }
        myKey = this.getKey(this.nEntries - 1);
        cmp = Key.compareKeys(keyVal, myKey, userCompareToFcn);
        return cmp <= 0;
    }

    public final long getLsn(int idx) {
        if (this.entryLsnLongArray == null) {
            int offset = idx << 2;
            int fileOffset = this.getFileOffset(offset);
            if (fileOffset == -1) {
                return -1L;
            }
            return DbLsn.makeLsn(this.baseFileNumber + (long)this.getFileNumberOffset(offset), fileOffset);
        }
        return this.entryLsnLongArray[idx];
    }

    private void setLsn(int idx, long newLsn) {
        if (this.shouldUpdateLsn(this.getLsn(idx), newLsn)) {
            this.setLsnNoValidation(idx, newLsn);
        }
    }

    private void setLsnNoValidation(int idx, long lsn) {
        int oldSize = this.computeLsnOverhead();
        this.setLsnElement(idx, lsn);
        this.changeMemorySize(this.computeLsnOverhead() - oldSize);
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 2);
    }

    final void setLsnElement(int idx, long value) {
        if (this.entryLsnLongArray != null) {
            this.entryLsnLongArray[idx] = value;
            return;
        }
        int offset = idx << 2;
        if (value == -1L) {
            this.setFileNumberOffset(offset, (byte)0);
            this.setFileOffset(offset, -1);
            return;
        }
        long thisFileNumber = DbLsn.getFileNumber(value);
        if (this.baseFileNumber == -1L) {
            this.baseFileNumber = thisFileNumber;
            this.setFileNumberOffset(offset, (byte)0);
        } else {
            long fileNumberDifference;
            if (thisFileNumber < this.baseFileNumber) {
                if (!this.adjustFileNumbers(thisFileNumber)) {
                    this.mutateToLongArray(idx, value);
                    return;
                }
                this.baseFileNumber = thisFileNumber;
            }
            if ((fileNumberDifference = thisFileNumber - this.baseFileNumber) > 127L) {
                this.mutateToLongArray(idx, value);
                return;
            }
            this.setFileNumberOffset(offset, (byte)(thisFileNumber - this.baseFileNumber));
        }
        int fileOffset = (int)DbLsn.getFileOffset(value);
        if (fileOffset > 0xFFFFFE) {
            this.mutateToLongArray(idx, value);
            return;
        }
        this.setFileOffset(offset, fileOffset);
    }

    private boolean adjustFileNumbers(long newBaseFileNumber) {
        long oldBaseFileNumber = this.baseFileNumber;
        for (int i = 0; i < this.entryLsnByteArray.length; i += 4) {
            if (this.getFileOffset(i) == -1) continue;
            long curEntryFileNumber = oldBaseFileNumber + (long)this.getFileNumberOffset(i);
            long newCurEntryFileNumberOffset = curEntryFileNumber - newBaseFileNumber;
            if (newCurEntryFileNumberOffset > 127L) {
                long undoOffset = oldBaseFileNumber - newBaseFileNumber;
                for (int j = i - 4; j >= 0; j -= 4) {
                    if (this.getFileOffset(j) == -1) continue;
                    this.setFileNumberOffset(j, (byte)((long)this.getFileNumberOffset(j) - undoOffset));
                }
                return false;
            }
            this.setFileNumberOffset(i, (byte)newCurEntryFileNumberOffset);
        }
        return true;
    }

    private void setFileNumberOffset(int offset, byte fileNumberOffset) {
        this.entryLsnByteArray[offset] = fileNumberOffset;
    }

    private byte getFileNumberOffset(int offset) {
        return this.entryLsnByteArray[offset];
    }

    private void setFileOffset(int offset, int fileOffset) {
        this.put3ByteInt(offset + 1, fileOffset);
    }

    private int getFileOffset(int offset) {
        return this.get3ByteInt(offset + 1);
    }

    private void put3ByteInt(int offset, int value) {
        this.entryLsnByteArray[offset++] = (byte)(value >>> 0);
        this.entryLsnByteArray[offset++] = (byte)(value >>> 8);
        this.entryLsnByteArray[offset] = (byte)(value >>> 16);
    }

    private int get3ByteInt(int offset) {
        int ret = (this.entryLsnByteArray[offset++] & 0xFF) << 0;
        ret += (this.entryLsnByteArray[offset++] & 0xFF) << 8;
        if ((ret += (this.entryLsnByteArray[offset] & 0xFF) << 16) == 0xFFFFFF) {
            ret = -1;
        }
        return ret;
    }

    private void mutateToLongArray(int idx, long value) {
        int nElts = this.entryLsnByteArray.length >> 2;
        long[] newArr = new long[nElts];
        for (int i = 0; i < nElts; ++i) {
            newArr[i] = this.getLsn(i);
        }
        newArr[idx] = value;
        this.entryLsnLongArray = newArr;
        this.entryLsnByteArray = null;
    }

    private final boolean shouldUpdateLsn(long oldLsn, long newLsn) {
        if (oldLsn == newLsn) {
            return false;
        }
        if (newLsn == -1L && this.getEnv().isReadOnly()) {
            return true;
        }
        if (this.databaseImpl.isDeferredWriteMode()) {
            if (oldLsn != -1L && DbLsn.isTransientOrNull(newLsn)) {
                throw EnvironmentFailureException.unexpectedState("DeferredWrite LSN update not allowed oldLsn = " + DbLsn.getNoFormatString(oldLsn) + " newLsn = " + DbLsn.getNoFormatString(newLsn));
            }
        } else if (DbLsn.isTransientOrNull(newLsn)) {
            throw EnvironmentFailureException.unexpectedState("LSN update not allowed oldLsn = " + DbLsn.getNoFormatString(oldLsn) + " newLsn = " + DbLsn.getNoFormatString(newLsn));
        }
        return true;
    }

    final long[] getEntryLsnLongArray() {
        return this.entryLsnLongArray;
    }

    final byte[] getEntryLsnByteArray() {
        return this.entryLsnByteArray;
    }

    final void initEntryLsn(int capacity) {
        this.entryLsnLongArray = null;
        this.entryLsnByteArray = new byte[capacity << 2];
        this.baseFileNumber = -1L;
    }

    public final void clearLsnCompaction() {
        assert (!this.isBINDelta());
        if (this.entryLsnByteArray != null) {
            this.mutateToLongArray(0, this.getLsn(0));
            this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
        }
    }

    boolean isLastLoggedSizeStored() {
        return false;
    }

    public void setLastLoggedSize(int idx, int lastLoggedSize) {
    }

    void setLastLoggedSizeUnconditional(int idx, int lastLoggedSize) {
    }

    public int getLastLoggedSize(int idx) {
        return 0;
    }

    public final INArrayRep<INTargetRep, INTargetRep.Type, Node> getTargets() {
        return this.entryTargets;
    }

    public final boolean isResident(int idx) {
        return this.entryTargets.get(idx) != null;
    }

    void setTarget(int idx, Node target) {
        assert (this.isLatchExclusiveOwner()) : "Not latched for write " + this.getClass().getName() + " id=" + this.getNodeId();
        Evictor evictor = this.getEvictor();
        if (target == null) {
            if (this.isUpperIN() && this.hasCachedChildrenFlag()) {
                IN curChild = (IN)this.entryTargets.get(idx);
                this.entryTargets = (INTargetRep)this.entryTargets.set(idx, target, this);
                if (curChild != null && !this.hasResidentChildren()) {
                    this.setHasCachedChildrenFlag(false);
                    if (evictor != null && !this.isDIN()) {
                        evictor.addBack(this);
                    }
                }
            } else {
                this.entryTargets = (INTargetRep)this.entryTargets.set(idx, target, this);
            }
        } else {
            if (this.isUpperIN() && !this.hasCachedChildrenFlag()) {
                this.setHasCachedChildrenFlag(true);
                if (evictor != null) {
                    evictor.remove(this);
                }
            }
            this.entryTargets = (INTargetRep)this.entryTargets.set(idx, target, this);
        }
    }

    public final Node getTarget(int idx) {
        return (Node)this.entryTargets.get(idx);
    }

    final IN fetchINWithNoLatch(int idx, byte[] searchKey) {
        return this.fetchINWithNoLatch(idx, searchKey, null);
    }

    final IN fetchINWithNoLatch(SearchResult result, byte[] searchKey) {
        return this.fetchINWithNoLatch(result.index, searchKey, result);
    }

    private IN fetchINWithNoLatch(int idx, byte[] searchKey, SearchResult result) {
        assert (this.isUpperIN());
        assert (this.isLatchOwner());
        EnvironmentImpl envImpl = this.getEnv();
        boolean isMiss = false;
        boolean success = false;
        IN child = (IN)this.entryTargets.get(idx);
        if (child == null) {
            isMiss = true;
            long lsn = this.getLsn(idx);
            if (lsn == -1L) {
                throw EnvironmentFailureException.unexpectedState(IN.makeFetchErrorMsg("NULL_LSN in upper IN", this, lsn, this.entryStates[idx]));
            }
            try {
                this.pin();
                this.releaseLatch();
                TestHookExecute.doHookIfSet(this.fetchINHook);
                WholeEntry wholeEntry = envImpl.getLogManager().getLogEntryAllowInvisibleAtRecovery(lsn);
                LogEntry logEntry = wholeEntry.getEntry();
                child = (IN)logEntry.getResolvedItem(this.databaseImpl);
                this.latch(CacheMode.UNCHANGED);
                if (idx >= this.nEntries || this.getLsn(idx) != lsn) {
                    if (searchKey == null) {
                        IN iN = null;
                        return iN;
                    }
                    idx = this.findEntry(searchKey, false, false);
                    if (!(idx != 0 && idx != this.nEntries - 1 || this.isKeyInBounds(searchKey))) {
                        IN iN = null;
                        return iN;
                    }
                }
                if (result != null) {
                    result.index = idx;
                }
                if (this.entryTargets.get(idx) != null) {
                    assert (DbLsn.compareTo(lsn, this.getLsn(idx)) <= 0);
                    child = (IN)this.entryTargets.get(idx);
                } else {
                    if (this.getLsn(idx) != lsn) {
                        IN iN = null;
                        return iN;
                    }
                    child.postFetchInit(this.databaseImpl, lsn);
                    this.attachNode(idx, child, null);
                }
                success = true;
            }
            catch (FileNotFoundException e) {
                throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, IN.makeFetchErrorMsg(null, this, lsn, this.entryStates[idx]), e);
            }
            catch (EnvironmentFailureException e) {
                e.addErrorMessage(IN.makeFetchErrorMsg(null, this, lsn, this.entryStates[idx]));
                throw e;
            }
            catch (RuntimeException e) {
                throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, IN.makeFetchErrorMsg(e.toString(), this, lsn, this.entryStates[idx]), e);
            }
            finally {
                if (!success) {
                    this.releaseLatchIfOwner();
                }
                this.unpin();
            }
        }
        assert (this.hasResidentChildren() == this.hasCachedChildrenFlag());
        child.incFetchStats(envImpl, isMiss);
        return child;
    }

    public IN fetchIN(int idx) {
        assert (this.isUpperIN());
        if (!this.isLatchExclusiveOwner()) {
            throw EnvironmentFailureException.unexpectedState("EX-latch not held before fetch");
        }
        EnvironmentImpl envImpl = this.getEnv();
        boolean isMiss = false;
        IN child = (IN)this.entryTargets.get(idx);
        if (child == null) {
            long lsn = this.getLsn(idx);
            if (lsn == -1L) {
                throw EnvironmentFailureException.unexpectedState(IN.makeFetchErrorMsg("NULL_LSN in upper IN", this, lsn, this.entryStates[idx]));
            }
            try {
                WholeEntry wholeEntry = envImpl.getLogManager().getLogEntryAllowInvisibleAtRecovery(lsn);
                LogEntry logEntry = wholeEntry.getEntry();
                child = (IN)logEntry.getResolvedItem(this.databaseImpl);
                child.postFetchInit(this.databaseImpl, lsn);
                this.attachNode(idx, child, null);
                isMiss = true;
            }
            catch (FileNotFoundException e) {
                throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, IN.makeFetchErrorMsg(null, this, lsn, this.entryStates[idx]), e);
            }
            catch (EnvironmentFailureException e) {
                e.addErrorMessage(IN.makeFetchErrorMsg(null, this, lsn, this.entryStates[idx]));
                throw e;
            }
            catch (RuntimeException e) {
                throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, IN.makeFetchErrorMsg(e.toString(), this, lsn, this.entryStates[idx]), e);
            }
        }
        assert (this.hasResidentChildren() == this.hasCachedChildrenFlag());
        child.incFetchStats(envImpl, isMiss);
        return child;
    }

    public final LN fetchLN(int idx, CacheMode cacheMode) {
        return (LN)this.fetchLN(idx, cacheMode, false);
    }

    public final LN fetchLNKnownActive(int idx, CacheMode cacheMode) {
        return (LN)this.fetchLN(idx, cacheMode, true);
    }

    public final Node fetchLNOrDIN(int idx, CacheMode cacheMode) {
        return this.fetchLN(idx, cacheMode, true);
    }

    final Node fetchLN(int idx, CacheMode cacheMode, boolean knownActive) {
        assert (this.isBIN());
        if (!this.isLatchExclusiveOwner()) {
            throw EnvironmentFailureException.unexpectedState("EX-latch not held before fetch");
        }
        EnvironmentImpl envImpl = this.getEnv();
        boolean isMiss = false;
        Node targetNode = (Node)this.entryTargets.get(idx);
        if (targetNode == null) {
            long lsn = this.getLsn(idx);
            if (lsn == -1L) {
                if (!this.isEntryKnownDeleted(idx)) {
                    throw EnvironmentFailureException.unexpectedState(IN.makeFetchErrorMsg("NULL_LSN without KnownDeleted", this, lsn, this.entryStates[idx]));
                }
                return null;
            }
            if (this.databaseImpl.isLNImmediatelyObsolete() && !knownActive) {
                throw EnvironmentFailureException.unexpectedState("May not fetch immediately obsolete LN");
            }
            try {
                WholeEntry wholeEntry = envImpl.getLogManager().getLogEntryAllowInvisibleAtRecovery(lsn);
                LogEntry logEntry = wholeEntry.getEntry();
                byte[] lnSlotKey = null;
                if (logEntry instanceof LNLogEntry) {
                    LNLogEntry lnEntry = (LNLogEntry)logEntry;
                    lnEntry.postFetchInit(this.databaseImpl);
                    lnSlotKey = lnEntry.getKey();
                    Evictor evictor = this.getEvictor();
                    if (evictor != null && cacheMode != CacheMode.EVICT_LN) {
                        evictor.moveToMixedLRU(this);
                    }
                }
                targetNode = (Node)logEntry.getResolvedItem(this.databaseImpl);
                targetNode.postFetchInit(this.databaseImpl, lsn);
                this.attachNode(idx, targetNode, lnSlotKey);
                this.setLastLoggedSize(idx, wholeEntry.getHeader().getEntrySize());
                isMiss = true;
            }
            catch (FileNotFoundException e) {
                if (!this.isEntryKnownDeleted(idx) && !this.isEntryPendingDeleted(idx)) {
                    throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, IN.makeFetchErrorMsg(null, this, lsn, this.entryStates[idx]), e);
                }
                return null;
            }
            catch (EnvironmentFailureException e) {
                e.addErrorMessage(IN.makeFetchErrorMsg(null, this, lsn, this.entryStates[idx]));
                throw e;
            }
            catch (RuntimeException e) {
                throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, IN.makeFetchErrorMsg(e.toString(), this, lsn, this.entryStates[idx]), e);
            }
        }
        targetNode.incFetchStats(envImpl, isMiss);
        return targetNode;
    }

    @Override
    public final void postFetchInit(DatabaseImpl db, long lastLoggedLsn) {
        this.commonPostFetchInit(db, lastLoggedLsn);
        this.convertDupKeys();
        db.getDbEnvironment().getInMemoryINs().add(this);
        Evictor evictor = this.getEvictor();
        if (evictor != null && this.isIN() && !this.isDIN() && !this.isDBIN()) {
            if (this.isUpperIN()) {
                // empty if block
            }
            evictor.addBack(this);
        }
    }

    public final void postRecoveryInit(DatabaseImpl db, long lastLoggedLsn) {
        this.commonPostFetchInit(db, lastLoggedLsn);
    }

    private void commonPostFetchInit(DatabaseImpl db, long lastLoggedLsn) {
        this.setDatabase(db);
        this.setLastLoggedLsn(lastLoggedLsn);
        this.initMemorySize();
    }

    private void convertDupKeys() {
        if (!this.needDupKeyConversion) {
            return;
        }
        this.needDupKeyConversion = false;
        DupConvert.convertInKeys(this.databaseImpl, this);
    }

    @Override
    public void incFetchStats(EnvironmentImpl envImpl, boolean isMiss) {
        this.getEvictor().incINFetchStats(isMiss);
    }

    static String makeFetchErrorMsg(String msg, IN in, long lsn, byte state) {
        StringBuilder sb = new StringBuilder();
        if (in == null) {
            sb.append("fetchRoot of ");
        } else if (in.isBIN()) {
            sb.append("fetchLN of ");
        } else {
            sb.append("fetchIN of ");
        }
        if (lsn == -1L) {
            sb.append("null lsn");
        } else {
            sb.append(DbLsn.getNoFormatString(lsn));
        }
        if (in != null) {
            sb.append(" parent IN=").append(in.getNodeId());
            sb.append(" IN class=").append(in.getClass().getName());
            sb.append(" lastFullVersion=");
            sb.append(DbLsn.getNoFormatString(in.getLastFullVersion()));
            sb.append(" lastLoggedVersion=");
            sb.append(DbLsn.getNoFormatString(in.getLastLoggedVersion()));
            sb.append(" parent.getDirty()=").append(in.getDirty());
        }
        sb.append(" state=").append(state);
        if (msg != null) {
            sb.append(" ").append(msg);
        }
        return sb.toString();
    }

    public final int findEntry(byte[] key, boolean indicateIfDuplicate, boolean exact) {
        return this.findEntry(key, indicateIfDuplicate, exact, null);
    }

    public final int findEntry(byte[] key, boolean indicateIfDuplicate, boolean exact, Comparator<byte[]> comparator) {
        boolean entryZeroSpecialCompare;
        int high = this.nEntries - 1;
        int low = 0;
        int middle = 0;
        Comparator<byte[]> userCompareToFcn = comparator != null ? comparator : this.databaseImpl.getKeyComparator();
        boolean bl = entryZeroSpecialCompare = this.isUpperIN() && !exact && !indicateIfDuplicate;
        assert (this.nEntries >= 0);
        while (low <= high) {
            int s;
            middle = (high + low) / 2;
            byte[] middleKey = null;
            if (middle == 0 && entryZeroSpecialCompare) {
                s = 1;
            } else {
                middleKey = this.getKey(middle);
                s = Key.compareKeys(key, middleKey, userCompareToFcn);
            }
            if (s < 0) {
                high = middle - 1;
                continue;
            }
            if (s > 0) {
                low = middle + 1;
                continue;
            }
            int ret = indicateIfDuplicate ? middle | 0x10000 : middle;
            if (ret >= 0 && exact && this.isEntryKnownDeleted(ret & 0xFFFF)) {
                return -1;
            }
            return ret;
        }
        if (exact) {
            return -1;
        }
        return high;
    }

    public final boolean insertEntry(ChildReference entry) throws DatabaseException {
        return (this.insertEntry1(entry) & 0x20000) != 0;
    }

    public final int insertEntry1(ChildReference entry) {
        int oldSize;
        assert (!this.isBINDelta());
        if (this.nEntries >= this.getMaxEntries()) {
            throw EnvironmentFailureException.unexpectedState("Node " + this.getNodeId() + " should have been split before calling insertEntry");
        }
        byte[] key = entry.getKey();
        int index = this.findEntry(key, true, false);
        if (index >= 0 && (index & 0x10000) != 0) {
            return index;
        }
        if (++index < this.nEntries) {
            oldSize = this.computeLsnOverhead();
            this.shiftEntriesRight(index);
            this.changeMemorySize(this.computeLsnOverhead() - oldSize);
        } else {
            ++this.nEntries;
        }
        oldSize = this.computeLsnOverhead();
        this.setTarget(index, entry.getTarget());
        this.setLsnElement(index, entry.getLsn());
        this.entryStates[index] = entry.getState();
        boolean multiSlotChange = this.setKeyAndPrefix(index, key);
        this.adjustCursorsForInsert(index);
        this.updateMemorySize(oldSize, this.getEntryInMemorySize(index) + (long)this.computeLsnOverhead());
        this.setDirty(true);
        if (multiSlotChange) {
            this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
        }
        assert (this.isBIN() || this.hasResidentChildren() == this.hasCachedChildrenFlag());
        return index | 0x20000;
    }

    final boolean deleteEntry(byte[] key, boolean maybeValidate) throws DatabaseException {
        assert (!this.isBINDelta());
        if (this.nEntries == 0) {
            return false;
        }
        int index = this.findEntry(key, false, true);
        if (index < 0) {
            return false;
        }
        return this.deleteEntry(index, maybeValidate);
    }

    public final boolean deleteEntry(int index, boolean maybeValidate) throws DatabaseException {
        assert (!this.isBINDelta());
        if (this.nEntries == 0) {
            return false;
        }
        assert (!maybeValidate || this.validateSubtreeBeforeDelete(index));
        if (index < this.nEntries) {
            Node child = this.getTarget(index);
            if (child != null && child.isIN()) {
                IN childIN = (IN)child;
                this.getEnv().getInMemoryINs().remove(childIN);
            }
            this.updateMemorySize(this.getEntryInMemorySize(index), 0L);
            int oldLSNArraySize = this.computeLsnOverhead();
            this.setTarget(index, null);
            this.copyEntries(index + 1, index, this.nEntries - index - 1);
            --this.nEntries;
            this.setDirty(true);
            this.setProhibitNextDelta();
            this.clearEntry(this.nEntries);
            this.updateMemorySize(oldLSNArraySize, this.computeLsnOverhead());
            assert (this.isBIN() || this.hasCachedChildrenFlag() == this.hasResidentChildren());
            this.traceDelete(Level.FINEST, index);
            return true;
        }
        return false;
    }

    void clearEntry(int idx) {
        assert (!this.isBINDelta());
        this.entryTargets = (INTargetRep)this.entryTargets.set(idx, null, this);
        this.entryKeyVals = (INKeyRep)this.entryKeyVals.set(idx, null, this);
        this.setLsnElement(idx, -1L);
        this.entryStates[idx] = 0;
    }

    public final void updateEntry(int idx, long lsn, int lastLoggedSize) {
        assert (!this.isBINDelta());
        this.setLsn(idx, lsn);
        this.setLastLoggedSize(idx, lastLoggedSize);
        this.setDirty(true);
    }

    final void updateEntry(int idx, Node node, long lsn, int lastLoggedSize, byte state) {
        assert (this.isBIN());
        assert (!this.isBINDelta());
        assert (lsn != -1L || (state & 1) != 0);
        this.setLsnNoValidation(idx, lsn);
        this.setLastLoggedSize(idx, lastLoggedSize);
        this.entryStates[idx] = state;
        this.setTarget(idx, node);
        this.setDirty(true);
    }

    public final void updateEntry(int idx, Node node, long lsn, int lastLoggedSize, byte[] key) {
        Node child = this.getTarget(idx);
        assert (child == null || child.isLN() || !((IN)child).getInListResident() || child == node);
        assert (!this.isBINDelta());
        long oldSize = this.getEntryInMemorySize(idx);
        this.setLsn(idx, lsn);
        this.setLastLoggedSize(idx, lastLoggedSize);
        this.setTarget(idx, node);
        boolean multiSlotChange = this.setKeyAndDirty(idx, key);
        if (multiSlotChange) {
            this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
        } else {
            long newSize = this.getEntryInMemorySize(idx);
            this.updateMemorySize(oldSize, newSize);
        }
        this.setDirty(true);
        assert (this.isBIN() || this.hasResidentChildren() == this.hasCachedChildrenFlag());
    }

    public final void updateEntry(int idx, long oldNodeSize, long lsn, int lastLoggedSize, byte[] lnSlotKey) {
        assert (this.isBIN());
        long oldSize = this.getEntryInMemorySize(idx);
        this.setLsn(idx, lsn);
        this.setLastLoggedSize(idx, lastLoggedSize);
        boolean multiSlotChange = this.setLNSlotKey(idx, lnSlotKey);
        if (multiSlotChange) {
            this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
        } else {
            long newSize = this.getEntryInMemorySize(idx);
            this.updateMemorySize(oldSize, newSize);
            Node currentNode = (Node)this.entryTargets.get(idx);
            long newNodeSize = currentNode != null ? currentNode.getMemorySizeIncludedByParent() : 0L;
            this.updateMemorySize(oldNodeSize, newNodeSize);
        }
        this.setDirty(true);
    }

    public final void updateNode(int idx, Node node, long lsn, int lastLoggedSize) {
        long oldSize = this.getEntryInMemorySize(idx);
        Node child = this.getTarget(idx);
        assert (child == null || child.isLN() || !((IN)child).getInListResident() || child == node);
        this.setLsn(idx, lsn);
        this.setLastLoggedSize(idx, lastLoggedSize);
        this.setTarget(idx, node);
        long newSize = this.getEntryInMemorySize(idx);
        this.updateMemorySize(oldSize, newSize);
        this.setDirty(true);
        assert (this.isBIN() || this.hasResidentChildren() == this.hasCachedChildrenFlag());
    }

    public final void attachNode(int idx, Node node, byte[] lnSlotKey) {
        long oldSize = this.getEntryInMemorySize(idx);
        assert (this.getTarget(idx) == null);
        this.setTarget(idx, node);
        boolean multiSlotChange = this.setLNSlotKey(idx, lnSlotKey);
        if (multiSlotChange) {
            this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
        } else {
            long newSize = this.getEntryInMemorySize(idx);
            this.updateMemorySize(oldSize, newSize);
        }
        assert (this.isBIN() || this.hasResidentChildren() == this.hasCachedChildrenFlag());
    }

    public final void detachNode(int idx, boolean updateLsn, long newLsn) {
        long oldSize = this.getEntryInMemorySize(idx);
        Node child = this.getTarget(idx);
        if (updateLsn) {
            this.setLsn(idx, newLsn);
            this.setDirty(true);
        }
        this.setTarget(idx, null);
        long newSize = this.getEntryInMemorySize(idx);
        this.updateMemorySize(oldSize, newSize);
        if (child != null && child.isIN()) {
            IN childIN = (IN)child;
            this.getEnv().getInMemoryINs().remove(childIN);
        }
        assert (this.isBIN() || this.hasResidentChildren() == this.hasCachedChildrenFlag());
    }

    void copyEntries(int from, int to, int n) {
        assert (!this.isBINDelta());
        this.entryTargets = (INTargetRep)this.entryTargets.copy(from, to, n, this);
        this.entryKeyVals = (INKeyRep)this.entryKeyVals.copy(from, to, n, this);
        System.arraycopy(this.entryStates, from, this.entryStates, to, n);
        if (this.entryLsnLongArray == null) {
            int fromOff = from << 2;
            int toOff = to << 2;
            int nBytes = n << 2;
            System.arraycopy(this.entryLsnByteArray, fromOff, this.entryLsnByteArray, toOff, nBytes);
        } else {
            System.arraycopy(this.entryLsnLongArray, from, this.entryLsnLongArray, to, n);
        }
    }

    void copyEntry(int idx, IN from, int fromIdx) {
        assert (!this.isBINDelta());
        Node target = (Node)from.entryTargets.get(fromIdx);
        byte[] keyVal = from.getKey(fromIdx);
        long lsn = from.getLsn(fromIdx);
        byte state = from.entryStates[fromIdx];
        long oldSize = this.computeLsnOverhead();
        int newNEntries = idx + 1;
        if (newNEntries > this.nEntries) {
            this.nEntries = newNEntries;
        } else {
            oldSize += this.getEntryInMemorySize(idx);
        }
        this.setTarget(idx, target);
        boolean multiSlotChange = this.setKeyAndPrefix(idx, keyVal);
        this.setLsnElement(idx, lsn);
        this.entryStates[idx] = state;
        if (multiSlotChange) {
            this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
        } else {
            long newSize = this.getEntryInMemorySize(idx) + (long)this.computeLsnOverhead();
            this.updateMemorySize(oldSize, newSize);
        }
        this.setDirty(true);
    }

    public final boolean needsSplitting() {
        assert (!this.isBINDelta());
        return this.getMaxEntries() - this.nEntries < 1;
    }

    final void split(IN parent, int childIndex, int maxEntries, CacheMode cacheMode) throws DatabaseException {
        this.splitInternal(parent, childIndex, maxEntries, -1, cacheMode);
    }

    void splitSpecial(IN parent, int parentIndex, int maxEntriesPerNode, byte[] key, boolean leftSide, CacheMode cacheMode) throws DatabaseException {
        int index = this.findEntry(key, false, false);
        if (leftSide && index == 0) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, 1, cacheMode);
        } else if (!leftSide && index == this.nEntries - 1) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, this.nEntries - 1, cacheMode);
        } else {
            this.split(parent, parentIndex, maxEntriesPerNode, cacheMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void splitInternal(IN parent, int childIndex, int maxEntries, int splitIndex, CacheMode cacheMode) throws DatabaseException {
        int high;
        int low;
        assert (!this.isBINDelta());
        if (this.identifierKey == null) {
            throw EnvironmentFailureException.unexpectedState();
        }
        int idKeyIndex = this.findEntry(this.identifierKey, false, false);
        if (splitIndex < 0) {
            splitIndex = this.nEntries / 2;
        }
        if (idKeyIndex < splitIndex) {
            low = splitIndex;
            high = this.nEntries;
        } else {
            low = 0;
            high = splitIndex;
        }
        byte[] newIdKey = this.getKey(low);
        long parentLsn = -1L;
        IN newSibling = this.createNewInstance(newIdKey, maxEntries, this.level);
        newSibling.latch(CacheMode.UNCHANGED);
        try {
            int toIdx = 0;
            boolean deletedEntrySeen = false;
            BINReference binRef = null;
            int newSiblingNEntries = high - low;
            boolean haveCachedChildren = this.hasCachedChildrenFlag();
            assert (this.isBIN() || haveCachedChildren == this.hasResidentChildren());
            for (int i = low; i < high; ++i) {
                if (this.isEntryPendingDeleted(i) && !deletedEntrySeen) {
                    deletedEntrySeen = true;
                    assert (newSibling.isBIN());
                    binRef = ((BIN)newSibling).createReference();
                }
                newSibling.copyEntry(toIdx++, this, i);
                this.clearEntry(i);
            }
            if (low == 0) {
                this.shiftEntriesLeft(newSiblingNEntries);
            }
            newSibling.nEntries = toIdx;
            this.nEntries -= newSiblingNEntries;
            this.setDirty(true);
            if (this.isUpperIN() && haveCachedChildren) {
                this.setHasCachedChildrenFlag(this.hasResidentChildren());
            }
            assert (this.isBIN() || this.hasCachedChildrenFlag() == this.hasResidentChildren());
            assert (this.isBIN() || newSibling.hasCachedChildrenFlag() == newSibling.hasResidentChildren());
            if (deletedEntrySeen) {
                this.getEnv().addToCompressorQueue(binRef, false);
            }
            this.adjustCursors(newSibling, low, high);
            byte[] newKeyPrefix = this.computeKeyPrefix(-1);
            this.recalcSuffixes(newKeyPrefix, null, -1);
            this.entryKeyVals = (INKeyRep)this.entryKeyVals.compact(this);
            if (newSibling.getNEntries() > 1) {
                byte[] newSiblingPrefix = newSibling.getKeyPrefix();
                newSiblingPrefix = newSibling.computeKeyPrefix(-1);
                newSibling.recalcSuffixes(newSiblingPrefix, null, -1);
                newSibling.initMemorySize();
            }
            EnvironmentImpl env = this.getEnv();
            INList inMemoryINs = env.getInMemoryINs();
            long oldMemorySize = this.inMemorySize;
            long newSize = this.computeMemorySize();
            this.updateMemorySize(oldMemorySize, newSize);
            inMemoryINs.add(newSibling);
            LogManager logManager = env.getLogManager();
            long newSiblingLsn = newSibling.optionalLogProvisional(logManager, parent);
            long myNewLsn = this.optionalLogProvisional(logManager, parent);
            if (low == 0) {
                parent.prepareForSlotReuse(childIndex);
                parent.updateSplitSlot(childIndex, newSibling, newSiblingLsn, newIdKey);
                byte[] ourKey = this.getKey(0);
                boolean insertOk = parent.insertEntry(new ChildReference(this, ourKey, myNewLsn));
                assert (insertOk);
            } else {
                parent.updateSplitSlot(childIndex, this, myNewLsn, this.getKey(0));
                boolean insertOk = parent.insertEntry(new ChildReference(newSibling, newIdKey, newSiblingLsn));
                assert (insertOk);
            }
            parentLsn = parent.optionalLog(logManager);
            if (parent.isRoot()) {
                parent.setDirty(true);
            }
            assert (!this.isDIN() && !this.isDBIN());
            Evictor evictor = this.getEvictor();
            if (evictor != null) {
                if (this.isBIN() || !newSibling.hasCachedChildrenFlag()) {
                    switch (cacheMode) {
                        case DEFAULT: 
                        case EVICT_LN: 
                        case UNCHANGED: 
                        case KEEP_HOT: {
                            if (this.isUpperIN()) {
                                // empty if block
                            }
                            evictor.addBack(newSibling);
                            break;
                        }
                        case MAKE_COLD: 
                        case EVICT_BIN: {
                            if (this.isBIN()) {
                                evictor.addFront(newSibling);
                                break;
                            }
                            evictor.addBack(newSibling);
                            break;
                        }
                        default: {
                            throw EnvironmentFailureException.unexpectedState("unknown cacheMode: " + (Object)((Object)cacheMode));
                        }
                    }
                }
                if (this.isUpperIN() && haveCachedChildren && !this.hasCachedChildrenFlag()) {
                    evictor.addBack(this);
                }
            }
            this.traceSplit(Level.FINE, parent, newSibling, parentLsn, myNewLsn, newSiblingLsn, splitIndex, idKeyIndex, childIndex);
        }
        finally {
            newSibling.releaseLatch();
        }
    }

    private void updateSplitSlot(int idx, IN child, long lsn, byte[] key) {
        assert (this.isUpperIN());
        long oldSize = this.getEntryInMemorySize(idx);
        this.setLsn(idx, lsn);
        this.setTarget(idx, child);
        if (idx == 0) {
            byte[] existingKey = this.getKey(idx);
            int s = Key.compareKeys(key, existingKey, this.getKeyComparator());
            boolean multiSlotChange = false;
            if (s < 0) {
                multiSlotChange = this.setKeyAndDirty(idx, key);
            }
            if (multiSlotChange) {
                this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
            } else {
                long newSize = this.getEntryInMemorySize(idx);
                this.updateMemorySize(oldSize, newSize);
            }
        } else {
            long newSize = this.getEntryInMemorySize(idx);
            this.updateMemorySize(oldSize, newSize);
        }
        this.setDirty(true);
        assert (this.hasResidentChildren() == this.hasCachedChildrenFlag());
    }

    private void shiftEntriesRight(int index) {
        this.copyEntries(index, index + 1, this.nEntries - index);
        this.clearEntry(index);
        ++this.nEntries;
        this.setDirty(true);
    }

    private void shiftEntriesLeft(int byHowMuch) {
        this.copyEntries(byHowMuch, 0, this.nEntries - byHowMuch);
        for (int i = this.nEntries - byHowMuch; i < this.nEntries; ++i) {
            this.clearEntry(i);
        }
        this.setDirty(true);
    }

    void adjustCursors(IN newSibling, int newSiblingLow, int newSiblingHigh) {
    }

    void adjustCursorsForInsert(int insertIndex) {
    }

    public void prepareForSlotReuse(int idx) {
        assert (!this.isBINDelta());
        if (this.databaseImpl.isDeferredWriteMode()) {
            this.setLsnNoValidation(idx, -1L);
        }
    }

    protected void initMemorySize() {
        this.entryKeyVals = (INKeyRep)this.entryKeyVals.compact(this);
        this.inMemorySize = this.computeMemorySize();
    }

    public boolean verifyMemorySize() {
        long calcMemorySize = this.computeMemorySize();
        if (calcMemorySize != this.inMemorySize) {
            String msg = "-Warning: Out of sync. Should be " + calcMemorySize + " / actual: " + this.inMemorySize + " node: " + this.getNodeId();
            LoggerUtils.envLogMsg(Level.INFO, this.getEnv(), msg);
            System.out.println(msg);
            this.printMemorySize();
            return false;
        }
        return true;
    }

    public long getBudgetedMemorySize() {
        return this.inMemorySize - (long)this.accumulatedDelta;
    }

    public long resetAndGetMemorySize() {
        this.accumulatedDelta = 0;
        return this.inMemorySize;
    }

    public long getTreeAdminMemorySize() {
        return 0L;
    }

    public long getInMemorySize() {
        return this.inMemorySize;
    }

    private long getEntryInMemorySize(int idx) {
        Node target;
        byte[] key;
        long ret = 0L;
        if (!this.entryKeyVals.accountsForKeyByteMemUsage() && (key = (byte[])this.entryKeyVals.get(idx)) != null) {
            ret += (long)MemoryBudget.byteArraySize(key.length);
        }
        if ((target = (Node)this.entryTargets.get(idx)) != null) {
            ret += target.getMemorySizeIncludedByParent();
        }
        return ret;
    }

    public long computeMemorySize() {
        long calcMemorySize = this.getFixedMemoryOverhead();
        calcMemorySize += (long)MemoryBudget.byteArraySize(this.entryStates.length);
        calcMemorySize += (long)this.computeLsnOverhead();
        for (int i = 0; i < this.nEntries; ++i) {
            calcMemorySize += this.getEntryInMemorySize(i);
        }
        if (this.keyPrefix != null) {
            calcMemorySize += (long)MemoryBudget.byteArraySize(this.keyPrefix.length);
        }
        if (this.provisionalObsolete != null) {
            calcMemorySize += (long)this.provisionalObsolete.getMemorySize();
        }
        calcMemorySize += this.entryTargets.calculateMemorySize();
        return calcMemorySize += this.entryKeyVals.calculateMemorySize();
    }

    protected long printMemorySize() {
        long inOverhead = this.getFixedMemoryOverhead();
        long statesOverhead = MemoryBudget.byteArraySize(this.entryStates.length);
        int lsnOverhead = this.computeLsnOverhead();
        int entryOverhead = 0;
        for (int i = 0; i < this.nEntries; ++i) {
            entryOverhead = (int)((long)entryOverhead + this.getEntryInMemorySize(i));
        }
        int keyPrefixOverhead = this.keyPrefix != null ? MemoryBudget.byteArraySize(this.keyPrefix.length) : 0;
        int provisionalOverhead = this.provisionalObsolete != null ? this.provisionalObsolete.getMemorySize() : 0;
        long targetRepOverhead = this.entryTargets.calculateMemorySize();
        long keyRepOverhead = this.entryKeyVals.calculateMemorySize();
        long total = inOverhead + statesOverhead + (long)lsnOverhead + (long)entryOverhead + (long)keyPrefixOverhead + (long)provisionalOverhead + targetRepOverhead + keyRepOverhead;
        System.out.println(" nEntries:" + this.nEntries + "/" + this.entryStates.length + " in: " + inOverhead + " states: " + statesOverhead + " entry: " + entryOverhead + " lsn: " + lsnOverhead + " keyPrefix: " + keyPrefixOverhead + " provisional: " + provisionalOverhead + " targetRep(" + this.entryTargets.getType() + "): " + targetRepOverhead + " keyRep(" + this.entryKeyVals.getType() + "): " + keyRepOverhead + " Total: " + total + " inMemorySize: " + this.inMemorySize);
        return total;
    }

    private boolean assertPrintMemorySize() {
        this.printMemorySize();
        return true;
    }

    private int computeLsnOverhead() {
        return this.entryLsnLongArray == null ? MemoryBudget.byteArraySize(this.entryLsnByteArray.length) : MemoryBudget.ARRAY_OVERHEAD + this.entryLsnLongArray.length * 8;
    }

    protected long getFixedMemoryOverhead() {
        return MemoryBudget.IN_FIXED_OVERHEAD;
    }

    protected void updateRepCacheStats(boolean increment) {
        this.entryKeyVals.updateCacheStats(increment, this);
        this.entryTargets.updateCacheStats(increment, this);
    }

    public long compactMemory() {
        long oldSize = this.inMemorySize;
        INKeyRep oldKeyRep = this.entryKeyVals;
        this.entryTargets = (INTargetRep)this.entryTargets.compact(this);
        this.entryKeyVals = (INKeyRep)this.entryKeyVals.compact(this);
        if (this.entryKeyVals != oldKeyRep) {
            this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
            return oldSize - this.inMemorySize;
        }
        return oldSize - this.inMemorySize;
    }

    protected int getCompactMaxKeyLength() {
        return this.getEnv().getCompactMaxKeyLength();
    }

    protected void updateMemorySize(long oldSize, long newSize) {
        long delta = newSize - oldSize;
        this.changeMemorySize(delta);
    }

    void updateMemorySize(Node oldNode, Node newNode) {
        long delta = 0L;
        if (newNode != null) {
            delta = newNode.getMemorySizeIncludedByParent();
        }
        if (oldNode != null) {
            delta -= oldNode.getMemorySizeIncludedByParent();
        }
        this.changeMemorySize(delta);
    }

    void changeMemorySize(long delta) {
        if (delta == 0L) {
            return;
        }
        this.inMemorySize += delta;
        if (this.inListResident) {
            EnvironmentImpl env = this.getEnv();
            assert (this.inMemorySize >= this.getFixedMemoryOverhead() || !env.isValid()) : "delta: " + delta + " inMemorySize: " + this.inMemorySize + " overhead: " + this.getFixedMemoryOverhead() + " computed: " + this.computeMemorySize() + " dump: " + this.toString() + this.assertPrintMemorySize();
            this.accumulatedDelta = (int)((long)this.accumulatedDelta + delta);
            if (this.accumulatedDelta > ACCUMULATED_LIMIT || this.accumulatedDelta < -ACCUMULATED_LIMIT) {
                this.updateMemoryBudget();
            }
        }
    }

    public void updateMemoryBudget() {
        EnvironmentImpl env = this.getEnv();
        env.getInMemoryINs().memRecalcUpdate(this, this.accumulatedDelta);
        env.getMemoryBudget().updateTreeMemoryUsage(this.accumulatedDelta);
        this.accumulatedDelta = 0;
    }

    public void setInListResident(boolean resident) {
        if (!resident) {
            this.entryTargets.updateCacheStats(resident, this);
            this.entryKeyVals.updateCacheStats(resident, this);
        }
        this.inListResident = resident;
        if (resident) {
            this.entryTargets.updateCacheStats(resident, this);
            this.entryKeyVals.updateCacheStats(resident, this);
        }
    }

    public boolean getInListResident() {
        return this.inListResident;
    }

    public IN getPrevLRUNode() {
        return this.prevLRUNode;
    }

    public void setPrevLRUNode(IN node) {
        this.prevLRUNode = node;
    }

    public IN getNextLRUNode() {
        return this.nextLRUNode;
    }

    public void setNextLRUNode(IN node) {
        this.nextLRUNode = node;
    }

    public long partialEviction() {
        return 0L;
    }

    public final boolean hasResidentChildren() {
        for (int i = 0; i < this.getNEntries(); ++i) {
            if (!this.isResident(i)) continue;
            return true;
        }
        return false;
    }

    public void setProhibitNextDelta() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateSubtreeBeforeDelete(int index) throws DatabaseException {
        if (index >= this.nEntries) {
            return true;
        }
        IN child = this.fetchIN(index);
        boolean needToLatch = !child.isLatchExclusiveOwner();
        try {
            if (needToLatch) {
                child.latch(CacheMode.UNCHANGED);
            }
            boolean bl = child.isValidForDelete();
            return bl;
        }
        finally {
            if (needToLatch && this.isLatchOwner()) {
                child.releaseLatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isValidForDelete() throws DatabaseException {
        assert (!this.isBINDelta());
        if (this.nEntries > 1) {
            return false;
        }
        if (this.nEntries == 1) {
            IN child = this.fetchIN(0);
            child.latch(CacheMode.UNCHANGED);
            boolean ret = false;
            try {
                if (child.isBINDelta()) {
                    boolean bl = false;
                    return bl;
                }
                ret = child.isValidForDelete();
            }
            finally {
                child.releaseLatch();
            }
            return ret;
        }
        return true;
    }

    @Override
    public final void verify(byte[] maxKey) throws EnvironmentFailureException {
    }

    @Override
    final void rebuildINList(INList inList) throws DatabaseException {
        this.initMemorySize();
        inList.add(this);
        boolean hasCachedChildren = false;
        for (int i = 0; i < this.nEntries; ++i) {
            Node n = this.getTarget(i);
            if (n == null) continue;
            n.rebuildINList(inList);
            hasCachedChildren = true;
        }
        Evictor evictor = this.getEvictor();
        if (this.isUpperIN()) {
            if (hasCachedChildren) {
                this.setHasCachedChildrenFlag(true);
            } else {
                this.setHasCachedChildrenFlag(false);
                if (evictor != null && !this.isDIN()) {
                    evictor.addBack(this);
                }
            }
        } else if (this.isBIN() && !this.isDBIN() && evictor != null) {
            evictor.addBack(this);
        }
    }

    @Override
    final void accountForSubtreeRemoval(INList inList, LocalUtilizationTracker localTracker) throws DatabaseException {
        assert (!this.isBINDelta(false));
        if (this.nEntries > 1) {
            throw EnvironmentFailureException.unexpectedState("Found non-deletable IN " + this.getNodeId() + " while flushing INList. nEntries = " + this.nEntries);
        }
        if (this.getLastFullVersion() != -1L) {
            localTracker.countObsoleteNode(this.getLastFullVersion(), this.getLogType(), 0, this.databaseImpl);
        }
        if (this.getLastDeltaVersion() != -1L) {
            localTracker.countObsoleteNode(this.getLastDeltaVersion(), this.getLogType(), 0, this.databaseImpl);
        }
        if (this.nEntries > 0) {
            if (this.isBIN()) {
                assert (this.isEntryKnownDeleted(0));
            } else {
                Node n = this.getTarget(0);
                n.accountForSubtreeRemoval(inList, localTracker);
            }
        }
    }

    @Override
    final void accountForDeferredWriteSubtreeRemoval(INList inList, IN subtreeParent) throws DatabaseException {
        assert (!this.isBINDelta(false));
        if (this.nEntries > 1) {
            throw EnvironmentFailureException.unexpectedState("Found non-deletable IN " + this.getNodeId() + " while flushing INList. nEntries = " + this.nEntries);
        }
        Evictor evictor = this.getEvictor();
        if (this.getLastFullVersion() != -1L) {
            subtreeParent.trackProvisionalObsolete(this, this.getLastFullVersion(), false, 0);
        }
        if (this.getLastDeltaVersion() != -1L) {
            subtreeParent.trackProvisionalObsolete(this, this.getLastDeltaVersion(), false, 0);
        }
        if (this.nEntries > 0) {
            if (this.isBIN()) {
                assert (this.isEntryKnownDeleted(0));
            } else {
                Node n = this.getTarget(0);
                assert (n != null && !n.isBINDelta(false));
                n.accountForDeferredWriteSubtreeRemoval(inList, subtreeParent);
            }
        }
    }

    void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processIN(this, this.getNodeId(), this.getLevel());
    }

    void setLastLoggedLsn(long lsn) {
        this.setLastFullLsn(lsn);
    }

    public long getLastLoggedVersion() {
        return this.getLastFullVersion();
    }

    public final void setLastFullLsn(long lsn) {
        this.lastFullVersion = lsn;
    }

    public final long getLastFullVersion() {
        return this.lastFullVersion;
    }

    public long getLastDeltaVersion() {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logDirtyChildren() throws DatabaseException {
        assert (!this.isBINDelta());
        EnvironmentImpl envImpl = this.getDatabase().getDbEnvironment();
        for (int i = 0; i < this.getNEntries(); ++i) {
            IN child = (IN)this.getTarget(i);
            if (child == null) continue;
            child.latch(CacheMode.UNCHANGED);
            try {
                if (!child.getDirty()) continue;
                child.logDirtyChildren();
                long childLsn = child.log(envImpl.getLogManager(), false, false, true, true, this);
                this.updateEntry(i, childLsn, 0);
                continue;
            }
            finally {
                child.releaseLatch();
            }
        }
    }

    public final long log(LogManager logManager) throws DatabaseException {
        return this.logInternal(logManager, false, false, Provisional.NO, false, null);
    }

    public final long log(LogManager logManager, boolean allowDeltas, boolean allowCompress, boolean isProvisional, boolean backgroundIO, IN parent) throws DatabaseException {
        return this.logInternal(logManager, allowDeltas, allowCompress, isProvisional ? Provisional.YES : Provisional.NO, backgroundIO, parent);
    }

    public final long log(LogManager logManager, boolean allowDeltas, boolean allowCompress, Provisional provisional, boolean backgroundIO, IN parent) throws DatabaseException {
        return this.logInternal(logManager, allowDeltas, allowCompress, provisional, backgroundIO, parent);
    }

    public final long optionalLog(LogManager logManager) throws DatabaseException {
        if (this.databaseImpl.isDeferredWriteMode()) {
            return this.getLastLoggedVersion();
        }
        return this.logInternal(logManager, false, false, Provisional.NO, false, null);
    }

    public final long optionalLogProvisional(LogManager logManager, IN parent) throws DatabaseException {
        if (this.databaseImpl.isDeferredWriteMode()) {
            return this.getLastLoggedVersion();
        }
        return this.logInternal(logManager, false, false, Provisional.YES, false, parent);
    }

    private long logInternal(LogManager logManager, boolean allowDeltas, boolean allowCompress, Provisional provisional, boolean backgroundIO, IN parent) throws DatabaseException {
        INLogItem item = new INLogItem();
        item.provisional = provisional;
        item.parent = parent;
        item.repContext = ReplicationContext.NO_REPLICATE;
        INLogContext context = new INLogContext();
        context.nodeDb = this.getDatabase();
        context.backgroundIO = backgroundIO;
        context.allowDeltas = allowDeltas;
        context.allowCompress = allowCompress;
        this.beforeLog(logManager, item, context);
        logManager.log(item, context);
        this.afterLog(logManager, item, context);
        return item.newLsn;
    }

    public void beforeLog(LogManager logManager, INLogItem item, INLogContext context) {
        this.beforeLogCommon(item, context, this.lastFullVersion, -1L);
        item.entry = new INLogEntry<IN>(this);
    }

    final void beforeLogCommon(INLogItem item, INLogContext context, long oldLsn, long auxOldLsn) {
        assert (this.isLatchExclusiveOwner());
        assert (item.parent == null || item.parent.isLatchExclusiveOwner());
        if (this.countObsoleteDuringLogging(item.provisional)) {
            item.oldLsn = oldLsn;
            item.auxOldLsn = auxOldLsn;
            context.packedObsoleteInfo = this.provisionalObsolete;
        }
    }

    public void afterLog(LogManager logManager, INLogItem item, INLogContext context) {
        this.afterLogCommon(logManager, item, context, this.lastFullVersion, -1L);
        this.setLastFullLsn(item.newLsn);
    }

    final void afterLogCommon(LogManager logManager, INLogItem item, INLogContext context, long oldLsn, long auxOldLsn) {
        if (this.countObsoleteDuringLogging(item.provisional)) {
            this.discardProvisionalObsolete(logManager);
        } else if (item.parent != null) {
            if (oldLsn != -1L) {
                item.parent.trackProvisionalObsolete(this, oldLsn, false, 0);
            }
            if (auxOldLsn != -1L) {
                item.parent.trackProvisionalObsolete(this, auxOldLsn, false, 0);
            }
        }
        this.setDirty(false);
        Evictor evictor = this.getEvictor();
        if (evictor != null) {
            evictor.moveToMixedLRU(this);
        }
        if (item.parent != null && item.parentIndex >= 0) {
            item.parent.clearKnownDeleted(item.parentIndex);
            item.parent.clearPendingDeleted(item.parentIndex);
        }
    }

    private boolean countObsoleteDuringLogging(Provisional provisional) {
        return provisional != Provisional.YES || this.databaseImpl.isTemporary();
    }

    final void trackProvisionalObsolete(IN childIN, long obsoleteLsn, boolean isObsoleteLN, int obsoleteSize) {
        int oldMemSize;
        int n = oldMemSize = this.provisionalObsolete != null ? this.provisionalObsolete.getMemorySize() : 0;
        if (childIN != null && childIN.provisionalObsolete != null) {
            if (this.provisionalObsolete != null) {
                this.provisionalObsolete.copyObsoleteInfo(childIN.provisionalObsolete);
            } else {
                this.provisionalObsolete = childIN.provisionalObsolete;
            }
            childIN.changeMemorySize(0 - childIN.provisionalObsolete.getMemorySize());
            childIN.provisionalObsolete = null;
        }
        if (obsoleteLsn != -1L) {
            if (this.provisionalObsolete == null) {
                this.provisionalObsolete = new PackedObsoleteInfo();
            }
            this.provisionalObsolete.addObsoleteInfo(obsoleteLsn, isObsoleteLN, obsoleteSize);
        }
        this.updateMemorySize(oldMemSize, this.provisionalObsolete != null ? (long)this.provisionalObsolete.getMemorySize() : 0L);
    }

    private void discardProvisionalObsolete(LogManager logManager) throws DatabaseException {
        if (this.provisionalObsolete != null) {
            this.changeMemorySize(0 - this.provisionalObsolete.getMemorySize());
            this.provisionalObsolete = null;
        }
    }

    public void mutateToFullBIN() {
    }

    @Override
    public final LogEntryType getGenericLogType() {
        return this.getLogType();
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_IN;
    }

    public final int getDeltasLogSize() {
        return this.getLogSize(true);
    }

    @Override
    public int getLogSize() {
        return this.getLogSize(false);
    }

    final int getLogSize(boolean deltasOnly) {
        boolean compactLsnsRep;
        int size = super.getLogSize();
        size += LogUtils.getPackedLongLogSize(this.nodeId);
        size += LogUtils.getByteArrayLogSize(this.identifierKey);
        if (this.keyPrefix != null) {
            size += LogUtils.getByteArrayLogSize(this.keyPrefix);
        }
        ++size;
        int nEntriesToWrite = this.getNEntriesToWrite(deltasOnly);
        size += LogUtils.getPackedIntLogSize(nEntriesToWrite);
        size += LogUtils.getPackedIntLogSize(this.level);
        size += LogUtils.getPackedIntLogSize(deltasOnly ? nEntriesToWrite : this.getMaxEntries());
        size += LogUtils.getBooleanLogSize();
        boolean bl = compactLsnsRep = this.entryLsnLongArray == null;
        if (compactLsnsRep) {
            size += 4;
        }
        boolean hasLastLoggedSize = this.isLastLoggedSizeStored();
        for (int i = 0; i < this.nEntries; ++i) {
            if (deltasOnly && !this.isDirty(i)) continue;
            size += LogUtils.getByteArrayLogSize((byte[])this.entryKeyVals.get(i)) + (compactLsnsRep ? 4 : LogUtils.getLongLogSize()) + 1;
            if (!hasLastLoggedSize) continue;
            size += LogUtils.getPackedIntLogSize(this.getLastLoggedSize(i));
        }
        return size;
    }

    private int getNEntriesToWrite(boolean deltasOnly) {
        if (!deltasOnly) {
            return this.nEntries;
        }
        return this.getNDeltas();
    }

    public final int getNDeltas() {
        int n = 0;
        for (int i = 0; i < this.nEntries; ++i) {
            if (!this.isDirty(i)) continue;
            ++n;
        }
        return n;
    }

    public final void writeDeltasToLog(ByteBuffer logBuffer) {
        this.writeToLog(logBuffer, true);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        this.writeToLog(logBuffer, false);
    }

    final void writeToLog(ByteBuffer logBuffer, boolean deltasOnly) {
        super.writeToLog(logBuffer);
        LogUtils.writePackedLong(logBuffer, this.nodeId);
        boolean hasKeyPrefix = this.keyPrefix != null;
        LogUtils.writeByteArray(logBuffer, this.identifierKey);
        boolean hasLastLoggedSize = this.isLastLoggedSizeStored();
        byte booleans = (byte)(this.isRoot() ? 1 : 0);
        booleans = (byte)(booleans | (hasKeyPrefix ? 2 : 0));
        booleans = (byte)(booleans | (hasLastLoggedSize ? 4 : 0));
        logBuffer.put(booleans);
        if (hasKeyPrefix) {
            LogUtils.writeByteArray(logBuffer, this.keyPrefix);
        }
        int nEntriesToWrite = this.getNEntriesToWrite(deltasOnly);
        LogUtils.writePackedInt(logBuffer, nEntriesToWrite);
        LogUtils.writePackedInt(logBuffer, this.level);
        LogUtils.writePackedInt(logBuffer, deltasOnly ? nEntriesToWrite : this.getMaxEntries());
        boolean compactLsnsRep = this.entryLsnLongArray == null;
        LogUtils.writeBoolean(logBuffer, compactLsnsRep);
        if (compactLsnsRep) {
            LogUtils.writeInt(logBuffer, (int)this.baseFileNumber);
        }
        for (int i = 0; i < this.nEntries; ++i) {
            if (deltasOnly && !this.isDirty(i)) continue;
            LogUtils.writeByteArray(logBuffer, (byte[])this.entryKeyVals.get(i));
            assert (this.checkForNullLSN(i)) : "logging IN " + this.getNodeId() + " with null lsn child " + " db=" + this.databaseImpl.getDebugName() + " isDeferredWriteMode=" + this.databaseImpl.isDeferredWriteMode() + " isTemporary=" + this.databaseImpl.isTemporary();
            if (compactLsnsRep) {
                int offset = i << 2;
                int fileOffset = this.getFileOffset(offset);
                logBuffer.put(this.getFileNumberOffset(offset));
                logBuffer.put((byte)(fileOffset >>> 0 & 0xFF));
                logBuffer.put((byte)(fileOffset >>> 8 & 0xFF));
                logBuffer.put((byte)(fileOffset >>> 16 & 0xFF));
            } else {
                LogUtils.writeLong(logBuffer, this.entryLsnLongArray[i]);
            }
            logBuffer.put(this.entryStates[i]);
            if (!deltasOnly) {
                int n = i;
                this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFFD);
            }
            if (!hasLastLoggedSize) continue;
            LogUtils.writePackedInt(logBuffer, this.getLastLoggedSize(i));
        }
    }

    private boolean checkForNullLSN(int index) {
        boolean ok = this.isBIN() ? this.getLsn(index) != -1L || (this.entryStates[index] & 1) != 0 : this.getLsn(index) != -1L;
        return ok;
    }

    public final void readDeltasFromLog(ByteBuffer itemBuffer, int entryVersion) {
        this.readFromLog(itemBuffer, entryVersion, true);
        this.setBINDelta(true);
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        this.readFromLog(itemBuffer, entryVersion, false);
    }

    final void readFromLog(ByteBuffer itemBuffer, int entryVersion, boolean deltasOnly) {
        boolean hasLastLoggedSize;
        super.readFromLog(itemBuffer, entryVersion);
        boolean unpacked = entryVersion < 6;
        this.nodeId = LogUtils.readLong(itemBuffer, unpacked);
        this.identifierKey = LogUtils.readByteArray(itemBuffer, unpacked);
        byte booleans = itemBuffer.get();
        this.setIsRootFlag((booleans & 1) != 0);
        if ((booleans & 2) != 0) {
            this.keyPrefix = LogUtils.readByteArray(itemBuffer, unpacked);
        }
        boolean bl = hasLastLoggedSize = (booleans & 4) != 0;
        assert (!hasLastLoggedSize || entryVersion >= 9);
        this.nEntries = LogUtils.readInt(itemBuffer, unpacked);
        this.level = LogUtils.readInt(itemBuffer, unpacked);
        int length = LogUtils.readInt(itemBuffer, unpacked);
        this.entryTargets = INTargetRep.NONE;
        this.entryKeyVals = new INKeyRep.Default(length);
        this.baseFileNumber = -1L;
        long storedBaseFileNumber = -1L;
        if (disableCompactLsns) {
            this.entryLsnByteArray = null;
            this.entryLsnLongArray = new long[length];
        } else {
            this.entryLsnByteArray = new byte[length << 2];
            this.entryLsnLongArray = null;
        }
        this.entryStates = new byte[length];
        boolean compactLsnsRep = false;
        if (entryVersion > 1 && (compactLsnsRep = LogUtils.readBoolean(itemBuffer))) {
            storedBaseFileNumber = this.baseFileNumber = (long)(LogUtils.readInt(itemBuffer) & 0xFFFFFFFF);
        }
        for (int i = 0; i < this.nEntries; ++i) {
            long lsn;
            this.entryKeyVals = (INKeyRep)this.entryKeyVals.set(i, LogUtils.readByteArray(itemBuffer, unpacked), this);
            if (compactLsnsRep) {
                byte fileNumberOffset = itemBuffer.get();
                int fileOffset = itemBuffer.get() & 0xFF;
                fileOffset |= (itemBuffer.get() & 0xFF) << 8;
                lsn = (fileOffset |= (itemBuffer.get() & 0xFF) << 16) == 0xFFFFFF ? -1L : DbLsn.makeLsn(storedBaseFileNumber + (long)fileNumberOffset, fileOffset);
            } else {
                lsn = LogUtils.readLong(itemBuffer);
            }
            this.setLsnElement(i, lsn);
            byte entryState = itemBuffer.get();
            if (!deltasOnly) {
                entryState = (byte)(entryState & 0xFFFFFFFD);
            }
            entryState = (byte)(entryState & 0xFFFFFFFB);
            if (lsn == -1L) {
                entryState = (byte)(entryState | 1);
            }
            this.entryStates[i] = entryState;
            if (!hasLastLoggedSize) continue;
            this.setLastLoggedSizeUnconditional(i, LogUtils.readPackedInt(itemBuffer));
        }
        this.needDupKeyConversion = entryVersion < 8;
    }

    @Override
    public final boolean logicalEquals(Loggable other) {
        return false;
    }

    @Override
    public final void dumpLog(StringBuilder sb, boolean verbose) {
        boolean compactLsnsRep;
        sb.append(this.beginTag());
        sb.append("<nodeId val=\"");
        sb.append(this.nodeId);
        sb.append("\"/>");
        sb.append(Key.dumpString(this.identifierKey, 0));
        sb.append("<isRoot val=\"");
        sb.append(this.isRoot());
        sb.append("\"/>");
        sb.append("<level val=\"");
        sb.append(Integer.toHexString(this.level));
        sb.append("\"/>");
        if (this.keyPrefix != null) {
            sb.append("<keyPrefix>");
            sb.append(Key.dumpString(this.keyPrefix, 0));
            sb.append("</keyPrefix>");
        }
        sb.append("<entries numEntries=\"");
        sb.append(this.nEntries);
        sb.append("\" length=\"");
        sb.append(this.getMaxEntries());
        boolean bl = compactLsnsRep = this.entryLsnLongArray == null;
        if (compactLsnsRep) {
            sb.append("\" baseFileNumber=\"");
            sb.append(this.baseFileNumber);
        }
        sb.append("\">");
        if (verbose) {
            for (int i = 0; i < this.nEntries; ++i) {
                sb.append("<ref kd=\"").append(this.isEntryKnownDeleted(i));
                sb.append("\" pd=\"").append(this.isEntryPendingDeleted(i));
                sb.append("\" logSize=\"").append(this.getLastLoggedSize(i));
                sb.append("\">");
                sb.append(Key.dumpString((byte[])this.entryKeyVals.get(i), 0));
                sb.append(DbLsn.toString(this.getLsn(i)));
                sb.append("</ref>");
            }
        }
        sb.append("</entries>");
        this.dumpLogAdditional(sb);
        sb.append(this.endTag());
    }

    protected void dumpLogAdditional(StringBuilder sb) {
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    final void dumpKeys() {
        for (int i = 0; i < this.nEntries; ++i) {
            System.out.println(Key.dumpString((byte[])this.entryKeyVals.get(i), 0));
        }
    }

    @Override
    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuilder sb = new StringBuilder();
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.beginTag());
            sb.append('\n');
        }
        if (dumpTags) {
            sb.append("<nodeId val=\"");
            sb.append(this.nodeId);
            sb.append("\"/>");
        } else {
            sb.append(this.nodeId);
        }
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<idkey>");
        sb.append(this.identifierKey == null ? "" : Key.dumpString(this.identifierKey, 0));
        sb.append("</idkey>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<prefix>");
        sb.append(this.keyPrefix == null ? "" : Key.dumpString(this.keyPrefix, 0));
        sb.append("</prefix>\n");
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<dirty val=\"").append(this.getDirty()).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<generation val=\"").append(this.generation).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<level val=\"");
        sb.append(Integer.toHexString(this.level)).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<isRoot val=\"").append(this.isRoot()).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<isBINDelta val=\"").append(this.isBINDelta(false)).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<entries nEntries=\"");
        sb.append(this.nEntries);
        sb.append("\">");
        sb.append('\n');
        for (int i = 0; i < this.nEntries; ++i) {
            sb.append(TreeUtils.indent(nSpaces + 4));
            sb.append("<entry id=\"" + i + "\">");
            sb.append('\n');
            if (this.getLsn(i) == -1L) {
                sb.append(TreeUtils.indent(nSpaces + 6));
                sb.append("<lsn/>");
            } else {
                sb.append(DbLsn.dumpString(this.getLsn(i), nSpaces + 6));
            }
            sb.append('\n');
            if (this.entryKeyVals.get(i) == null) {
                sb.append(TreeUtils.indent(nSpaces + 6));
                sb.append("<key/>");
            } else {
                sb.append(Key.dumpString((byte[])this.entryKeyVals.get(i), nSpaces + 6));
            }
            sb.append('\n');
            if (this.entryTargets.get(i) == null) {
                sb.append(TreeUtils.indent(nSpaces + 6));
                sb.append("<target/>");
            } else {
                sb.append(((Node)this.entryTargets.get(i)).dumpString(nSpaces + 6, true));
            }
            sb.append('\n');
            sb.append(TreeUtils.indent(nSpaces + 6));
            IN.dumpDeletedState(sb, this.getState(i));
            sb.append("<dirty val=\"").append(this.isDirty(i)).append("\"/>");
            sb.append('\n');
            sb.append(TreeUtils.indent(nSpaces + 4));
            sb.append("</entry>");
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("</entries>");
        sb.append('\n');
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.endTag());
        }
        return sb.toString();
    }

    static void dumpDeletedState(StringBuilder sb, byte state) {
        sb.append("<knownDeleted val=\"");
        sb.append(IN.isStateKnownDeleted(state)).append("\"/>");
        sb.append("<pendingDeleted val=\"");
        sb.append(IN.isStatePendingDeleted(state)).append("\"/>");
    }

    @Override
    public String toString() {
        return this.dumpString(0, true);
    }

    public String shortClassName() {
        return "IN";
    }

    private void traceSplit(Level level, IN parent, IN newSibling, long parentLsn, long myNewLsn, long newSiblingLsn, int splitIndex, int idKeyIndex, int childIndex) {
        Logger logger = this.getEnv().getLogger();
        if (logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(TRACE_SPLIT);
            sb.append(" parent=");
            sb.append(parent.getNodeId());
            sb.append(" child=");
            sb.append(this.getNodeId());
            sb.append(" newSibling=");
            sb.append(newSibling.getNodeId());
            sb.append(" parentLsn = ");
            sb.append(DbLsn.getNoFormatString(parentLsn));
            sb.append(" childLsn = ");
            sb.append(DbLsn.getNoFormatString(myNewLsn));
            sb.append(" newSiblingLsn = ");
            sb.append(DbLsn.getNoFormatString(newSiblingLsn));
            sb.append(" splitIdx=");
            sb.append(splitIndex);
            sb.append(" idKeyIdx=");
            sb.append(idKeyIndex);
            sb.append(" childIdx=");
            sb.append(childIndex);
            LoggerUtils.logMsg(logger, this.databaseImpl.getDbEnvironment(), level, sb.toString());
        }
    }

    private void traceDelete(Level level, int index) {
        Logger logger = this.databaseImpl.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(TRACE_DELETE);
            sb.append(" in=").append(this.getNodeId());
            sb.append(" index=");
            sb.append(index);
            LoggerUtils.logMsg(logger, this.databaseImpl.getDbEnvironment(), level, sb.toString());
        }
    }

    public final void setFetchINHook(TestHook hook) {
        this.fetchINHook = hook;
    }

    static {
        ACCUMULATED_LIMIT = 1000;
    }
}

