/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.SizeofMarker;

public abstract class INLongRep {
    public static INLongRep EMPTY_REP = new INLongRep(){

        @Override
        public long get(int idx) {
            return 0L;
        }

        @Override
        public INLongRep set(int idx, long val, IN parent, int minLength) {
            if (val == 0L) {
                return this;
            }
            DefaultRep newCache = new DefaultRep(parent.getMaxEntries(), minLength);
            parent.updateMemorySize(this.getMemorySize(), ((INLongRep)newCache).getMemorySize());
            return ((INLongRep)newCache).set(idx, val, parent, minLength);
        }

        @Override
        public INLongRep copy(int from, int to, int n) {
            return this;
        }

        @Override
        public long getMemorySize() {
            return 0L;
        }
    };

    public abstract long get(int var1);

    public abstract INLongRep set(int var1, long var2, IN var4, int var5);

    public abstract INLongRep copy(int var1, int var2, int var3);

    public abstract long getMemorySize();

    public static class DefaultRep
    extends INLongRep {
        private static long[] MAX_VALUE = new long[]{0L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, Long.MAX_VALUE};
        private final byte[] byteArray;
        private final int bytesPerValue;

        public DefaultRep(int capacity, int nBytes) {
            assert (capacity >= 1);
            assert (nBytes >= 1);
            assert (nBytes <= 8);
            this.bytesPerValue = nBytes;
            this.byteArray = new byte[capacity * this.bytesPerValue];
        }

        public DefaultRep(SizeofMarker marker) {
            this.bytesPerValue = 0;
            this.byteArray = null;
        }

        @Override
        public long get(int idx) {
            int i = idx * this.bytesPerValue;
            int end = i + this.bytesPerValue;
            long val = this.byteArray[i] & 0xFF;
            ++i;
            while (i < end) {
                val <<= 8;
                val |= (long)(this.byteArray[i] & 0xFF);
                ++i;
            }
            return val;
        }

        @Override
        public DefaultRep set(int idx, long val, IN parent, int minLength) {
            assert (idx >= 0);
            assert (idx < this.byteArray.length / this.bytesPerValue);
            assert (val >= 0L);
            if (val > MAX_VALUE[this.bytesPerValue]) {
                int capacity = this.byteArray.length / this.bytesPerValue;
                DefaultRep newCache = new DefaultRep(capacity, this.bytesPerValue + 1);
                parent.updateMemorySize(this.getMemorySize(), newCache.getMemorySize());
                newCache = newCache.set(idx, val, parent, minLength);
                for (int i = 0; i < capacity; ++i) {
                    if (i == idx) continue;
                    newCache = newCache.set(i, this.get(i), parent, minLength);
                }
                return newCache;
            }
            int i = (idx + 1) * this.bytesPerValue - 1;
            int end = i - this.bytesPerValue;
            this.byteArray[i] = (byte)(val & 0xFFL);
            --i;
            while (i > end) {
                this.byteArray[i] = (byte)((val >>= 8) & 0xFFL);
                --i;
            }
            assert ((val & 0xFFFFFFFFFFFFFF00L) == 0L) : val;
            return this;
        }

        @Override
        public DefaultRep copy(int from, int to, int n) {
            System.arraycopy(this.byteArray, from * this.bytesPerValue, this.byteArray, to * this.bytesPerValue, n * this.bytesPerValue);
            return this;
        }

        @Override
        public long getMemorySize() {
            return MemoryBudget.DEFAULT_LONG_REP_OVERHEAD + MemoryBudget.byteArraySize(this.byteArray.length);
        }
    }
}

