/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;

public class BuddyLocker
extends BasicLocker {
    private final Locker buddy;

    protected BuddyLocker(EnvironmentImpl env, Locker buddy) {
        super(env, buddy.getDefaultNoWait());
        this.buddy = buddy;
        buddy.addBuddy(this);
    }

    public static BuddyLocker createBuddyLocker(EnvironmentImpl env, Locker buddy) throws DatabaseException {
        return new BuddyLocker(env, buddy);
    }

    @Override
    void close() {
        super.close();
        this.buddy.removeBuddy(this);
    }

    Locker getBuddy() {
        return this.buddy;
    }

    @Override
    public Txn getTxnLocker() {
        return this.buddy.getTxnLocker();
    }

    @Override
    public Transaction getTransaction() {
        return this.buddy.getTransaction();
    }

    @Override
    public void releaseNonTxnLocks() throws DatabaseException {
        super.releaseNonTxnLocks();
        this.buddy.releaseNonTxnLocks();
    }

    @Override
    public boolean sharesLocksWith(Locker other) {
        if (super.sharesLocksWith(other)) {
            return true;
        }
        return this.buddy == other;
    }

    @Override
    public long getLockTimeout() {
        return this.buddy.getLockTimeout();
    }

    @Override
    public long getTxnTimeout() {
        return this.buddy.getTxnTimeout();
    }

    @Override
    public void setLockTimeout(long timeout) {
        this.buddy.setLockTimeout(timeout);
    }

    @Override
    public void setTxnTimeout(long timeout) {
        this.buddy.setTxnTimeout(timeout);
    }

    @Override
    public boolean isTimedOut() {
        return this.buddy.isTimedOut();
    }

    @Override
    public void setOnlyAbortable(OperationFailureException cause) {
        this.buddy.setOnlyAbortable(cause);
    }

    @Override
    public void checkPreempted(Locker allowPreemptedLocker) throws OperationFailureException {
        this.buddy.checkPreempted(allowPreemptedLocker);
    }

    @Override
    public boolean isReplicated() {
        return this.buddy.isReplicated();
    }

    @Override
    public boolean isLocalWrite() {
        return this.buddy.isLocalWrite();
    }
}

