/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockNotAvailableException;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.txn.BuddyLocker;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.StatGroup;
import java.util.HashMap;
import java.util.Map;

public abstract class Locker {
    protected EnvironmentImpl envImpl;
    protected LockManager lockManager;
    protected long id;
    protected boolean readUncommittedDefault;
    protected final boolean defaultNoWait;
    private long lockTimeoutMillis;
    private long txnTimeoutMillis;
    private long txnStartMillis;
    private Lock waitingFor;
    protected Map<Long, BINReference> deleteInfo;
    protected Thread thread;
    private boolean isOpen = true;
    private boolean preemptable = true;
    private RuntimeException preemptedCause;
    private Locker closingLocker;

    protected Locker(EnvironmentImpl envImpl, boolean readUncommittedDefault, boolean noWait, long mandatedId) {
        TxnManager txnManager = envImpl.getTxnManager();
        this.lockManager = txnManager.getLockManager();
        this.id = this.generateId(txnManager, mandatedId);
        this.envImpl = envImpl;
        this.readUncommittedDefault = readUncommittedDefault;
        this.waitingFor = null;
        this.defaultNoWait = noWait;
        this.lockTimeoutMillis = this.getInitialLockTimeout();
        this.txnTimeoutMillis = envImpl.getTxnTimeout();
        this.txnStartMillis = this.txnTimeoutMillis != 0L ? System.currentTimeMillis() : 0L;
        this.thread = Thread.currentThread();
    }

    Locker() {
        this.defaultNoWait = false;
    }

    protected long getInitialLockTimeout() {
        return this.envImpl.getLockTimeout();
    }

    public EnvironmentImpl getEnvironment() {
        return this.envImpl;
    }

    protected abstract long generateId(TxnManager var1, long var2);

    public long getId() {
        return this.id;
    }

    public boolean getDefaultNoWait() {
        return this.defaultNoWait;
    }

    public synchronized long getLockTimeout() {
        return this.lockTimeoutMillis;
    }

    public synchronized void setLockTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("the timeout value cannot be negative");
        }
        if ((double)timeout > Math.pow(2.0, 32.0)) {
            throw new IllegalArgumentException("the timeout value cannot be greater than 2^32");
        }
        this.lockTimeoutMillis = timeout;
    }

    public synchronized void setTxnTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("the timeout value cannot be negative");
        }
        if ((double)timeout > Math.pow(2.0, 32.0)) {
            throw new IllegalArgumentException("the timeout value cannot be greater than 2^32");
        }
        this.txnTimeoutMillis = timeout;
        this.txnStartMillis = this.txnTimeoutMillis != 0L ? System.currentTimeMillis() : 0L;
    }

    public boolean isReadUncommittedDefault() {
        return this.readUncommittedDefault;
    }

    Lock getWaitingFor() {
        return this.waitingFor;
    }

    void setWaitingFor(Lock lock) {
        this.waitingFor = lock;
    }

    public void setOnlyAbortable(OperationFailureException cause) {
    }

    public void setImportunate(boolean importunate) {
    }

    public boolean getImportunate() {
        return false;
    }

    public void setPreemptable(boolean preemptable) {
        this.preemptable = preemptable;
    }

    public boolean getPreemptable() {
        return this.preemptable;
    }

    public void setPreempted() {
        this.preemptedCause = new RuntimeException("Lock was preempted by the replication replayer");
    }

    public void checkPreempted(Locker allowPreemptedLocker) throws OperationFailureException {
        this.throwIfPreempted(allowPreemptedLocker);
    }

    final void throwIfPreempted(Locker allowPreemptedLocker) throws OperationFailureException {
        if (this != allowPreemptedLocker && this.preemptedCause != null) {
            throw this.envImpl.createLockPreemptedException(this, this.preemptedCause);
        }
    }

    final boolean isPreempted() {
        return this.preemptedCause != null;
    }

    public void setClosingLocker(Locker closingLocker) {
        this.closingLocker = closingLocker;
    }

    boolean setAllowMultithreadedAccess(boolean allow) {
        return false;
    }

    protected abstract void checkState(boolean var1) throws DatabaseException;

    public void openCursorHook(DatabaseImpl dbImpl) {
    }

    public boolean isReplicated() {
        return TxnManager.isReplicatedTxn(this.id);
    }

    public boolean isLocalWrite() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    abstract LockResult lockInternal(long var1, LockType var3, boolean var4, boolean var5, DatabaseImpl var6) throws LockConflictException, DatabaseException;

    public LockResult lock(long lsn, LockType lockType, boolean noWait, DatabaseImpl database) throws LockNotAvailableException, LockConflictException {
        LockResult result = this.lockInternal(lsn, lockType, noWait, false, database);
        if (result.getLockGrant() == LockGrantType.DENIED) {
            throw this.lockManager.newLockNotAvailableException(this, "Non-blocking lock was denied.");
        }
        this.checkPreempted(this.closingLocker);
        return result;
    }

    public LockResult nonBlockingLock(long lsn, LockType lockType, boolean jumpAheadOfWaiters, DatabaseImpl database) {
        LockResult result = this.lockInternal(lsn, lockType, true, jumpAheadOfWaiters, database);
        if (result.getLockGrant() != LockGrantType.DENIED) {
            this.checkPreempted(this.closingLocker);
        }
        return result;
    }

    public synchronized boolean releaseLock(long lsn) throws DatabaseException {
        boolean ret = this.lockManager.release(lsn, this);
        this.removeLock(lsn);
        return ret;
    }

    public void demoteLock(long lsn) throws DatabaseException {
        this.lockManager.demote(lsn, this);
    }

    public synchronized void lockAfterLsnChange(long oldLsn, long newLsn, DatabaseImpl dbImpl) {
        if (!this.isValid()) {
            return;
        }
        LockType lockType = this.lockManager.getOwnedLockType(oldLsn, this);
        if (lockType == null) {
            return;
        }
        LockResult lockResult = this.nonBlockingLock(newLsn, lockType, false, dbImpl);
        if (lockResult.getLockGrant() == LockGrantType.DENIED) {
            throw EnvironmentFailureException.unexpectedState("No contention is possible on new LSN: " + DbLsn.getNoFormatString(newLsn) + " old LSN: " + DbLsn.getNoFormatString(oldLsn) + " LockType: " + lockType);
        }
    }

    public abstract void preLogWithoutLock(DatabaseImpl var1);

    public void disallowReplicaWrite() {
    }

    public abstract boolean isTransactional();

    public abstract boolean isSerializableIsolation();

    public abstract boolean isReadCommittedIsolation();

    public abstract Txn getTxnLocker();

    public Transaction getTransaction() {
        return null;
    }

    public abstract Locker newNonTxnLocker() throws DatabaseException;

    public abstract void releaseNonTxnLocks() throws DatabaseException;

    public abstract void nonTxnOperationEnd() throws DatabaseException;

    void addBuddy(BuddyLocker buddy) {
    }

    void removeBuddy(BuddyLocker buddy) {
    }

    public boolean sharesLocksWith(Locker other) {
        return false;
    }

    public final void operationEnd() throws DatabaseException {
        this.operationEnd(true);
    }

    public final void operationEnd(OperationStatus status) throws DatabaseException {
        this.operationEnd(status == OperationStatus.SUCCESS);
    }

    public abstract void operationEnd(boolean var1) throws DatabaseException;

    void close() throws DatabaseException {
        this.isOpen = false;
    }

    public boolean isValid() {
        return this.isOpen;
    }

    public void addOpenedDatabase(Database dbHandle) {
    }

    public boolean allowReleaseLockAfterLsnChange() {
        return false;
    }

    public abstract void registerCursor(CursorImpl var1);

    public abstract void unRegisterCursor(CursorImpl var1);

    public abstract boolean lockingRequired();

    public abstract WriteLockInfo getWriteLockInfo(long var1);

    public abstract void markDeleteAtTxnEnd(DatabaseImpl var1, boolean var2) throws DatabaseException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeleteInfo(BIN bin) {
        if (bin.shouldLogDelta()) {
            return;
        }
        Locker locker = this;
        synchronized (locker) {
            Long nodeId;
            if (this.deleteInfo == null) {
                this.deleteInfo = new HashMap<Long, BINReference>();
            }
            if (this.deleteInfo.containsKey(nodeId = Long.valueOf(bin.getNodeId()))) {
                return;
            }
            this.deleteInfo.put(nodeId, bin.createReference());
        }
    }

    protected abstract void addLock(Long var1, LockType var2, LockGrantType var3) throws DatabaseException;

    abstract void removeLock(long var1) throws DatabaseException;

    abstract void moveWriteToReadLock(long var1, Lock var3);

    public abstract StatGroup collectStats() throws DatabaseException;

    public boolean isTimedOut() {
        long diff;
        long timeout = this.getTxnTimeout();
        return timeout != 0L && (diff = System.currentTimeMillis() - this.txnStartMillis) > timeout;
    }

    public synchronized long getTxnTimeout() {
        return this.txnTimeoutMillis;
    }

    long getTxnStartMillis() {
        return this.txnStartMillis;
    }

    public boolean isRolledBack() {
        return false;
    }

    public String toString() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        return System.identityHashCode(this) + " " + Long.toString(this.id) + "_" + (this.thread == null ? "" : this.thread.getName()) + "_" + className;
    }

    public void dumpLockTable() throws DatabaseException {
        this.lockManager.dump();
    }
}

