/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.Database;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.ReadCommittedLocker;
import com.sleepycat.je.txn.ThreadLocker;
import com.sleepycat.je.txn.Txn;

public class LockerFactory {
    public static Locker getWritableLocker(Environment env, Transaction userTxn, boolean isInternalDb, boolean dbIsTransactional, boolean autoTxnIsReplicated) {
        return LockerFactory.getWritableLocker(env, userTxn, isInternalDb, dbIsTransactional, autoTxnIsReplicated, null);
    }

    public static Locker getWritableLocker(Environment env, Transaction userTxn, boolean isInternalDb, boolean dbIsTransactional, boolean autoTxnIsReplicated, TransactionConfig autoCommitConfig) {
        Transaction xaLocker;
        EnvironmentImpl envImpl = DbInternal.getEnvironmentImpl(env);
        boolean envIsTransactional = envImpl.isTransactional();
        if (userTxn == null && (xaLocker = env.getThreadTransaction()) != null) {
            return DbInternal.getLocker(xaLocker);
        }
        if (dbIsTransactional && userTxn == null) {
            if (autoCommitConfig == null) {
                autoCommitConfig = DbInternal.getDefaultTxnConfig(env);
            }
            return Txn.createAutoTxn(envImpl, autoCommitConfig, autoTxnIsReplicated ? ReplicationContext.MASTER : ReplicationContext.NO_REPLICATE);
        }
        if (userTxn == null) {
            return ThreadLocker.createThreadLocker(envImpl, autoTxnIsReplicated);
        }
        if (!isInternalDb && !envIsTransactional) {
            throw new IllegalArgumentException("A Transaction cannot be used because the environment was opened non-transactionally");
        }
        if (!dbIsTransactional) {
            throw new IllegalArgumentException("A Transaction cannot be used because the database was opened non-transactionally");
        }
        Locker locker = DbInternal.getLocker(userTxn);
        if (locker.isReadCommittedIsolation()) {
            return ReadCommittedLocker.createReadCommittedLocker(envImpl, locker);
        }
        return locker;
    }

    public static Locker getReadableLocker(Database dbHandle, Transaction userTxn, boolean readCommittedIsolation) {
        return LockerFactory.getReadableLocker(dbHandle, userTxn != null ? DbInternal.getLocker(userTxn) : null, readCommittedIsolation);
    }

    public static Locker getReadableLocker(Database dbHandle, Locker locker, boolean readCommittedIsolation) {
        DatabaseImpl dbImpl = DbInternal.getDatabaseImpl(dbHandle);
        if (!dbImpl.isTransactional() && locker != null && locker.isTransactional()) {
            throw new IllegalArgumentException("A Transaction cannot be used because the database was opened non-transactionally");
        }
        if (locker != null && !locker.isTransactional()) {
            locker = null;
        }
        if (locker != null && locker.isReadCommittedIsolation()) {
            readCommittedIsolation = true;
        }
        boolean autoTxnIsReplicated = dbImpl.isReplicated() && dbImpl.getEnvironmentImpl().isReplicated();
        return LockerFactory.getReadableLocker(dbHandle.getEnvironment(), locker, autoTxnIsReplicated, readCommittedIsolation);
    }

    private static Locker getReadableLocker(Environment env, Locker locker, boolean autoTxnIsReplicated, boolean readCommittedIsolation) {
        EnvironmentImpl envImpl = DbInternal.getEnvironmentImpl(env);
        if (locker == null) {
            Transaction xaTxn = env.getThreadTransaction();
            if (xaTxn != null) {
                return DbInternal.getLocker(xaTxn);
            }
            return ThreadLocker.createThreadLocker(envImpl, autoTxnIsReplicated);
        }
        if (readCommittedIsolation) {
            return ReadCommittedLocker.createReadCommittedLocker(envImpl, locker);
        }
        return locker;
    }

    public static Locker getInternalReadOperationLocker(EnvironmentImpl envImpl) {
        return BasicLocker.createBasicLocker(envImpl);
    }
}

