/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.StringTokenizer;

class FilesToMigrate {
    private final EnvironmentImpl env;
    private long[] forceCleanFiles;
    private int upgradeToVersion;
    private boolean checkLogVersion;
    private boolean nextAvailable;
    private long nextFile;

    FilesToMigrate(EnvironmentImpl env) {
        this.env = env;
        String forceCleanProp = env.getConfigManager().get(EnvironmentParams.CLEANER_FORCE_CLEAN_FILES);
        this.parseForceCleanFiles(forceCleanProp);
        this.upgradeToVersion = env.getConfigManager().getInt(EnvironmentParams.CLEANER_UPGRADE_TO_LOG_VERSION);
        if (this.upgradeToVersion == -1) {
            this.upgradeToVersion = 10;
        }
        this.checkLogVersion = this.upgradeToVersion != 0;
        this.nextAvailable = false;
        this.nextFile = -1L;
    }

    boolean hasNext(SortedMap<Long, FileSummary> fileSummaryMap) {
        if (this.nextAvailable) {
            return true;
        }
        long foundFile = -1L;
        for (long file : fileSummaryMap.tailMap(this.nextFile + 1L).keySet()) {
            if (this.isForceCleanFile(file)) {
                foundFile = file;
                break;
            }
            if (!this.checkLogVersion) continue;
            try {
                int logVersion = this.env.getFileManager().getFileLogVersion(file);
                if (logVersion < this.upgradeToVersion) {
                    foundFile = file;
                    break;
                }
                this.checkLogVersion = false;
            }
            catch (RuntimeException e) {
                this.nextFile = file;
                throw e;
            }
        }
        if (foundFile != -1L) {
            this.nextFile = foundFile;
            this.nextAvailable = true;
            return true;
        }
        return false;
    }

    long next(SortedMap<Long, FileSummary> fileSummaryMap) throws NoSuchElementException {
        if (this.hasNext(fileSummaryMap)) {
            this.nextAvailable = false;
            return this.nextFile;
        }
        throw new NoSuchElementException();
    }

    private boolean isForceCleanFile(long file) {
        if (this.forceCleanFiles != null) {
            for (int i = 0; i < this.forceCleanFiles.length; i += 2) {
                long from = this.forceCleanFiles[i];
                long to = this.forceCleanFiles[i + 1];
                if (file < from || file > to) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseForceCleanFiles(String propValue) throws IllegalArgumentException {
        if (propValue == null || propValue.length() == 0) {
            this.forceCleanFiles = null;
            return;
        }
        String errPrefix = "Error in " + EnvironmentParams.CLEANER_FORCE_CLEAN_FILES.getName() + "=" + propValue + ": ";
        StringTokenizer tokens = new StringTokenizer(propValue, ",-", true);
        ArrayList<Long> list = new ArrayList<Long>();
        while (tokens.hasMoreTokens()) {
            long fromNum;
            String fromStr = tokens.nextToken();
            try {
                fromNum = Long.parseLong(fromStr, 16);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(errPrefix + "Invalid hex file number: " + fromStr);
            }
            long toNum = -1L;
            if (tokens.hasMoreTokens()) {
                String delim = tokens.nextToken();
                if (",".equals(delim)) {
                    toNum = fromNum;
                } else {
                    if (!"-".equals(delim)) throw new IllegalArgumentException(errPrefix + "Expected '-' or ',': " + delim);
                    if (!tokens.hasMoreTokens()) throw new IllegalArgumentException(errPrefix + "Expected file number: " + delim);
                    String toStr = tokens.nextToken();
                    try {
                        toNum = Long.parseLong(toStr, 16);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(errPrefix + "Invalid hex file number: " + toStr);
                    }
                }
            } else {
                toNum = fromNum;
            }
            assert (toNum != -1L);
            list.add(fromNum);
            list.add(toNum);
        }
        this.forceCleanFiles = new long[list.size()];
        for (int i = 0; i < this.forceCleanFiles.length; ++i) {
            this.forceCleanFiles[i] = (Long)list.get(i);
        }
    }
}

