/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.ProgressListener;
import com.sleepycat.je.RecoveryProgress;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StatGroup;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.EnumMap;
import java.util.Formatter;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StartupTracker {
    private final Map<Phase, Elapsed> elapsed = new EnumMap<Phase, Elapsed>(Phase.class);
    private final Map<Phase, Counter> counters = new EnumMap<Phase, Counter>(Phase.class);
    private final Map<Phase, StatGroup> stats = new EnumMap<Phase, StatGroup>(Phase.class);
    private final Logger logger;
    private final EnvironmentImpl envImpl;
    private RecoveryInfo info;
    private long lastDumpMillis;

    public StartupTracker(EnvironmentImpl envImpl) {
        for (Phase p : Phase.values()) {
            this.elapsed.put(p, new Elapsed());
        }
        this.envImpl = envImpl;
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.lastDumpMillis = System.currentTimeMillis();
    }

    public void setRecoveryInfo(RecoveryInfo rInfo) {
        this.info = rInfo;
    }

    public void start(Phase phase) {
        String msg = "Starting " + (Object)((Object)phase);
        if (this.info != null) {
            msg = msg + " " + this.info;
        }
        LoggerUtils.logMsg(this.logger, this.envImpl, Level.CONFIG, msg);
        this.elapsed.get((Object)phase).start();
        Counter c = new Counter();
        this.counters.put(phase, c);
        if (!phase.equals((Object)Phase.TOTAL_ENV_OPEN)) {
            c.setCacheMissStart(this.envImpl.getLogManager().getNCacheMiss());
        }
    }

    public void stop(Phase phase) {
        Elapsed e = this.elapsed.get((Object)phase);
        e.end();
        Counter c = this.getCounter(phase);
        c.setCacheMissEnd(this.envImpl.getLogManager().getNCacheMiss());
        String msg = "Stopping " + (Object)((Object)phase);
        if (this.info != null) {
            msg = msg + " " + this.info;
        }
        LoggerUtils.logMsg(this.logger, this.envImpl, Level.CONFIG, msg);
        int dumpThreshold = this.envImpl.getConfigManager().getDuration(EnvironmentParams.STARTUP_DUMP_THRESHOLD);
        if (phase.root == null && e.getEnd() - e.getStart() > (long)dumpThreshold) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream p = new PrintStream(baos);
            this.displayStats(p, phase);
            LoggerUtils.logMsg(this.logger, this.envImpl, Level.INFO, baos.toString());
            return;
        }
        if (System.currentTimeMillis() - this.lastDumpMillis > (long)dumpThreshold) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream p = new PrintStream(baos);
            this.displayInterim(p, phase);
            LoggerUtils.logMsg(this.logger, this.envImpl, Level.INFO, baos.toString());
        }
    }

    public void setProgress(RecoveryProgress progress) {
        ProgressListener<RecoveryProgress> progressListener = this.envImpl.getRecoveryProgressListener();
        if (progressListener == null) {
            return;
        }
        if (!progressListener.progress(progress, -1L, -1L)) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.PROGRESS_LISTENER_HALT, "EnvironmentConfig.recoveryProgressListener: ");
        }
    }

    public Counter getCounter(Phase phase) {
        return this.counters.get((Object)phase);
    }

    public void setStats(Phase phase, StatGroup sg) {
        this.stats.put(phase, sg);
    }

    private String displayRecoveryInterval() {
        StringBuilder returnInfo = new StringBuilder();
        CheckpointEnd cEnd = this.info.checkpointEnd;
        if (cEnd != null) {
            returnInfo.append("checkpointId = ");
            returnInfo.append(cEnd.getId());
            if (cEnd.getInvoker() == null) {
                returnInfo.append(" ");
            } else {
                returnInfo.append("[").append(cEnd.getInvoker());
                returnInfo.append("] ");
            }
        }
        long fileMax = this.envImpl.getConfigManager().getLong(EnvironmentParams.LOG_FILE_MAX);
        long useStart = this.info.checkpointStartLsn == -1L ? 0L : this.info.checkpointStartLsn;
        long head = DbLsn.getNoCleaningDistance(useStart, this.info.firstActiveLsn, fileMax);
        long useEnd = this.info.checkpointEndLsn == -1L ? 0L : this.info.checkpointEndLsn;
        long ckpt = DbLsn.getNoCleaningDistance(useEnd, this.info.checkpointStartLsn, fileMax);
        long useLast = this.info.lastUsedLsn == -1L ? 0L : this.info.lastUsedLsn;
        long tail = DbLsn.getNoCleaningDistance(useLast, this.info.checkpointEndLsn, fileMax);
        returnInfo.append("firstActive[" + DbLsn.getNoFormatString(this.info.firstActiveLsn) + "], ckptStart[" + DbLsn.getNoFormatString(this.info.checkpointStartLsn) + "], ckptEnd[" + DbLsn.getNoFormatString(this.info.checkpointEndLsn) + "], lastUsed[" + DbLsn.getNoFormatString(this.info.lastUsedLsn) + "]\n");
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        f.format("%24s bytes = %,d\n%24s bytes = %,d\n%24s bytes = %,d", "firstActive->ckptStart", head, "ckptStart->ckptEnd", ckpt, "ckptEnd->end bytes", tail);
        return returnInfo.toString() + "\nApproximate distances:\n" + sb.toString();
    }

    private String displayTimestamp(Long time) {
        StringBuilder sb = new StringBuilder();
        Formatter timestampFormatter = new Formatter(sb);
        timestampFormatter.format("%tD,%tH:%tM:%tS:%tL", time, time, time, time, time);
        return sb.toString();
    }

    private void displayPhaseSubtree(PrintStream stream, Phase parent, Elapsed parentTime, Elapsed rootElapsed) {
        String headerFormat = "%24s  %% of total  %s\n";
        String parentFormat = "%20s             %3d %s\n";
        String dataFormat = "%24s         %3d %s\n";
        String divider = "                         -------------------------";
        if (parent.children == null) {
            return;
        }
        if (parentTime.getEnd() - parentTime.getStart() == 0L) {
            return;
        }
        stream.println("\n");
        stream.printf(headerFormat, " ", Elapsed.DISPLAY_COLUMNS);
        stream.printf(parentFormat, new Object[]{parent, parentTime.getPercentage(rootElapsed), parentTime});
        stream.println(divider);
        for (Phase child : parent.children) {
            Elapsed time = this.elapsed.get((Object)child);
            if (time.getStart() == 0L) continue;
            stream.printf(dataFormat, new Object[]{child, time.getPercentage(rootElapsed), time});
        }
    }

    private void displayCounters(PrintStream stream, Phase root) {
        String basicFormat = "%20s   %s\n";
        boolean headerNotPrinted = true;
        for (Map.Entry<Phase, Counter> c : this.counters.entrySet()) {
            Counter counter;
            Phase p = c.getKey();
            if (p.root != root || (counter = c.getValue()).isEmpty()) continue;
            if (headerNotPrinted) {
                stream.println();
                stream.printf(basicFormat, " ", Counter.DISPLAY_COLUMNS);
                headerNotPrinted = false;
            }
            stream.printf(basicFormat, new Object[]{c.getKey(), counter});
        }
    }

    public void displayStats(PrintStream stream, Phase root) {
        Phase p;
        this.lastDumpMillis = System.currentTimeMillis();
        Elapsed rootTime = this.elapsed.get((Object)root);
        stream.println("\n=== " + root.reportLabel + " Report  ===");
        stream.println("start = " + this.displayTimestamp(rootTime.getStart()));
        stream.println("end   = " + this.displayTimestamp(rootTime.getEnd()));
        if (root == Phase.TOTAL_ENV_OPEN) {
            stream.print(this.displayRecoveryInterval());
        }
        for (Map.Entry<Phase, Elapsed> entry : this.elapsed.entrySet()) {
            p = entry.getKey();
            if (p.root == null ? p != root : p.root != root) continue;
            this.displayPhaseSubtree(stream, entry.getKey(), entry.getValue(), rootTime);
        }
        this.displayCounters(stream, root);
        for (Map.Entry<Phase, Object> entry : this.stats.entrySet()) {
            p = entry.getKey();
            if (p.root != root) continue;
            stream.println((Object)((Object)entry.getKey()) + " stats:");
            stream.println(entry.getValue());
        }
    }

    private void displayInterim(PrintStream stream, Phase phase) {
        this.lastDumpMillis = System.currentTimeMillis();
        stream.println("\n=== Interim " + (Object)((Object)phase) + " Report  ===");
        stream.println(this.displayRecoveryInterval());
        boolean headerNotPrinted = true;
        for (Map.Entry<Phase, Elapsed> entry : this.elapsed.entrySet()) {
            Phase p = entry.getKey();
            Elapsed e = entry.getValue();
            if (e.start == 0L) continue;
            if (headerNotPrinted) {
                stream.println("                             Elapsed(ms)");
                headerNotPrinted = false;
            }
            stream.printf("%20s : %s\n", new Object[]{p, e});
        }
        this.displayCounters(stream, phase.root);
        for (Map.Entry<Phase, Object> entry : this.stats.entrySet()) {
            stream.println((Object)((Object)entry.getKey()) + " stats:");
            stream.println(entry.getValue());
        }
    }

    public static class Counter {
        private int numRead;
        private int numProcessed;
        private int numDeleted;
        private int numAux;
        private long numRepeatIteratorReads;
        private long startCacheMiss;
        private long endCacheMiss;
        static String DISPLAY_COLUMNS = "      nRead nProcessed   nDeleted       nAux  nRepeatRd nCacheMiss";

        private boolean isEmpty() {
            return this.numRead == 0 && this.numProcessed == 0 && this.numDeleted == 0 && this.numAux == 0 && this.numRepeatIteratorReads == 0L && this.endCacheMiss - this.startCacheMiss == 0L;
        }

        public void incNumRead() {
            ++this.numRead;
        }

        public void incNumProcessed() {
            ++this.numProcessed;
        }

        public void incNumDeleted() {
            ++this.numDeleted;
        }

        public void incNumAux() {
            ++this.numAux;
        }

        public void setRepeatIteratorReads(long repeats) {
            this.numRepeatIteratorReads = repeats;
        }

        public void setCacheMissStart(long miss) {
            this.startCacheMiss = miss;
        }

        public void setCacheMissEnd(long miss) {
            this.endCacheMiss = miss;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Formatter f = new Formatter(sb);
            f.format("%,11d%,11d%,11d%,11d%,11d%,11d", this.numRead, this.numProcessed, this.numDeleted, this.numAux, this.numRepeatIteratorReads, this.endCacheMiss - this.startCacheMiss);
            return sb.toString();
        }

        public int getNumProcessed() {
            return this.numProcessed;
        }
    }

    private static class Elapsed {
        static String DISPLAY_COLUMNS = " Elapsed(ms)";
        private long start;
        private long end;

        private Elapsed() {
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        private void start() {
            this.start = System.currentTimeMillis();
        }

        private void end() {
            this.end = System.currentTimeMillis();
        }

        private int getPercentage(Elapsed rootTime) {
            if (rootTime == null) {
                return 0;
            }
            long rootTotal = rootTime.end - rootTime.start;
            if (rootTotal <= 0L) {
                return 0;
            }
            if (this.end == 0L) {
                return 0;
            }
            return (int)((float)(this.end - this.start) / (float)rootTotal * 100.0f);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Formatter f = new Formatter(sb);
            if (this.end != 0L) {
                f.format("%,13d", this.end - this.start);
            } else if (this.start != 0L) {
                f.format("%13s  %tD,%tH:%tM:%tS:%tL", "started at", this.start, this.start, this.start, this.start, this.start);
            } else {
                f.format("%13s", "none");
            }
            return sb.toString();
        }
    }

    public static enum Phase {
        TOTAL_ENV_OPEN("Environment Open"),
        TOTAL_RECOVERY,
        FIND_END_OF_LOG,
        FIND_LAST_CKPT,
        BUILD_TREE,
        READ_MAP_INS,
        REDO_MAP_INS,
        UNDO_MAP_LNS,
        REDO_MAP_LNS,
        READ_INS,
        REDO_INS,
        UNDO_LNS,
        REDO_LNS,
        POPULATE_UP,
        REMOVE_TEMP_DBS,
        CKPT,
        TOTAL_JOIN_GROUP("Replication Join Group"),
        FIND_MASTER,
        BECOME_CONSISTENT;

        private Phase[] children;
        private Phase root;
        private String reportLabel;

        private Phase() {
        }

        private Phase(String reportLabel) {
            this.reportLabel = reportLabel;
        }

        static {
            Phase.TOTAL_ENV_OPEN.children = new Phase[]{TOTAL_RECOVERY};
            Phase.TOTAL_RECOVERY.children = new Phase[]{FIND_END_OF_LOG, FIND_LAST_CKPT, BUILD_TREE, POPULATE_UP, REMOVE_TEMP_DBS, CKPT};
            Phase.BUILD_TREE.children = new Phase[]{READ_MAP_INS, REDO_MAP_INS, UNDO_MAP_LNS, REDO_MAP_LNS, READ_INS, REDO_INS, UNDO_LNS, REDO_LNS};
            Phase.TOTAL_JOIN_GROUP.children = new Phase[]{FIND_MASTER, BECOME_CONSISTENT};
            Phase.TOTAL_RECOVERY.root = TOTAL_ENV_OPEN;
            Phase.FIND_END_OF_LOG.root = TOTAL_ENV_OPEN;
            Phase.FIND_LAST_CKPT.root = TOTAL_ENV_OPEN;
            Phase.BUILD_TREE.root = TOTAL_ENV_OPEN;
            Phase.READ_MAP_INS.root = TOTAL_ENV_OPEN;
            Phase.REDO_MAP_INS.root = TOTAL_ENV_OPEN;
            Phase.UNDO_MAP_LNS.root = TOTAL_ENV_OPEN;
            Phase.REDO_MAP_LNS.root = TOTAL_ENV_OPEN;
            Phase.READ_INS.root = TOTAL_ENV_OPEN;
            Phase.REDO_INS.root = TOTAL_ENV_OPEN;
            Phase.UNDO_LNS.root = TOTAL_ENV_OPEN;
            Phase.REDO_LNS.root = TOTAL_ENV_OPEN;
            Phase.POPULATE_UP.root = TOTAL_ENV_OPEN;
            Phase.REMOVE_TEMP_DBS.root = TOTAL_ENV_OPEN;
            Phase.CKPT.root = TOTAL_ENV_OPEN;
            Phase.FIND_MASTER.root = TOTAL_JOIN_GROUP;
            Phase.BECOME_CONSISTENT.root = TOTAL_JOIN_GROUP;
        }
    }
}

