/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.elections;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.rep.elections.ElectionAgentThread;
import com.sleepycat.je.rep.elections.Proposer;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.elections.Utils;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.channels.Channels;
import java.util.logging.Level;

public class Acceptor
extends ElectionAgentThread {
    private final RepNode repNode;
    private Proposer.Proposal promisedProposal = null;
    private Protocol.Value acceptedValue = null;
    private final SuggestionGenerator suggestionGenerator;
    public static final String SERVICE_NAME = "Acceptor";

    public Acceptor(Protocol protocol, RepNode repNode, SuggestionGenerator suggestionGenerator) {
        super(repNode, protocol, "Acceptor Thread " + repNode.getNameIdPair().getName());
        this.repNode = repNode;
        this.suggestionGenerator = suggestionGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block25: {
            serviceDispatcher = this.repNode.getServiceDispatcher();
            serviceDispatcher.register("Acceptor", this.channelQueue);
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Acceptor started");
            channel = null;
            try {
                while (true) lbl-1000:
                // 6 sources

                {
                    block23: {
                        block24: {
                            block22: {
                                if ((channel = serviceDispatcher.takeChannel("Acceptor", true, this.protocol.getReadTimeout())) == null) {
                                    return;
                                }
                                in = null;
                                out = null;
                                in = new BufferedReader(new InputStreamReader(Channels.newInputStream(channel)));
                                out = new PrintWriter(Channels.newOutputStream(channel), true);
                                requestLine = in.readLine();
                                if (requestLine != null) break block22;
                                LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Acceptor: EOF on request");
                                Utils.cleanup(this.logger, this.envImpl, this.formatter, channel, in, out);
                                this.cleanup();
                                continue;
                            }
                            requestMessage = null;
                            try {
                                requestMessage = this.protocol.parseRequest(requestLine);
                            }
                            catch (TextProtocol.InvalidMessageException e) {
                                LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.WARNING, "Message format error: " + e.getMessage());
                                v0 = this.protocol;
                                v0.getClass();
                                out.println(new TextProtocol.ProtocolError((TextProtocol)v0, e).wireFormat());
                                Utils.cleanup(this.logger, this.envImpl, this.formatter, channel, in, out);
                                this.cleanup();
                            }
                            responseMessage = null;
                            if (requestMessage.getOp() == this.protocol.PROPOSE) {
                                responseMessage = this.process((Protocol.Propose)requestMessage);
                                break block23;
                            }
                            if (requestMessage.getOp() == this.protocol.ACCEPT) {
                                responseMessage = this.process((Protocol.Accept)requestMessage);
                                break block23;
                            }
                            if (requestMessage.getOp() != this.protocol.SHUTDOWN) break block24;
                            Utils.cleanup(this.logger, this.envImpl, this.formatter, channel, in, out);
                            this.cleanup();
                            break block25;
                        }
                        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.SEVERE, "Unrecognized request: " + requestLine);
                        Utils.cleanup(this.logger, this.envImpl, this.formatter, channel, in, out);
                        this.cleanup();
                        continue;
                    }
                    try {
                        responseMessage.setSendVersion(requestMessage.getSendVersion());
                        out.println(responseMessage.wireFormat());
                    }
                    catch (IOException e) {
                        try {
                            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.WARNING, "IO error on socket: " + e.getMessage());
                        }
                        catch (Throwable var8_11) {
                            Utils.cleanup(this.logger, this.envImpl, this.formatter, channel, in, out);
                            this.cleanup();
                            throw var8_11;
                        }
                        Utils.cleanup(this.logger, this.envImpl, this.formatter, channel, in, out);
                        this.cleanup();
                        continue;
                    }
                    Utils.cleanup(this.logger, this.envImpl, this.formatter, channel, in, out);
                    this.cleanup();
                    continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                if (this.isShutdown()) {
                    return;
                }
                LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.WARNING, "Acceptor unexpected interrupted");
                throw EnvironmentFailureException.unexpectedException(e);
            }
            finally {
                serviceDispatcher.cancel("Acceptor");
                this.cleanup();
            }
            ** GOTO lbl-1000
        }
    }

    TextProtocol.ResponseMessage process(Protocol.Propose propose) {
        if (this.promisedProposal != null && this.promisedProposal.compareTo(propose.getProposal()) > 0) {
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Reject Propose: " + propose.getProposal() + " Promised proposal: " + this.promisedProposal);
            Protocol protocol = this.protocol;
            protocol.getClass();
            return new Protocol.Reject(protocol, this.promisedProposal);
        }
        this.promisedProposal = propose.getProposal();
        Protocol.Value suggestedValue = this.suggestionGenerator.get(this.promisedProposal);
        long suggestionRanking = this.suggestionGenerator.getRanking(this.promisedProposal);
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Promised: " + this.promisedProposal + " Suggested Value: " + suggestedValue + " Suggestion Ranking: " + suggestionRanking);
        Protocol protocol = this.protocol;
        protocol.getClass();
        return new Protocol.Promise(protocol, this.promisedProposal, this.acceptedValue, suggestedValue, suggestionRanking, this.repNode.getElectionPriority(), this.repNode.getLogVersion(), JEVersion.CURRENT_VERSION);
    }

    TextProtocol.ResponseMessage process(Protocol.Accept accept) {
        if (this.promisedProposal != null && this.promisedProposal.compareTo(accept.getProposal()) != 0) {
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Reject Accept: " + accept.getProposal() + " Promised proposal: " + this.promisedProposal);
            Protocol protocol = this.protocol;
            protocol.getClass();
            return new Protocol.Reject(protocol, this.promisedProposal);
        }
        this.acceptedValue = accept.getValue();
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Promised: " + this.promisedProposal + " Accepted: " + accept.getProposal() + " Value: " + this.acceptedValue);
        Protocol protocol = this.protocol;
        protocol.getClass();
        return new Protocol.Accepted(protocol, accept.getProposal(), this.acceptedValue);
    }

    public static interface SuggestionGenerator {
        public Protocol.Value get(Proposer.Proposal var1);

        public long getRanking(Proposer.Proposal var1);
    }
}

