/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint;

import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.utilint.NamedChannel;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class NamedChannelWithTimeout
extends NamedChannel {
    private volatile boolean readActivity;
    private volatile int timeoutMs;
    private final EnvironmentImpl envImpl;
    private final Logger logger;
    private long lastCheckMs = 0L;

    public NamedChannelWithTimeout(RepNode repNode, DataChannel channel, int timeoutMs) {
        super(channel);
        this.timeoutMs = timeoutMs;
        this.envImpl = repNode.getRepImpl();
        this.logger = repNode.getLogger();
        this.readActivity = true;
        if (timeoutMs > 0) {
            repNode.getChannelTimeoutTask().register(this);
        }
    }

    public void setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
        this.readActivity = true;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int bytes = this.channel.read(dst);
        if (bytes > 0) {
            this.readActivity = true;
        }
        return bytes;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
        this.readActivity = false;
    }

    private void resetActivityCounter(long timeMs) {
        this.lastCheckMs = timeMs;
        this.readActivity = false;
    }

    public boolean isActive(long timeMs) {
        if (!this.channel.isOpen()) {
            return false;
        }
        if (!this.channel.getSocketChannel().isConnected()) {
            return true;
        }
        if (this.readActivity) {
            this.resetActivityCounter(timeMs);
            return true;
        }
        if (this.timeoutMs == 0 || timeMs - this.lastCheckMs < (long)this.timeoutMs) {
            return true;
        }
        LoggerUtils.info(this.logger, this.envImpl, "Inactive channel: " + this.getNameIdPair() + " forced close. Timeout: " + this.timeoutMs + "ms.");
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

