/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint.net;

import com.sleepycat.je.rep.ReplicationSSLConfig;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.net.DataChannelFactory;
import com.sleepycat.je.rep.net.InstanceContext;
import com.sleepycat.je.rep.net.InstanceLogger;
import com.sleepycat.je.rep.net.InstanceParams;
import com.sleepycat.je.rep.net.PasswordSource;
import com.sleepycat.je.rep.net.SSLAuthenticator;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.utilint.net.AliasKeyManager;
import com.sleepycat.je.rep.utilint.net.DataChannelFactoryBuilder;
import com.sleepycat.je.rep.utilint.net.SSLDNAuthenticator;
import com.sleepycat.je.rep.utilint.net.SSLDNHostVerifier;
import com.sleepycat.je.rep.utilint.net.SSLDataChannel;
import com.sleepycat.je.rep.utilint.net.SSLMirrorAuthenticator;
import com.sleepycat.je.rep.utilint.net.SSLMirrorHostVerifier;
import com.sleepycat.je.rep.utilint.net.SSLStdHostVerifier;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;

public class SSLChannelFactory
implements DataChannelFactory {
    private static final String SSL_CONTEXT_PROTOCOL = "TLS";
    private static final String X509_ALGO_NAME_PROPERTY = "je.ssl.x509AlgoName";
    private static final String X509_ALGO_NAME = SSLChannelFactory.getX509AlgoName();
    private final SSLContext serverSSLContext;
    private final SSLContext clientSSLContext;
    private final SSLParameters baseSSLParameters;
    private final SSLAuthenticator sslAuthenticator;
    private final HostnameVerifier sslHostVerifier;
    private final InstanceLogger logger;

    public SSLChannelFactory(InstanceParams params) {
        this.serverSSLContext = SSLChannelFactory.constructSSLContext(params, false);
        this.clientSSLContext = SSLChannelFactory.constructSSLContext(params, true);
        this.baseSSLParameters = SSLChannelFactory.filterSSLParameters(SSLChannelFactory.constructSSLParameters(params), this.serverSSLContext);
        this.sslAuthenticator = SSLChannelFactory.constructSSLAuthenticator(params);
        this.sslHostVerifier = SSLChannelFactory.constructSSLHostVerifier(params);
        this.logger = params.getContext().getLoggerFactory().getLogger(this.getClass());
    }

    public SSLChannelFactory(SSLContext serverSSLContext, SSLContext clientSSLContext, SSLParameters baseSSLParameters, SSLAuthenticator sslAuthenticator, HostnameVerifier sslHostVerifier, InstanceLogger logger) {
        this.serverSSLContext = serverSSLContext;
        this.clientSSLContext = clientSSLContext;
        this.baseSSLParameters = SSLChannelFactory.filterSSLParameters(baseSSLParameters, serverSSLContext);
        this.sslAuthenticator = sslAuthenticator;
        this.sslHostVerifier = sslHostVerifier;
        this.logger = logger;
    }

    @Override
    public DataChannel acceptChannel(SocketChannel socketChannel) {
        SocketAddress socketAddress = socketChannel.socket().getRemoteSocketAddress();
        String host = null;
        if (socketAddress == null) {
            throw new IllegalArgumentException("socketChannel is not connected");
        }
        if (socketAddress instanceof InetSocketAddress) {
            host = ((InetSocketAddress)socketAddress).getAddress().toString();
        }
        SSLEngine engine = this.serverSSLContext.createSSLEngine(host, socketChannel.socket().getPort());
        engine.setSSLParameters(this.baseSSLParameters);
        engine.setUseClientMode(false);
        if (this.sslAuthenticator != null) {
            engine.setWantClientAuth(true);
        }
        return new SSLDataChannel(socketChannel, engine, null, null, this.sslAuthenticator, this.logger);
    }

    @Override
    public DataChannel connect(InetSocketAddress addr, DataChannelFactory.ConnectOptions connectOptions) throws IOException {
        SocketChannel socketChannel = RepUtils.openSocketChannel(addr, connectOptions);
        String host = addr.getHostName();
        if (host == null) {
            host = addr.getAddress().toString();
        }
        SSLEngine engine = this.clientSSLContext.createSSLEngine(host, addr.getPort());
        engine.setSSLParameters(this.baseSSLParameters);
        engine.setUseClientMode(true);
        return new SSLDataChannel(socketChannel, engine, host, this.sslHostVerifier, null, this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore readKeyStore(InstanceContext context) {
        KeyStoreInfo ksInfo = SSLChannelFactory.readKeyStoreInfo(context);
        try {
            KeyStore keyStore = ksInfo.ks;
            return keyStore;
        }
        finally {
            ksInfo.clearPassword();
        }
    }

    public static boolean isValidAuthenticator(String authSpec) {
        if ((authSpec = authSpec.trim()).equals("") || authSpec.equals("mirror")) {
            return true;
        }
        if (authSpec.startsWith("dnmatch(") && authSpec.endsWith(")")) {
            try {
                SSLDNAuthenticator.validate(authSpec);
                return true;
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }
        return false;
    }

    public static boolean isValidHostVerifier(String hvSpec) {
        if ((hvSpec = hvSpec.trim()).equals("") || hvSpec.equals("mirror") || hvSpec.equals("hostname")) {
            return true;
        }
        if (hvSpec.startsWith("dnmatch(") && hvSpec.endsWith(")")) {
            try {
                SSLDNHostVerifier.validate(hvSpec);
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SSLContext constructSSLContext(InstanceParams params, boolean clientMode) {
        ReplicationSSLConfig config = (ReplicationSSLConfig)params.getContext().getRepNetConfig();
        KeyManager[] kmList = null;
        KeyStoreInfo ksInfo = SSLChannelFactory.readKeyStoreInfo(params.getContext());
        if (ksInfo != null) {
            try {
                String ksAliasProp;
                String string = ksAliasProp = clientMode ? config.getSSLClientKeyAlias() : config.getSSLServerKeyAlias();
                if (ksAliasProp != null && ksAliasProp.isEmpty()) {
                    ksAliasProp = null;
                }
                kmList = SSLChannelFactory.buildKeyManagerList(ksInfo, ksAliasProp, clientMode);
            }
            finally {
                ksInfo.clearPassword();
            }
        }
        TrustManager[] tmList = null;
        KeyStoreInfo tsInfo = SSLChannelFactory.readTrustStoreInfo(params.getContext());
        if (tsInfo != null) {
            try {
                tmList = SSLChannelFactory.buildTrustManagerList(tsInfo);
            }
            finally {
                tsInfo.clearPassword();
            }
        }
        SSLContext newContext = null;
        try {
            newContext = SSLContext.getInstance(SSL_CONTEXT_PROTOCOL);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException("Unable to find a suitable SSLContext", nsae);
        }
        try {
            newContext.init(kmList, tmList, null);
        }
        catch (KeyManagementException kme) {
            throw new IllegalStateException("Error establishing SSLContext", kme);
        }
        return newContext;
    }

    private static KeyManager[] buildKeyManagerList(KeyStoreInfo ksInfo, String ksAlias, boolean clientMode) {
        KeyManagerFactory kmf;
        try {
            kmf = KeyManagerFactory.getInstance(X509_ALGO_NAME);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException("Unable to find a suitable KeyManagerFactory", nsae);
        }
        try {
            kmf.init(ksInfo.ks, ksInfo.ksPwd);
        }
        catch (KeyStoreException kse) {
            throw new IllegalStateException("Error processing keystore file " + ksInfo.ksFile, kse);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException("Unable to find appropriate algorithm for keystore file " + ksInfo.ksFile, nsae);
        }
        catch (UnrecoverableKeyException uke) {
            throw new IllegalStateException("Unable to recover key from keystore file " + ksInfo.ksFile, uke);
        }
        KeyManager[] kmList = kmf.getKeyManagers();
        if (ksAlias != null) {
            X509ExtendedKeyManager x509KeyManager = null;
            for (KeyManager km : kmList) {
                if (!(km instanceof X509ExtendedKeyManager)) continue;
                x509KeyManager = (X509ExtendedKeyManager)km;
                break;
            }
            if (x509KeyManager == null) {
                throw new IllegalStateException("Unable to locate an X509ExtendedKeyManager corresponding to keyStore " + ksInfo.ksFile);
            }
            kmList = new KeyManager[]{clientMode ? new AliasKeyManager(x509KeyManager, null, ksAlias) : new AliasKeyManager(x509KeyManager, ksAlias, null)};
        }
        return kmList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStoreInfo readKeyStoreInfo(InstanceContext context) {
        ReplicationSSLConfig config = (ReplicationSSLConfig)context.getRepNetConfig();
        String ksProp = config.getSSLKeyStore();
        if (ksProp == null || ksProp.isEmpty()) {
            ksProp = System.getProperty("javax.net.ssl.keyStore");
        }
        if (ksProp == null) {
            return null;
        }
        String ksTypeProp = config.getSSLKeyStoreType();
        char[] ksPw = SSLChannelFactory.getKeyStorePassword(context);
        try {
            if (ksPw == null) {
                throw new IllegalArgumentException("Unable to open keystore without a password");
            }
            KeyStore ks = SSLChannelFactory.loadStore(ksProp, ksPw, "keystore", ksTypeProp);
            KeyStoreInfo keyStoreInfo = new KeyStoreInfo(ksProp, ks, ksPw);
            return keyStoreInfo;
        }
        finally {
            if (ksPw != null) {
                Arrays.fill(ksPw, ' ');
            }
        }
    }

    private static char[] getKeyStorePassword(InstanceContext context) {
        ReplicationSSLConfig config = (ReplicationSSLConfig)context.getRepNetConfig();
        char[] ksPw = null;
        PasswordSource ksPwSource = config.getSSLKeyStorePasswordSource();
        if (ksPwSource == null) {
            ksPwSource = SSLChannelFactory.constructKSPasswordSource(new InstanceParams(context, null));
        }
        if (ksPwSource != null) {
            ksPw = ksPwSource.getPassword();
        } else {
            String ksPwProp = config.getSSLKeyStorePassword();
            if (ksPwProp == null || ksPwProp.isEmpty()) {
                ksPwProp = System.getProperty("javax.net.ssl.keyStorePassword");
            }
            if (ksPwProp != null) {
                ksPw = ksPwProp.toCharArray();
            }
        }
        return ksPw;
    }

    private static TrustManager[] buildTrustManagerList(KeyStoreInfo tsInfo) {
        TrustManagerFactory tmf;
        try {
            tmf = TrustManagerFactory.getInstance(X509_ALGO_NAME);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException("Unable to find a suitable TrustManagerFactory", nsae);
        }
        try {
            tmf.init(tsInfo.ks);
        }
        catch (KeyStoreException kse) {
            throw new IllegalStateException("Error initializing truststore " + tsInfo.ksFile, kse);
        }
        return tmf.getTrustManagers();
    }

    private static KeyStoreInfo readTrustStoreInfo(InstanceContext context) {
        String tsTypeProp;
        ReplicationSSLConfig config = (ReplicationSSLConfig)context.getRepNetConfig();
        String tsProp = config.getSSLTrustStore();
        if (tsProp == null || tsProp.isEmpty()) {
            tsProp = System.getProperty("javax.net.ssl.trustStore");
        }
        if ((tsTypeProp = config.getSSLTrustStoreType()) == null || tsTypeProp.isEmpty()) {
            tsTypeProp = KeyStore.getDefaultType();
        }
        if (tsProp != null) {
            KeyStore ts = SSLChannelFactory.loadStore(tsProp, null, "truststore", tsTypeProp);
            return new KeyStoreInfo(tsProp, ts, null);
        }
        return null;
    }

    private static SSLParameters constructSSLParameters(InstanceParams params) {
        ReplicationSSLConfig config = (ReplicationSSLConfig)params.getContext().getRepNetConfig();
        String cipherSuitesProp = config.getSSLCipherSuites();
        String[] cipherSuites = null;
        if (cipherSuitesProp != null && !cipherSuitesProp.isEmpty()) {
            cipherSuites = cipherSuitesProp.split(",");
        }
        String protocolsProp = config.getSSLProtocols();
        String[] protocols = null;
        if (protocolsProp != null && !protocolsProp.isEmpty()) {
            protocols = protocolsProp.split(",");
        }
        return new SSLParameters(cipherSuites, protocols);
    }

    private static SSLParameters filterSSLParameters(SSLParameters configParams, SSLContext filterContext) throws IllegalArgumentException {
        String[] suppProtocols;
        String[] suppCipherSuites;
        SSLParameters suppParams = filterContext.getSupportedSSLParameters();
        String[] configCipherSuites = configParams.getCipherSuites();
        if (configCipherSuites != null && (configCipherSuites = SSLChannelFactory.filterConfig(configCipherSuites, suppCipherSuites = suppParams.getCipherSuites())).length == 0) {
            throw new IllegalArgumentException("None of the configured SSL cipher suites are supported by the environment.");
        }
        String[] configProtocols = configParams.getProtocols();
        if (configProtocols != null && (configProtocols = SSLChannelFactory.filterConfig(configProtocols, suppProtocols = suppParams.getProtocols())).length == 0) {
            throw new IllegalArgumentException("None of the configured SSL protocols are supported by the environment.");
        }
        SSLParameters newParams = new SSLParameters(configCipherSuites, configProtocols);
        newParams.setWantClientAuth(configParams.getWantClientAuth());
        newParams.setNeedClientAuth(configParams.getNeedClientAuth());
        return newParams;
    }

    private static String[] filterConfig(String[] configChoices, String[] supported) {
        ArrayList<String> keep = new ArrayList<String>();
        block0: for (String choice : configChoices) {
            for (String supp : supported) {
                if (!choice.equals(supp)) continue;
                keep.add(choice);
                continue block0;
            }
        }
        return keep.toArray(new String[keep.size()]);
    }

    private static Object constructSSLChecker(InstanceParams params, String checkerClassName, String checkerClassParams, Class<?> mustImplement, String miDesc) {
        InstanceParams objParams = new InstanceParams(params.getContext(), checkerClassParams);
        return DataChannelFactoryBuilder.constructObject(checkerClassName, mustImplement, miDesc, new DataChannelFactoryBuilder.CtorArgSpec(new Class[]{InstanceParams.class}, new Object[]{objParams}));
    }

    private static SSLAuthenticator constructSSLAuthenticator(InstanceParams params) throws IllegalArgumentException {
        ReplicationSSLConfig config = (ReplicationSSLConfig)params.getContext().getRepNetConfig();
        String authSpec = config.getSSLAuthenticator();
        String authClassName = config.getSSLAuthenticatorClass();
        if (authSpec != null && !authSpec.equals("") && authClassName != null && !authClassName.equals("")) {
            throw new IllegalArgumentException("Cannot specify both authenticator and authenticatorClass");
        }
        if (authSpec != null && !authSpec.equals("")) {
            return SSLChannelFactory.constructStdAuthenticator(params, authSpec);
        }
        if (authClassName == null || authClassName.equals("")) {
            return null;
        }
        String authParams = config.getSSLAuthenticatorParams();
        return (SSLAuthenticator)SSLChannelFactory.constructSSLChecker(params, authClassName, authParams, SSLAuthenticator.class, "authenticator");
    }

    private static SSLAuthenticator constructStdAuthenticator(InstanceParams params, String authSpec) throws IllegalArgumentException {
        if ((authSpec = authSpec.trim()).startsWith("dnmatch(") && authSpec.endsWith(")")) {
            String match = authSpec.substring("dnmatch(".length(), authSpec.length() - 1);
            return new SSLDNAuthenticator(new InstanceParams(params.getContext(), match));
        }
        if (authSpec.equals("mirror")) {
            return new SSLMirrorAuthenticator(new InstanceParams(params.getContext(), null));
        }
        throw new IllegalArgumentException(authSpec + " is not a valid authenticator specification.");
    }

    private static HostnameVerifier constructSSLHostVerifier(InstanceParams params) throws IllegalArgumentException {
        ReplicationSSLConfig config = (ReplicationSSLConfig)params.getContext().getRepNetConfig();
        String hvSpec = config.getSSLHostVerifier();
        String hvClassName = config.getSSLHostVerifierClass();
        if (hvSpec != null && !hvSpec.equals("") && hvClassName != null && !hvClassName.equals("")) {
            throw new IllegalArgumentException("Cannot specify both hostVerifier and hostVerifierClass");
        }
        if (hvSpec != null && !hvSpec.equals("")) {
            return SSLChannelFactory.constructStdHostVerifier(params, hvSpec);
        }
        if (hvClassName == null || hvClassName.equals("")) {
            return null;
        }
        String hvParams = config.getSSLHostVerifierParams();
        return (HostnameVerifier)SSLChannelFactory.constructSSLChecker(params, hvClassName, hvParams, HostnameVerifier.class, "hostname verifier");
    }

    private static HostnameVerifier constructStdHostVerifier(InstanceParams params, String hvSpec) throws IllegalArgumentException {
        if ((hvSpec = hvSpec.trim()).startsWith("dnmatch(") && hvSpec.endsWith(")")) {
            String match = hvSpec.substring("dnmatch(".length(), hvSpec.length() - 1);
            return new SSLDNHostVerifier(new InstanceParams(params.getContext(), match));
        }
        if (hvSpec.equals("mirror")) {
            return new SSLMirrorHostVerifier(new InstanceParams(params.getContext(), null));
        }
        if (hvSpec.equals("hostname")) {
            return new SSLStdHostVerifier(new InstanceParams(params.getContext(), null));
        }
        throw new IllegalArgumentException(hvSpec + " is not a valid hostVerifier specification.");
    }

    private static PasswordSource constructPasswordSource(InstanceParams params, String pwdSrcClassName, String pwSrcParams) {
        InstanceParams objParams = new InstanceParams(params.getContext(), pwSrcParams);
        return (PasswordSource)DataChannelFactoryBuilder.constructObject(pwdSrcClassName, PasswordSource.class, "password source", new DataChannelFactoryBuilder.CtorArgSpec(new Class[]{InstanceParams.class}, new Object[]{objParams}));
    }

    private static PasswordSource constructKSPasswordSource(InstanceParams params) {
        ReplicationSSLConfig config = (ReplicationSSLConfig)params.getContext().getRepNetConfig();
        String pwSrcClassName = config.getSSLKeyStorePasswordClass();
        if (pwSrcClassName == null || pwSrcClassName.equals("")) {
            return null;
        }
        String pwSrcParams = config.getSSLKeyStorePasswordParams();
        return SSLChannelFactory.constructPasswordSource(params, pwSrcClassName, pwSrcParams);
    }

    private static KeyStore loadStore(String storeName, char[] storePassword, String storeFlavor, String storeType) throws IllegalArgumentException {
        FileInputStream fis;
        KeyStore ks;
        if (storeType == null || storeType.isEmpty()) {
            storeType = KeyStore.getDefaultType();
        }
        try {
            ks = KeyStore.getInstance(storeType);
        }
        catch (KeyStoreException kse) {
            throw new IllegalArgumentException("Unable to find a " + storeFlavor + " instance of type " + storeType, kse);
        }
        try {
            fis = new FileInputStream(storeName);
        }
        catch (FileNotFoundException fnfe) {
            throw new IllegalArgumentException("Unable to locate specified " + storeFlavor + " " + storeName, fnfe);
        }
        try {
            ks.load(fis, storePassword);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Error reading from " + storeFlavor + " file " + storeName, ioe);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalArgumentException("Unable to check " + storeFlavor + " integrity: " + storeName, nsae);
        }
        catch (CertificateException ce) {
            throw new IllegalArgumentException("Not all certificates could be loaded: " + storeName, ce);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ioe) {}
        }
        return ks;
    }

    private static String getX509AlgoName() {
        String x509Name = System.getProperty(X509_ALGO_NAME_PROPERTY);
        if (x509Name != null && !x509Name.isEmpty()) {
            return x509Name;
        }
        String jvmVendor = System.getProperty("java.vendor");
        if (jvmVendor.startsWith("IBM")) {
            return "IbmX509";
        }
        return "SunX509";
    }

    private static class KeyStoreInfo {
        private final String ksFile;
        private final KeyStore ks;
        private final char[] ksPwd;

        private KeyStoreInfo(String ksFile, KeyStore ks, char[] ksPwd) {
            this.ksFile = ksFile;
            this.ks = ks;
            this.ksPwd = ksPwd == null ? null : Arrays.copyOf(ksPwd, ksPwd.length);
        }

        private void clearPassword() {
            if (this.ksPwd != null) {
                Arrays.fill(this.ksPwd, ' ');
            }
        }
    }
}

