/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.NameLNLogEntry;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.txn.Txn;
import java.nio.ByteBuffer;

public final class NameLN
extends LN {
    private static final String BEGIN_TAG = "<nameLN>";
    private static final String END_TAG = "</nameLN>";
    private DatabaseId id;
    private boolean deleted;

    public NameLN(DatabaseId id) {
        super(new byte[0]);
        this.id = id;
        this.deleted = false;
    }

    public NameLN() {
        this.id = new DatabaseId();
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    void makeDeleted() {
        this.deleted = true;
    }

    public DatabaseId getId() {
        return this.id;
    }

    public void setId(DatabaseId id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return this.dumpString(0, true);
    }

    @Override
    public String beginTag() {
        return BEGIN_TAG;
    }

    @Override
    public String endTag() {
        return END_TAG;
    }

    @Override
    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.dumpString(nSpaces, dumpTags));
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<deleted val=\"").append(Boolean.toString(this.deleted));
        sb.append("\">");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<id val=\"").append(this.id);
        sb.append("\">");
        sb.append('\n');
        return sb.toString();
    }

    @Override
    protected LogEntryType getLogType(boolean isInsert, boolean isTransactional) {
        return isTransactional ? LogEntryType.LOG_NAMELN_TRANSACTIONAL : LogEntryType.LOG_NAMELN;
    }

    @Override
    public int getLogSize() {
        return super.getLogSize() + this.id.getLogSize() + 1;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        this.id.writeToLog(logBuffer);
        byte booleans = (byte)(this.deleted ? 1 : 0);
        logBuffer.put(booleans);
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        super.readFromLog(itemBuffer, entryVersion);
        this.id.readFromLog(itemBuffer, entryVersion);
        byte booleans = itemBuffer.get();
        this.deleted = (booleans & 1) != 0;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        if (!(other instanceof NameLN)) {
            return false;
        }
        NameLN otherLN = (NameLN)other;
        if (!super.logicalEquals(otherLN)) {
            return false;
        }
        if (!this.id.equals(otherLN.id)) {
            return false;
        }
        return this.deleted == otherLN.deleted;
    }

    @Override
    protected void dumpLogAdditional(StringBuilder sb, boolean verbose) {
        this.id.dumpLog(sb, true);
    }

    @Override
    LNLogEntry<?> createLogEntry(LogEntryType entryType, DatabaseImpl dbImpl, byte[] key, long logAbortLsn, boolean logAbortKnownDeleted, Txn logTxn, ReplicationContext repContext) {
        return new NameLNLogEntry(entryType, this, dbImpl.getId(), key, logAbortLsn, logAbortKnownDeleted, logTxn, repContext);
    }
}

