/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.utilint.DbLsn;

public class TreeLocation {
    public BIN bin;
    public int index;
    public byte[] lnKey;
    public long childLsn = -1L;
    public int childLoggedSize;

    public void reset() {
        this.bin = null;
        this.index = -1;
        this.lnKey = null;
        this.childLsn = -1L;
        this.childLoggedSize = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("<TreeLocation bin=\"");
        if (this.bin == null) {
            sb.append("null");
        } else {
            sb.append(this.bin.getNodeId());
        }
        sb.append("\" index=\"");
        sb.append(this.index);
        sb.append("\" lnKey=\"");
        sb.append(Key.dumpString(this.lnKey, 0));
        sb.append("\" childLsn=\"");
        sb.append(DbLsn.toString(this.childLsn));
        sb.append("\" childLoggedSize=\"");
        sb.append(this.childLoggedSize);
        sb.append("\">");
        return sb.toString();
    }
}

