/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree.dupConvert;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.DupKeyData;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.dupConvert.DBIN;
import com.sleepycat.je.tree.dupConvert.DIN;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import java.util.ArrayList;

public class DupConvert {
    private static final boolean DEBUG = false;
    private final EnvironmentImpl envImpl;
    private final DbTree dbTree;
    private final boolean preloadAll;
    private final PreloadConfig preloadConfig;
    private LocalUtilizationTracker localTracker;
    private long nConverted;
    private BIN bin;
    private int index;

    public DupConvert(EnvironmentImpl envImpl, DbTree dbTree) {
        this.envImpl = envImpl;
        this.dbTree = dbTree;
        this.preloadAll = envImpl.getConfigManager().getBoolean(EnvironmentParams.ENV_DUP_CONVERT_PRELOAD_ALL);
        this.preloadConfig = envImpl.getDupConvertPreloadConfig() != null ? envImpl.getDupConvertPreloadConfig() : new PreloadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertDatabases() {
        if (this.preloadAll) {
            this.preloadAllDatabases();
        }
        for (DatabaseId dbId : this.dbTree.getDbNamesAndIds().keySet()) {
            DatabaseImpl dbImpl = this.dbTree.getDb(dbId);
            try {
                if (!this.needsConversion(dbImpl)) continue;
                this.convertDatabase(dbImpl);
            }
            finally {
                this.dbTree.releaseDb(dbImpl);
            }
        }
        assert (this.noDupNodesPresent());
    }

    private boolean noDupNodesPresent() {
        for (IN in : this.envImpl.getInMemoryINs()) {
            if (!(in instanceof DIN) && !(in instanceof DBIN)) continue;
            System.out.println(in.toString());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preloadAllDatabases() {
        ArrayList<DatabaseImpl> dbsToConvert = new ArrayList<DatabaseImpl>();
        try {
            for (DatabaseId dbId : this.dbTree.getDbNamesAndIds().keySet()) {
                DatabaseImpl dbImpl = this.dbTree.getDb(dbId);
                boolean releaseDbImpl = true;
                try {
                    if (!this.needsConversion(dbImpl)) continue;
                    dbsToConvert.add(dbImpl);
                    releaseDbImpl = false;
                }
                finally {
                    if (!releaseDbImpl) continue;
                    this.dbTree.releaseDb(dbImpl);
                }
            }
            if (dbsToConvert.size() == 0) {
                return;
            }
            DatabaseImpl[] dbArray = new DatabaseImpl[dbsToConvert.size()];
            dbsToConvert.toArray(dbArray);
            this.envImpl.preload(dbArray, this.preloadConfig);
        }
        finally {
            for (DatabaseImpl dbImpl : dbsToConvert) {
                this.dbTree.releaseDb(dbImpl);
            }
        }
    }

    private boolean needsConversion(DatabaseImpl dbImpl) {
        return dbImpl.getSortedDuplicates() && !dbImpl.getDupsConverted() && !dbImpl.isDeleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertDatabase(DatabaseImpl dbImpl) {
        boolean saveDeferredWrite = dbImpl.isDurableDeferredWrite();
        try {
            this.localTracker = new LocalUtilizationTracker(this.envImpl);
            dbImpl.setDeferredWrite(true);
            dbImpl.setKeyPrefixing();
            if (!this.preloadAll) {
                dbImpl.preload(this.preloadConfig);
            }
            this.bin = dbImpl.getTree().getFirstNode(CacheMode.UNCHANGED);
            if (this.bin == null) {
                return;
            }
            this.index = -1;
            while (this.getNextBinSlot()) {
                this.convertBinSlot();
            }
            dbImpl.setDupsConverted();
            dbImpl.sync(false);
            this.envImpl.getUtilizationProfile().flushLocalTracker(this.localTracker);
        }
        finally {
            dbImpl.setDeferredWrite(saveDeferredWrite);
        }
    }

    private boolean getNextBinSlot() {
        ++this.index;
        if (this.index < this.bin.getNEntries()) {
            return true;
        }
        this.bin.compactMemory();
        assert (this.bin.verifyMemorySize());
        this.bin = this.bin.getDatabase().getTree().getNextBin(this.bin, CacheMode.UNCHANGED);
        if (this.bin == null) {
            return false;
        }
        this.index = 0;
        return true;
    }

    private void convertBinSlot() {
        if (this.isLNDeleted(this.bin, this.index)) {
            this.deleteSlot();
            return;
        }
        Node node = this.bin.fetchLNOrDIN(this.index, CacheMode.DEFAULT);
        if (!node.containsDuplicates()) {
            assert (node instanceof LN);
            ++this.nConverted;
            return;
        }
        byte[] binKey = this.bin.getKey(this.index);
        DIN din = (DIN)node;
        this.deleteSlot();
        this.convertDin(din, binKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLNDeleted(BIN checkBin, int checkIndex) {
        if (!checkBin.isEntryKnownDeleted(checkIndex) && !checkBin.isEntryPendingDeleted(checkIndex)) {
            return false;
        }
        long lsn = checkBin.getLsn(checkIndex);
        if (lsn == -1L) {
            return true;
        }
        BasicLocker lockingTxn = BasicLocker.createBasicLocker(this.envImpl);
        lockingTxn.setPreemptable(false);
        try {
            LockResult lockRet = lockingTxn.nonBlockingLock(lsn, LockType.READ, false, checkBin.getDatabase());
            if (lockRet.getLockGrant() == LockGrantType.DENIED) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lockingTxn.operationEnd();
        }
    }

    private void deleteSlot() {
        this.bin.deleteEntry(this.index, true);
        if (this.index == 0 && this.bin.getNEntries() != 0) {
            this.bin.setIdentifierKey(this.bin.getKey(0));
        }
        --this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void convertDin(DIN din, byte[] binKey) {
        din.latch();
        try {
            for (i = 0; i < din.getNEntries(); ++i) {
                child = din.fetchIN(i);
                if (!DupConvert.$assertionsDisabled && child.isBINDelta(false)) {
                    throw new AssertionError();
                }
                if (child instanceof DBIN) {
                    dbin = (DBIN)child;
                    dbin.latch();
                    try {
                        for (j = 0; j < dbin.getNEntries(); ++j) {
                            if (this.isLNDeleted(dbin, j)) continue;
                            this.convertDbinSlot(dbin, j, binKey);
                        }
                        if (!DupConvert.$assertionsDisabled && !dbin.verifyMemorySize()) {
                            throw new AssertionError();
                        }
                        if (dbin.getLastLoggedVersion() == -1L) ** GOTO lbl24
                        this.localTracker.countObsoleteNodeInexact(dbin.getLastLoggedVersion(), dbin.getLogType(), 0, dbin.getDatabase());
                    }
                    finally {
                        dbin.releaseLatch();
                    }
                } else {
                    this.convertDin((DIN)child, binKey);
                }
lbl24:
                // 3 sources

                din.detachNode(i, false, -1L);
            }
            if (!DupConvert.$assertionsDisabled && !din.verifyMemorySize()) {
                throw new AssertionError();
            }
            if (din.getLastLoggedVersion() != -1L) {
                this.localTracker.countObsoleteNodeInexact(din.getLastLoggedVersion(), din.getLogType(), 0, din.getDatabase());
            }
            if ((dupCountRef = din.getDupCountLNRef()) != null && dupCountRef.getLsn() != -1L) {
                this.localTracker.countObsoleteNodeInexact(dupCountRef.getLsn(), LogEntryType.LOG_DUPCOUNTLN, 0, din.getDatabase());
            }
        }
        finally {
            din.releaseLatch();
        }
    }

    private void convertDbinSlot(DBIN dbin, int dbinIndex, byte[] binKey) {
        int newIndex;
        byte[] newKey = DupKeyData.replaceData(binKey, dbin.getKey(dbinIndex));
        if (this.bin.needsSplitting() || !this.bin.isKeyInBounds(newKey)) {
            this.bin.compactMemory();
            this.bin.releaseLatch();
            this.envImpl.daemonEviction(false);
            this.bin = dbin.getDatabase().getTree().searchSplitsAllowed(newKey, CacheMode.UNCHANGED);
        }
        if (((newIndex = this.bin.insertEntry1(null, newKey, dbin.getLsn(dbinIndex), dbin.getState(dbinIndex), false)) & 0x20000) == 0) {
            throw EnvironmentFailureException.unexpectedState("Key not inserted: " + Key.dumpString(newKey, 0) + " DB: " + dbin.getDatabase().getId());
        }
        this.index = newIndex & 0xFFFDFFFF;
        dbin.detachNode(dbinIndex, false, -1L);
        ++this.nConverted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertInKeys(DatabaseImpl dbImpl, IN in) {
        if (!dbImpl.getSortedDuplicates()) {
            return;
        }
        if (in instanceof DIN || in instanceof DBIN) {
            return;
        }
        in.latch();
        try {
            for (int i = 0; i < in.getNEntries(); ++i) {
                byte[] oldKey = in.getKey(i);
                byte[] newKey = DupKeyData.makePrefixKey(oldKey, 0, oldKey.length);
                in.updateEntry(i, in.getTarget(i), in.getLsn(i), in.getLastLoggedSize(i), newKey);
            }
            byte[] oldKey = in.getIdentifierKey();
            byte[] newKey = DupKeyData.makePrefixKey(oldKey, 0, oldKey.length);
            in.setIdentifierKey(newKey);
            assert (in.verifyMemorySize());
        }
        finally {
            in.releaseLatch();
        }
    }
}

