/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseExistsException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.util.DbScavenger;
import com.sleepycat.je.utilint.CmdUtil;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.logging.Level;

public class DbDump {
    private static final int VERSION = 3;
    protected File envHome = null;
    protected Environment env;
    protected String dbName = null;
    protected boolean formatUsingPrintable;
    private boolean dupSort;
    private String outputFileName = null;
    protected String outputDirectory = null;
    protected PrintStream outputFile = null;
    protected boolean doScavengerRun = false;
    protected boolean doAggressiveScavengerRun = false;
    protected boolean verbose = false;
    private static final String usageString = "usage: " + CmdUtil.getJavaCommand(DbDump.class) + "\n" + "  -h <dir> # environment home directory\n" + "  [-f <fileName>]     # output file, for non -rR dumps\n" + "  [-l]                # list databases in the environment\n" + "  [-p]                # output printable characters\n" + "  [-r]                # salvage mode\n" + "  [-R]                # aggressive salvage mode\n" + "  [-d] <directory>    # directory for *.dump files (salvage mode)\n" + "  [-s <databaseName>] # database to dump\n" + "  [-v]                # verbose in salvage mode\n" + "  [-V]                # print JE version number\n";

    private DbDump() {
    }

    @Deprecated
    public DbDump(Environment env, String dbName, PrintStream outputFile, String outputDirectory, boolean formatUsingPrintable) {
        this.init(env, dbName, outputFile, formatUsingPrintable);
    }

    public DbDump(Environment env, String dbName, PrintStream outputFile, boolean formatUsingPrintable) {
        this.init(env, dbName, outputFile, formatUsingPrintable);
    }

    private void init(Environment env, String dbName, PrintStream outputFile, boolean formatUsingPrintable) {
        this.envHome = env.getHome();
        this.env = env;
        this.dbName = dbName;
        this.outputFile = outputFile;
        this.formatUsingPrintable = formatUsingPrintable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        DbDump dumper = new DbDump();
        boolean listDbs = dumper.parseArgs(argv);
        if (dumper.doScavengerRun) {
            dumper.openEnv(false);
            dumper = new DbScavenger(dumper.env, dumper.outputDirectory, dumper.formatUsingPrintable, dumper.doAggressiveScavengerRun, dumper.verbose);
            ((DbScavenger)dumper).setDumpCorruptedBounds(true);
        }
        if (listDbs) {
            dumper.listDbs();
            System.exit(0);
        }
        try {
            dumper.dump();
        }
        catch (Throwable T) {
            T.printStackTrace();
        }
        finally {
            dumper.env.close();
            if (dumper.outputFile != null && dumper.outputFile != System.out) {
                dumper.outputFile.close();
            }
        }
    }

    private void listDbs() throws EnvironmentNotFoundException, EnvironmentLockedException {
        this.openEnv(true);
        List<String> dbNames = this.env.getDatabaseNames();
        for (String name : dbNames) {
            System.out.println(name);
        }
    }

    protected void printUsage(String msg) {
        System.err.println(msg);
        System.err.println(usageString);
        System.exit(-1);
    }

    protected boolean parseArgs(String[] argv) throws IOException {
        int argc = 0;
        int nArgs = argv.length;
        boolean listDbs = false;
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-p")) {
                this.formatUsingPrintable = true;
                continue;
            }
            if (thisArg.equals("-V")) {
                System.out.println(JEVersion.CURRENT_VERSION);
                System.exit(0);
                continue;
            }
            if (thisArg.equals("-l")) {
                listDbs = true;
                continue;
            }
            if (thisArg.equals("-r")) {
                this.doScavengerRun = true;
                continue;
            }
            if (thisArg.equals("-R")) {
                this.doScavengerRun = true;
                this.doAggressiveScavengerRun = true;
                continue;
            }
            if (thisArg.equals("-f")) {
                if (argc < nArgs) {
                    this.outputFileName = argv[argc++];
                    continue;
                }
                this.printUsage("-f requires an argument");
                continue;
            }
            if (thisArg.equals("-h")) {
                if (argc < nArgs) {
                    String envDir = argv[argc++];
                    this.envHome = new File(envDir);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            if (thisArg.equals("-d")) {
                if (argc < nArgs) {
                    this.outputDirectory = argv[argc++];
                    continue;
                }
                this.printUsage("-d requires an argument");
                continue;
            }
            if (thisArg.equals("-s")) {
                if (argc < nArgs) {
                    this.dbName = argv[argc++];
                    continue;
                }
                this.printUsage("-s requires an argument");
                continue;
            }
            if (thisArg.equals("-v")) {
                this.verbose = true;
                continue;
            }
            this.printUsage(thisArg + " is not a valid option.");
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
        if (!listDbs && !this.doScavengerRun && this.dbName == null) {
            this.printUsage("Must supply a database name if -l not supplied.");
        }
        this.outputFile = this.outputFileName == null ? System.out : new PrintStream(new FileOutputStream(this.outputFileName));
        return listDbs;
    }

    protected void openEnv(boolean doRecovery) throws EnvironmentNotFoundException, EnvironmentLockedException {
        if (this.env == null) {
            EnvironmentConfig envConfiguration = new EnvironmentConfig();
            envConfiguration.setReadOnly(true);
            envConfiguration.setConfigParam(EnvironmentParams.ENV_RECOVERY.getName(), doRecovery ? "true" : "false");
            envConfiguration.setConfigParam(EnvironmentParams.ENV_COMPARATORS_REQUIRED.getName(), "true");
            this.env = new Environment(this.envHome, envConfiguration);
        }
    }

    public void dump() throws EnvironmentNotFoundException, EnvironmentLockedException, DatabaseNotFoundException, IOException {
        Database db;
        this.openEnv(true);
        LoggerUtils.envLogMsg(Level.INFO, DbInternal.getEnvironmentImpl(this.env), "DbDump.dump of " + this.dbName + " starting");
        DatabaseEntry foundKey = new DatabaseEntry();
        DatabaseEntry foundData = new DatabaseEntry();
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setReadOnly(true);
        DbInternal.setUseExistingConfig(dbConfig, true);
        try {
            db = this.env.openDatabase(null, this.dbName, dbConfig);
        }
        catch (DatabaseExistsException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        this.dupSort = db.getConfig().getSortedDuplicates();
        this.printHeader(this.outputFile, this.dupSort, this.formatUsingPrintable);
        Cursor cursor = db.openCursor(null, null);
        while (cursor.getNext(foundKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            this.dumpOne(this.outputFile, foundKey.getData(), this.formatUsingPrintable);
            this.dumpOne(this.outputFile, foundData.getData(), this.formatUsingPrintable);
        }
        cursor.close();
        db.close();
        this.outputFile.println("DATA=END");
        LoggerUtils.envLogMsg(Level.INFO, DbInternal.getEnvironmentImpl(this.env), "DbDump.dump of " + this.dbName + " ending");
    }

    protected void printHeader(PrintStream o, boolean dupSort, boolean formatUsingPrintable) {
        o.println("VERSION=3");
        if (formatUsingPrintable) {
            o.println("format=print");
        } else {
            o.println("format=bytevalue");
        }
        o.println("type=btree");
        o.println("dupsort=" + (dupSort ? "1" : "0"));
        o.println("HEADER=END");
    }

    protected void dumpOne(PrintStream o, byte[] ba, boolean formatUsingPrintable) {
        StringBuilder sb = new StringBuilder();
        sb.append(' ');
        CmdUtil.formatEntry(sb, ba, formatUsingPrintable);
        o.println(sb.toString());
    }
}

