/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.DatabaseComparator;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.ComparatorCatalog;
import com.sleepycat.persist.impl.CompositeKeyFormat;
import com.sleepycat.persist.impl.EnumFormat;
import com.sleepycat.persist.impl.FieldInfo;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistKeyBinding;
import com.sleepycat.persist.impl.RefreshException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class PersistComparator
implements DatabaseComparator,
Comparator<byte[]>,
Serializable {
    private static final long serialVersionUID = 5221576538843355317L;
    private String keyClassName;
    private String[] comositeFieldOrder;
    private Map<String, String[]> fieldFormatData;
    private transient PersistKeyBinding binding;

    public PersistComparator(PersistKeyBinding binding) {
        this.binding = binding;
        CompositeKeyFormat format = (CompositeKeyFormat)binding.keyFormat;
        this.keyClassName = format.getClassName();
        this.comositeFieldOrder = CompositeKeyFormat.getFieldNameArray(format.getClassMetadata().getCompositeKeyFields());
        for (FieldInfo field : format.getFieldInfo()) {
            Format fieldFormat = field.getType();
            if (!fieldFormat.isEnum()) continue;
            EnumFormat enumFormat = (EnumFormat)fieldFormat;
            if (this.fieldFormatData == null) {
                this.fieldFormatData = new HashMap<String, String[]>();
            }
            this.fieldFormatData.put(enumFormat.getClassName(), enumFormat.getFormatData());
        }
    }

    @Override
    public void initialize(ClassLoader loader) {
        Class keyClass;
        ComparatorCatalog catalog;
        if (this.fieldFormatData == null) {
            catalog = new ComparatorCatalog(loader, null);
        } else {
            HashMap<String, Format> enumFormats = new HashMap<String, Format>();
            catalog = new ComparatorCatalog(loader, enumFormats);
            for (Map.Entry<String, String[]> entry : this.fieldFormatData.entrySet()) {
                Class fldClass;
                String fldClassName = entry.getKey();
                String[] enumNames = entry.getValue();
                try {
                    fldClass = catalog.resolveClass(fldClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
                enumFormats.put(fldClassName, new EnumFormat(catalog, fldClass, enumNames));
            }
            for (Format fldFormat : enumFormats.values()) {
                fldFormat.initializeIfNeeded(catalog, null);
            }
        }
        try {
            keyClass = catalog.resolveClass(this.keyClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        this.binding = new PersistKeyBinding((Catalog)catalog, keyClass, this.comositeFieldOrder);
    }

    @Override
    public int compare(byte[] b1, byte[] b2) {
        if (this.binding == null) {
            throw DbCompat.unexpectedState("Not initialized");
        }
        try {
            Comparable k1 = (Comparable)this.binding.bytesToObject(b1, 0, b1.length);
            Comparable k2 = (Comparable)this.binding.bytesToObject(b2, 0, b2.length);
            return k1.compareTo(k2);
        }
        catch (RefreshException e) {
            throw DbCompat.unexpectedException(e);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[DPL comparator ");
        b.append(" keyClassName = ").append(this.keyClassName);
        b.append(" comositeFieldOrder = [");
        for (String s : this.comositeFieldOrder) {
            b.append(s).append(',');
        }
        b.append(']');
        b.append(" fieldFormatData = {");
        for (Map.Entry<String, String[]> entry : this.fieldFormatData.entrySet()) {
            b.append(entry.getKey()).append(": [");
            for (String s : entry.getValue()) {
                b.append(s).append(',');
            }
            b.append(']');
        }
        b.append('}');
        b.append(']');
        return b.toString();
    }
}

