/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.FilesToMigrate;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UtilizationCalculator {
    private final EnvironmentImpl env;
    private final Cleaner cleaner;
    private final Logger logger;
    private final FilesToMigrate filesToMigrate;
    private volatile int lastKnownUtilization = -1;

    UtilizationCalculator(EnvironmentImpl env, Cleaner cleaner) {
        this.env = env;
        this.cleaner = cleaner;
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.filesToMigrate = new FilesToMigrate(env);
    }

    int getLastKnownUtilization() {
        return this.lastKnownUtilization;
    }

    synchronized Long getBestFile(SortedMap<Long, FileSummary> fileSummaryMap, boolean forceCleaning, boolean isBacklog, Set<Long> excludeFiles) {
        Level logLevel;
        String loggingMsg;
        Long fileChosen;
        long firstActiveTxnFile;
        if (fileSummaryMap.size() == 0) {
            LoggerUtils.logMsg(this.logger, this.env, Level.SEVERE, "Can't clean, map is empty.");
            return null;
        }
        boolean isLoggingLevelFine = this.logger.isLoggable(Level.FINE);
        int useMinUtilization = this.cleaner.minUtilization;
        int useMinFileUtilization = this.cleaner.minFileUtilization;
        int useMinAge = this.cleaner.minAge;
        long firstActiveFile = fileSummaryMap.lastKey();
        long firstActiveTxnLsn = this.env.getTxnManager().getFirstActiveLsn();
        if (firstActiveTxnLsn != -1L && firstActiveFile > (firstActiveTxnFile = DbLsn.getFileNumber(firstActiveTxnLsn))) {
            firstActiveFile = firstActiveTxnFile;
        }
        long lastFileToClean = firstActiveFile - (long)useMinAge;
        Long bestFile = null;
        int bestUtilization = 101;
        long totalSize = 0L;
        long totalObsoleteSize = 0L;
        long lastKnownSize = 0L;
        long lastKnownObsoleteSize = 0L;
        for (Map.Entry<Long, FileSummary> entry : fileSummaryMap.entrySet()) {
            Long file = entry.getKey();
            long fileNum = file;
            FileSummary summary = entry.getValue();
            int obsoleteSize = summary.getObsoleteSize();
            lastKnownSize += (long)summary.totalSize;
            lastKnownObsoleteSize += (long)obsoleteSize;
            if (this.cleaner.getFileSelector().isFileCleaningInProgress(file)) {
                int utilizedSize = summary.totalSize - obsoleteSize;
                totalSize += (long)utilizedSize;
                if (!isLoggingLevelFine) continue;
                LoggerUtils.logMsg(this.logger, this.env, Level.FINE, "Skip file previously selected for cleaning: 0x" + Long.toHexString(fileNum) + " utilizedSize: " + utilizedSize + " " + summary);
                continue;
            }
            totalSize += (long)summary.totalSize;
            totalObsoleteSize += (long)obsoleteSize;
            if (excludeFiles.contains(file) || fileNum > lastFileToClean) continue;
            int thisUtilization = FileSummary.utilization(obsoleteSize, summary.totalSize);
            if (bestFile != null && thisUtilization >= bestUtilization) continue;
            bestFile = file;
            bestUtilization = thisUtilization;
        }
        int totalUtilization = FileSummary.utilization(totalObsoleteSize, totalSize);
        this.lastKnownUtilization = FileSummary.utilization(lastKnownObsoleteSize, lastKnownSize);
        if (totalUtilization < useMinUtilization || bestUtilization < useMinFileUtilization) {
            fileChosen = bestFile;
            loggingMsg = "Chose lowest utilized file for cleaning.";
        } else if (!isBacklog && this.filesToMigrate.hasNext(fileSummaryMap)) {
            fileChosen = this.filesToMigrate.next(fileSummaryMap);
            loggingMsg = "Chose file from files-to-migrate for cleaning.";
        } else if (forceCleaning) {
            fileChosen = bestFile;
            loggingMsg = "Chose file for forced cleaning (during testing).";
        } else {
            fileChosen = null;
            loggingMsg = "No file selected for cleaning.";
        }
        Level level = logLevel = fileChosen != null ? Level.INFO : Level.FINE;
        if (this.logger.isLoggable(logLevel)) {
            String fileChosenString = fileChosen != null ? " fileChosen: 0x" + Long.toHexString(fileChosen) : "";
            LoggerUtils.logMsg(this.logger, this.env, logLevel, loggingMsg + fileChosenString + " totalUtilization: " + totalUtilization + " bestFileUtilization: " + bestUtilization);
        }
        return fileChosen;
    }

    synchronized Long getCheapestFileToClean(SortedMap<Long, FileSummary> fileSummaryMap, SortedSet<Long> candidateFiles) {
        if (candidateFiles.size() == 0) {
            return null;
        }
        if (candidateFiles.size() == 1) {
            return candidateFiles.first();
        }
        Long bestFile = null;
        int bestCost = Integer.MAX_VALUE;
        for (Long file : candidateFiles) {
            FileSummary summary = (FileSummary)fileSummaryMap.get(file);
            if (summary == null) {
                return file;
            }
            int thisCost = summary.getNonObsoleteCount();
            if (bestFile != null && thisCost >= bestCost) continue;
            bestFile = file;
            bestCost = thisCost;
        }
        return bestFile;
    }
}

