/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.cleaner.PackedOffsets;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.StartupTracker;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.FileSummaryLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UtilizationProfile {
    private final EnvironmentImpl env;
    private final UtilizationTracker tracker;
    private DatabaseImpl fileSummaryDb;
    private SortedMap<Long, FileSummary> fileSummaryMap;
    private boolean cachePopulated;
    private final Logger logger;

    public UtilizationProfile(EnvironmentImpl env, UtilizationTracker tracker) {
        this.env = env;
        this.tracker = tracker;
        this.fileSummaryMap = new TreeMap<Long, FileSummary>();
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    synchronized int getNumberOfFiles() {
        return this.fileSummaryMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getTotalLogSize() {
        long size = 0L;
        UtilizationProfile utilizationProfile = this;
        synchronized (utilizationProfile) {
            for (FileSummary summary : this.fileSummaryMap.values()) {
                size += (long)summary.totalSize;
            }
        }
        for (TrackedFileSummary summary : this.tracker.getTrackedFiles()) {
            size += (long)summary.totalSize;
        }
        return size;
    }

    private synchronized FileSummary getFileSummary(Long file) {
        FileSummary summary = (FileSummary)this.fileSummaryMap.get(file);
        TrackedFileSummary trackedSummary = this.tracker.getTrackedFile(file);
        if (trackedSummary != null) {
            FileSummary totals = new FileSummary();
            totals.add(summary);
            totals.add(trackedSummary);
            summary = totals;
        }
        return summary;
    }

    public void flushLocalTracker(LocalUtilizationTracker localTracker) throws DatabaseException {
        this.env.getLogManager().transferToUtilizationTracker(localTracker);
        this.flushFileUtilization(localTracker.getTrackedFiles());
        this.flushDbUtilization(localTracker);
    }

    public void flushFileUtilization(Collection<TrackedFileSummary> activeFiles) throws DatabaseException {
        if (!DbInternal.getCheckpointUP(this.env.getConfigManager().getEnvironmentConfig())) {
            return;
        }
        for (TrackedFileSummary activeFile : activeFiles) {
            long fileNum = activeFile.getFileNumber();
            TrackedFileSummary tfs = this.tracker.getTrackedFile(fileNum);
            if (tfs == null) continue;
            this.flushFileSummary(tfs);
        }
    }

    private void flushDbUtilization(LocalUtilizationTracker localTracker) throws DatabaseException {
        if (!DbInternal.getCheckpointUP(this.env.getConfigManager().getEnvironmentConfig())) {
            return;
        }
        for (DatabaseImpl databaseImpl : localTracker.getTrackedDbs()) {
            if (databaseImpl.isDeleted() || !databaseImpl.isDirty()) continue;
            this.env.getDbTree().modifyDbRoot(databaseImpl);
        }
    }

    public synchronized SortedMap<Long, FileSummary> getFileSummaryMap(boolean includeTrackedFiles) {
        assert (this.cachePopulated);
        if (includeTrackedFiles) {
            TreeMap<Long, FileSummary> map = new TreeMap<Long, FileSummary>();
            for (Long file : this.fileSummaryMap.keySet()) {
                FileSummary summary = this.getFileSummary(file);
                map.put(file, summary);
            }
            for (TrackedFileSummary summary : this.tracker.getTrackedFiles()) {
                Long fileNum = summary.getFileNumber();
                if (map.containsKey(fileNum)) continue;
                map.put(fileNum, summary);
            }
            return map;
        }
        return new TreeMap<Long, FileSummary>(this.fileSummaryMap);
    }

    SortedMap<Long, FileSummary> getMapForTesting() {
        return this.fileSummaryMap;
    }

    private synchronized void clearCache() {
        int memorySize = this.fileSummaryMap.size() * MemoryBudget.UTILIZATION_PROFILE_ENTRY;
        MemoryBudget mb = this.env.getMemoryBudget();
        mb.updateAdminMemoryUsage(0 - memorySize);
        this.fileSummaryMap = new TreeMap<Long, FileSummary>();
        this.cachePopulated = false;
    }

    void removeFile(Long fileNum, Set<DatabaseId> databases) throws DatabaseException {
        this.removePerDbMetadata(Collections.singleton(fileNum), databases);
        this.removePerFileMetadata(fileNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePerFileMetadata(Long fileNum) throws DatabaseException {
        UtilizationProfile utilizationProfile = this;
        synchronized (utilizationProfile) {
            assert (this.cachePopulated);
            FileSummary oldSummary = (FileSummary)this.fileSummaryMap.remove(fileNum);
            if (oldSummary != null) {
                MemoryBudget mb = this.env.getMemoryBudget();
                mb.updateAdminMemoryUsage(0 - MemoryBudget.UTILIZATION_PROFILE_ENTRY);
            }
        }
        this.deleteFileSummary(fileNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePerDbMetadata(final Collection<Long> fileNums, Set<DatabaseId> databases) throws DatabaseException {
        final LogManager logManager = this.env.getLogManager();
        final DbTree dbTree = this.env.getDbTree();
        DatabaseImpl idDatabase = dbTree.getDb(DbTree.ID_DB_ID);
        DatabaseImpl nameDatabase = dbTree.getDb(DbTree.NAME_DB_ID);
        boolean logRoot = false;
        if (logManager.removeDbFileSummaries(idDatabase, fileNums)) {
            logRoot = true;
        }
        if (logManager.removeDbFileSummaries(nameDatabase, fileNums)) {
            logRoot = true;
        }
        if (logRoot) {
            this.env.logMapTreeRoot();
        }
        if (databases != null) {
            for (DatabaseId dbId : databases) {
                if (dbId.equals(DbTree.ID_DB_ID) || dbId.equals(DbTree.NAME_DB_ID)) continue;
                DatabaseImpl db = dbTree.getDb(dbId);
                try {
                    if (db == null || !logManager.removeDbFileSummaries(db, fileNums)) continue;
                    dbTree.modifyDbRoot(db);
                }
                finally {
                    dbTree.releaseDb(db);
                }
            }
        } else {
            CursorImpl.traverseDbWithCursor(idDatabase, LockType.NONE, true, new CursorImpl.WithCursor(){

                @Override
                public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                    DatabaseImpl db;
                    MapLN mapLN = (MapLN)cursor.lockAndGetCurrentLN(LockType.NONE);
                    if (mapLN != null && logManager.removeDbFileSummaries(db = mapLN.getDatabase(), fileNums)) {
                        dbTree.modifyDbRoot(db, -1L, false);
                    }
                    return true;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFileSummary(Long fileNum) throws DatabaseException {
        BasicLocker locker = null;
        CursorImpl cursor = null;
        try {
            locker = BasicLocker.createBasicLocker(this.env, false);
            cursor = new CursorImpl(this.fileSummaryDb, locker);
            cursor.setAllowEviction(true);
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry dataEntry = new DatabaseEntry();
            long fileNumVal = fileNum;
            dataEntry.setPartial(0, 0, true);
            OperationStatus status = OperationStatus.SUCCESS;
            status = this.getFirstFSLN(cursor, fileNumVal, keyEntry, dataEntry, LockType.WRITE) ? OperationStatus.SUCCESS : OperationStatus.NOTFOUND;
            while (status == OperationStatus.SUCCESS && fileNumVal == FileSummaryLN.getFileNumber(keyEntry.getData())) {
                this.env.daemonEviction(true);
                cursor.deleteCurrentRecord(ReplicationContext.NO_REPLICATE);
                status = cursor.getNext(keyEntry, dataEntry, LockType.WRITE, false, true, false, null);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (locker != null) {
                locker.operationEnd();
            }
        }
        TrackedFileSummary tfs = this.tracker.getTrackedFile(fileNum);
        if (tfs != null) {
            this.env.getLogManager().removeTrackedFile(tfs);
        }
    }

    public void flushFileSummary(TrackedFileSummary tfs) throws DatabaseException {
        if (tfs.getAllowFlush()) {
            this.putFileSummary(tfs);
        }
    }

    private synchronized PackedOffsets putFileSummary(TrackedFileSummary tfs) throws DatabaseException {
        if (this.env.isReadOnly()) {
            throw EnvironmentFailureException.unexpectedState("Cannot write file summary in a read-only environment");
        }
        if (tfs.isEmpty()) {
            return null;
        }
        if (!this.cachePopulated) {
            return null;
        }
        long fileNum = tfs.getFileNumber();
        Long fileNumLong = fileNum;
        FileSummary summary = (FileSummary)this.fileSummaryMap.get(fileNumLong);
        if (summary == null) {
            if (!this.fileSummaryMap.isEmpty() && fileNum < this.fileSummaryMap.lastKey() && !this.env.getFileManager().isFileValid(fileNum)) {
                this.env.getLogManager().removeTrackedFile(tfs);
                return null;
            }
            summary = new FileSummary();
        }
        FileSummary tmp = new FileSummary();
        tmp.add(summary);
        tmp.add(tfs);
        int sequence = tmp.getEntriesCounted();
        FileSummaryLN ln = new FileSummaryLN(summary);
        ln.setTrackedSummary(tfs);
        this.insertFileSummary(ln, fileNum, sequence);
        summary = ln.getBaseSummary();
        if (this.fileSummaryMap.put(fileNumLong, summary) == null) {
            MemoryBudget mb = this.env.getMemoryBudget();
            mb.updateAdminMemoryUsage(MemoryBudget.UTILIZATION_PROFILE_ENTRY);
        }
        return ln.getObsoleteOffsets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackedOffsets getObsoleteDetail(Long fileNum, boolean logUpdate) throws DatabaseException {
        PackedOffsets packedOffsets = new PackedOffsets();
        if (!this.env.getCleaner().trackDetail) {
            return packedOffsets;
        }
        assert (this.cachePopulated);
        long fileNumVal = fileNum;
        ArrayList<long[]> list = new ArrayList<long[]>();
        TrackedFileSummary tfs = this.env.getLogManager().getUnflushableTrackedSummary(fileNumVal);
        try {
            BasicLocker locker = BasicLocker.createBasicLocker(this.env, false);
            CursorImpl cursor = new CursorImpl(this.fileSummaryDb, locker);
            try {
                cursor.setAllowEviction(true);
                DatabaseEntry keyEntry = new DatabaseEntry();
                DatabaseEntry dataEntry = new DatabaseEntry();
                OperationStatus status = OperationStatus.SUCCESS;
                if (!this.getFirstFSLN(cursor, fileNumVal, keyEntry, dataEntry, LockType.NONE)) {
                    status = OperationStatus.NOTFOUND;
                }
                while (status == OperationStatus.SUCCESS) {
                    this.env.daemonEviction(true);
                    FileSummaryLN ln = (FileSummaryLN)cursor.lockAndGetCurrentLN(LockType.NONE);
                    if (ln != null) {
                        if (fileNumVal != FileSummaryLN.getFileNumber(keyEntry.getData())) {
                            break;
                        }
                        PackedOffsets offsets = ln.getObsoleteOffsets();
                        if (offsets != null) {
                            list.add(offsets.toArray());
                        }
                        cursor.evictLN();
                    }
                    status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, false, true, false, null);
                }
            }
            finally {
                cursor.close();
                locker.operationEnd();
            }
            if (!tfs.isEmpty()) {
                if (logUpdate) {
                    PackedOffsets offsets = this.putFileSummary(tfs);
                    if (offsets != null) {
                        list.add(offsets.toArray());
                    }
                } else {
                    long[] offsetList = tfs.getObsoleteOffsets();
                    if (offsetList != null) {
                        list.add(offsetList);
                    }
                }
            }
        }
        finally {
            tfs.setAllowFlush(true);
        }
        int size = 0;
        for (int i = 0; i < list.size(); ++i) {
            long[] a = (long[])list.get(i);
            size += a.length;
        }
        long[] offsets = new long[size];
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            long[] a = (long[])list.get(i);
            System.arraycopy(a, 0, offsets, index, a.length);
            index += a.length;
        }
        assert (index == offsets.length);
        packedOffsets.pack(offsets);
        return packedOffsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean populateCache(StartupTracker.Counter counter) throws DatabaseException {
        assert (!this.cachePopulated);
        if (!this.openFileSummaryDatabase()) {
            return false;
        }
        int oldMemorySize = this.fileSummaryMap.size() * MemoryBudget.UTILIZATION_PROFILE_ENTRY;
        Object[] existingFiles = this.env.getFileManager().getAllFileNumbers();
        BasicLocker locker = null;
        CursorImpl cursor = null;
        try {
            locker = BasicLocker.createBasicLocker(this.env, false);
            cursor = new CursorImpl(this.fileSummaryDb, locker);
            cursor.setAllowEviction(true);
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry dataEntry = new DatabaseEntry();
            if (cursor.positionFirstOrLast(true)) {
                OperationStatus status = cursor.lockAndGetCurrent(keyEntry, dataEntry, LockType.NONE, false, true, true);
                if (status != OperationStatus.SUCCESS) {
                    status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, false, true, false, null);
                }
                while (status == OperationStatus.SUCCESS) {
                    counter.incNumRead();
                    this.env.daemonEviction(false);
                    FileSummaryLN ln = (FileSummaryLN)cursor.lockAndGetCurrentLN(LockType.NONE);
                    if (ln == null) {
                        status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, false, true, false, null);
                        continue;
                    }
                    byte[] keyBytes = keyEntry.getData();
                    boolean isOldVersion = FileSummaryLN.hasStringKey(keyBytes);
                    long fileNum = FileSummaryLN.getFileNumber(keyBytes);
                    Long fileNumLong = fileNum;
                    if (Arrays.binarySearch(existingFiles, fileNumLong) >= 0) {
                        counter.incNumProcessed();
                        FileSummary summary = ln.getBaseSummary();
                        this.fileSummaryMap.put(fileNumLong, summary);
                        if (isOldVersion && !this.env.isReadOnly()) {
                            this.insertFileSummary(ln, fileNum, 0);
                            cursor.deleteCurrentRecord(ReplicationContext.NO_REPLICATE);
                        } else {
                            cursor.evictLN();
                        }
                    } else {
                        counter.incNumDeleted();
                        this.fileSummaryMap.remove(fileNumLong);
                        if (!this.env.isReadOnly()) {
                            this.removePerDbMetadata(Collections.singleton(fileNumLong), null);
                            if (isOldVersion) {
                                cursor.latchBIN();
                                cursor.deleteCurrentRecord(ReplicationContext.NO_REPLICATE);
                            } else {
                                this.deleteFileSummary(fileNumLong);
                            }
                        }
                    }
                    if (isOldVersion) {
                        status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, false, true, false, null);
                        continue;
                    }
                    if (this.getFirstFSLN(cursor, fileNum + 1L, keyEntry, dataEntry, LockType.NONE)) continue;
                    status = OperationStatus.NOTFOUND;
                }
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (locker != null) {
                locker.operationEnd();
            }
            int newMemorySize = this.fileSummaryMap.size() * MemoryBudget.UTILIZATION_PROFILE_ENTRY;
            MemoryBudget mb = this.env.getMemoryBudget();
            mb.updateAdminMemoryUsage(newMemorySize - oldMemorySize);
        }
        this.cachePopulated = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getFirstFSLN(CursorImpl cursor, long fileNum, DatabaseEntry keyEntry, DatabaseEntry dataEntry, LockType lockType) throws DatabaseException {
        byte[] keyBytes = FileSummaryLN.makePartialKey(fileNum);
        keyEntry.setData(keyBytes);
        cursor.reset();
        try {
            boolean exactKeyMatch;
            int result = cursor.searchRange(keyEntry, null);
            if ((result & 1) == 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = exactKeyMatch = (result & 2) != 0;
            if (exactKeyMatch && cursor.lockAndGetCurrent(keyEntry, dataEntry, lockType, false, true, false) != OperationStatus.KEYEMPTY) {
                boolean bl2 = true;
                return bl2;
            }
        }
        finally {
            cursor.releaseBIN();
        }
        cursor.evictLN();
        OperationStatus status = cursor.getNext(keyEntry, dataEntry, lockType, false, true, false, null);
        return status == OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openFileSummaryDatabase() throws DatabaseException {
        if (this.fileSummaryDb != null) {
            return true;
        }
        DbTree dbTree = this.env.getDbTree();
        Txn autoTxn = null;
        boolean operationOk = false;
        try {
            autoTxn = Txn.createLocalAutoTxn(this.env, new TransactionConfig());
            DatabaseImpl db = dbTree.getDb(autoTxn, DbType.UTILIZATION.getInternalName(), null);
            if (db == null) {
                if (this.env.isReadOnly()) {
                    boolean bl = false;
                    return bl;
                }
                DatabaseConfig dbConfig = new DatabaseConfig();
                dbConfig.setReplicated(false);
                db = dbTree.createInternalDb(autoTxn, DbType.UTILIZATION.getInternalName(), dbConfig);
            }
            this.fileSummaryDb = db;
            operationOk = true;
            boolean bl = true;
            return bl;
        }
        finally {
            if (autoTxn != null) {
                ((Locker)autoTxn).operationEnd(operationOk);
            }
        }
    }

    public DatabaseImpl getFileSummaryDb() {
        return this.fileSummaryDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean insertFileSummary(FileSummaryLN ln, long fileNum, int sequence) throws DatabaseException {
        byte[] keyBytes = FileSummaryLN.makeFullKey(fileNum, sequence);
        BasicLocker locker = null;
        CursorImpl cursor = null;
        try {
            locker = BasicLocker.createBasicLocker(this.env, false);
            cursor = new CursorImpl(this.fileSummaryDb, locker);
            OperationStatus status = cursor.insertRecord(keyBytes, ln, false, ReplicationContext.NO_REPLICATE);
            if (status == OperationStatus.KEYEXIST) {
                LoggerUtils.traceAndLog(this.logger, this.env, Level.SEVERE, "Cleaner duplicate key sequence file=0x" + Long.toHexString(fileNum) + " sequence=0x" + Long.toHexString(sequence));
                boolean bl = false;
                return bl;
            }
            cursor.evictLN();
            boolean bl = true;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (locker != null) {
                locker.operationEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyFileSummaryDatabase() throws DatabaseException {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        this.openFileSummaryDatabase();
        BasicLocker locker = null;
        CursorImpl cursor = null;
        boolean ok = true;
        try {
            locker = BasicLocker.createBasicLocker(this.env, false);
            cursor = new CursorImpl(this.fileSummaryDb, locker);
            cursor.setAllowEviction(true);
            if (cursor.positionFirstOrLast(true)) {
                OperationStatus status = cursor.lockAndGetCurrent(key, data, LockType.NONE, false, true, true);
                while (status == OperationStatus.SUCCESS) {
                    this.env.daemonEviction(true);
                    FileSummaryLN ln = (FileSummaryLN)cursor.lockAndGetCurrentLN(LockType.NONE);
                    if (ln != null) {
                        long fileNumVal = FileSummaryLN.getFileNumber(key.getData());
                        PackedOffsets offsets = ln.getObsoleteOffsets();
                        if (offsets != null) {
                            long[] vals = offsets.toArray();
                            for (int i = 0; i < vals.length; ++i) {
                                long lsn = DbLsn.makeLsn(fileNumVal, vals[i]);
                                if (this.verifyLsnIsObsolete(lsn)) continue;
                                ok = false;
                            }
                        }
                        cursor.evictLN();
                    }
                    status = cursor.getNext(key, data, LockType.NONE, false, true, false, null);
                }
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (locker != null) {
                locker.operationEnd();
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyLsnIsObsolete(long lsn) throws DatabaseException {
        LogEntry o = this.env.getLogManager().getLogEntryHandleFileNotFound(lsn);
        if (!(o instanceof LNLogEntry)) {
            return true;
        }
        LNLogEntry entry = (LNLogEntry)o;
        DatabaseId dbId = entry.getDbId();
        DatabaseImpl db = this.env.getDbTree().getDb(dbId);
        IN bin = null;
        try {
            if (db == null || db.isDeleted()) {
                boolean bl = true;
                return bl;
            }
            if (entry.isImmediatelyObsolete(db)) {
                boolean bl = true;
                return bl;
            }
            entry.postFetchInit(db);
            Tree tree = db.getTree();
            TreeLocation location = new TreeLocation();
            boolean parentFound = tree.getParentBINForChildLN(location, entry.getKey(), false, false, CacheMode.UNCHANGED);
            bin = location.bin;
            int index = location.index;
            if (!parentFound) {
                boolean bl = true;
                return bl;
            }
            if (bin.isEntryKnownDeleted(index)) {
                boolean bl = true;
                return bl;
            }
            if (bin.getLsn(index) != lsn) {
                boolean bl = true;
                return bl;
            }
            System.err.println("lsn " + DbLsn.getNoFormatString(lsn) + " was found in tree.");
            boolean bl = false;
            return bl;
        }
        finally {
            this.env.getDbTree().releaseDb(db);
            if (bin != null) {
                bin.releaseLatch();
            }
        }
    }

    void close() {
        this.clearCache();
        if (this.fileSummaryDb != null) {
            this.fileSummaryDb.releaseTreeAdminMemory();
        }
    }
}

