/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.LSNAccumulator;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.evictor.OffHeapCache;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.WholeEntry;
import com.sleepycat.je.log.entry.BINDeltaLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.OldBINDeltaLogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.OldBINDelta;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.SizeofMarker;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SortedLSNTreeWalker {
    protected final DatabaseImpl[] dbImpls;
    protected final EnvironmentImpl envImpl;
    private final long[] rootLsns;
    private final boolean setDbState;
    private long internalMemoryLimit = Long.MAX_VALUE;
    private long internalMemoryUsage;
    private final TreeNodeProcessor callback;
    protected boolean accumulateLNs = false;
    protected boolean preloadIntoOffHeapCache = false;
    protected boolean accumulateDupLNs = false;
    private final List<DatabaseException> savedExceptions;
    private final ExceptionPredicate excPredicate;
    private long lsnBatchSize = Long.MAX_VALUE;
    private final DatabaseEntry lnKeyEntry = new DatabaseEntry();
    private final Map<Long, INEntry> lsnINMap = new HashMap<Long, INEntry>();

    public SortedLSNTreeWalker(DatabaseImpl[] dbImpls, boolean setDbState, long[] rootLsns, TreeNodeProcessor callback, List<DatabaseException> savedExceptions, ExceptionPredicate excPredicate) {
        if (dbImpls == null || dbImpls.length < 1) {
            throw EnvironmentFailureException.unexpectedState("DatabaseImpls array is null or 0-length for SortedLSNTreeWalker");
        }
        this.dbImpls = dbImpls;
        this.envImpl = dbImpls[0].getEnv();
        for (DatabaseImpl di : dbImpls) {
            EnvironmentImpl ei = di.getEnv();
            if (ei == null) {
                throw EnvironmentFailureException.unexpectedState("environmentImpl is null for target db " + di.getDebugName());
            }
            if (ei == this.envImpl) continue;
            throw new IllegalArgumentException("Environment.preload() must be called with Databases which are all in the same Environment. (" + di.getDebugName() + ")");
        }
        this.setDbState = setDbState;
        this.rootLsns = rootLsns;
        this.callback = callback;
        this.savedExceptions = savedExceptions;
        this.excPredicate = excPredicate;
    }

    void setLSNBatchSize(long lsnBatchSize) {
        this.lsnBatchSize = lsnBatchSize;
    }

    void setInternalMemoryLimit(long internalMemoryLimit) {
        this.internalMemoryLimit = internalMemoryLimit;
    }

    void incInternalMemoryUsage(long increment) {
        this.internalMemoryUsage += increment;
    }

    private LSNAccumulator createLSNAccumulator() {
        return new LSNAccumulator(){

            @Override
            void noteMemUsage(long increment) {
                SortedLSNTreeWalker.this.incInternalMemoryUsage(increment);
            }
        };
    }

    public void walk() {
        this.walkInternal();
    }

    protected void walkInternal() {
        LSNAccumulator pendingLSNs = this.createLSNAccumulator();
        for (int i = 0; i < this.dbImpls.length; ++i) {
            this.processRootLSN(this.dbImpls[i], pendingLSNs, this.rootLsns[i]);
        }
        this.processAccumulatedLSNs(pendingLSNs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRootLSN(DatabaseImpl dbImpl, LSNAccumulator pendingLSNs, long rootLsn) {
        IN root = this.getOrFetchRootIN(dbImpl, rootLsn);
        if (root != null) {
            try {
                this.accumulateLSNs(root, pendingLSNs, null, -1);
            }
            finally {
                this.releaseRootIN(root);
            }
        }
        if (this.setDbState) {
            dbImpl.finishedINListHarvest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void accumulateLSNs(IN parent, LSNAccumulator pendingLSNs, IN ohBinParent, int ohBinIndex) {
        boolean allChildrenAreLNs;
        DatabaseImpl db = parent.getDatabase();
        boolean dups = db.getSortedDuplicates();
        if (!dups || db.getDupsConverted()) {
            allChildrenAreLNs = parent.isBIN();
        } else {
            boolean bl = allChildrenAreLNs = parent.isBIN() && parent.containsDuplicates();
        }
        boolean accumulateChildren = !allChildrenAreLNs || (dups ? this.accumulateDupLNs : this.accumulateLNs);
        BIN parentBin = parent.isBIN() ? (BIN)parent : null;
        OffHeapCache ohCache = this.envImpl.getOffHeapCache();
        for (int i = 0; i < parent.getNEntries(); ++i) {
            boolean internalMemoryExceeded;
            long fullLsn;
            byte[] lnKey;
            long lsn = parent.getLsn(i);
            Node child = parent.getTarget(i);
            boolean childCached = child != null;
            byte[] byArray = lnKey = allChildrenAreLNs || childCached && child.isLN() ? parent.getKey(i) : null;
            if (parent.isEntryPendingDeleted(i) || parent.isEntryKnownDeleted(i)) {
                this.processDirtyLN(child, lsn, lnKey);
            } else if (!childCached && parentBin != null && parentBin.getOffHeapLNId(i) != 0L) {
                assert (!parent.isEmbeddedLN(i));
                child = ohCache.loadLN(parentBin, i, CacheMode.UNCHANGED);
                assert (child != null);
                this.processChild(lsn, child, lnKey, parent.getLastLoggedSize(i), pendingLSNs);
            } else if (!childCached && parent.getOffHeapBINId(i) >= 0) {
                child = ohCache.materializeBIN(this.envImpl, ohCache.getBINBytes(parent, i));
                BIN bin = (BIN)child;
                bin.latchNoUpdateLRU(db);
                boolean isLatched = true;
                try {
                    if (bin.isBINDelta()) {
                        assert (lsn != -1L);
                        fullLsn = bin.getLastFullLsn();
                        pendingLSNs.add(fullLsn);
                        this.addToLsnINMap(fullLsn, parent, i, bin, lsn);
                    }
                    bin.releaseLatch();
                    isLatched = false;
                    this.processChild(lsn, bin, lnKey, parent.getLastLoggedSize(i), pendingLSNs);
                }
                finally {
                    if (isLatched) {
                        bin.releaseLatch();
                    }
                }
            } else if (accumulateChildren && !childCached && lsn != -1L) {
                if (!parent.isEmbeddedLN(i)) {
                    pendingLSNs.add(lsn);
                    if (ohBinParent != null) {
                        this.addToLsnINMap(lsn, ohBinParent, ohBinIndex);
                    } else {
                        this.addToLsnINMap(lsn, parent, i);
                    }
                } else {
                    this.processChild(-1L, null, lnKey, 0, pendingLSNs);
                }
            } else if (childCached) {
                child.latchShared();
                boolean isLatched = true;
                try {
                    if (child.isBINDelta()) {
                        assert (lsn != -1L);
                        BIN delta = (BIN)child;
                        fullLsn = delta.getLastFullLsn();
                        pendingLSNs.add(fullLsn);
                        this.addToLsnINMap(fullLsn, parent, i, delta, lsn);
                    }
                    child.releaseLatch();
                    isLatched = false;
                    this.processChild(lsn, child, lnKey, parent.getLastLoggedSize(i), pendingLSNs);
                }
                finally {
                    if (isLatched) {
                        child.releaseLatch();
                    }
                }
            } else {
                this.processChild(lsn, null, lnKey, parent.getLastLoggedSize(i), pendingLSNs);
            }
            boolean bl = internalMemoryExceeded = this.internalMemoryUsage > this.internalMemoryLimit;
            if ((long)pendingLSNs.getNTotalEntries() <= this.lsnBatchSize && !internalMemoryExceeded) continue;
            if (internalMemoryExceeded) {
                this.callback.noteMemoryExceeded();
            }
            this.processAccumulatedLSNs(pendingLSNs);
            pendingLSNs.clear();
        }
    }

    private void processDirtyLN(Node node, long lsn, byte[] lnKey) {
        LN ln;
        if (node != null && node.isLN() && (ln = (LN)node).isDirty()) {
            this.callback.processDirtyDeletedLN(lsn, ln, lnKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processChild(long lsn, Node child, byte[] lnKey, int lastLoggedSize, LSNAccumulator pendingLSNs) {
        boolean childCached = child != null;
        this.callProcessLSNHandleExceptions(lsn, !childCached ? LogEntryType.LOG_INS_LN : child.getGenericLogType(), child, lnKey, lastLoggedSize);
        if (childCached && child.isIN()) {
            IN nodeAsIN = (IN)child;
            try {
                nodeAsIN.latch(CacheMode.UNCHANGED);
                this.accumulateLSNs(nodeAsIN, pendingLSNs, null, -1);
            }
            finally {
                nodeAsIN.releaseLatch();
            }
        }
    }

    protected void processAccumulatedLSNs(LSNAccumulator pendingLSNs) {
        while (!pendingLSNs.isEmpty()) {
            long[] currentLSNs = pendingLSNs.getAndSortPendingLSNs();
            pendingLSNs = this.createLSNAccumulator();
            for (long lsn : currentLSNs) {
                this.fetchAndProcessLSN(lsn, pendingLSNs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchAndProcessLSN(long lsn, LSNAccumulator pendingLSNs) {
        IN in;
        this.lnKeyEntry.setData(null);
        FetchResult result = this.fetchLSNHandleExceptions(lsn, this.lnKeyEntry, pendingLSNs);
        if (result == null) {
            return;
        }
        boolean isIN = result.node.isIN();
        if (isIN) {
            in = (IN)result.node;
            in.latch(CacheMode.UNCHANGED);
        } else {
            in = null;
        }
        try {
            this.callProcessLSNHandleExceptions(lsn, result.node.getGenericLogType(), result.node, this.lnKeyEntry.getData(), result.lastLoggedSize);
            if (isIN) {
                this.accumulateLSNs(in, pendingLSNs, result.ohBinParent, result.ohBinIndex);
            }
        }
        finally {
            if (isIN) {
                in.releaseLatch();
            }
        }
    }

    private FetchResult fetchLSNHandleExceptions(long lsn, DatabaseEntry lnKeyEntry, LSNAccumulator pendingLSNs) {
        DatabaseException dbe;
        block7: {
            dbe = null;
            try {
                return this.fetchLSN(lsn, lnKeyEntry, pendingLSNs);
            }
            catch (FileNotFoundException e) {
                if (this.excPredicate == null || !this.excPredicate.ignoreException(e)) {
                    dbe = new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
                }
            }
            catch (DatabaseException e) {
                if (this.excPredicate != null && this.excPredicate.ignoreException(e)) break block7;
                dbe = e;
            }
        }
        if (dbe != null) {
            if (this.savedExceptions != null) {
                this.savedExceptions.add(dbe);
            } else {
                throw dbe;
            }
        }
        return null;
    }

    protected void callProcessLSNHandleExceptions(long childLSN, LogEntryType childType, Node theNode, byte[] lnKey, int lastLoggedSize) {
        DatabaseException dbe;
        block7: {
            dbe = null;
            try {
                this.callback.processLSN(childLSN, childType, theNode, lnKey, lastLoggedSize);
            }
            catch (FileNotFoundException e) {
                if (this.excPredicate == null || !this.excPredicate.ignoreException(e)) {
                    dbe = new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
                }
            }
            catch (DatabaseException e) {
                if (this.excPredicate != null && this.excPredicate.ignoreException(e)) break block7;
                dbe = e;
            }
        }
        if (dbe != null) {
            if (this.savedExceptions != null) {
                this.savedExceptions.add(dbe);
            } else {
                throw dbe;
            }
        }
    }

    protected IN getOrFetchRootIN(DatabaseImpl dbImpl, long rootLsn) {
        IN root = this.getResidentRootIN(dbImpl);
        if (root != null) {
            return root;
        }
        if (rootLsn == -1L) {
            return null;
        }
        return this.getRootIN(dbImpl, rootLsn);
    }

    protected IN getRootIN(DatabaseImpl dbImpl, long rootLsn) {
        IN root = (IN)this.envImpl.getLogManager().getEntryHandleFileNotFound(rootLsn);
        if (root == null) {
            return null;
        }
        root.setDatabase(dbImpl);
        root.latchShared(CacheMode.DEFAULT);
        return root;
    }

    protected IN getResidentRootIN(DatabaseImpl dbImpl) {
        return dbImpl.getTree().getResidentRootIN(true);
    }

    protected void releaseRootIN(IN root) {
        root.releaseLatch();
    }

    private void addToLsnINMap(long lsn, IN in, int index) {
        this.addEntryToLsnMap(lsn, new INEntry(in, index));
    }

    private void addToLsnINMap(long lsn, IN in, int index, Object delta, long deltaLsn) {
        this.addEntryToLsnMap(lsn, new DeltaINEntry(in, index, delta, deltaLsn));
    }

    private void addEntryToLsnMap(long lsn, INEntry inEntry) {
        if (this.lsnINMap.put(lsn, inEntry) == null) {
            this.incInternalMemoryUsage(inEntry.getMemorySize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FetchResult fetchLSN(long lsn, DatabaseEntry lnKeyEntry, LSNAccumulator pendingLSNs) throws FileNotFoundException {
        LogManager logManager = this.envImpl.getLogManager();
        OffHeapCache ohCache = this.envImpl.getOffHeapCache();
        INEntry inEntry = this.lsnINMap.remove(lsn);
        assert (inEntry != null) : DbLsn.getNoFormatString(lsn);
        this.incInternalMemoryUsage(-inEntry.getMemorySize());
        IN in = inEntry.in;
        int index = inEntry.index;
        IN ohBinParent = null;
        int ohBinIndex = -1;
        IN in1ToUnlatch = null;
        IN in2ToUnlatch = null;
        if (!in.isLatchExclusiveOwner()) {
            in.latch();
            in1ToUnlatch = in;
        }
        DatabaseImpl dbImpl = in.getDatabase();
        byte[] lnKey = null;
        try {
            Node residentNode;
            BIN ohBin;
            boolean isLnInOffHeapBin;
            boolean bl = isLnInOffHeapBin = in.getOffHeapBINId(index) >= 0;
            if (isLnInOffHeapBin) {
                assert (this.fetchAndInsertIntoTree());
                ohBin = ohCache.materializeBIN(this.envImpl, ohCache.getBINBytes(in, index));
                int foundIndex = -1;
                for (int i = 0; i < ohBin.getNEntries(); ++i) {
                    if (ohBin.getLsn(i) != lsn) continue;
                    foundIndex = i;
                    break;
                }
                if (foundIndex == -1) {
                    FetchResult i = null;
                    return i;
                }
                ohBinParent = in;
                ohBinIndex = index;
                in = ohBin;
                index = foundIndex;
                in.latchNoUpdateLRU(dbImpl);
                in2ToUnlatch = in;
            }
            if (in.isEntryPendingDeleted(index) || in.isEntryKnownDeleted(index)) {
                ohBin = null;
                return ohBin;
            }
            if (inEntry.getDelta() == null) {
                if (in.getLsn(index) != lsn) {
                    ohBin = null;
                    return ohBin;
                }
            } else if (in.getLsn(index) != inEntry.getDeltaLsn()) {
                ohBin = null;
                return ohBin;
            }
            if ((residentNode = in.getTarget(index)) != null) {
                if (residentNode.isBINDelta(false)) {
                    BIN delta = (BIN)residentNode;
                    long fullLsn = delta.getLastFullLsn();
                    pendingLSNs.add(fullLsn);
                    this.addToLsnINMap(fullLsn, in, index, delta, lsn);
                    FetchResult fetchResult = null;
                    return fetchResult;
                }
                if (residentNode.isLN()) {
                    lnKeyEntry.setData(in.getKey(index));
                }
                FetchResult delta = new FetchResult(residentNode, in.getLastLoggedSize(index), null, -1);
                return delta;
            }
            WholeEntry wholeEntry = logManager.getWholeLogEntry(lsn);
            LogEntry entry = wholeEntry.getEntry();
            int lastLoggedSize = wholeEntry.getHeader().getEntrySize();
            if (entry instanceof BINDeltaLogEntry) {
                BINDeltaLogEntry deltaEntry = (BINDeltaLogEntry)entry;
                long fullLsn = deltaEntry.getPrevFullLsn();
                BIN delta2 = (BIN)deltaEntry.getMainItem();
                pendingLSNs.add(fullLsn);
                this.addToLsnINMap(fullLsn, in, index, delta2, lsn);
                FetchResult fetchResult = null;
                return fetchResult;
            }
            if (entry instanceof OldBINDeltaLogEntry) {
                OldBINDelta delta = (OldBINDelta)entry.getMainItem();
                long fullLsn = delta.getLastFullLsn();
                pendingLSNs.add(fullLsn);
                this.addToLsnINMap(fullLsn, in, index, delta, lsn);
                FetchResult delta2 = null;
                return delta2;
            }
            if (entry instanceof LNLogEntry) {
                LNLogEntry lnEntry = (LNLogEntry)entry;
                lnEntry.postFetchInit(dbImpl);
                lnKey = lnEntry.getKey();
                lnKeyEntry.setData(lnKey);
            }
            Node ret = (Node)entry.getResolvedItem(dbImpl);
            long lastLoggedLsn = lsn;
            if (ret.isIN()) {
                IN retIn = (IN)ret;
                retIn.setDatabase(dbImpl);
            }
            assert (!isLnInOffHeapBin || ret.isLN());
            Object deltaObject = inEntry.getDelta();
            if (deltaObject != null) {
                Loggable delta;
                BIN fullBIN = (BIN)ret;
                if (deltaObject instanceof OldBINDelta) {
                    delta = (OldBINDelta)deltaObject;
                    assert (lsn == ((OldBINDelta)delta).getLastFullLsn());
                    ((OldBINDelta)delta).reconstituteBIN(dbImpl, fullBIN);
                    lastLoggedLsn = inEntry.getDeltaLsn();
                } else {
                    delta = (BIN)deltaObject;
                    assert (lsn == ((IN)delta).getLastFullLsn());
                    ((BIN)delta).reconstituteBIN(dbImpl, fullBIN);
                    lastLoggedLsn = inEntry.getDeltaLsn();
                }
            }
            assert (!ret.isBINDelta(false));
            IN retOhBinParent = null;
            int retOhBinIndex = -1;
            if (this.fetchAndInsertIntoTree()) {
                boolean storeOffHeap;
                in.setLastLoggedSize(index, lastLoggedSize);
                MemoryBudget memBudget = this.envImpl.getMemoryBudget();
                boolean bl2 = storeOffHeap = this.preloadIntoOffHeapCache && memBudget.getCacheMemoryUsage() > memBudget.getMaxMemory();
                if (isLnInOffHeapBin || storeOffHeap && !ret.isUpperIN()) {
                    if (ret.isLN()) {
                        BIN bin = (BIN)in;
                        LN retLn = (LN)ret;
                        ohCache.storePreloadedLN(bin, index, retLn);
                        if (isLnInOffHeapBin) {
                            bin.setOffHeap(true);
                            ohCache.freeBIN(bin, ohBinParent, ohBinIndex);
                            ohCache.storePreloadedBIN(bin, ohBinParent, ohBinIndex);
                        }
                    } else {
                        BIN retBin = (BIN)ret;
                        retBin.latchNoUpdateLRU(dbImpl);
                        try {
                            if (!ohCache.storePreloadedBIN(retBin, in, index)) {
                                FetchResult retLn = null;
                                return retLn;
                            }
                        }
                        finally {
                            retBin.releaseLatch();
                        }
                        retOhBinParent = in;
                        retOhBinIndex = index;
                    }
                } else {
                    if (ret.isIN()) {
                        IN retIn = (IN)ret;
                        retIn.latchNoUpdateLRU(dbImpl);
                        ret.postFetchInit(dbImpl, lastLoggedLsn);
                        in.attachNode(index, ret, lnKey);
                        retIn.releaseLatch();
                    } else {
                        ret.postFetchInit(dbImpl, lastLoggedLsn);
                        in.attachNode(index, ret, lnKey);
                    }
                    if (in.isBIN()) {
                        Evictor evictor = this.envImpl.getEvictor();
                        CacheMode mode = in.getDatabase().getDefaultCacheMode();
                        if (evictor != null && mode != CacheMode.EVICT_LN) {
                            evictor.moveToPri1LRU(in);
                        }
                    }
                }
            }
            FetchResult fetchResult = new FetchResult(ret, lastLoggedSize, retOhBinParent, retOhBinIndex);
            return fetchResult;
        }
        finally {
            if (in1ToUnlatch != null) {
                in1ToUnlatch.releaseLatch();
            }
            if (in2ToUnlatch != null) {
                in2ToUnlatch.releaseLatch();
            }
        }
    }

    protected boolean fetchAndInsertIntoTree() {
        return false;
    }

    public List<DatabaseException> getSavedExceptions() {
        return this.savedExceptions;
    }

    private static class FetchResult {
        final Node node;
        final int lastLoggedSize;
        final IN ohBinParent;
        final int ohBinIndex;

        FetchResult(Node node, int lastLoggedSize, IN ohBinParent, int ohBinIndex) {
            this.node = node;
            this.lastLoggedSize = lastLoggedSize;
            this.ohBinParent = ohBinParent;
            this.ohBinIndex = ohBinIndex;
        }
    }

    public static class DeltaINEntry
    extends INEntry {
        private final Object delta;
        private final long deltaLsn;

        DeltaINEntry(IN in, int index, Object delta, long deltaLsn) {
            super(in, index);
            assert (delta != null);
            assert (deltaLsn != -1L);
            this.delta = delta;
            this.deltaLsn = deltaLsn;
        }

        public DeltaINEntry(SizeofMarker marker) {
            super(marker);
            this.delta = null;
            this.deltaLsn = 0L;
        }

        @Override
        Object getDelta() {
            return this.delta;
        }

        @Override
        long getDeltaLsn() {
            return this.deltaLsn;
        }

        @Override
        long getMemorySize() {
            long deltaSize = this.delta instanceof OldBINDelta ? ((OldBINDelta)this.delta).getMemorySize() : ((BIN)this.delta).getInMemorySize();
            return deltaSize + (long)MemoryBudget.HASHMAP_ENTRY_OVERHEAD + (long)MemoryBudget.DELTAINENTRY_OVERHEAD;
        }
    }

    public static class INEntry {
        final IN in;
        final int index;

        INEntry(IN in, int index) {
            assert (in != null);
            assert (in.getDatabase() != null);
            this.in = in;
            this.index = index;
        }

        public INEntry(SizeofMarker marker) {
            this.in = null;
            this.index = 0;
        }

        Object getDelta() {
            return null;
        }

        long getDeltaLsn() {
            return -1L;
        }

        long getMemorySize() {
            return MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.INENTRY_OVERHEAD;
        }
    }

    public static interface ExceptionPredicate {
        public boolean ignoreException(Exception var1);
    }

    public static interface TreeNodeProcessor {
        public void processLSN(long var1, LogEntryType var3, Node var4, byte[] var5, int var6) throws FileNotFoundException;

        public void processDirtyDeletedLN(long var1, LN var3, byte[] var4);

        public void noteMemoryExceeded();
    }
}

