/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.arbiter.impl;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.rep.GroupShutdownException;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.arbiter.impl.ArbBinaryStateService;
import com.sleepycat.je.rep.arbiter.impl.ArbiterAcker;
import com.sleepycat.je.rep.arbiter.impl.ArbiterNodeStateService;
import com.sleepycat.je.rep.arbiter.impl.ArbiterStatDefinition;
import com.sleepycat.je.rep.arbiter.impl.ArbiterVLSNTracker;
import com.sleepycat.je.rep.arbiter.impl.MonitorEventManager;
import com.sleepycat.je.rep.elections.Acceptor;
import com.sleepycat.je.rep.elections.Elections;
import com.sleepycat.je.rep.elections.ElectionsConfig;
import com.sleepycat.je.rep.elections.Learner;
import com.sleepycat.je.rep.elections.MasterValue;
import com.sleepycat.je.rep.elections.Proposer;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.impl.BinaryNodeStateProtocol;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.ChannelTimeoutTask;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.monitor.LeaveGroupEvent;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.net.DataChannelFactory;
import com.sleepycat.je.rep.stream.MasterStatus;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.StoppableThread;
import com.sleepycat.je.utilint.StringStat;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArbiterImpl
extends StoppableThread {
    private static final String DATA_FILE_NAME = "00000000.adb";
    private static final int MASTER_QUERY_INTERVAL = 1000;
    private ServiceDispatcher serviceDispatcher;
    private DataChannelFactory channelFactory;
    private MasterStatus masterStatus;
    private MasterChangeListener changeListener;
    private Acceptor.SuggestionGenerator suggestionGenerator;
    private ReplicationGroupAdmin repGroupAdmin;
    private RepGroupImpl cachedRepGroupImpl;
    private Timer timer;
    private ChannelTimeoutTask channelTimeoutTask;
    private ArbiterVLSNTracker arbiterVLSNTracker;
    private ArbiterNodeStateService nodeStateService;
    private ArbBinaryStateService binaryStateService;
    private Logger logger;
    private Formatter formatter;
    private final RepImpl repImpl;
    NameIdPair nameIdPair;
    private Elections elections;
    private final File arbiterHome;
    private String groupName;
    private ArbiterAcker arbiterAcker;
    private MonitorEventManager monitorEventManager;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private volatile RepUtils.ExceptionAwareCountDownLatch readyLatch = null;
    private AtomicReference<ReplicatedEnvironment.State> currentState;
    private long joinGroupTime;
    private Set<InetSocketAddress> helperSockets;

    public ArbiterImpl(File arbiterHome, RepImpl repImpl) throws EnvironmentNotFoundException, EnvironmentLockedException, DatabaseException {
        super(repImpl, "ArbiterNode " + repImpl.getNameIdPair());
        this.repImpl = repImpl;
        this.arbiterHome = arbiterHome;
        try {
            this.initialize();
        }
        catch (IOException ioe) {
            throw EnvironmentFailureException.unexpectedException(repImpl, "Problem attempting to join on " + this.getSocket(), ioe);
        }
    }

    public StatGroup loadStats(StatsConfig config) {
        if (this.arbiterAcker == null) {
            return null;
        }
        StatGroup arbStat = this.arbiterAcker.loadStats(config);
        StringStat state = new StringStat(arbStat, ArbiterStatDefinition.ARB_STATE);
        state.set(this.currentState.toString());
        LongStat vlsn = new LongStat(arbStat, ArbiterStatDefinition.ARB_VLSN);
        long vlsnValue = this.arbiterVLSNTracker == null ? 0L : this.arbiterVLSNTracker.get().getSequence();
        vlsn.set(vlsnValue);
        return arbStat;
    }

    private void initialize() throws IOException {
        this.nameIdPair = this.repImpl.getNameIdPair();
        this.currentState = new AtomicReference<ReplicatedEnvironment.State>(ReplicatedEnvironment.State.DETACHED);
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.formatter = new ReplicationFormatter(this.nameIdPair);
        this.readyLatch = new RepUtils.ExceptionAwareCountDownLatch(this.repImpl, 1);
        this.channelFactory = this.repImpl.getChannelFactory();
        this.serviceDispatcher = new ServiceDispatcher(this.getSocket(), this.repImpl, this.channelFactory);
        this.serviceDispatcher.start();
        this.masterStatus = new MasterStatus(this.nameIdPair);
        this.changeListener = new MasterChangeListener();
        File dataFile = new File(this.arbiterHome.getAbsolutePath() + File.separator + DATA_FILE_NAME);
        this.arbiterVLSNTracker = new ArbiterVLSNTracker(dataFile);
        this.suggestionGenerator = new MasterSuggestionGenerator();
        if (this.arbiterVLSNTracker.getCachedNodeId() != -1) {
            this.nameIdPair.update(new NameIdPair(this.nameIdPair.getName(), this.arbiterVLSNTracker.getCachedNodeId()));
        }
        this.groupName = this.repImpl.getConfigManager().get(RepParams.GROUP_NAME);
        this.helperSockets = this.repImpl.getHelperSockets();
        this.monitorEventManager = new MonitorEventManager(this);
    }

    public void runArbiter() {
        block12: {
            this.elections = new Elections(new ArbElectionsConfig(), this.changeListener, this.suggestionGenerator);
            this.elections.startLearner();
            this.elections.startAcceptor();
            this.repGroupAdmin = new ReplicationGroupAdmin(this.groupName, this.helperSockets, this.channelFactory);
            this.timer = new Timer(true);
            this.channelTimeoutTask = new ChannelTimeoutTask(this.timer);
            this.utilityServicesStart();
            this.start();
            int timeout = this.repImpl.getConfigManager().getDuration(RepParams.ENV_UNKNOWN_STATE_TIMEOUT);
            if (timeout == 0) {
                timeout = Integer.MAX_VALUE;
            }
            boolean done = false;
            try {
                done = this.getReadyLatch().awaitOrException(timeout, TimeUnit.MILLISECONDS);
                if (done) {
                    this.joinGroupTime = System.currentTimeMillis();
                    this.monitorEventManager.notifyJoinGroup();
                    break block12;
                }
                throw new UnknownMasterException("Master not found within the specified time period.");
            }
            catch (InterruptedException e) {
                throw EnvironmentFailureException.unexpectedException(e);
            }
            finally {
                if (!done) {
                    this.shutdown();
                    try {
                        this.join();
                    }
                    catch (InterruptedException ignore) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Error repNodeError = null;
        try {
            while (!this.isShutdownOrInvalid()) {
                this.queryGroupForMembership();
                this.masterStatus.sync();
                this.arbiterAcker = new ArbiterAcker(this, this.repImpl);
                this.arbiterAcker.runArbiterAckLoop();
            }
        }
        catch (InterruptedException e) {
            LoggerUtils.fine(this.logger, this.repImpl, "Arbiter main thread interrupted -  forced shutdown.");
        }
        catch (GroupShutdownException e) {
            this.saveShutdownException(e);
            LoggerUtils.fine(this.logger, this.repImpl, "Arbiter main thread sees group shutdown - " + e);
        }
        catch (InsufficientLogException e) {
            this.saveShutdownException(e);
        }
        catch (RuntimeException e) {
            LoggerUtils.fine(this.logger, this.repImpl, "Arbiter main thread sees runtime ex - " + e);
            this.saveShutdownException(e);
            throw e;
        }
        catch (Error e) {
            LoggerUtils.fine(this.logger, this.repImpl, e + " incurred during arbiter loop");
            repNodeError = e;
            this.repImpl.invalidate(e);
        }
        finally {
            LoggerUtils.info(this.logger, this.repImpl, "Arbiter main thread shutting down.");
            if (repNodeError != null) {
                LoggerUtils.info(this.logger, this.repImpl, "Node state at shutdown:\n" + this.repImpl.dumpState());
                throw repNodeError;
            }
            Exception exception = this.getSavedShutdownException();
            if (exception == null) {
                LoggerUtils.fine(this.logger, this.repImpl, "Node state at shutdown:\n" + this.repImpl.dumpState());
            } else {
                LoggerUtils.info(this.logger, this.repImpl, "Arbiter shutdown exception:\n" + exception.getMessage() + this.repImpl.dumpState());
            }
            try {
                this.shutdown();
            }
            catch (DatabaseException e) {
                RepUtils.chainExceptionCause(e, exception);
                LoggerUtils.severe(this.logger, this.repImpl, "Unexpected exception during shutdown" + e);
                throw e;
            }
            this.setState(ReplicatedEnvironment.State.DETACHED);
            this.cleanup();
        }
    }

    private LeaveGroupEvent.LeaveReason getLeaveReason() {
        LeaveGroupEvent.LeaveReason reason = null;
        Exception exception = this.getSavedShutdownException();
        reason = exception == null ? LeaveGroupEvent.LeaveReason.NORMAL_SHUTDOWN : (exception instanceof GroupShutdownException ? LeaveGroupEvent.LeaveReason.MASTER_SHUTDOWN_GROUP : LeaveGroupEvent.LeaveReason.ABNORMAL_TERMINATION);
        return reason;
    }

    String getMasterName() {
        if (this.masterStatus.getGroupMasterNameId().getId() == -1) {
            return null;
        }
        return this.masterStatus.getGroupMasterNameId().getName();
    }

    String getNodeName() {
        return this.nameIdPair.getName();
    }

    RepGroupImpl getGroup() {
        return this.cachedRepGroupImpl;
    }

    public Elections getElections() {
        return this.elections;
    }

    public void setState(ReplicatedEnvironment.State state) {
        this.currentState.set(state);
        this.repImpl.getNodeState().changeAndNotify(state, NameIdPair.NULL);
    }

    private void utilityServicesStart() {
        this.nodeStateService = new ArbiterNodeStateService(this.serviceDispatcher, this);
        this.serviceDispatcher.register(this.nodeStateService);
        this.binaryStateService = new ArbBinaryStateService(this.serviceDispatcher, this);
    }

    private void utilityServicesShutdown() {
        if (this.binaryStateService != null) {
            try {
                this.binaryStateService.shutdown();
            }
            catch (Exception e) {
                LoggerUtils.info(this.logger, this.repImpl, "Error shutting down binaryStateService " + e.getMessage());
            }
        }
        if (this.nodeStateService != null) {
            try {
                this.serviceDispatcher.cancel("NodeState");
            }
            catch (Exception e) {
                LoggerUtils.info(this.logger, this.repImpl, "Error canceling serviceDispatch " + e.getMessage());
            }
        }
    }

    public void shutdown() {
        boolean changed = this.shutdown.compareAndSet(false, true);
        if (!changed) {
            return;
        }
        try {
            this.monitorEventManager.notifyLeaveGroup(this.getLeaveReason());
        }
        catch (Exception e) {
            LoggerUtils.info(this.logger, this.repImpl, "Error shutting down monitor event manager " + e.getMessage());
        }
        this.utilityServicesShutdown();
        if (this.arbiterAcker != null) {
            try {
                this.arbiterAcker.shutdown();
            }
            catch (Exception e) {
                LoggerUtils.info(this.logger, this.repImpl, "Error shutting down ArbiterAcker " + e.getMessage());
            }
        }
        if (this.elections != null) {
            try {
                this.elections.shutdown();
            }
            catch (Exception e) {
                LoggerUtils.info(this.logger, this.repImpl, "Error shutting down elections " + e.getMessage());
            }
        }
        if (this.serviceDispatcher != null) {
            this.serviceDispatcher.shutdown();
        }
        LoggerUtils.info(this.logger, this.repImpl, this.nameIdPair + " shutdown completed.");
        this.masterStatus.setGroupMaster(null, NameIdPair.NULL);
        this.readyLatch.releaseAwait(this.getSavedShutdownException());
        this.arbiterVLSNTracker.close();
        this.channelTimeoutTask.cancel();
        this.timer.cancel();
    }

    ReplicatedEnvironment.State getNodeState() {
        return this.currentState.get();
    }

    String getGroupName() {
        return this.groupName;
    }

    RepImpl getRepImpl() {
        return this.repImpl;
    }

    public void refreshHelperHosts() {
        HashSet<InetSocketAddress> helpers = new HashSet<InetSocketAddress>(this.repImpl.getHelperSockets());
        if (this.cachedRepGroupImpl != null) {
            helpers.addAll(this.cachedRepGroupImpl.getAllHelperSockets());
        }
        this.helperSockets = helpers;
        if (this.repGroupAdmin != null) {
            this.repGroupAdmin.setHelperSockets(this.helperSockets);
        }
    }

    RepGroupImpl refreshCachedGroup() throws DatabaseException {
        RepNodeImpl n;
        RepGroupImpl repGroupImpl = this.repGroupAdmin.getGroup().getRepGroupImpl();
        this.elections.updateRepGroupOnly(repGroupImpl);
        if (this.nameIdPair.hasNullId() && (n = repGroupImpl.getMember(this.nameIdPair.getName())) != null) {
            this.nameIdPair.update(n.getNameIdPair());
            this.arbiterVLSNTracker.writeNodeId(n.getNameIdPair().getId());
        }
        HashSet<InetSocketAddress> helpers = new HashSet<InetSocketAddress>(this.repImpl.getHelperSockets());
        helpers.addAll(repGroupImpl.getAllHelperSockets());
        this.helperSockets = helpers;
        this.cachedRepGroupImpl = repGroupImpl;
        return this.cachedRepGroupImpl;
    }

    void updateNameIdPair(NameIdPair other) {
        this.nameIdPair.update(other);
    }

    long getJoinGroupTime() {
        return this.joinGroupTime;
    }

    private void queryGroupForMembership() throws InterruptedException {
        NameIdPair groupMasterNameId;
        this.checkLoopbackAddresses(this.helperSockets);
        if (this.helperSockets.isEmpty()) {
            throw EnvironmentFailureException.unexpectedState("Need a helper to add a new node into the group");
        }
        while (true) {
            this.elections.getLearner().queryForMaster(this.helperSockets);
            groupMasterNameId = this.masterStatus.getGroupMasterNameId();
            if (!groupMasterNameId.hasNullId()) {
                if (this.nameIdPair.hasNullId() && groupMasterNameId.getName().equals(this.nameIdPair.getName())) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw EnvironmentFailureException.unexpectedException(e);
                    }
                }
                if (this.checkGroupMasterIsAlive(groupMasterNameId)) break;
            }
            if (this.isShutdownOrInvalid()) {
                throw new InterruptedException("Arbiter node shutting down.");
            }
            Thread.sleep(1000L);
        }
        LoggerUtils.info(this.logger, this.repImpl, "New node " + this.nameIdPair.getName() + " located master: " + groupMasterNameId);
    }

    ArbiterVLSNTracker getArbiterVLSNTracker() {
        return this.arbiterVLSNTracker;
    }

    boolean isShutdownOrInvalid() {
        if (this.isShutdown()) {
            return true;
        }
        if (this.repImpl.wasInvalidated()) {
            this.saveShutdownException(this.repImpl.getInvalidatingException());
            return true;
        }
        return false;
    }

    private void checkLoopbackAddresses(Set<InetSocketAddress> helperSockets) {
        InetAddress myAddress = this.getSocket().getAddress();
        boolean isLoopback = myAddress.isLoopbackAddress();
        for (InetSocketAddress socketAddress : helperSockets) {
            InetAddress nodeAddress = socketAddress.getAddress();
            if (nodeAddress.isLoopbackAddress() == isLoopback) continue;
            String message = this.getSocket() + " the address associated with this node, " + (isLoopback ? "is " : "is not ") + "a loopback address." + " It conflicts with an existing use, by a different node " + " of the address:" + socketAddress + (!isLoopback ? " which is a loopback address." : " which is not a loopback address.") + " Such mixing of addresses within a group is not allowed, " + "since the nodes will not be able to communicate with " + "each other.";
            throw new IllegalArgumentException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkGroupMasterIsAlive(NameIdPair groupMasterNameId) {
        Channel channel = null;
        try {
            InetSocketAddress masterSocket = this.masterStatus.getGroupMaster();
            BinaryNodeStateProtocol protocol = new BinaryNodeStateProtocol(NameIdPair.NOCHECK, null);
            channel = this.repImpl.getChannelFactory().connect(masterSocket, new DataChannelFactory.ConnectOptions().setTcpNoDelay(true).setOpenTimeout(5000).setReadTimeout(5000));
            ServiceDispatcher.doServiceHandshake((DataChannel)channel, "BinaryNodeState");
            BinaryNodeStateProtocol binaryNodeStateProtocol = protocol;
            binaryNodeStateProtocol.getClass();
            protocol.write((BinaryProtocol.Message)new BinaryNodeStateProtocol.BinaryNodeStateRequest(binaryNodeStateProtocol, groupMasterNameId.getName(), this.repImpl.getConfigManager().get(RepParams.GROUP_NAME)), (WritableByteChannel)channel);
            BinaryNodeStateProtocol.BinaryNodeStateResponse response = protocol.read((ReadableByteChannel)channel, BinaryNodeStateProtocol.BinaryNodeStateResponse.class);
            ReplicatedEnvironment.State state = response.getNodeState();
            boolean bl = state != null && state.isMaster();
            return bl;
        }
        catch (Exception e) {
            LoggerUtils.info(this.logger, this.repImpl, "Queried master:" + groupMasterNameId + " unavailable. Reason:" + e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private InetSocketAddress getSocket() {
        return new InetSocketAddress(this.getHostName(), this.getPort());
    }

    NameIdPair getNameIdPair() {
        return this.nameIdPair;
    }

    MasterStatus getMasterStatus() {
        return this.masterStatus;
    }

    ChannelTimeoutTask getChannelTimeoutTask() {
        return this.channelTimeoutTask;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public RepUtils.ExceptionAwareCountDownLatch getReadyLatch() {
        return this.readyLatch;
    }

    public void resetReadyLatch(Exception exception) {
        RepUtils.ExceptionAwareCountDownLatch old = this.readyLatch;
        this.readyLatch = new RepUtils.ExceptionAwareCountDownLatch(this.repImpl, 1);
        if (old.getCount() != 0L) {
            old.releaseAwait(exception);
        }
    }

    public String getHostName() {
        String hostAndPort = this.repImpl.getConfigManager().get(RepParams.NODE_HOST_PORT);
        int colonToken = hostAndPort.indexOf(":");
        return colonToken >= 0 ? hostAndPort.substring(0, colonToken) : hostAndPort;
    }

    public int getPort() {
        String hostAndPort = this.repImpl.getConfigManager().get(RepParams.NODE_HOST_PORT);
        int colonToken = hostAndPort.indexOf(":");
        return colonToken >= 0 ? Integer.parseInt(hostAndPort.substring(colonToken + 1)) : Integer.parseInt(RepParams.DEFAULT_PORT.getDefault());
    }

    public void changeState(ReplicatedEnvironment.State state) {
        this.repImpl.getState();
    }

    private class MasterSuggestionGenerator
    implements Acceptor.SuggestionGenerator {
        private MasterSuggestionGenerator() {
        }

        @Override
        public Protocol.Value get(Proposer.Proposal proposal) {
            return new MasterValue(null, ArbiterImpl.this.getPort(), NameIdPair.NULL);
        }

        @Override
        public long getRanking(Proposer.Proposal proposal) {
            return ArbiterImpl.this.arbiterVLSNTracker.get().getSequence();
        }
    }

    private class ArbElectionsConfig
    implements ElectionsConfig {
        private ArbElectionsConfig() {
        }

        @Override
        public String getGroupName() {
            return ArbiterImpl.this.groupName;
        }

        @Override
        public NameIdPair getNameIdPair() {
            return ArbiterImpl.this.nameIdPair;
        }

        @Override
        public ServiceDispatcher getServiceDispatcher() {
            return ArbiterImpl.this.serviceDispatcher;
        }

        @Override
        public int getElectionPriority() {
            return Integer.MIN_VALUE;
        }

        @Override
        public int getLogVersion() {
            return 11;
        }

        @Override
        public RepImpl getRepImpl() {
            return ArbiterImpl.this.repImpl;
        }

        @Override
        public RepNode getRepNode() {
            return null;
        }
    }

    private class MasterChangeListener
    implements Learner.Listener {
        private MasterValue currentValue = null;

        private MasterChangeListener() {
        }

        @Override
        public void notify(Proposer.Proposal proposal, Protocol.Value value) {
            if (value.equals(this.currentValue)) {
                return;
            }
            this.currentValue = (MasterValue)value;
            try {
                String currentMasterName = this.currentValue.getNodeName();
                LoggerUtils.logMsg(ArbiterImpl.this.logger, ArbiterImpl.this.formatter, Level.INFO, "Arbiter notified of new Master: " + currentMasterName);
                ArbiterImpl.this.masterStatus.setGroupMaster(new InetSocketAddress(this.currentValue.getHostName(), this.currentValue.getPort()), this.currentValue.getNameId());
            }
            catch (Exception e) {
                LoggerUtils.logMsg(ArbiterImpl.this.logger, ArbiterImpl.this.formatter, Level.SEVERE, "Arbiter change event processing exception: " + e.getMessage());
            }
        }
    }
}

