/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.TracerFormatter;
import com.sleepycat.je.utilint.VLSN;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

class GlobalCBVLSN {
    private static final DateFormat DATE_FORMAT = TracerFormatter.makeDateFormat();
    private final RepImpl repImpl;
    private final Logger logger;
    private final long streamTimeoutMs;
    private final int minRetainedVLSNs;
    private volatile VLSN groupCBVLSN = VLSN.NULL_VLSN;
    private int activeSyncups = 0;
    private String groupCBVLSNNodeName;
    private long groupCBVLSNNodeBarrierTime;
    private long groupCBVLSNLatestBarrierTime;
    private final Date date = new Date();

    GlobalCBVLSN(RepNode repNode) {
        this.repImpl = repNode.getRepImpl();
        this.streamTimeoutMs = this.repImpl.getConfigManager().getDuration(RepParams.REP_STREAM_TIMEOUT);
        this.minRetainedVLSNs = this.repImpl.getConfigManager().getInt(RepParams.MIN_RETAINED_VLSNS);
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    VLSN getCBVLSN() {
        return this.groupCBVLSN;
    }

    synchronized CBVLSNInfo getCBVLSNInfo() {
        if (VLSN.NULL_VLSN.equals(this.groupCBVLSN)) {
            return new CBVLSNInfo(this.groupCBVLSN, "to support initial replication");
        }
        if (this.groupCBVLSNNodeBarrierTime == 0L) {
            return new CBVLSNInfo(this.groupCBVLSN, "to support active replication by node " + this.groupCBVLSNNodeName);
        }
        StringBuilder sb = new StringBuilder();
        long nodeLagSecs = (this.groupCBVLSNLatestBarrierTime - this.groupCBVLSNNodeBarrierTime) / 1000L;
        sb.append("to support replication by node ").append(this.groupCBVLSNNodeName).append(", last updated ").append(this.getDate(this.groupCBVLSNNodeBarrierTime)).append(", ").append(nodeLagSecs).append(" seconds before the most recently updated node").append(", and less than the ").append(this.streamTimeoutMs / 1000L).append(" seconds timeout specified by the").append(" ReplicationConfig.REP_STREAM_TIMEOUT parameter");
        return new CBVLSNInfo(this.groupCBVLSN, sb.toString());
    }

    private String getDate(long time) {
        assert (Thread.holdsLock(this));
        this.date.setTime(time);
        return DATE_FORMAT.format(this.date);
    }

    synchronized void syncupStarted() {
        ++this.activeSyncups;
        LoggerUtils.finest(this.logger, this.repImpl, "activeSyncups = " + this.activeSyncups);
    }

    synchronized void syncupEnded() {
        --this.activeSyncups;
        LoggerUtils.finest(this.logger, this.repImpl, "activeSyncups = " + this.activeSyncups);
    }

    synchronized int getActiveSyncups() {
        return this.activeSyncups;
    }

    void recalculate(RepGroupImpl groupInfo) {
        VLSN rangeFirst;
        VLSN maxCBVLSN = VLSN.NULL_VLSN;
        long latestBarrierTime = 0L;
        String nodeName = null;
        for (RepNodeImpl node : groupInfo.getDataMembers()) {
            RepGroupImpl.BarrierState nodeBarrier = node.getBarrierState();
            VLSN cbvlsn = nodeBarrier.getLastCBVLSN();
            if (cbvlsn == null || cbvlsn.isNull()) continue;
            long nodeBarrierTime = nodeBarrier.getBarrierTime();
            if (maxCBVLSN.compareTo(cbvlsn) > 0) continue;
            latestBarrierTime = cbvlsn.equals(maxCBVLSN) ? Math.min(nodeBarrierTime, latestBarrierTime) : nodeBarrierTime;
            maxCBVLSN = cbvlsn;
            nodeName = node.getName();
        }
        if (latestBarrierTime == 0L) {
            return;
        }
        if (maxCBVLSN.isNull()) {
            return;
        }
        VLSN newGroupCBVLSN = maxCBVLSN;
        long nodeBarrierTime = 0L;
        for (RepNodeImpl node : groupInfo.getDataMembers()) {
            RepGroupImpl.BarrierState nodeBarrier;
            VLSN nodeCBVLSN;
            if (node.getType().isArbiter() || (nodeCBVLSN = (nodeBarrier = node.getBarrierState()).getLastCBVLSN()) == null || nodeCBVLSN.isNull() || latestBarrierTime - nodeBarrier.getBarrierTime() > this.streamTimeoutMs || newGroupCBVLSN.compareTo(nodeCBVLSN) <= 0) continue;
            newGroupCBVLSN = nodeCBVLSN;
            nodeName = node.getName();
            nodeBarrierTime = nodeBarrier.getBarrierTime();
        }
        newGroupCBVLSN = new VLSN(newGroupCBVLSN.getSequence() - (long)this.minRetainedVLSNs);
        VLSNIndex vlsnIndex = this.repImpl.getVLSNIndex();
        VLSN vLSN = rangeFirst = vlsnIndex != null ? vlsnIndex.getRange().getFirst() : VLSN.FIRST_VLSN;
        if (rangeFirst.compareTo(newGroupCBVLSN) > 0) {
            newGroupCBVLSN = rangeFirst;
        }
        this.updateGroupCBVLSN(groupInfo, newGroupCBVLSN, nodeName, nodeBarrierTime, latestBarrierTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGroupCBVLSN(RepGroupImpl groupInfo, VLSN newGroupCBVLSN, String nodeName, long nodeBarrierTime, long latestBarrierTime) {
        boolean changed = false;
        int numGatingSyncups = 0;
        String cbvlsnLoweredMessage = null;
        VLSN oldCBVLSN = VLSN.NULL_VLSN;
        GlobalCBVLSN globalCBVLSN = this;
        synchronized (globalCBVLSN) {
            if (newGroupCBVLSN.compareTo(this.groupCBVLSN) > 0) {
                if (this.activeSyncups == 0) {
                    VLSNRange currentRange = this.repImpl.getVLSNIndex().getRange();
                    if (!currentRange.contains(newGroupCBVLSN) && this.logger.isLoggable(Level.FINE)) {
                        cbvlsnLoweredMessage = "GroupCBVLSN: " + newGroupCBVLSN + " is outside VLSN range: " + currentRange + " Current group:" + groupInfo;
                    } else {
                        oldCBVLSN = this.groupCBVLSN;
                        this.groupCBVLSN = newGroupCBVLSN;
                        this.groupCBVLSNNodeName = nodeName;
                        this.groupCBVLSNNodeBarrierTime = nodeBarrierTime;
                        this.groupCBVLSNLatestBarrierTime = latestBarrierTime;
                        changed = true;
                    }
                } else {
                    numGatingSyncups = this.activeSyncups;
                }
            } else {
                this.groupCBVLSNNodeName = nodeName;
                this.groupCBVLSNNodeBarrierTime = nodeBarrierTime;
                this.groupCBVLSNLatestBarrierTime = latestBarrierTime;
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            if (cbvlsnLoweredMessage != null) {
                LoggerUtils.fine(this.logger, this.repImpl, cbvlsnLoweredMessage);
            }
            if (changed) {
                LoggerUtils.fine(this.logger, this.repImpl, "Global CBVLSN changed from " + oldCBVLSN + " to " + newGroupCBVLSN);
            }
            if (numGatingSyncups > 0) {
                LoggerUtils.fine(this.logger, this.repImpl, "Global CBVLSN update gated by " + numGatingSyncups + " syncups");
            }
        }
    }

    static class CBVLSNInfo {
        final VLSN cbvlsn;
        final String message;

        CBVLSNInfo(VLSN cbvlsn, String message) {
            this.cbvlsn = cbvlsn;
            this.message = message;
        }
    }
}

