/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.ReplicableLogEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.rep.stream.InputWireRecord;
import com.sleepycat.je.rep.stream.WireRecord;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.txn.TxnEnd;
import com.sleepycat.je.utilint.VLSN;
import java.nio.ByteBuffer;

public class OutputWireRecord
extends WireRecord {
    protected final ByteBuffer entryBuffer;
    protected final EnvironmentImpl envImpl;
    private ReplicableLogEntry sharedEntry = null;
    private ReplicableLogEntry logEntry = null;

    OutputWireRecord(EnvironmentImpl envImpl, LogEntryHeader header, ByteBuffer readerBuffer) {
        super(header);
        this.envImpl = envImpl;
        this.entryBuffer = readerBuffer.slice();
        this.entryBuffer.limit(header.getItemSize());
    }

    OutputWireRecord(EnvironmentImpl envImpl, LogItem logItem) {
        super(logItem.header);
        this.envImpl = envImpl;
        ByteBuffer buffer = logItem.buffer;
        buffer.position(this.header.getSize());
        this.entryBuffer = buffer.slice();
        assert (this.entryBuffer.limit() == this.header.getItemSize()) : "Limit:" + this.entryBuffer.limit() + " size:" + this.header.getItemSize();
    }

    OutputWireRecord(EnvironmentImpl envImpl, InputWireRecord input) {
        super(input.header);
        this.envImpl = envImpl;
        LogEntry entry = input.getLogEntry();
        this.entryBuffer = ByteBuffer.allocate(entry.getSize());
        entry.writeEntry(this.entryBuffer);
        this.entryBuffer.flip();
    }

    private synchronized ReplicableLogEntry getSharedEntry() throws DatabaseException {
        if (this.sharedEntry == null) {
            LogEntryType entryType = this.getLogEntryType();
            if (!entryType.isReplicationPossible()) {
                throw EnvironmentFailureException.unexpectedState("Log entry type does not support replication: " + entryType);
            }
            this.sharedEntry = (ReplicableLogEntry)entryType.getSharedLogEntry();
        }
        return this.sharedEntry;
    }

    private synchronized ReplicableLogEntry instantiateEntry() throws DatabaseException {
        if (this.logEntry == null) {
            LogEntry entry = this.instantiateEntry(this.envImpl, this.entryBuffer);
            if (!(entry instanceof ReplicableLogEntry)) {
                throw EnvironmentFailureException.unexpectedState("Log entry type does not support replication: " + entry.getClass().getName());
            }
            this.logEntry = (ReplicableLogEntry)entry;
        }
        return this.logEntry;
    }

    public byte getEntryType() {
        return this.header.getType();
    }

    public boolean match(InputWireRecord input) throws DatabaseException {
        if (!this.header.logicalEqualsIgnoreVersion(input.header)) {
            return false;
        }
        ReplicableLogEntry entry = this.instantiateEntry();
        return entry.logicalEquals(input.getLogEntry());
    }

    public boolean match(OutputWireRecord otherRecord) throws DatabaseException {
        if (!this.header.logicalEqualsIgnoreVersion(otherRecord.header)) {
            return false;
        }
        ReplicableLogEntry entry = this.instantiateEntry();
        LogEntry otherEntry = otherRecord.instantiateEntry(this.envImpl, otherRecord.entryBuffer);
        return entry.logicalEquals(otherEntry);
    }

    public VLSN getVLSN() {
        return this.header.getVLSN();
    }

    public String dump() throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        this.header.dumpRep(sb);
        ReplicableLogEntry entry = this.instantiateEntry();
        entry.dumpRep(sb);
        return sb.toString();
    }

    public String toString() {
        try {
            return this.dump();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return "";
        }
    }

    int getWireSize(int logVersion) {
        return 17 + this.getEntrySize(logVersion);
    }

    private int getEntrySize(int logVersion) {
        if (this.requiresFormatChange(logVersion)) {
            return this.instantiateEntry().getSize(logVersion);
        }
        return this.header.getItemSize();
    }

    private boolean requiresFormatChange(int logVersion) {
        return logVersion < 11 && logVersion < this.header.getVersion() && logVersion < this.getSharedEntry().getLastFormatChange();
    }

    boolean writeToWire(ByteBuffer messageBuffer, int logVersion) {
        messageBuffer.put(this.header.getType());
        boolean changeFormat = this.requiresFormatChange(logVersion);
        if (changeFormat) {
            ReplicableLogEntry entry = this.instantiateEntry();
            LogUtils.writeInt(messageBuffer, logVersion);
            LogUtils.writeInt(messageBuffer, entry.getSize(logVersion));
            LogUtils.writeLong(messageBuffer, this.header.getVLSN().getSequence());
            this.entryBuffer.mark();
            entry.writeEntry(messageBuffer, logVersion);
        } else {
            LogUtils.writeInt(messageBuffer, this.header.getVersion());
            LogUtils.writeInt(messageBuffer, this.header.getItemSize());
            LogUtils.writeLong(messageBuffer, this.header.getVLSN().getSequence());
            this.entryBuffer.mark();
            messageBuffer.put(this.entryBuffer);
        }
        this.entryBuffer.reset();
        return changeFormat;
    }

    public long getCommitTxnId() throws DatabaseException {
        if (!LogEntryType.LOG_TXN_COMMIT.equalsType(this.header.getType())) {
            return 0L;
        }
        ReplicableLogEntry commitEntry = this.instantiateEntry();
        return commitEntry.getTransactionId();
    }

    public long getCommitTimeStamp() throws DatabaseException {
        if (!LogEntryType.LOG_TXN_COMMIT.equalsType(this.header.getType())) {
            return 0L;
        }
        TxnCommit txnCommit = (TxnCommit)this.instantiateEntry().getMainItem();
        return txnCommit.getTime().getTime();
    }

    public long getTimeStamp() throws DatabaseException {
        Class logClass;
        LogEntry sharedLogEntry = this.getLogEntryType().getSharedLogEntry();
        if (sharedLogEntry instanceof SingleItemEntry && TxnEnd.class.isAssignableFrom(logClass = ((SingleItemEntry)sharedLogEntry).getLogClass())) {
            TxnEnd txnEnd = (TxnEnd)this.instantiateEntry().getMainItem();
            return txnEnd.getTime().getTime();
        }
        return 0L;
    }

    public boolean verifyNegativeSequences(String debugTag) {
        ReplicableLogEntry entry = null;
        try {
            entry = this.instantiateEntry();
        }
        catch (DatabaseException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        if (entry.getTransactionId() >= 0L) {
            throw EnvironmentFailureException.unexpectedState(debugTag + " txn id should be negative: " + entry);
        }
        if (entry instanceof LNLogEntry) {
            if (LogEntryType.LOG_NAMELN_TRANSACTIONAL.equalsType(this.getEntryType())) {
                LNLogEntry lnEntry = (LNLogEntry)entry;
                lnEntry.postFetchInit(false);
                NameLN nameLN = (NameLN)lnEntry.getLN();
                if (nameLN.getId().getId() >= 0L) {
                    throw EnvironmentFailureException.unexpectedState(debugTag + " db id should be negative: " + entry);
                }
            } else if (entry.getDbId().getId() >= 0L) {
                throw EnvironmentFailureException.unexpectedState(debugTag + " db id should be negative: " + entry);
            }
        }
        return true;
    }
}

