/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.com.fasterxml.jackson.databind;

import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.FormatSchema;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonLocation;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonParser;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonToken;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JavaType;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class MappingIterator<T>
implements Iterator<T>,
Closeable {
    protected static final MappingIterator<?> EMPTY_ITERATOR = new MappingIterator(null, null, null, null, false, null);
    protected final JavaType _type;
    protected final DeserializationContext _context;
    protected final JsonDeserializer<T> _deserializer;
    protected JsonParser _parser;
    protected final boolean _closeParser;
    protected boolean _hasNextChecked;
    protected final T _updatedValue;

    @Deprecated
    protected MappingIterator(JavaType javaType, JsonParser jsonParser, DeserializationContext deserializationContext, JsonDeserializer<?> jsonDeserializer) {
        this(javaType, jsonParser, deserializationContext, jsonDeserializer, true, null);
    }

    protected MappingIterator(JavaType javaType, JsonParser jsonParser, DeserializationContext deserializationContext, JsonDeserializer<?> jsonDeserializer, boolean bl, Object object) {
        this._type = javaType;
        this._parser = jsonParser;
        this._context = deserializationContext;
        this._deserializer = jsonDeserializer;
        this._closeParser = bl;
        this._updatedValue = object == null ? null : object;
        if (bl && jsonParser != null && jsonParser.getCurrentToken() == JsonToken.START_ARRAY) {
            jsonParser.clearCurrentToken();
        }
    }

    protected static <T> MappingIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.hasNextValue();
        }
        catch (JsonMappingException jsonMappingException) {
            throw new RuntimeJsonMappingException(jsonMappingException.getMessage(), jsonMappingException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public T next() {
        try {
            return this.nextValue();
        }
        catch (JsonMappingException jsonMappingException) {
            throw new RuntimeJsonMappingException(jsonMappingException.getMessage(), jsonMappingException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this._parser != null) {
            this._parser.close();
        }
    }

    public boolean hasNextValue() throws IOException {
        if (this._parser == null) {
            return false;
        }
        if (!this._hasNextChecked) {
            JsonToken jsonToken = this._parser.getCurrentToken();
            this._hasNextChecked = true;
            if (jsonToken == null && ((jsonToken = this._parser.nextToken()) == null || jsonToken == JsonToken.END_ARRAY)) {
                JsonParser jsonParser = this._parser;
                this._parser = null;
                if (this._closeParser) {
                    jsonParser.close();
                }
                return false;
            }
        }
        return true;
    }

    public T nextValue() throws IOException {
        T t;
        if (!this._hasNextChecked && !this.hasNextValue()) {
            throw new NoSuchElementException();
        }
        if (this._parser == null) {
            throw new NoSuchElementException();
        }
        this._hasNextChecked = false;
        if (this._updatedValue == null) {
            t = this._deserializer.deserialize(this._parser, this._context);
        } else {
            this._deserializer.deserialize(this._parser, this._context, this._updatedValue);
            t = this._updatedValue;
        }
        this._parser.clearCurrentToken();
        return t;
    }

    public List<T> readAll() throws IOException {
        return this.readAll(new ArrayList());
    }

    public List<T> readAll(List<T> list) throws IOException {
        while (this.hasNextValue()) {
            list.add(this.nextValue());
        }
        return list;
    }

    public JsonParser getParser() {
        return this._parser;
    }

    public FormatSchema getParserSchema() {
        return this._parser.getSchema();
    }

    public JsonLocation getCurrentLocation() {
        return this._parser.getCurrentLocation();
    }
}

