/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.com.fasterxml.jackson.databind;

import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.Base64Variant;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonParser;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonToken;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.BeanProperty;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.DatabindContext;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.InjectableValues;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JavaType;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.KeyDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.deser.DeserializerCache;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.deser.impl.TypeWrappedDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.introspect.Annotated;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.type.TypeFactory;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.util.ClassUtil;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.util.LinkedNode;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class DeserializationContext
extends DatabindContext
implements Serializable {
    private static final long serialVersionUID = -7727373309391091315L;
    private static final int MAX_ERROR_STR_LEN = 500;
    protected final DeserializerCache _cache;
    protected final DeserializerFactory _factory;
    protected final DeserializationConfig _config;
    protected final int _featureFlags;
    protected final Class<?> _view;
    protected transient JsonParser _parser;
    protected final InjectableValues _injectableValues;
    protected transient ArrayBuilders _arrayBuilders;
    protected transient ObjectBuffer _objectBuffer;
    protected transient DateFormat _dateFormat;

    protected DeserializationContext(DeserializerFactory deserializerFactory) {
        this(deserializerFactory, null);
    }

    protected DeserializationContext(DeserializerFactory deserializerFactory, DeserializerCache deserializerCache) {
        if (deserializerFactory == null) {
            throw new IllegalArgumentException("Can not pass null DeserializerFactory");
        }
        this._factory = deserializerFactory;
        this._cache = deserializerCache == null ? new DeserializerCache() : deserializerCache;
        this._featureFlags = 0;
        this._config = null;
        this._injectableValues = null;
        this._view = null;
    }

    protected DeserializationContext(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory) {
        this._cache = deserializationContext._cache;
        this._factory = deserializerFactory;
        this._config = deserializationContext._config;
        this._featureFlags = deserializationContext._featureFlags;
        this._view = deserializationContext._view;
        this._parser = deserializationContext._parser;
        this._injectableValues = deserializationContext._injectableValues;
    }

    protected DeserializationContext(DeserializationContext deserializationContext, DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
        this._cache = deserializationContext._cache;
        this._factory = deserializationContext._factory;
        this._config = deserializationConfig;
        this._featureFlags = deserializationConfig.getDeserializationFeatures();
        this._view = deserializationConfig.getActiveView();
        this._parser = jsonParser;
        this._injectableValues = injectableValues;
    }

    public DeserializationConfig getConfig() {
        return this._config;
    }

    @Override
    public final Class<?> getActiveView() {
        return this._view;
    }

    @Override
    public final AnnotationIntrospector getAnnotationIntrospector() {
        return this._config.getAnnotationIntrospector();
    }

    @Override
    public final TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public DeserializerFactory getFactory() {
        return this._factory;
    }

    public final boolean isEnabled(DeserializationFeature deserializationFeature) {
        return (this._featureFlags & deserializationFeature.getMask()) != 0;
    }

    public final JsonParser getParser() {
        return this._parser;
    }

    public final Object findInjectableValue(Object object, BeanProperty beanProperty, Object object2) {
        if (this._injectableValues == null) {
            throw new IllegalStateException("No 'injectableValues' configured, can not inject value with id [" + object + "]");
        }
        return this._injectableValues.findInjectableValue(object, this, beanProperty, object2);
    }

    public final Base64Variant getBase64Variant() {
        return this._config.getBase64Variant();
    }

    public final JsonNodeFactory getNodeFactory() {
        return this._config.getNodeFactory();
    }

    public Locale getLocale() {
        return this._config.getLocale();
    }

    public TimeZone getTimeZone() {
        return this._config.getTimeZone();
    }

    public boolean hasValueDeserializerFor(JavaType javaType) {
        return this._cache.hasValueDeserializerFor(this, this._factory, javaType);
    }

    public final JsonDeserializer<Object> findContextualValueDeserializer(JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._cache.findValueDeserializer(this, this._factory, javaType);
        if (jsonDeserializer != null && jsonDeserializer instanceof ContextualDeserializer) {
            jsonDeserializer = ((ContextualDeserializer)((Object)jsonDeserializer)).createContextual(this, beanProperty);
        }
        return jsonDeserializer;
    }

    public final JsonDeserializer<Object> findRootValueDeserializer(JavaType javaType) throws JsonMappingException {
        TypeDeserializer typeDeserializer;
        JsonDeserializer<Object> jsonDeserializer = this._cache.findValueDeserializer(this, this._factory, javaType);
        if (jsonDeserializer == null) {
            return null;
        }
        if (jsonDeserializer instanceof ContextualDeserializer) {
            jsonDeserializer = ((ContextualDeserializer)((Object)jsonDeserializer)).createContextual(this, null);
        }
        if ((typeDeserializer = this._factory.findTypeDeserializer(this._config, javaType)) != null) {
            typeDeserializer = typeDeserializer.forProperty(null);
            return new TypeWrappedDeserializer(typeDeserializer, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    public final KeyDeserializer findKeyDeserializer(JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        KeyDeserializer keyDeserializer = this._cache.findKeyDeserializer(this, this._factory, javaType);
        if (keyDeserializer instanceof ContextualKeyDeserializer) {
            keyDeserializer = ((ContextualKeyDeserializer)((Object)keyDeserializer)).createContextual(this, beanProperty);
        }
        return keyDeserializer;
    }

    public abstract ReadableObjectId findObjectId(Object var1, ObjectIdGenerator<?> var2);

    public final JavaType constructType(Class<?> clazz) {
        return this._config.constructType(clazz);
    }

    public Class<?> findClass(String string) throws ClassNotFoundException {
        return ClassUtil.findClass(string);
    }

    public abstract JsonDeserializer<Object> deserializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    public abstract KeyDeserializer keyDeserializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    public final ObjectBuffer leaseObjectBuffer() {
        ObjectBuffer objectBuffer = this._objectBuffer;
        if (objectBuffer == null) {
            objectBuffer = new ObjectBuffer();
        } else {
            this._objectBuffer = null;
        }
        return objectBuffer;
    }

    public final void returnObjectBuffer(ObjectBuffer objectBuffer) {
        if (this._objectBuffer == null || objectBuffer.initialCapacity() >= this._objectBuffer.initialCapacity()) {
            this._objectBuffer = objectBuffer;
        }
    }

    public final ArrayBuilders getArrayBuilders() {
        if (this._arrayBuilders == null) {
            this._arrayBuilders = new ArrayBuilders();
        }
        return this._arrayBuilders;
    }

    public Date parseDate(String string) throws IllegalArgumentException {
        try {
            return this.getDateFormat().parse(string);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Failed to parse Date value '" + string + "': " + parseException.getMessage());
        }
    }

    public Calendar constructCalendar(Date date) {
        Calendar calendar = Calendar.getInstance(this.getTimeZone());
        calendar.setTime(date);
        return calendar;
    }

    public boolean handleUnknownProperty(JsonParser jsonParser, JsonDeserializer<?> jsonDeserializer, Object object, String string) throws IOException, JsonProcessingException {
        LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers();
        if (linkedNode != null) {
            while (linkedNode != null) {
                if (linkedNode.value().handleUnknownProperty(this, jsonParser, jsonDeserializer, object, string)) {
                    return true;
                }
                linkedNode = linkedNode.next();
            }
        }
        return false;
    }

    public void reportUnknownProperty(Object object, String string, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            return;
        }
        Collection<Object> collection = jsonDeserializer == null ? null : jsonDeserializer.getKnownPropertyNames();
        throw UnrecognizedPropertyException.from(this._parser, object, string, collection);
    }

    public JsonMappingException mappingException(Class<?> clazz) {
        return this.mappingException(clazz, this._parser.getCurrentToken());
    }

    public JsonMappingException mappingException(Class<?> clazz, JsonToken jsonToken) {
        String string = this._calcName(clazz);
        return JsonMappingException.from(this._parser, "Can not deserialize instance of " + string + " out of " + (Object)((Object)jsonToken) + " token");
    }

    public JsonMappingException mappingException(String string) {
        return JsonMappingException.from(this.getParser(), string);
    }

    public JsonMappingException instantiationException(Class<?> clazz, Throwable throwable) {
        return JsonMappingException.from(this._parser, "Can not construct instance of " + clazz.getName() + ", problem: " + throwable.getMessage(), throwable);
    }

    public JsonMappingException instantiationException(Class<?> clazz, String string) {
        return JsonMappingException.from(this._parser, "Can not construct instance of " + clazz.getName() + ", problem: " + string);
    }

    @Deprecated
    public JsonMappingException weirdStringException(Class<?> clazz, String string) {
        return this.weirdStringException(null, clazz, string);
    }

    public JsonMappingException weirdStringException(String string, Class<?> clazz, String string2) {
        return InvalidFormatException.from(this._parser, "Can not construct instance of " + clazz.getName() + " from String value '" + this._valueDesc() + "': " + string2, string, clazz);
    }

    @Deprecated
    public JsonMappingException weirdNumberException(Class<?> clazz, String string) {
        return this.weirdStringException(null, clazz, string);
    }

    public JsonMappingException weirdNumberException(Number number, Class<?> clazz, String string) {
        return InvalidFormatException.from(this._parser, "Can not construct instance of " + clazz.getName() + " from number value (" + this._valueDesc() + "): " + string, null, clazz);
    }

    public JsonMappingException weirdKeyException(Class<?> clazz, String string, String string2) {
        return InvalidFormatException.from(this._parser, "Can not construct Map key of type " + clazz.getName() + " from String \"" + this._desc(string) + "\": " + string2, string, clazz);
    }

    public JsonMappingException wrongTokenException(JsonParser jsonParser, JsonToken jsonToken, String string) {
        return JsonMappingException.from(jsonParser, "Unexpected token (" + (Object)((Object)jsonParser.getCurrentToken()) + "), expected " + (Object)((Object)jsonToken) + ": " + string);
    }

    public JsonMappingException unknownTypeException(JavaType javaType, String string) {
        return JsonMappingException.from(this._parser, "Could not resolve type id '" + string + "' into a subtype of " + javaType);
    }

    public JsonMappingException endOfInputException(Class<?> clazz) {
        return JsonMappingException.from(this._parser, "Unexpected end-of-input when trying to deserialize a " + clazz.getName());
    }

    protected DateFormat getDateFormat() {
        if (this._dateFormat != null) {
            return this._dateFormat;
        }
        DateFormat dateFormat = this._config.getDateFormat();
        this._dateFormat = dateFormat = (DateFormat)dateFormat.clone();
        return dateFormat;
    }

    protected String determineClassName(Object object) {
        return ClassUtil.getClassDescription(object);
    }

    protected String _calcName(Class<?> clazz) {
        if (clazz.isArray()) {
            return this._calcName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    protected String _valueDesc() {
        try {
            return this._desc(this._parser.getText());
        }
        catch (Exception exception) {
            return "[N/A]";
        }
    }

    protected String _desc(String string) {
        if (string.length() > 500) {
            string = string.substring(0, 500) + "]...[" + string.substring(string.length() - 500);
        }
        return string;
    }
}

